// styleswitcher.js -
//  Offer selection of preferred display size
//  Choice gets stored in cookie upon leaving page, is loaded from cookie
//  Depending on choice, different style sheets are loaded
//
//  Auswahl bevorzugter Darstellungsgre
//  Auswahl wird beim Verlassen der Seite als Cookie gespeichert und wieder aus Cookie geladen
//  Abhngig von Auswahl werden verschiedene style sheets geladen
//
// functions loadImages, changeHeaderImages (c) 2005, 2006 Christian Hennecke
 
function setActiveStyleSheet(title) {
  var i, a, main;
  for(i=0; (a = document.getElementsByTagName("link")[i]); i++) {
    if(a.getAttribute("rel").indexOf("style") != -1 && a.getAttribute("title")) {
      a.disabled = true;
      if(a.getAttribute("title") == title) {
        a.disabled = false;
        changeHeaderImages(title);
      }
    }
  }
}
 
function getActiveStyleSheet() {
  var i, a;
  for(i=0; (a = document.getElementsByTagName("link")[i]); i++) {
    if(a.getAttribute("rel").indexOf("style") != -1 && a.getAttribute("title") && !a.disabled) return a.getAttribute("title");
  }
  return null;
}
 
function getPreferredStyleSheet() {
  var i, a;
  for(i=0; (a = document.getElementsByTagName("link")[i]); i++) {
    if(a.getAttribute("rel").indexOf("style") != -1
       && a.getAttribute("rel").indexOf("alt") == -1
       && a.getAttribute("title")
       ) return a.getAttribute("title");
  }
  return null;
}
 
function createCookie(name,value,days) {
  if (days) {
    var date = new Date();
    date.setTime(date.getTime()+(days*24*60*60*1000));
    var expires = "; expires="+date.toGMTString();
  }
  else expires = "";
  document.cookie = name+"="+value+expires+"; path=/";
}
 
function readCookie(name) {
  var nameEQ = name + "=";
  var ca = document.cookie.split(';');
  for(var i=0;i < ca.length;i++) {
    var c = ca[i];
    while (c.charAt(0)==' ') c = c.substring(1,c.length);
    if (c.indexOf(nameEQ) == 0) return c.substring(nameEQ.length,c.length);
  }
  return null;
}
 
function loadImages() {
  var i, size;
  logo = new Array(3);
  flag = new Array(3);
  down = new Array(3);
  previous = new Array(3);
  content = new Array(3);
  next = new Array(3);
  for (i=0; i<=2; i++) {
    size = String(14 + i * 2);
    logo[i] = new Image();
    logo[i].src = "img/voicebg-" + size + ".png";
    flag[i] = new Image();
    flag[i].src = "img/flag-" + size + ".png";
    down[i] = new Image();
    down[i].src = "img/down-" + size + ".png";
    previous[i] = new Image();
    previous[i].src = "img/previous-" + size + ".png";
    content[i] = new Image();
    content[i].src = "img/content-" + size + ".png";
    next[i] = new Image();
    next[i].src = "img/next-" + size + ".png";
  }
}

function changeHeaderImages(title) {
  var i = 0;
  switch (title) {
    case "small":
      i = 0;
      break;
    case "medium":
      i = 1;
      break;
    case "large":
      i = 2;
      break;
  }
  try {
    document.getElementById('logo').src = logo[i].src;
    document.getElementById('flag').src = flag[i].src;
    document.getElementById('down').src = down[i].src;
    if(document.getElementById('previousTop')) {
      document.getElementById('previousTop').src = previous[i].src;
    }
    document.getElementById('contentTop').src = content[i].src;
    if(document.getElementById('nextTop')) {
      document.getElementById('nextTop').src = next[i].src;
    }
    if(document.getElementById('previousBottom')) {
      document.getElementById('previousBottom').src = previous[i].src;
    }
    document.getElementById('contentBottom').src = content[i].src;
    if(document.getElementById('nextBottom')) {
      document.getElementById('nextBottom').src = next[i].src;
    }
  }
  catch (dummy) {
    setTimeout("changeHeaderImages('" + title + "')", 500);
  }
}

window.onload = function(e) {
  var cookie = readCookie("style");
  var title = cookie ? cookie : getPreferredStyleSheet();

  setActiveStyleSheet(title);
}

window.onunload = function(e) {
  var title = getActiveStyleSheet();
  createCookie("style", title, 365);
}
 
var cookie = readCookie("style");
var title = cookie ? cookie : getPreferredStyleSheet();
 
loadImages();
setActiveStyleSheet(title);
