#include <math.h>
#include "glClass.h"
#include "mfClass.h"
#include "dood.h"

#define BINARY_DECLARE(x) \
  extern "C" char x[];\
  extern "C" int x##_size; 
  
BINARY_DECLARE(music)

int headmotion[] = {
  0,0,1,
  2,3,4,
  5,5,6,
  7,7,7
};

int endscreen[]={
1,1,1,0,0,0,1,1,0,0,1,1,1,1,0,1,0,0,0,
1,0,0,1,0,1,0,0,1,0,1,0,0,0,0,1,0,0,0,
1,1,1,0,0,1,0,0,1,0,1,1,0,0,0,1,0,0,0,
1,0,0,1,0,0,1,1,0,0,1,0,0,0,0,1,1,1,1,
};

int APIENTRY WinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR     lpCmdLine,
                     int       nCmdShow)
 {

#ifdef _DEBUG
	int fs=IDYES;
#else
	int fs=MessageBox(0,"%%%","[]",MB_YESNOCANCEL);
	if (fs==IDCANCEL) return 1;
#endif
  
  glClass gl(fs==IDYES);
  mfClass sound(music,music_size);
  
  sound.Play();
  dood robot;
  
  while(!glClass::finished) {
    gl.messages(); 
	  glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
    int sync = sound.Sync();
    ///////////////////////////////////////////////////////////////

    gl.set3D(60);
    //gluLookAt(sin(sync/200.0)*20,0,-100, 0,0,0, 0,1,0);

    int p = sound.Pattern();
    int r = sound.Row();
    
    if (p==0) {
      gluLookAt(0,0,-100, 0,0,0, 0,1,0);
      robot.armsync=0;
      robot.headmotion=0;
      robot.head=robot.torso=robot.feet=0;
      if (r==0) robot.head=1;
      if (r==1) robot.head=robot.torso=1;
      if (r==2) robot.head=robot.torso=robot.feet=1;
      robot.render();
    } else if (p>=1 && p<=0x18) {
      robot.headmotion=headmotion[r]+p*3;
      robot.head=robot.torso=robot.feet=1;
      gluLookAt(r<6 ? 50 : -50,0,-100, 0,0,0, 0,1,0);
      //gluLookAt(-100,0,0, 0,0,0, 0,1,0);
      if (p>=9 && p<=16) glTranslatef(0,sinf(sync*10)*20*sinf(sync/5.0),0);
      if (r>=9 && (p==0x0c || p==16)) glTranslatef(sinf(sync*20)*30,sinf(sync*2)*30,0);
      if (r>=6 && (p%4==0)) glScalef(1,-1,1);
      if (p>=0x11 && r==3) glScalef(1+sinf(sync*100)*10,1,1);
      if (p>=0x11 && r==5) glRotatef(1+sinf(sync*100)*90,0,0,1);
      if (p>=0x11 && r>=9) glTranslatef(0,0,(r-9)*40);
      if (p==0x14 || p==0x18) {
        glLoadIdentity()   ;     
        glRotatef((r/3)*20-40,0,0,1);
        gluLookAt(0,20,-((4-(r/3))*20+20), 0,20,0, 0,1,0);
      }
      robot.armsync = sync/100.0;
      robot.render();
    } else if (p==0x19) {
      gluLookAt(0,0,-100, 0,0,0, 0,1,0);
      glColor3f(1,1,1);
      for (int y=0; y<4; y++)
        for (int x=0; x<19; x++)
          if (endscreen[x+y*19]) {
            glPushMatrix();
            glTranslatef(x*1.5-(19*0.75),-y*1.5,0);
            robot.koob.draw();
            glPopMatrix();
          }
        
    }
    
    ///////////////////////////////////////////////////////////////
    gl.flip();

    if (p==0x19 && r>=6) break;
  }
  //sound.Stop();
  
  return 0;
  

}