//PSAME.C
// Attempt at SameGame for GBA drsmith@iee.org (for 4k compo)

#define WIDTH 14
#define HEIGHT 10
#define EMPTY ((unsigned char)255)

void Display(void);
int makeGroups(void);
void Blank(void);

/*
 _____
 | 0 |
3|   |4
 |   |
 _____
 | 1 |
5|   |6
 |   |
 _____
   2
*/
/*0123456789AMEgRt?_ S=5*/
const unsigned char bcd[]={0x7d,0x50,0x37,0x57,0x5a,0x4f,0x6f,0x51,0x7f,0x5f,0x7b,0x79,0x2f,0x5f,0x39,0x2e,0x33};
unsigned char flags=0;
char nmod;
unsigned char restart[]={14,12,5,15,10,14,15,16},samegame[]={5,10,11,11,12,13,10,11,11,12};

/* black, blue, green, red, cyan, magenta, yellow, white */
const unsigned short pal[]=/*{0x0,0x7C00,0x03E0,0x001F,0x7FE0,0x7C1F,0x03FF,0x7FFF};*/
{0x0,
0x7c21,0x07e1,0x043f,0x7fe1,0x7c3f,0x07ff,
0x7c63,0x0fe3,0x0c7f,0x7fe3,0x7c7f,0x0fff,
0x7ca5,0x17e5,0x14bf,0x7fe5,0x7cbf,0x17ff,
0x7ce7,0x1fe7,0x1cff,0x7fe7,0x7cff,0x1fff,
0x7d4a,0x2bea,0x295f,0x7fea,0x7d5f,0x2bff,
0x7d6b,0x2feb,0x2d7f,0x7feb,0x7d7f,0x2fff,
0x7def,0x3fef,0x3dff,0x7fef,0x7dff,0x3fff,
0x7e31,0x47f1,0x463f,0x7ff1,0x7e3f,0x47ff,
0x7e94,0x53f4,0x529f,0x7ff4,0x7e9f,0x53ff,
0x7ed6,0x5bf6,0x5adf,0x7ff6,0x7edf,0x5bff,
0x7f7b,0x6ffb,0x6f7f,0x7ffb,0x7f7f,0x6fff,
0x7fff};

unsigned char *block1=(unsigned char*)0x03007000,*block2=(unsigned char*)0x03007100,*grplut=(unsigned char*)0x03007200;
unsigned char *bmpbuf=(unsigned char *)0x03007300;
unsigned int keys=0,oldkeys=0,rand_next,scr=0,old_rand,cur_scr,endm;
int scr_x=120,scr_y=80;

unsigned short *scrn=(unsigned short *)0x6000000;

/* shiny marble */
unsigned char glyph[128]={
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x03,0x33,0x21,0x00,0x00,0x00,
0x00,0x04,0x56,0x65,0x42,0x11,0x00,0x00,
0x00,0x46,0x78,0x87,0x63,0x21,0x10,0x00,
0x03,0x68,0x9a,0xa8,0x75,0x11,0x11,0x00,
0x04,0x68,0xab,0xba,0x86,0x31,0x11,0x00,
0x14,0x68,0xab,0xba,0x76,0x31,0x11,0x10,
0x14,0x67,0x9a,0xa9,0x75,0x21,0x11,0x10,
0x12,0x46,0x78,0x87,0x64,0x11,0x11,0x10,
0x11,0x14,0x66,0x65,0x42,0x11,0x11,0x10,
0x11,0x11,0x33,0x32,0x11,0x11,0x11,0x10,
0x01,0x11,0x11,0x11,0x11,0x11,0x11,0x00,
0x01,0x11,0x11,0x11,0x11,0x11,0x11,0x00,
0x00,0x11,0x11,0x11,0x11,0x11,0x10,0x00,
0x00,0x01,0x11,0x11,0x11,0x11,0x00,0x00,
0x00,0x00,0x01,0x11,0x11,0x00,0x00,0x00};

unsigned int mod4(unsigned int i)
{return (i&0x30000000)>>28;}

unsigned int mod5(unsigned int x)
{
int i,j;
i=x-5;
x = x - (x>>2);
x = x + (x>>4);
x = x + (x>>8);
x = x + (x>>16);
x>>=2;
j=x + (x<<2);
i-=j;
if(i<0)
	i+=5;

return i;
}

unsigned int mod6(unsigned int x)
{
int i,j;
i=x-6;
x>>=1;
x = x + (x>>2);
x = x + (x>>4);
x = x + (x>>8);
x = x + (x>>16);
x>>=2;
j=(x<<2)-x;
i-=(j<<1);
if(i<0)
	i+=6;

return i;
}

unsigned int (*mods[3])(unsigned int)={mod4,mod5,mod6};

void DrawVert(unsigned char x, unsigned char y, unsigned char pal)
{
    int i;
    unsigned short tmp, *offset=scrn + ((x>>1)+y*120);

    for(i=5;i>=0;i--)
    {
        tmp=*offset;
        if(!(x&1))
            tmp = pal + (tmp&0xff00);
        else
            tmp = (pal<<8) + (tmp&0xff);
        *offset=tmp;
        offset+=120;
    }
}

void DrawHoriz(unsigned char x, unsigned char y, unsigned char pal)
{
unsigned short tmp, *offset=scrn + (y*120 + (x>>1)),blt=pal+ (pal<<8);

    if(!(x&1))
    {
        *offset++=blt;
        *offset++=blt;
        *offset=blt;
    }
    else
    {
        tmp = *offset;
        tmp = (pal<<8) + (tmp&0xff);
        *offset++ = tmp;
        *offset++=blt;
        *offset++=blt;
        tmp = *offset;
        tmp = pal + (tmp&0xff00);
        *offset = tmp;
    }
}
void DrawSeg(unsigned char x, unsigned char y, unsigned char index, unsigned char pal)
{

    if(bcd[index]&0x1)
        DrawHoriz(x+1,y,pal);
    if(bcd[index]&0x2)
        DrawHoriz(x+1,y+7,pal);
    if(bcd[index]&0x4)
        DrawHoriz(x+1,y+14,pal);
    if(bcd[index]&0x8)
        DrawVert(x, y+1,pal);
    if(bcd[index]&0x10)
        DrawVert(x+7, y+1,pal);
    if(bcd[index]&0x20)
        DrawVert(x, y+8,pal);
    if(bcd[index]&0x40)
        DrawVert(x+7, y+8,pal);
}

void BeepYes(void)
{
    *(volatile unsigned short *)0x4000080 = 0x1177;//chn1 to L&R max vol
    *(volatile unsigned short *)0x4000060 = 0x0022;//sweep up in quarter freqs, 15.6ms
    *(volatile unsigned short *)0x4000062 = 0xf080;//1/4 secs length, 50% duty, max vol
    *(volatile unsigned short *)0x4000064 = 0xc6fa;//reset, timed, freq 500hz
}

void BeepNo(void)
{
    *(volatile unsigned short *)0x4000080 = 0x1177;//chn1 to L&R max vol
    *(volatile unsigned short *)0x4000060 = 0x002a;//sweep down in quarter freqs, 15.6ms
    *(volatile unsigned short *)0x4000062 = 0xf080;//1/4 secs length, 50% duty, max vol
    *(volatile unsigned short *)0x4000064 = 0xc7f8;//reset, timed, freq 16000hz
}

int main(void)
{
int i,j,k,nblks,x,y;

//set gfx mode etc
*(volatile unsigned short *)0x4000000 = 0x404;//mode 4, bg2
*(volatile unsigned short *)0x4000084 = 0x0080;//sound on
*(volatile unsigned short *)0x4000100 = 0x00;
*(volatile unsigned short *)0x4000102 = 0x80; //start timer, system frequency
*(volatile unsigned short *)0x4000104 = 0x00;
*(volatile unsigned short *)0x4000106 = 0x84; //start timer, triggered by timer 0

/* load palette */
for(i=sizeof(pal)/sizeof(short) - 1;i>=0;i--)
    ((volatile unsigned short *)(0x5000000))[i] = pal[i];

/* load bitmaps - 4 bpp */
for(i=5;i>=0;i--)
{
    for(j=255;j>=0;j--)
    {
        x=(j&1?glyph[j>>1]&0x0f:glyph[j>>1]>>4);
        bmpbuf[i*256 + j]=(x!=0?1 + (x-1) * 6 + i:0); /* palette blk col11 col21 col31 ... white */
    }
}

level_select:
nmod=3;scr=0;flags=0;keys=0;
while(((*(volatile unsigned int*)0x4000130)&0xf)^0xf)//A,B,Start or Select pressed
{}
//wait for 'start'
while(!(keys&0xf))
{
    i = *(volatile unsigned int*)0x4000130;
    i=~i;
    if(((keys^i)&i)&16) //->
        nmod++;
    if(((keys^i)&i)&32)//<-
        nmod--;
    keys = i;
    if(nmod>4)
        nmod=4;
    if(nmod<2)
        nmod=2;
    Blank();
    x=137;y=71;
    for(i=9;i>=0;i--)
    {
        DrawSeg(x,y,samegame[i],sizeof(pal)/sizeof(unsigned short) - 1);
        if(i==5)
        {
            x=148;y=51;
        }
        if(x==126)
            x+=4;
        x-=11;
    }
    for(i=2;i>=0;i--)
        DrawSeg(97 + (i*20),111,i,(nmod-2)==i?3:sizeof(pal)/sizeof(unsigned short) - 1);

    while(*(volatile unsigned short*)0x4000006 < 160)//vblank
    {}

    //flip buffer
    if(*(volatile unsigned short *)0x4000000 & 0x10)
    {
        *(volatile unsigned short *)0x4000000 &= ~0x10;
        scrn = (unsigned short *)0x600A000; //back
    }
    else
    {
        *(volatile unsigned short *)0x4000000 |= 0x10;
        scrn = (unsigned short *)0x6000000;//front
    }
}
while(1)
{
    do
    {
        if(!(flags&1))
        {
            rand_next=*(volatile unsigned short *)0x4000100 + ((*(volatile unsigned short *)0x4000104)<<16);
        }
        else
            rand_next=old_rand;
        old_rand = rand_next;
        nmod-=2;
        for(i = (HEIGHT*WIDTH)-1;i>=0;i--)
        {
            rand_next = rand_next * 1664525 + 1013904223;
            block1[i]=mods[nmod](rand_next) + 1;
        }
    } while(!makeGroups());
    cur_scr=flags=0;endm=WIDTH;
    nblks = WIDTH*HEIGHT;
    while(nblks!=0)
    {
        //get user input
        Display();
        if(keys & 4) //select - back to level select
            {goto level_select;}
        if(keys & 8) //start - replay level
            {flags=1;break;}
        if(keys & 16) //->
            scr_x++;
        if(keys & 32) //<-
            scr_x--;
        if(keys & 64) //^
            scr_y--;
        if(keys & 128) //down
            scr_y++;
        if(scr_y<0)
            scr_y=0;
        if(scr_y>159)
            scr_y = 159;
        if(scr_x<0)
            scr_x=0;
        if(scr_x>239)
            scr_x = 239;
        if(keys & 1)//A
        {
            if(scr_x<224)
            {
                x = scr_x>>4;
                y = scr_y>>4;
                //kill some blocks
                j = block2[y*WIDTH + x];
                if(grplut[j]>=2 && j!=0)
                {
                    cur_scr+=(grplut[j]-1)*(grplut[j]-1);
                    BeepYes();
                    for(i = (HEIGHT*WIDTH)-1;i>=0;i--)
                    {
                        if(block2[i]==j)
                        {
                            block1[i] = EMPTY;
                            nblks--;
                        }
                    }
                	for(i=0;i<=WIDTH-1;i++) //col
                    {
                		for(j=HEIGHT-1;j>=0;j--) //row bottom to top
                        {
                			if(block1[i + j*WIDTH] == EMPTY)
                			{
                				for(k=j;k>0;k--)
				                	block1[i + k*WIDTH] = block1[i + (k-1)*WIDTH];
                				block1[i]=0;//top of column
				                j++;
                			}
                		}
                		if(block1[WIDTH * (HEIGHT-1) + i]==0 && i<endm)
                		{
			                for(j = i;j<WIDTH-1;j++)
                			{
				                for(k=HEIGHT-1;k>=0;k--)
                				{
				                	block1[k*WIDTH + j]=block1[k*WIDTH + j + 1];
                					block1[k*WIDTH + j + 1]=0;
				                }
                			}
                            endm--;
    			            i--;
	                	}
                	}
                    if(block1[(HEIGHT-1)*WIDTH]==0)//screen empty, next screen
                    {
                        BeepYes();scr+=cur_scr;break;
                    }
                    if(!makeGroups())//can't finish screen - wait 'til action
                    {
                        BeepNo();
                        flags|=2;
                    }
                }
                else
                    BeepNo();
            }
            else
                BeepNo();
        }
    }
}
}

unsigned int div10(unsigned int *x)
{
int y,i,j;

y=*x;
i=y-10;
y = y - (y>>2);
y = y + (y>>4);
y = y + (y>>8);
y = y + (y>>16);
y>>=3;
j=(y<<2) + y;
i-=(j<<1);
if(i>=0)
	y+=1;
else
    i+=10;

*x=y;

return i;
}
void Display(void)
{
    int j,x,y;
    unsigned char i;
    unsigned int *ptr,*ptr2,mask=0xff00ff00;
    unsigned short *cur;
    Blank();
    i = block2[(scr_y>>4) * WIDTH + (scr_x>>4)];
    if(i==0)
        i=255;
    for(y = HEIGHT-1;y>=0;y--)
    {
        for(x=WIDTH-1;x>=0;x--)
        {
            if(block1[y*WIDTH + x]!=0)/* only draw real marbles */
            {
                ptr2 = &(((unsigned int*)scrn)[y*16*60 + x*4]);
                ptr=&(((unsigned int *)bmpbuf)[(block1[y*WIDTH + x]-1) * 64]);
                if(i == block2[y*WIDTH + x] && grplut[block2[y*WIDTH + x]]>1)//same group, more than 1 so highlight
                {
                    for(j=0;j<16;j++)
                    {
                        *ptr2=(*ptr) & mask;ptr++;ptr2++;
                        *ptr2=(*ptr) & mask;ptr++;ptr2++;
                        *ptr2=(*ptr) & mask;ptr++;ptr2++;
                        *ptr2=(*ptr) & mask;ptr++;
                        ptr2+=57;
                        mask=~mask;
                    }
                }
                else
                {
                    for(j=0;j<16;j++)
                    {
                        *ptr2=*ptr;ptr++;ptr2++;
                        *ptr2=*ptr;ptr++;ptr2++;
                        *ptr2=*ptr;ptr++;ptr2++;
                        *ptr2=*ptr;ptr++;
                        ptr2+=57;
                    }
                }
            }
        }
    }

//show score
    x=scr+cur_scr;
    for(j=9;j>=0;j--)
    {
        DrawSeg(228,j*16,div10((unsigned int *)&x),sizeof(pal)/sizeof(unsigned short) - 1);
    }
    if(flags&2)//REStARt ?
    {
        for(j=7;j>=0;j--)
            DrawSeg((j*11)+75,71,restart[j],sizeof(pal)/sizeof(unsigned short) - 1);
    }

    //+ as cursor - contrasting colour
    for(j=-3;j<4;j++)
    {
        if((j+scr_x) > -1 && (j+scr_x)<239)
        {
            cur=&scrn[scr_y * 120 + ((scr_x+j)>>1)];
            if((scr_x+j)&1)
                *cur=(*cur)^((sizeof(pal)/sizeof(unsigned short) - 1)<<8);
            else
                *cur = (*cur)^(sizeof(pal)/sizeof(unsigned short) - 1);
        }
    }
    for(j=-3;j<4;j++)
    {
        if((j+scr_y) > -1 && (j+scr_y)<159)
        {
            cur=&scrn[(scr_y+j) * 120 + (scr_x>>1)];
            if(scr_x&1)
                *cur=(*cur)^((sizeof(pal)/sizeof(unsigned short) - 1)<<8);
            else
                *cur = (*cur)^(sizeof(pal)/sizeof(unsigned short) - 1);
        }
    }
    /*cur=&scrn[scr_y * 120 + (scr_x>>1)];
    if(scr_x&1)
        *cur=(*cur)^0x7000;
    else
        *cur = (*cur)^0x7;*/

while(*(volatile unsigned short*)0x4000006 < 160)//vblank
{}

//flip buffer
if(*(volatile unsigned short *)0x4000000 & 0x10)
{
    *(volatile unsigned short *)0x4000000 &= ~0x10;
    scrn = (unsigned short *)0x600A000; //back
}
else
{
    *(volatile unsigned short *)0x4000000 |= 0x10;
    scrn = (unsigned short *)0x6000000;//front
}

//input
mask = *(volatile unsigned int*)0x4000130;
mask=~mask;
keys = ((mask^(oldkeys&0xf)) & mask) | (mask&0xff0);
oldkeys=mask;
}

int makeGroups(void)
{
    int ngrp=0,i,j,x,y,found;

    for(i = (HEIGHT*WIDTH)-1;i>=0;i--)
        block2[i]=0;
    for(i = HEIGHT-1;i>=0;i--)
    {
        for(j= WIDTH-1;j>=0;j--)
        {
            if(block2[i*WIDTH + j]==0 && block1[i*WIDTH + j]!=0)
            {
                block2[i*WIDTH + j]=++ngrp;
                found=1;
                while(found)
                {
                    found=0;
                    for(y = HEIGHT-1;y>=0;y--)
                    {
                        for(x=WIDTH-1;x>=0;x--)
                        {
                            if(block2[y*WIDTH + x]==ngrp)
                            {
                                if(x<WIDTH-1 && block2[y*WIDTH + x+1]==0 && block1[y*WIDTH + x+1] == block1[i*WIDTH + j])
                                {
                                    found = 1;
                                    block2[y*WIDTH + x+1]=ngrp;
                                }
                                if(x>0 && block2[y*WIDTH + x-1]==0 && block1[y*WIDTH + x-1] == block1[i*WIDTH + j])
                                {
                                    found = 1;
                                    block2[y*WIDTH + x-1]=ngrp;
                                }
                                if(y<HEIGHT-1 && block2[(y+1)*WIDTH + x]==0 && block1[(y+1)*WIDTH + x] == block1[i*WIDTH + j])
                                {
                                    found = 1;
                                    block2[(y+1)*WIDTH + x]=ngrp;
                                }
                                if(y>0 && block2[(y-1)*WIDTH + x]==0 && block1[(y-1)*WIDTH + x] == block1[i*WIDTH + j])
                                {
                                    found = 1;
                                    block2[(y-1)*WIDTH + x]=ngrp;
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    for(i = ngrp;i>=0;i--)
        grplut[i]=0;
    for(i = (HEIGHT*WIDTH)-1;i>=0;i--)
        grplut[block2[i]]++;
    for(i=ngrp;i>0;i--)
    {
        if(grplut[i]>1)
            return 1;
    }
    return 0;
}

void Blank(void)
{
    unsigned int *quad = (unsigned int *)scrn;
    int i;
//blank fast from andrew cox
    for(i = 159; i>=0;i--)
    {
        // Clear a whole scanline in one unrolled loop:
        // 60 writes (4 bytes * 60 == 240 byte scanline):
        /*16*/ *quad++ = 0u; *quad++ = 0u; *quad++ = 0u; *quad++ = 0u;
               *quad++ = 0u; *quad++ = 0u; *quad++ = 0u; *quad++ = 0u;
               *quad++ = 0u; *quad++ = 0u; *quad++ = 0u; *quad++ = 0u;
               *quad++ = 0u; *quad++ = 0u; *quad++ = 0u; *quad++ = 0u;
        /*16*/ *quad++ = 0u; *quad++ = 0u; *quad++ = 0u; *quad++ = 0u;
               *quad++ = 0u; *quad++ = 0u; *quad++ = 0u; *quad++ = 0u;
               *quad++ = 0u; *quad++ = 0u; *quad++ = 0u; *quad++ = 0u;
               *quad++ = 0u; *quad++ = 0u; *quad++ = 0u; *quad++ = 0u;
        /*16*/ *quad++ = 0u; *quad++ = 0u; *quad++ = 0u; *quad++ = 0u;
               *quad++ = 0u; *quad++ = 0u; *quad++ = 0u; *quad++ = 0u;
               *quad++ = 0u; *quad++ = 0u; *quad++ = 0u; *quad++ = 0u;
               *quad++ = 0u; *quad++ = 0u; *quad++ = 0u; *quad++ = 0u;
        /*12*/ *quad++ = 0u; *quad++ = 0u; *quad++ = 0u; *quad++ = 0u;
               *quad++ = 0u; *quad++ = 0u; *quad++ = 0u; *quad++ = 0u;
               *quad++ = 0u; *quad++ = 0u; *quad++ = 0u; *quad++ = 0u;
    }
}
