#include <i86.h>
#include <dos.h>
#include <stdio.h>
#include <string.h>

#include "pm.h"

void allocate_dos_mem(short chunks,dos_mem *ourmem)
{
  union REGS regs;
  struct SREGS sregs;

  memset(&sregs,0,sizeof(sregs));
  regs.w.ax=0x0100;
  regs.w.bx=chunks;
  int386x(0x31, &regs, &regs, &sregs);
  ourmem->segment=regs.w.ax;
  ourmem->selector=regs.w.dx;
}

void free_dos_mem(dos_mem *ourmem)
{
  union REGS regs;
  struct SREGS sregs;

  memset(&sregs,0,sizeof(sregs));
  regs.w.ax=0x0101;
  regs.w.dx=ourmem->selector;
  int386x(0x31,&regs,&regs,&sregs);
}

void call_dos_int(char intr,REAL_REGS RMI)
{
    union REGS regs;
    struct SREGS sregs;

    memset(&sregs,0,sizeof(sregs));
    memset(&regs,0,sizeof(regs));

    regs.w.ax = 0x0300;
    regs.h.bl = intr;
    regs.h.bh = 0;
    regs.w.cx = 0;
    sregs.es = FP_SEG(&RMI);
    regs.x.edi = FP_OFF(&RMI);
    int386x( 0x31, &regs, &regs, &sregs );

}

unsigned int real_to_pm_ptr(unsigned char *real_mode_ptr)
{
  unsigned int retr;
  _asm {
     mov eax,[real_mode_ptr]
     mov ebx,eax
     and ebx,0ffffh
     shr eax,16
     and eax,0ffffh
     shl eax,4
     add eax,ebx
     mov [retr],eax
 };
    return retr;
}
