/*
swivel | CSR
swivel@csrmusic.org
*/

#include	"fastmath.h"
#include	"sprite.h"


void bumpmap(unsigned char *src, unsigned char *dest, int light_x, int light_y, const unsigned int width, const unsigned int height, struct SPRITE *light)
{
	unsigned int	x, y, hxlxdiff, lxdiff = 0;
	int		tx, ty, normal_x, normal_y, angle;
	int		lxbegin, lxend, lybegin, lyend, lx, ly, lw, lh;
	unsigned char 	result, lightbyte, *lightdata;
	unsigned int 	i = 0, j = 0;
	float		pixel, illum;

	memset(dest, 0, width * height);

	hxlxdiff = width - light->width;

	lightdata = light->data;
	lxend = light->width >> 1;
	lyend = light->height >> 1;
	lxbegin = -lxend;
	lybegin = -lyend;

	/* center texture on light position */
	tx = light_x - lxend;
	ty = light_y - lyend;

	if(tx < 0) {
		unsigned int	bla = abs(tx);

		lxbegin += bla;
		j += bla;
		lxdiff = bla;
		hxlxdiff += bla;
	} else {
		if(tx + light->width > width) {
			unsigned int	bla = (tx + light->width) - width;

			lxend -= bla;
			hxlxdiff += bla;
			lxdiff = bla;
		}

		src += tx;
		dest += tx;
	}
			

	if(ty < 0) {
		unsigned int	bla = abs(ty);

		lybegin += bla;
		j += (bla * light->width);
	} else {
		if(ty + light->height > height) {
			lyend -= (ty + light->height) - height;
		}
		src += ty * width;
		dest += ty * width;
	}



	for(ly = lybegin; ly < lyend; ly++) {
		for(lx = lxbegin; lx < lxend; lx++, i++, j++) {
			lightbyte = (lightdata[j] >> 1);

			if(lightbyte) {

				normal_x = src[i + 1] - src[i - 1];
				normal_y = src[i + width] - src[i - width];
				
				angle = normal_x - lx;
				pixel = fastcos(angle);
				illum = lightbyte * pixel;
				if(illum < 0)
					illum = 0;
				result = illum;

				angle = normal_y - ly;
				pixel = fastcos(angle);
				illum = lightbyte * pixel;
				if(illum < 0)
					illum = 0;
				result += illum;

				dest[i] = result;
			}
		}
		i += hxlxdiff;
		j += lxdiff;
	}


	return;
}


void bumpmap_clear(void * unisrc, void * unidest, int light_x, int light_y, unsigned int width, unsigned int height)
{
	int	x, y, tx, ty, normal_x, normal_y = 0;
	unsigned int illum_x, illum_y, pixel;
	unsigned char result;
	

	unsigned char 	*losrc, *lodest;
	unsigned int i =0;

	losrc = unisrc;
	lodest = unidest;

	ty = 0;
	tx = 0;

	for(y = 0; y < height; y++) {
		for(x = 0; x < width; x++) {
			result = 0;

			tx = x - light_x;
			ty = y - light_y;

			if(tx < 160 && tx >-160 && ty < 160 && ty >-160) {
				normal_x = losrc[ i + 1] - losrc[ i - 1];
				normal_y = losrc[ i + width] - losrc[ i - width];
				if( normal_x != 0 && normal_y != 0) {

				pixel = abs(tx - normal_x);

				if(pixel > 127)
					pixel = 127;
					
				illum_x = 127 - pixel;

				if(illum_x < 0)
					illum_x = 1;

					

				pixel = abs(ty - normal_y);

				if(pixel > 127)  
					pixel = 127;

				illum_y = 127 - pixel;

				if(illum_y < 0) 
					illum_y = 1;

				result = illum_x + illum_y;

				}
			}

			lodest[i] = result;
			i++;
		}
	}	
}
