
/*

dont ask.

 swivel | CSR 
 swivel@csrmusic.org 
*/

#include	"distort.h"
#include	"fastmath.h"
#include	<math.h>

#define twidth   256
#define	theight   256



void distort(void *texture, int phase, int rate, double amp,
             void *dest, int dwidth, int dheight)
{

	unsigned int	*dst = dest;
	unsigned int	*txtr = texture;

	/* texture coords */
	unsigned char    tx = 0;
	unsigned char    ty = 0;
	unsigned int	 line;

	/* destination coords */
	unsigned int    dx = 0;
	unsigned int    dy = 0;
	unsigned int    i = 0;


	for(dy = 0; dy < dheight / 32; dy++) {
		ty = dy * fastsin(phase * rate) / amp; 
		line = ty * twidth;

		for(dx = 0; dx < dwidth / 32; dx++) {

			tx = dx * fastcos(phase * rate) / amp;

			dst[i] = txtr[line + tx];
			dst[i + 1] = txtr[line + tx + 1];
			dst[i + 2] = txtr[line + tx + 2];
			dst[i + 3] = txtr[line + tx + 3];
			dst[i + 4] = txtr[line + tx + 1];
			dst[i + 5] = txtr[line + tx + 2];
			dst[i + 6] = txtr[line + tx + 3];
			dst[i + 7] = txtr[line + tx + 3];

			dst[i + twidth / 4] = txtr[line + twidth / 4 + tx];
			dst[i + twidth / 4 + 1] = txtr[line + tx + twidth / 4 + 1];
			dst[i + twidth / 4 + 2] = txtr[line + tx + twidth / 4 + 2];
			dst[i + twidth / 4 + 3] = txtr[line + tx + twidth / 4 + 3];
			dst[i + twidth / 4 + 4] = txtr[line + tx + twidth / 4 + 1];
			dst[i + twidth / 4 + 5] = txtr[line + tx + twidth / 4 + 2];
			dst[i + twidth / 4 + 6] = txtr[line + tx + twidth / 4 + 3];
			dst[i + twidth / 4 + 7] = txtr[line + tx + twidth / 4 + 3];
			i++;
		}
	}
}
