/*

8 bit palette fading function
for fading  a palette to a target palette at a specified rate.

for use along with the sprite library (uses the palette structures for
supporting multiple palette formats)
not.  never got around to implementing the support for multiple palette formats.
oh well ill do it some time, for now it will just um be interesting when fading
from like a targa palette to a pcvga palette (b,g,r -> r,g,b) but the same goal will
still be reached. so thats ok, its just the fading itself that will look interesting.
could actually be beneficial for interesting psychadelic palette fades.

also sprite fading functions. (fade a sprite into a graphics buffer contents)

swivel | CSR
swivel@csrmusic.org
*/


#include	"sprite.h"



int fade_pal(unsigned char *palette, unsigned char *goal, int quantity, int speed)
{
	int	i;
	int	r, g, b, rg, gg, bg;
	int	activity = 0;

	for(i = 0; i < quantity; i++) {

		rg = goal[i * 3];
		if(palette[i * 3] != rg) {
			activity = 1;
			r = palette[i * 3];
			
			if(r < rg) {
				r += speed;
				if(r > rg)
					r = rg;
				palette[i * 3] = r;
			} else {
				if(r > rg) {
					r -= speed;
					if(r < rg)
						r = rg;
					palette[i * 3] = r;
				}
			}
		}


		gg = goal[i * 3 + 1];
		if(palette[i * 3 + 1] != gg){
			activity = 1;
			g = palette[i * 3 + 1];
			
			if(g < gg) {
				g += speed;	
				if(g > gg)
					g = gg;
				palette[i * 3 + 1] = g;
			} else {
				if(g > gg) {
					g -= speed;
					if(g < gg)
						g = gg;
					palette[i * 3 + 1] = g;
				}
			}
		}

		bg = goal[i * 3 + 2];
		if(palette[i * 3 + 2] != bg) {
			activity = 1;
			b = palette[i * 3 + 2];
			
			if(b < goal[i * 3 + 2]) {
				b += speed;	
				if(b > bg)
					b = bg;
				palette[i * 3 + 2] = b;
			} else {
				if(b > bg) {
					b -= speed;
					if(b < bg)
						b = bg;
					palette[i * 3 + 2] = b;
				}
			}
		}
	}

	return activity;
}



/* fading sprites into other sprites.  current is what is modified to meet goal
*/
int fade_sprite_in(struct SPRITE *current, struct SPRITE *goal, int X, int Y, int speed)
{
	unsigned int 		x, y, width, height;
	register unsigned int	i = 0, j = 0;
	int			activity = 0;
	unsigned int		gdiff = 0, cdiff = 0;
	unsigned char 		*cur, *dst, trans, dpixel;
	short 			spixel; 

	cur = current->data;
	dst = goal->data;
	trans = goal->transparent;


	if(current->width >= goal->width) {
		cdiff = current->width - goal->width;
		width = goal->width;
	} else {
		gdiff = goal->width - current->width;
		width = current->width;
	}

	if(current->height >= goal->height) {
		height = goal->height;
	} else {
		height = current->height;
	}

	/* adjust dest pointer to position desired */
	cur += (Y * current->width) + X;

	for(y = 0; y < height; y++) {
		for(x = 0; x < width; x++, i++, j++) {

			dpixel = dst[j];

			if(dpixel != trans) {	

				spixel = cur[i];

				if(spixel != dpixel) {
					activity = 1;

					if(spixel < dpixel) {
						spixel += speed;

						if(spixel > dpixel)
							cur[i] = dpixel;
						else 
							cur[i] = spixel;
					} else {
						spixel -= speed;

						if(spixel < dpixel) 
							cur[i] = dpixel;
						else
							cur[i] = spixel;
					}
				}
			}
		}

		i += cdiff;
		j += gdiff;
	}	

	return activity;
}



/* fading sprite out of current sprite.  requires 3 sprits, currents original
sprite (what to fade back to), current, and the sprite that was faded in.
*/
int fade_sprite_out(struct SPRITE *current, struct SPRITE *goal, struct SPRITE *map, int X, int Y, int speed)
{
	unsigned int 		x, y, width, height;
	register unsigned int	i = 0, j = 0, k = 0;
	int			activity = 0;
	unsigned int		cdiff = 0, gdiff = 0, mdiff = 0;
	unsigned char 		*cur, *dst, *mapdata, trans, dpixel, mpixel;
	short 			spixel; 

	cur = current->data;
	dst = goal->data;
	mapdata = map->data;
	trans = map->transparent;

	if(current->width >= map->width) {
		cdiff = current->width - map->width;
		gdiff = goal->width - map->width;
		width = map->width;
	} else {
		mdiff = map->width - current->width;
		width = current->width;
	}

		

	if(current->height >= map->height) {
		height = map->height;
	} else {
		height = current->height;
	}

	/* adjust dest pointer to position desired */
	cur += (Y * current->width) + X;
	dst += (Y * goal->width) + X;

	for(y = 0; y < height; y++) {
		for(x = 0; x < width; x++, i++, j++, k++) {

			mpixel = mapdata[j];

			if(mpixel != trans) {	

				dpixel = dst[k];
				spixel = cur[i];

				if(spixel != dpixel) {
					activity = 1;

					if(spixel < dpixel) {
						spixel += speed;

						if(spixel > dpixel)
							cur[i] = dpixel;
						else 
							cur[i] = spixel;
					} else {
						spixel -= speed;

						if(spixel < dpixel) 
							cur[i] = dpixel;
						else
							cur[i] = spixel;
					}
				}
			}
		}

		i += cdiff;
		j += mdiff;
		k += gdiff;
	}	

	return activity;
}



int fade_sprite_center_in(struct SPRITE *current, struct SPRITE *goal, int speed)
{
	int x, y;

	x = current->width - goal->width;
	y = current->height - goal->height;

	/* halves for center */
	x >>= 1;
	y >>= 1;

	return fade_sprite_in(current, goal, x, y, speed);
}



int fade_sprite_center_out(struct SPRITE *current, struct SPRITE *goal, struct SPRITE *map, int speed)
{
	int x, y;

	x = current->width - map->width;
	y = current->height - map->height;

	/* halves for center */
	x >>= 1;
	y >>= 1;

	return fade_sprite_out(current, goal, map, x, y, speed);
}
