/*
variable wave distortion

swivel - CSR
swivel@csrmusic.org
*/


#include	<math.h>
#include	"fastmath.h"


void wave(void * src, void * dest, double amp, double phase, double freq, int width, int height)
{
	unsigned char *tdest, *tsrc;
	int	twidth, theight;
	int	x, y;
	int	xoff, yoff;
	int	cur_y;
	double  ix = 0, iy = 0;

	tsrc = src;
	tdest = dest;



	for(y = 0; y < height; y++) {
		yoff = y + (amp * cos(phase + iy));	
		cur_y = y * width;

		for(x = 0; x < width; x++) {
			xoff = x + (amp * cos(phase + ix));	

			if( xoff < width &&
			    xoff > 0 &&
			    yoff < height &&
			    yoff > 0 ) {

				tdest[(cur_y + x)] = 
				tsrc[((yoff) * width) + xoff];

			}

		ix += freq;

		}

	iy += freq;

	}
}
