/*
image file format
non-compressed simple format without embedded palettes mainly for sprite use.

Swivel | CSR
swivel@csrmusic.org

*/

/*
	image
	file format
	5			char		"IMAGE" - ID
	1			ushort		width
	1			ushort		height
	(width * height)	uchar		data

	palette
	file format
	3			char		"PAL" - ID
	1			uchar		start
	1			ushort		quantity
	(quantity * 3)		uchar		data
			palette data will be stored in 8 bpe format (0-255)
*/


#include	<stdio.h>
#include        <sys/types.h>
#include        <sys/stat.h>
#include        <fcntl.h>
#include	"image.h"

struct im * imload_image(char *path)
{
	char		ID[5];
	struct	im	*image;
	int		file;

	file = open(path, O_RDONLY);
	if(file == -1) {
		printf("Error opening image: %s\n", path);
		return NULL;
	}

	image = imnew_image();
	if(image == NULL) return NULL;
		

	read(file, ID, 5);
	if(strncmp("IMAGE", ID, 5) != 0) return NULL;

	read(file, &image->width, 2);
	read(file, &image->height, 2);

	image->data = (unsigned char *)calloc(1, image->width * image->height);
	if(image->data == NULL) {
		printf("Error allocating %i bytes for image data\n",
			image->width * image->height);
		return NULL;
	}

	read(file, image->data, image->width * image->height);

	close(file);

	return(image);
}



struct pal * imload_palette(char *path)
{
	char		ID[3];
	struct	pal	*palette;
	int		file;


	file = open(path, O_RDONLY);
	if(file == -1) {
		printf("Error opening palette: %s\n", path);
		return NULL;
	}

	palette = imnew_palette();
	if(palette == NULL) {
		return NULL;
	}

	read(file, ID, 3);
/*
	if(ID != "PAL") {
		return NULL;
	}	
*/

	read(file, &palette->start, 1);
	read(file, &palette->quantity, 2);
	palette->data = (unsigned char *)calloc(1, palette->quantity * 3);
	if(palette->data == NULL) {
		printf("Error allocating %i bytes for palette data\n",
			palette->quantity * 3);
		return NULL;
	}

	read(file, palette->data, palette->quantity * 3);

	close(file);

	return palette;
}


int	imsave_image(struct im *image, char *path)
{
	int	file;

	if(image == NULL) {
		printf("Invalid image data\n");
		return 0;
	}

	file = open(path, O_WRONLY | O_CREAT);
	if(file == -1) {
		printf("Error creating file: %s\n", path);
		return 0;
	}

	write(file, "IMAGE", 5);
	write(file, &image->width, 2);
	write(file, &image->height, 2);
	write(file, image->data, image->width * image->height);

	close(file);

	return 1;
}


int	imsave_palette(struct pal *palette, char *path)
{
	int	file;

	if(palette == NULL) {
		printf("Invalid palette data\n");
		return 0;
	}

	file = open(path, O_WRONLY | O_CREAT);
	if(file == -1) {
		printf("Error creating file: %s\n", path);
		return 0;
	}

	write(file, "PAL", 3);
	write(file, &palette->start, 1);
	write(file, &palette->quantity, 2);
	write(file, palette->data, palette->quantity * 3);

	close(file);

	return 1;
}


struct im * imnew_image(void)
{
	struct im  *image;

	image = (struct im *)calloc(1, sizeof(struct im));
	if(image == NULL) {
		printf("Error allocating %i bytes for image structure\n");
		return NULL;
	}

	return image;
}


struct pal * imnew_palette(void)
{
	struct pal  *palette;

	palette = (struct pal *)calloc(1, sizeof(struct pal));
	if(palette == NULL) {
		printf("Error allocating %i bytes for palette structure\n");
		return NULL;
	}

	return palette;
}
