/* music player for demos */
/* output to OSS and a nosound driver */
/* many thanks go out to the many authors of mikmod */
/* swivel | CSR */
/* swivel@csrmusic.org */

#include	<stdio.h>
#include	<unistd.h>
#include	<mikmod.h>
#include	"music.h"
#include	"synch.h"

#ifdef	SDLHACK
	extern int	premature;
#endif


void	playsong(char * songname)
{

	MODULE *songfile;


	md_mixfreq      = 44100;        /* standard mixing freq */
        md_device       = 0;            /* standard device: autodetect */
        md_volume       = 96;           /* driver volume (max 128) */
        md_musicvolume  = 128;          /* music volume (max 128) */
        md_sndfxvolume  = 128;          /* sound effects volume (max 128) */
        md_pansep       = 128;          /* panning separation (0=mono 128=full stereo)*/
        md_reverb       = 0;            /* Reverb (max 15) */
        /* default mixing mode */
        md_mode                 = DMODE_16BITS | DMODE_STEREO | DMODE_SOFT_MUSIC;



        MikMod_RegisterAllLoaders();
        MikMod_RegisterAllDrivers();


	MikMod_Init();


	if(!(songfile = Player_Load(songname, 32, 0))) {
		printf("Error loading song: %s\n", songname);
		return;
	}


	    songfile->extspd  = 1;
	    songfile->panflag = 1;
 	    songfile->wrap    = 0;
 	    songfile->loop    = 0;
 	    songfile->fadeout = 0;


	Player_Start(songfile);


#ifdef	SDLHACK
	while(Player_Active() && !premature) {
#else
	while(Player_Active()) {
#endif
		MikMod_Update();
		usleep(10);
	}


	Player_Stop();
	Player_Free(songfile);

}

