/* palette type defines */
#define PCVGA8BIT	0
#define TARGA8BIT	1
#define PCVGA6BIT	2
#define TARGA6BIT	3

#include	"targa.h"
#include	"image.h"

	
struct SPRITE {
	unsigned char *	data;
	unsigned int	width;
	unsigned int	height;
	unsigned char	transparent;		
};

struct PALETTE {
	unsigned char * data;
	unsigned short start;
	unsigned short quantity;
	unsigned char type;
};

void    set_palette(struct PALETTE *);

void	draw_sprite(struct SPRITE *, unsigned char *,
	            int, int, int, int);

void	draw_sprite_trans(struct SPRITE *, unsigned char *,
	            int, int, int, int);

void 	draw_sprite_center(struct SPRITE *, unsigned char *, int, int);
void 	draw_sprite_trans_center(struct SPRITE *, unsigned char *, int, int);


struct SPRITE * load_sprite(char *);
void unload_sprite(struct SPRITE *);
struct PALETTE * load_palette(char *);
void unload_palette(struct PALETTE *); 
struct SPRITE * sprite_from_targa(struct TARGA *);
struct SPRITE * sprite_from_image(struct im *);
struct SPRITE * sprite_from_data(unsigned char *, int, int, int);
struct PALETTE * new_palette_struct(void);
struct SPRITE * new_sprite_struct(void);
