/*

L O O P

swivel | CSR
swivel@csrmusic.org

*/

#include	<stdio.h>
#include	<stdlib.h>
#include	<pthread.h>
#include	<sys/time.h>
#include	<sys/resource.h>

#ifdef	SDLHACK
#	include		<SDL/SDL.h>
#else
#	include		<vga.h>
#	include		<signal.h>
#	include		<sys/wait.h>
#endif

#include	"fastmath.h"
#include	"./prefs.h"
#include	"io/synch.h"
#include	"io/music.h"

#include	"scenes/scenes.h"

#define		demo_version	"16.843"
#define		ITFILE		"data/loop.it"



#ifdef	SDLHACK
	extern SDL_Surface	*SDLscreen;
	int			premature = 0;
#else
	pid_t			demo_process;
	void    		synch(int sig);
	void    		effect(int sig);
#endif
	int			effekt = 0;
	int			noexit = 1;


void	mikmodthread(void)
{
        setpriority(PRIO_PROCESS, 0, 5);
	playsong(ITFILE);
#ifdef	SDLHACK
	pthread_exit(0);
#else
	return;
#endif
}

int	main(void)
{
#ifdef	SDLHACK
	pthread_t       	mikmod_thread;
	unsigned int		video_flags;
#else
	pid_t			phunkE;
	struct sigaction	sync;
	struct sigaction	effct;
#endif
	unsigned char 		*temp1_buffer;
	unsigned char 		*temp2_buffer;
	unsigned char 		*screen_buffer;


	printf("Loop version %s\n", demo_version);
	printf("Loading...\n");

#ifdef	SDLHACK
	/* SDL == X11 == multithreading allowed :) :) */
        pthread_create( &mikmod_thread, NULL, mikmodthread, NULL);
#else
	/* SVGAlib == SIGUSR1/2 needed == IPC :( :( */
	/* we still use SIGUSR? in demo for synching, hit alt-F? during demo */
	/* dont care... SVGAlib needs to be fixed. tried multithreaded version
	/* with svgalib and nothing happened :), literally. */
        demo_process = getpid();

        /* fork mikmod */
        phunkE = fork();

        switch(phunkE) {

        case -1:
		printf("blah!@#!$@!$!@%$@#%@\n");
                exit(1);

        case 0:
                mikmodthread();
                exit(0);

        default:

	        /* setup signal handler for synch */
       		sync.sa_handler = synch;
       	 	sigemptyset(&sync.sa_mask);
        	sync.sa_flags = 0;

        	/* setup signal handler for fx */
        	effct.sa_handler = effect;
        	sigemptyset(&effct.sa_mask);
        	effct.sa_flags = 0;


                break;
        }
#endif



	init_gfx();
#ifndef	SDLHACK
        sigaction(SIGUSR2, &sync, 0);
        sigaction(SIGUSR1, &effct, 0);
#else
	SDL_WM_SetCaption(". L O O P .", "loop-sdl");
#endif

	/* initialize sin/cos LUT */
	init_math();

	/* allocate screen buffers */
	printf("Allocating memory...\n");

	(unsigned char *)screen_buffer = calloc(1, VWIDTH * (VHEIGHT + 2));
	if(screen_buffer == NULL) {
		printf("Error allocating screen_buffer.\n");
		return 0;
	}

	(unsigned char *)temp1_buffer = calloc(1, VWIDTH * (VHEIGHT + 2));
	if(temp1_buffer == NULL) {
		printf("Error allocating temp1_buffer.\n");
		return 0;
	}

	(unsigned char *)temp2_buffer = calloc(1, VWIDTH * (VHEIGHT + 2));
	if(temp2_buffer == NULL) {
		printf("Error allocating temp2_buffer.\n");
		return 0;
	}

	/* padding on the buffers of 1 line to allow dirty (faster) blurring
	   and such effects. 3 is actually more than needed, but I got lazy.
	*/
	screen_buffer += VWIDTH;
	temp1_buffer += VWIDTH;
	temp2_buffer += VWIDTH;


		printf("And now, my friends, the action begins.  Hopefully.\n");
		intro(screen_buffer, temp1_buffer, temp2_buffer);
		psychadelic(screen_buffer, temp1_buffer, temp2_buffer);
		jupiter(screen_buffer, temp1_buffer, temp2_buffer);
		bump(screen_buffer, temp1_buffer, temp2_buffer);
		rotozoom(screen_buffer, temp1_buffer, temp2_buffer);
		fuse(screen_buffer, temp1_buffer, temp2_buffer);
		rain(screen_buffer, temp1_buffer, temp2_buffer);
		credits(screen_buffer, NULL, NULL);

	printf("\nCleaning up.");
	free(screen_buffer - VWIDTH);
	printf(".");
	free(temp1_buffer - VWIDTH);
	printf(".");
	free(temp2_buffer - VWIDTH);
	printf(".\n");



	close_gfx();

	printf("Waiting for libmikmod to exit...\n");
#ifdef	SDLHACK
	premature = 1;
	pthread_join(mikmod_thread, NULL);
#else
	waitpid(phunkE, NULL, 0);
#endif


	printf("\n-*- www.csrmusic.org -*-\n"); /* PLUG! */
	printf("\nYeah, Whatevah.\n"); /* sifl & olly 'whatever' */

	printf("\n . L O O P .  1st place @ Spring Break 1999 \n");


	return 1;
}

#ifndef	SDLHACK
void    effect(int s)
{
        effekt  = 1;
#ifdef LMMDEBUG
        printf("Recieved signal: %i for effect\n", s);
#endif
}

void    synch(int s)
{
        noexit = 0;
#ifdef LMMDEBUG
        printf("Recieved signal: %i for synch\n", s);
#endif
}
#endif

