
/* swivel | CSR */
/* swivel@csrmusic.org */

#include	<stdio.h>
#include	"sprite.h"
#include	"fade.h"
#include	"gfx.h"
#include	"bumpmap.h"
#include	"fastmath.h"
#include	"prefs.h"


extern int effekt;
extern int noexit;



void setlinpal(void)
{
	struct PALETTE 	*pal;
	unsigned char 	paldata[256 * 3];
	int		l = 0, p = 0;
	float		r = 0;

	pal = new_palette_struct();

	pal->data = paldata;
	pal->type = PCVGA8BIT;
	pal->quantity = 256;


		for(p = 0 ; p < 256 ; p++) {

			paldata[p * 3] = (p);
			paldata[p * 3 + 1] = (p / 3);
			paldata[p * 3 + 2] = (p / 5);

			r += .00351562;
		}

	set_palette(pal);
	free(pal);
}


void bump(unsigned char *screen, unsigned char *temp1, unsigned char *temp2)
{
	struct SPRITE 	*image, blah, *light;
	struct SPRITE 	*sprites[9];
	int		sprite = 0;
	int		lx = 0, ly = 0;
	int		D = 100;
	int		lightspeed = 2;
	int		p = 0;
	int 		fadeleft = 1;
	int		i;
	int		notidle = 1;
	int		direction = 0;
	unsigned char	*temp;


	noexit = 1;

	/* main bumpmap */
	image = load_sprite("data/bump.img");

	/* bumpmap light sprite (cheeseball ;) )*/
	/*light = load_sprite("data/light-small.img"); */
	light = load_sprite("data/light-huge.img");


/* load pics.. umm.. this is a bad way of doing it.. could really cause a 
significant pause on a slower box, a better way may be to load them on the fly
as they are needed, would distribute the chunk more across the scene lowering
possibility of there being a significant pause in the beginning of the scene
screwing with the flow of things.... oh well for now */

	sprites[0] = load_sprite("data/moon.img");
	sprites[1] = load_sprite("data/atomic.img");
	sprites[2] = load_sprite("data/star.img");
	sprites[3] = load_sprite("data/hearts.img");
	sprites[4] = load_sprite("data/dr.img");
	sprites[5] = load_sprite("data/cryptic.img");
	sprites[6] = load_sprite("data/stench.img");
	sprites[7] = load_sprite("data/records.img");
	sprites[8] = load_sprite("data/stupidthing.img");

	memset(screen, 0, VWIDTH * VHEIGHT);
	draw_screen(screen);

	draw_sprite(image, screen, 0, 0, VWIDTH, VHEIGHT);
	draw_sprite(image, temp2, 0, 0, VWIDTH, VHEIGHT);

	/* we will use one of the framebuffers as a sprite in this scene */
	blah.width = VWIDTH;
	blah.height = VHEIGHT;
	blah.transparent = 0;
	blah.data = temp2;
	

	setlinpal();


	while(noexit) {

	/* move light source */
		lx = D * (fastcos(p) * fastsin(ly << 20));
		ly = D * (fastsin(p) * fastcos(lx << 20));


		bumpmap(screen, 
			temp1, 
			lx + (VWIDTH / 2),
			ly + (VHEIGHT / 2),
			VWIDTH, 
			VHEIGHT,
			light);


		draw_screen(temp1);


		if(direction == 1) {
			if(fadeleft) {
				/* fade object in */
				fadeleft = 
				fade_sprite_center_in(&blah, sprites[sprite], 35);
				draw_sprite(&blah, screen, 0, 0, VWIDTH, VHEIGHT);
				blur_opt(screen, temp1, VWIDTH * VHEIGHT);

				temp = temp1;
				temp1 = screen;
				screen = temp;
			}
		} else if(direction == 2) {
			
			if(fadeleft) {
				/* fade object out */
				fadeleft =
				fade_sprite_center_out(&blah, image, sprites[sprite], 35);
				draw_sprite(&blah, screen, 0, 0, VWIDTH, VHEIGHT);
				blur_opt(screen, temp1, VWIDTH * VHEIGHT);

				temp = temp1;
				temp1 = screen;
				screen = temp;
			}
		}


		if(effekt) {
			if(sprite < 8) {
				direction++;
				if(direction > 2) {
					direction = 1;
					unload_sprite(sprites[sprite]);
					sprite++;
				}

				fadeleft = 1;
			}
				
			effekt = 0;
		}


		p += lightspeed;

		usleep(200);
	}

	unload_sprite(sprites[sprite]);
	unload_sprite(image);
	unload_sprite(light);
}


