
/* swivel | CSR */
/* swivel@csrmusic.org */

#include	<stdio.h>
#include	<stdlib.h>
#include	<sprite.h>
#include	"fastmath.h"
#include	"gfx.h"
#include	"bumpmap.h"
#include	"water.h"
#include	"prefs.h"

extern int effekt;
extern int noexit;


void water_pal(unsigned char *dest)
{
	int	p;

		for(p = 0 ; p < 256 ; p++)
		{ 
				dest[p * 3] = p / 2; 
				dest[p * 3 + 1]	= p / 1.5; 
				dest[p * 3 + 2] = p;
		}
}


void disturb_water(struct WATER *water, int x, int y)
{
	short	*dest;

	dest = water_page(water);

	if( x < VWIDTH - 2 && y < VHEIGHT - 2 && x > 2 && y > 2) {
		dest[(y * VWIDTH) + x] = 256;
		dest[(y * VWIDTH) + x + 1] = 256;
		dest[(y * VWIDTH) + x + 2] = 256;
		dest[((y + 1) * VWIDTH) + x] = 256;
		dest[((y + 1) * VWIDTH) + x + 1] = 256;
		dest[((y + 1) * VWIDTH) + x + 2] = 256;
		dest[((y + 2) * VWIDTH) + x] = 256;
		dest[((y + 2) * VWIDTH) + x + 1] = 256;
		dest[((y + 2) * VWIDTH) + x + 2] = 256;
	}
}

void draw_water(struct WATER *water, unsigned char *dest)
{
	short		*src;
	unsigned char	blah;
	int		size = water->width * water->height;
	int		i;

	src = water_page(water);

	for(i = 0; i < size; i++) {
		blah = abs(src[i]); 
		dest[i] = blah;
	}
}

void rain(unsigned char *screen, unsigned char *temp1, unsigned char *temp2)
{
	double		wav = 0;
	struct WATER	*water;
	struct PALETTE 	pal, *active_pal;
	struct SPRITE	*light;
        unsigned char   active_data[256 * 3];
        unsigned char   pal_data[256 * 3];
        int		tpal[256 * 3];
	unsigned char	*blankpal;
	int		R = 0;
	int		poop;
	int		i;
	int		fadeleft = 1;

	noexit = 1;

	active_pal = get_palette();
	light = load_sprite("data/light-small.img");
        blankpal = (unsigned char *)calloc(1, 256 * 3);
	water_pal(pal_data);

	water = new_water(VWIDTH, VHEIGHT);


 	while(fadeleft) {
                fadeleft = fade_pal(active_pal->data, blankpal, 256, 10);
                set_palette(active_pal);
        }


	fadeleft = 1;
	while(noexit) {


		for(poop = 0; poop < abs(10 * fastcos(R)); poop++) {

#ifdef THIRTEENH
			disturb_water(water, 
			      1 + (int) (320.0 * rand() / (RAND_MAX+1.0)),
			      1 + (int) (200.0 * rand() / (RAND_MAX+1.0)));
#endif


#ifdef MODEX
			disturb_water(water, 
			      1 + (int) (320.0 * rand() / (RAND_MAX+1.0)),
			      1 + (int) (240.0 * rand() / (RAND_MAX+1.0)));
#endif

#ifdef SVGA
			disturb_water(water, 
			      1 + (int) (640.0 * rand() / (RAND_MAX+1.0)),
			      1 + (int) (480.0 * rand() / (RAND_MAX+1.0)));
#endif

#ifdef SDLLO
			disturb_water(water, 
			      1 + (int) (320.0 * rand() / (RAND_MAX+1.0)),
			      1 + (int) (240.0 * rand() / (RAND_MAX+1.0)));
#endif

#ifdef SDLHI
			disturb_water(water, 
			      1 + (int) (640.0 * rand() / (RAND_MAX+1.0)),
			      1 + (int) (480.0 * rand() / (RAND_MAX+1.0)));
#endif

		}
		
		move_water(water, 4);
		draw_water(water, screen);

		bumpmap(screen, 
			temp1, 
			(VWIDTH / 2) + 100 * fastsin(R) * fastcos(R), 
			(VHEIGHT / 2) + 100 * fastcos(R), 
			VWIDTH, 
			VHEIGHT,
			light);

		draw_screen(temp1);

		R += 8;

                if(fadeleft) {
                        fadeleft = fade_pal(active_pal->data, pal_data, 256, 10);
                        set_palette(active_pal);
                }

		usleep(5);
	}

	free(blankpal);
	del_water(water);
	unload_sprite(light);
	unload_palette(active_pal);

	return;
}
