/*

image blurring function

loads image specified @ commandline
displays image with a linear palette
hit 's' to save file and exit
hit any other key to quit without save

blurring will be done in real-time while being displayed.

swivel | CSR
swivel@csrmusic.org

this was developed post party to blur the bump mapping images before demo
use, gimp wasnt doing a very good (linear) job of it, and it looked cherry
when blurred real-time in the demo 2-3 times before being bump mapped.
but this was a severe waste of cpu time.  so here you go.

*/



#include	<stdio.h>
#include	<limits.h>
#include	<vga.h>
#include	<math.h>

#include	"gfx.h"
#include	"sprite.h"
#include	"blur.h"
#include	"bumpmap.h"
#include	"prefs.h"

#define		amount		1

void linpal(void)
{
	int p;

	for(p = 0; p < 256; p++) {
		vga_setpalette(p, p / 7, p / 4, p / 4);
	}	
}


void save_file(struct im *image, unsigned char *newdata)
{
	char *path;
	path = (char *)calloc(1, PATH_MAX);

	vga_setmode(TEXT);


	image->data = newdata;

	printf("Enter filename to save new blurred targa as: ");
	gets(path);

	if(!imsave_image(image, path)) {
		printf("Error saving image to %s\n", path);
		exit(0);
	}

	exit(1);	
}


int main(int argn, char *args[])
{
	unsigned char screen_buffer[VWIDTH * VHEIGHT];
	unsigned char bump_buffer[VWIDTH * VHEIGHT];
	unsigned char *padded_buffer, *padded2_buffer;
	struct im *sourcefile;
	struct SPRITE *tempsprite, *temp2sprite, *light;
	double	r = 0;

	if(argn < 2) {
		printf("targa file blurring utility. \nUsage: %s filename.tga\n", args[0]);
		return 0;
	}

	sourcefile = imload_image(args[1]);
	if(sourcefile == NULL) return 0;
	

	light = load_sprite("../data/light-huge.img");
	if(light == NULL) {
		printf("error loading light\n");
		return 0;
	}

	padded_buffer = (unsigned char *)calloc(1, 
	(sourcefile->width + (amount * 2)) * (sourcefile->height + (amount * 2)))
	+ (sourcefile->width * amount);
	if(padded_buffer == NULL) {
		printf("Error allocating padding buffer\n");
		return 0;
	}

	padded2_buffer = (unsigned char *)calloc(1, 
	(sourcefile->width + (amount * 2)) * (sourcefile->height + (amount * 2)))
	+ (sourcefile->width * amount);
	if(padded2_buffer == NULL) {
		printf("Error allocating 2nd padding buffer\n");
		return 0;
	}


	tempsprite = sprite_from_image(sourcefile);
	draw_sprite(tempsprite, padded_buffer, 0, 0, tempsprite->width, tempsprite->height);

	temp2sprite = sprite_from_data(padded2_buffer, 
	sourcefile->width, sourcefile->height, 0);


	memset(screen_buffer, 0, VWIDTH * VHEIGHT);
	vga_init();
	vga_setmode(VMODE);
	linpal();






		blur_data_8(padded_buffer, padded2_buffer, temp2sprite->width, temp2sprite->height, amount, amount);
		draw_sprite(temp2sprite, screen_buffer, 0, 0, VWIDTH, VHEIGHT);

		draw_screen(screen_buffer);


	switch(getchar()) {

	case 'q':
		return 1;

	case 's':
		save_file(sourcefile, padded2_buffer);
		return 1;

	default:
		return 0;	
	}


	vga_setmode(TEXT);
	return 1;
}
