uniform float iTime;

    float drawSun(vec2 uv, float radius) {
        float dist = length(uv);
        return smoothstep(radius, radius - 0.01, dist);  // Smooth edge for anti-aliasing
    }

    // Function to create the spinning rays
    float drawRays(vec2 uv, float time) {
        vec2 direction = normalize(uv);
        float angle = atan(direction.y, direction.x);  // Polar angle of the current pixel
        float radius = length(uv);
        
        // Increase the thickness of rays based on the distance to the screen corners
        float thickness = radius * 0.1 + 0.7;  // Increase thickness further from the center
        
        // Create rays using the angle, and spin them with time
        float rayPattern = cos(angle * 12.0 + time * 12.0);  // 12 rays spinning over time
        return smoothstep(thickness, thickness - 0.005, abs(rayPattern));  // Smooth transition
    }

void main( )
{

    vec2 iResolution = vec2(1920., 1080.);

    // Built-in uniforms in ShaderToy
    vec2 u_resolution = iResolution.xy;
    float u_time = iTime;

    // Normalize and center UV coordinates
    // vec2 uv = (fragCoord - u_resolution * 0.5) / u_resolution.y;

    vec2 uv = gl_TexCoord[0].xy;

    // Function to draw the central sun

    // Draw the spinning rays
    float rays = drawRays(uv, u_time);

    // Draw the sun in the middle
    float sun = drawSun(uv, 0.2);  // Radius of 0.2

    // Combine sun and rays
    vec3 color = mix(vec3(0.5, 0.5, 0.6), vec3(1.0), rays);  // Sun color (yellowish)
    color = mix(color, vec3(0.5, 0.5, 0.6), sun);  // Rays color (lighter yellow)
    
    // Output final color
    gl_FragColor = vec4(color, 1.0);
}
