org 0x100

; Variables
time      equ   0x900
cur_x     equ   0x902
cur_y2    equ   0x903
intensity equ   0x904

initial_time    equ 0xffc0
final_time      equ 0x86

; blue and white
bg_color    equ 0x0b
fg_color    equ 0x0f
; red + gray
;bg_color    equ 0x04
;fg_color    equ 0x07

init:
;  mov ax, 0x251c
;  mov dl, timer
;  int 0x21

  mov ax, 0xb800
  push eax
  pop es

  mov word [time], initial_time
top:
  mov dx, 80*24 - 1

frame:

  mov ax, dx
  mov cl, 80
  div cl                    ; ah = x, al = y
  mov byte [cur_x], ah      ; x

  push ax

  xchg ah, al               ; al = x, ah = y

  shr ah, 1   ; ah < y / 2
  mov byte [cur_y2], ah
  mov bl, ah  ; bl = y2 (y / 2)
  mov cl, ah  ; cl = y2, ah = y2
  add cl, 0x3 ; i = y2 + 3
  mov ch, 0

  mov byte [intensity], byte 0 ; c = 0

loop1:
  mov al, [cur_x] ; al < x
  shr al, 2       ; al < x/4
  add al, cl      ; al < x/4 + i

  test bl, 0x1    ; y2 par / impar
  jz move_left

  add al, byte [time]
  jmp continue

move_left:
  sub al, byte [time]

continue:
  or al, bl       ; al < al | y2
  mov ah, 0
  div byte [mod_table]
  cmp ah, 0
  jnz skip
  inc byte [intensity]

skip:
  loop loop1

  mov al, byte [intensity]

code:
  cmp al, 0x4
  jle skip2

  mov al, 0x4

skip2:
  shl al, 2         ; c x 4

  and byte [cur_x], 0x3 ; x4

  test bl, 0x1
  jz next

  add byte [cur_x], 2
  and byte [cur_x], 0x3

next:
  clc
  adc al, byte [cur_x]

  mov bl, al
  mov bh, 0

  mov al, byte [density2d + bx]

paint:
  mov bx, dx
  shl bx, 1
  ; DEBUG mov al, byte [intensity]
  ; DEBUG adc al, 0x30

paint_char:
  mov byte [es:bx], al

  pop ax
  cmp ah, 31
  jl skip3
  cmp ah, 49
  jg skip3

setbgcolor:
  mov al, bg_color
  jmp apply_color

skip3:
  mov al, fg_color

apply_color:
  mov byte [es:bx+1], al

skip_frame:

  dec dx
  jge frame

  inc bp
  mov cx, bp
  and cx, 0b0000000000111111
  jnz top

  ; tick
  add word [time], 1

  ;cmp word [time], 0x129
  cmp word [time], final_time
  jl top

  dec byte [code+1]
  dec byte [code+5]

  ;dec byte [setbgcolor+1]

  jge top

  mov      bx, 2*80*12 + 38*2
  ;mov      dword [es:bx+4], 0x0f500f46
  ;mov      dword [es:bx], 0x04030f49 ; I love FP
  ;mov      word [es:bx+8], 0x0e02  ; smily
  ;mov      dword [es:bx], 0x034C0b46 ; FLASH
  ;mov      dword [es:bx+4], 0x03530b41
  ;mov      word [es:bx+8], 0x0b48
  mov      dword [es:bx], 0x0b500b46 ; FP`25
  mov      dword [es:bx+4], 0x08320860
  mov      word [es:bx+8], 0x0835

  int 0x20

mod_table:
  db 11

density2d:
  db 0x20, 0x20, 0x20, 0x20
  db 0x20, 0x20, 0xb3, 0x20
  db 0x20, 0x20, 0xdb, 0x20
  db 0x20, 0xde, 0xdb, 0xdd
  db 0xde, 0xdb, 0xdb, 0xdd

;music:
;  db 0xc3  ; change instrument on channel 3
;  db 49    ; Instrument: https://en.wikipedia.org/wiki/General_MIDI#Sound_Effects
;  db 0x93  ; play note on channel 3
;  db 10    ; deep "b" = note number 35
;  db 34    ; play with volume = 127
;  ;db 43    ; play with volume = 127
