#!/bin/bash
set -e

echo "Instalando dependencias..."
#sudo apt update
#sudo apt install -y python3 python3-pip python3-venv git ffmpeg cmake build-essential portaudio19-dev libsdl2-dev libfftw3-dev
python3 -m venv py3venv
. py3venv/bin/activate
pip install pyyaml


# Clonar solo si no existe
echo "Descargando repositorios..."
[ -d "audpv" ] || git clone https://github.com/caalma/audpv
[ -d "rpn_eval" ] || git clone https://github.com/caalma/rpn_eval

# Compilar audpv
echo "Compilando audpv..."
cd audpv
make
cd ..

# Compilar rpn_eval/base
echo "Compilando rpn_eval/base..."
cd rpn_eval/base
make
cd ../..

# Crear enlace
echo "Creando enlace simbólico..."
rm -f cliente_server.bash
ln -s "$(realpath rpn_eval/aplicaciones/audio-bytebeat-interactive/utils/clients_of_server/bash/directo.bash)" cliente_server

echo "Todo completado con éxito."
