#!/usr/bin/env python3

from sys import argv
from time import sleep
import yaml
from subprocess import Popen, run


#/home/carlos/Escritorio/1_Trabajos/caalma/sonoro/i-rracional+predecibre/audio-bytebeat-interactive/abb_server

def obtener_serie(archivo):
    with open(archivo, 'r') as f:
        dat = f.read().strip()
        entero, decimal = dat.split('.')
        return [entero, decimal]

def separar_en_lista_de(n, lista):
    return [lista[i:i+n] for i in range(0, len(lista), n)]

def duraciones_hasta(m, lista):
    n = 0
    suma = 0
    for v in lista:
        if suma >= m:
            break
        suma += int(v)
        n += 1
    return n

def calcular_distancias(numero_string):
    digitos = [int(d) for d in numero_string]
    distancias = [abs(digitos[i] - digitos[i+1]) for i in range(len(digitos) - 1)]
    return ''.join(map(str, distancias))

def enviar(cmd):
    p = run(cmd, shell=True, capture_output=True, text=True)
    return p.stdout


def main(ar_seteo):
    seteo = {}
    with open(ar_seteo, 'r') as f:
        seteo = yaml.safe_load(f)

    trios = []
    duraciones = []
    cliente_bb = seteo['cliente_de_bytebeat']
    duracion_total = seteo['duracion_total']
    expr_elegida = seteo['expresion_elegida']
    expresion_base = seteo['expresion'][expr_elegida]
    tiempo_inicial = seteo['tiempo_inicial']

    simular = seteo['simular']
    ut = seteo['unidad_temporal']
    if seteo['separacion_automatica']:
        sn_entero, sn_decimal = obtener_serie(seteo['archivo_serie_numerica'])
        dos_cifras = separar_en_lista_de(2, sn_decimal)
        trios = separar_en_lista_de(3, dos_cifras)

        duraciones = separar_en_lista_de(1, calcular_distancias(f'{sn_entero}{sn_decimal}'))
        duraciones = duraciones[:len(trios)]
        if seteo['normalizar_0_a_10']:
            duraciones = ['10' if v == '0' else v for v in duraciones]

        segmentos_a_usar = duraciones_hasta(duracion_total, duraciones)

        # recortar duraciones a usar
        trios = trios[:segmentos_a_usar]
        duraciones = duraciones[:segmentos_a_usar]
        duraciones = [int(n) for n in duraciones]

        print(
            f'Segmentos hasta {duracion_total}: segmentos_a_usar',
            f'\nTrios: {len(trios)}',
            f'\nDuraciones: {len(duraciones)}',
            )

    else:
        trios = seteo['trios']
        duraciones = seteo['duraciones']


    if enviar(f'{cliente_bb} "0"') == 'Respuesta del servidor:\n\n':
        print('Error! Servidor desactivado')
        quit(1)
    else:
        print('Servidor activo. Comenzamos ...')


    # setear tiempo inicial
    enviar(f'{cliente_bb} "{tiempo_inicial} set_t" &')
    print(f'Setear tiempo:\n{tiempo_inicial} set_t')

    for i, dat in enumerate(trios):
        n1, n2, n3 = dat
        expr_bb = expresion_base.format(**locals())
        cmd = f'{cliente_bb} "{expr_bb}" &'

        print(f'{duraciones[i]:02}s >---> {expr_bb}')
        if not simular:
            enviar(cmd)
            sleep(duraciones[i] * ut)

    # finalizar
    enviar(f'{cliente_bb} "0"')

if __name__ == '__main__':
    main(argv[1])
