/*
** El Barto's ADX player plugin
** Copyright (c) 2001 bero, El Barto
**
** Modified by Rob 7/2001
*/

#include <windows.h>
#include <mmreg.h>
#include <msacm.h>
#include <math.h>
#include "in2.h"


// avoid CRT. Evil. Big. Bloated.
BOOL WINAPI _DllMainCRTStartup(HANDLE hInst, ULONG ul_reason_for_call, LPVOID lpReserved)
{
	return TRUE;
}

// post this to the main window at end of file (after playback as stopped)
#define WM_WA_MPEG_EOF WM_USER+2
// raw configuration
#define BPS 16


char lastfn[MAX_PATH]; // currently playing file (used for getting info on the current file)
char sample_buffer[576*2*2]; // sample buffer

int file_length; // file length, in bytes
int decode_pos_ms; // current decoding position, in milliseconds
int paused; // are we paused?
int seek_needed; // if != -1, it is the point that the decode thread should seek to, in ms.
int killDecodeThread=0;					// the kill switch for the decode thread
int NCH = 2;
int SAMPLERATE = 44100;


In_Module mod; // the output module (declared near the bottom of this file)

HANDLE input_file=INVALID_HANDLE_VALUE; // input file handle
HANDLE thread_handle=INVALID_HANDLE_VALUE;	// the handle to the decode thread

DWORD WINAPI __stdcall DecodeThread(void *b); // the decode thread procedure


typedef struct
{
  int s1, s2;
} PREV;

PREV prev[2];


void config(HWND hwndParent)
{
	MessageBox(hwndParent,
		"No configuration.",
		"Configuration",MB_OK);
	// if we had a configuration we'd want to write it here :)
}

void about(HWND hwndParent)
{
	MessageBox(hwndParent,"Rob's ADX player.\n\nBased on bero and El Barto's code, but with\nsome adjustments and bugs fixed\n\nChanges:\n   Switched to bero's C decoder\n   Volume increased\n   ADX recognition compatibility increased\n   Source code asthetics improved :)","Rob's ADX Player",MB_OK);
}

void init() { /* any one-time initialization goes here (configuration reading, etc) */ }

void quit() { /* one-time deinit, such as memory freeing */ }

int isourfile(char *fn) { return 0; } 
// used for detecting URL streams.. unused here. strncmp(fn,"http://",7) to detect HTTP streams, etc


int get16bit(unsigned char* p)
{
	return (p[0] << 8) | p[1];
}

int get32bit(unsigned char* p)
{
	return (p[0] << 24) | (p[1] << 16) | (p[2] << 8) | p[3];
}


int nrsamples;
int cri_ofs;

int play(char *fn) 
{ 
	int maxlatency;
	int thread_id;
	unsigned char readbuf[4096];
	int l;


    prev[0].s1 = 0;
    prev[0].s2 = 0;
    prev[1].s1 = 0;
    prev[1].s2 = 0;

	input_file = CreateFile(fn,GENERIC_READ,FILE_SHARE_READ|FILE_SHARE_WRITE,NULL,
		OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);

	if (input_file == INVALID_HANDLE_VALUE) // error opening file
	{
		return 1;
	}

	
	ReadFile(input_file, readbuf, 4096, &l, NULL);

	if(readbuf[0] != 0x80) 
	{
		CloseHandle(input_file);
		input_file=INVALID_HANDLE_VALUE;
		return 1;
	}

	cri_ofs = get16bit(&readbuf[2]);

 	if(readbuf[cri_ofs+0-2] != '(' || readbuf[cri_ofs+1-2] != 'c' || readbuf[cri_ofs+2-2] != ')' ||
	   readbuf[cri_ofs+3-2] != 'C' || readbuf[cri_ofs+4-2] != 'R' || readbuf[cri_ofs+5-2] != 'I' || l < 4096) 
	{
		MessageBox(NULL, "Not a valid ADX file", "ADX error", MB_OK);
		CloseHandle(input_file);
		input_file=INVALID_HANDLE_VALUE;
		return 1;
	}

	NCH = (int)readbuf[7];
	SAMPLERATE = get32bit(&readbuf[8]);
	nrsamples = get32bit(&readbuf[12]);

	SetFilePointer(input_file, cri_ofs+4, NULL, FILE_BEGIN);
	
    file_length=GetFileSize(input_file,NULL);

	lstrcpy(lastfn,fn);
	paused=0;
	decode_pos_ms=0;
	seek_needed=-1;

	maxlatency = mod.outMod->Open(SAMPLERATE,NCH,BPS, -1,-1);
	if (maxlatency < 0) // error opening device
	{
		CloseHandle(input_file);
		input_file=INVALID_HANDLE_VALUE;
		return 1;
	}
	// dividing by 1000 for the first parameter of setinfo makes it
	// display 'H'... for hundred.. i.e. 14H Kbps.
	mod.SetInfo((SAMPLERATE*BPS*NCH*18/64)/1000,SAMPLERATE/1000,NCH,1);

	// initialize vis stuff
	mod.SAVSAInit(maxlatency,SAMPLERATE);
	mod.VSASetInfo(SAMPLERATE,NCH);

	mod.outMod->SetVolume(-666); // set the output plug-ins default volume

	killDecodeThread=0;
	thread_handle = (HANDLE) CreateThread(NULL,0,(LPTHREAD_START_ROUTINE) DecodeThread,(void *) &killDecodeThread,0,&thread_id);
	
	return 0; 
}


void pause() 
{ 
	paused=1; 
	mod.outMod->Pause(1); 
}


void unpause() 
{ 
	paused=0; 
	mod.outMod->Pause(0); 
}


int ispaused() 
{ 
	return paused; 
}


void stop() 
{ 
	if (thread_handle != INVALID_HANDLE_VALUE)
	{
		killDecodeThread=1;
		if (WaitForSingleObject(thread_handle,INFINITE) == WAIT_TIMEOUT)
		{
			MessageBox(mod.hMainWindow,"error asking thread to die!\n","error killing decode thread",0);
			TerminateThread(thread_handle,0);
		}
		CloseHandle(thread_handle);
		thread_handle = INVALID_HANDLE_VALUE;
	}
	if (input_file != INVALID_HANDLE_VALUE)
	{
		CloseHandle(input_file);
		input_file=INVALID_HANDLE_VALUE;
	}

	mod.outMod->Close();
	mod.SAVSADeInit();
}


int getlength() 
{ 
	return nrsamples/SAMPLERATE*1000;
}


int getoutputtime() 
{ 
	return decode_pos_ms+(mod.outMod->GetOutputTime()-mod.outMod->GetWrittenTime()); 
}


void setoutputtime(int time_in_ms) 
{ 
	seek_needed=time_in_ms; 
}


void setvolume(int volume) 
{ 
	mod.outMod->SetVolume(volume); 
}


void setpan(int pan) 
{ 
	mod.outMod->SetPan(pan); 
}


int infoDlg(char *fn, HWND hwnd)
{
	// TODO: implement info dialog. 
	return 0;
}

void getfileinfo(char *filename, char *title, int *length_in_ms)
{
	if (!filename || !*filename)  // currently playing file
	{
		if (length_in_ms) *length_in_ms=getlength();
		if (title) 
		{
			char *p=lastfn+lstrlen(lastfn);
			while (*p != '\\' && p >= lastfn) p--;
			lstrcpy(title,++p);
		}
	}
	else // some other file
	{
		if (length_in_ms) 
		{
			HANDLE hFile;
			*length_in_ms=-1000;
			hFile = CreateFile(filename,GENERIC_READ,FILE_SHARE_READ|FILE_SHARE_WRITE,NULL,
				OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
			if (hFile != INVALID_HANDLE_VALUE)
			{
				*length_in_ms = (GetFileSize(hFile,NULL)*10)/(SAMPLERATE/100*NCH*(BPS/8));
			}
			CloseHandle(hFile);
		}
		if (title) 
		{
			char *p=filename+lstrlen(filename);
			while (*p != '\\' && p >= filename) p--;
			lstrcpy(title,++p);
		}
	}
}


void eq_set(int on, char data[10], int preamp) 
{ 
	// most plug-ins can't even do an EQ anyhow.. I'm working on writing
	// a generic PCM EQ, but it looks like it'll be a little too CPU 
	// consuming to be useful :)
}



#define BASEVOL 0x2000

/************** Elite ANSI C ADX decoder function **************/
int convert(short *out,unsigned char *in,PREV *prev)
{

  int scale = ( (in[0] << 8) | (in[1]) );
  int i;
  int s0, s1, s2, d;


  in += 2;


  s1 = prev->s1;
  s2 = prev->s2;

  for (i = 0; i < 16; i++)
  {
    d = in[i] >> 4;

    if (d & 8)
    {
      d -= 16;
    }

    s0 = (BASEVOL*d*scale + 0x7298*s1 - 0x3350*s2) >> 14;

    if (s0 > 32767)
    {
      s0 = 32767;
    }
    else if (s0 < -32768)
    {
      s0 = -32768;
    }

	*out++ = s0;
  
    s2 = s1;
    s1 = s0;

    d = in[i] & 15;

    if (d & 8)
    {
      d -= 16;
    }

    s0 = (BASEVOL*d*scale + 0x7298*s1 - 0x3350*s2) >> 14;

    if (s0 > 32767)
    {
      s0 = 32767;
    }
    else if (s0 < -32768)
    {
      s0 = -32768;
    }

  	*out++ = s0;
	
    s2 = s1;
    s1 = s0;

  }

  prev->s1 = s1;
  prev->s2 = s2;

  return 0;
   
}




// render 576 samples into buf. 
// note that if you adjust the size of sample_buffer, for say, 1024
// sample blocks, it will still work, but some of the visualization 
// might not look as good as it could. Stick with 576 sample blocks
// if you can, and have an additional auxiliary (overflow) buffer if 
// necessary.. 




int get_576_samples(char *buf)
{
	int i, l, j;
	
	unsigned char readbuf[18 * 2] = {0};
	
	for(i = 0; i < 576*2*2; i++) 
		buf[i] = 0;

	if(NCH == 1) 
	{

	    for(i = 0; i < 18; i++) 
		{
            /* used as intermediate C function output buffer */
			short outbuff[64] = {0};
           	   	
			l = 0; 
			
			ReadFile(input_file, readbuf, 18, &l, NULL); 
         
			convert(outbuff, readbuf, prev);             // LEFT CHANNEL                 	    	

			for(j = 0; j < 32; j++) 
			{
				((short *)buf)[i*32 + j] = outbuff[j];
			}

    		if(l < 18) 	
	    		return 0;
        }

	} 
	else 
	{

		for(i = 0; i < 18; i++) 
		{
            /* used as intermediate C function output buffer */
			short outbuff[64] = {0};
           	   			
			l = 0; 
			
			ReadFile(input_file, readbuf, 36, &l, NULL); 
			
            convert(outbuff, readbuf, prev);                // LEFT CHANNEL              
            convert(outbuff + 32, readbuf + 18, prev+1);    // RIGHT CHANNEL
   
	    	for(j = 0; j < 32; j++) 
			{
				((short *)buf)[i*64 + j*2] = outbuff[j];
                ((short *)buf)[i*64 + j*2 + 1] = outbuff[j + 32];
   			}

			if(l < 36) 
				return 0;
		}

	}
	return i*32;
}


DWORD WINAPI __stdcall DecodeThread(void *b)
{
	int done=0;
	while (! *((int *)b) ) 
	{
		if (seek_needed != -1)
		{
			int offs;
			decode_pos_ms = seek_needed-(seek_needed%1000);
			seek_needed=-1;
			done=0;
			mod.outMod->Flush(decode_pos_ms);
			offs = (decode_pos_ms/1000) * SAMPLERATE;			
			SetFilePointer(input_file,cri_ofs+4 + (offs*NCH/32*18),NULL,FILE_BEGIN);
		}
		if (done)
		{
			mod.outMod->CanWrite();
			if (!mod.outMod->IsPlaying())
			{
				PostMessage(mod.hMainWindow,WM_WA_MPEG_EOF,0,0);
				return 0;
			}
			Sleep(10);
		}
		else if (mod.outMod->CanWrite() >= ((576*NCH*(BPS/8))<<(mod.dsp_isactive()?1:0)))
		{	
			int l=576;
			l=get_576_samples(sample_buffer);
			if (!l) 
			{
				done=1;
			}
			else
			{
				mod.SAAddPCMData((char *)sample_buffer,NCH,BPS,decode_pos_ms);
				mod.VSAAddPCMData((char *)sample_buffer,NCH,BPS,decode_pos_ms);
				decode_pos_ms+=(576*1000)/SAMPLERATE;
				if (mod.dsp_isactive()) 
					l = mod.dsp_dosamples((short *)sample_buffer, l, BPS, NCH, SAMPLERATE);
				mod.outMod->Write(sample_buffer, l *(NCH*(BPS/8)));
			}
		}
		else Sleep(20);
	}
	return 0;
}



In_Module mod = 
{
	IN_VER,
	"Rob's ADX Player v1.1 "
#ifdef _DEBUG
	"(DEBUG)"
#endif
	,
	0,	// hMainWindow
	0,  // hDllInstance
	"ADX\0ADX Audio File (*.ADX)\0"
	,
	1,	// is_seekable
	1, // uses output
	config,
	about,
	init,
	quit,
	getfileinfo,
	infoDlg,
	isourfile,
	play,
	pause,
	unpause,
	ispaused,
	stop,
	
	getlength,
	getoutputtime,
	setoutputtime,

	setvolume,
	setpan,

	0,0,0,0,0,0,0,0,0, // vis stuff


	0,0, // dsp

	eq_set,

	NULL,		// setinfo

	0 // out_mod

};

__declspec( dllexport ) In_Module * winampGetInModule2()
{
	return &mod;
}

int main (void)
{
	return 0;
}
