#include <ntp.h>
#include <libraries/dos.h>
#include <intuition/intuition.h>
#include <graphics/text.h>
#include <graphics/gfxbase.h>

#define NUMSEGMENTS 10
#define NUMLINES 20
#define NC 59
#define LAB YELLOW
#define NORM WHITE
extern struct GfxBase *GfxBase;

struct Segment
{
   char *Adr,*Start,Len;
};

typedef struct Hyp
{
   struct Hyper *Next;
   char Line,Col;
   char *Adr;
} Hyper;

static Hyper *top;
static struct Segment l[NUMLINES][NUMSEGMENTS];
static char MaxLine=0,*last,*first,*adr,ofs;
static struct RastPort *rp;
static char line,col,NewLine,NewCol;
static struct Window *w;
static int Len=0;
static char *cia=(char *)0xbfe001;

#ifdef SLOVAKIA
#define NUMC 38

static unsigned char k[NUMC][2]=
{
   "r",  /* Lower Case */
   "e",
   "e",
   "r",
   "t",
   "z",
   "u",
   "i",
   "o",
   "o",
   "a",
   "s",
   "d",
   "l",
   "l",
   "y",
   "c",
   "n",
   "a",

   "R",   /* Upper Case */
   "E",
   "E",
   "R",
   "T",
   "Z",
   "U",
   "I",
   "O",
   "O",
   "A",
   "S",
   "D",
   "L",
   "L",
   "Y",
   "C",
   "N",
   "A"
};

static unsigned char *z;

Prototype void InitConv()
{
   int i;
   if(z=(unsigned char *)malloc(256))
   {
      for(i=0;i<256;i++) z[i]=i;
      for(i=0;i<NUMC;i++) z[k[i][0]]=k[i][1];
   } else pbx=1;
}

Local Text1(unsigned char *text,int len)
{
   if(!pbx)
   {
      register x;
      for(x=0;x<len;x++)
         text[x]=z[text[x]];
   }
   Text(rp,text,len);
}
#endif

Prototype void PrCr(int l,int c)
{
   RectFill(rp,3+(c<<3),15+(l<<3),10+(c<<3),22+(l<<3));
}

Local void PrintLine(int i)
{
   register j;
   for(j=0;l[i][j].Start;j++)
   {
      if(l[i][j].Adr) SetAPen(rp,LAB);
      else SetAPen(rp,NORM);
#ifdef SLOVAKIA
      Text1(l[i][j].Start,l[i][j].Len);
#else
      Text(rp,l[i][j].Start,l[i][j].Len);
#endif
   }
}


Local char *MakeLine(int i,unsigned char *p)
{
   int x,y=0;
   char z=0,*j=0;
   l[i][y].Start=p;
   if(*p=='')
   {
      z=1;x=0;p++;
      CopyMem(p,&x,4);
      l[i][y].Start+=5;
      l[i][y].Adr=adr+x;
   }
   else l[i][y].Adr=0;
   while(*p!='\n')
   {
      if(j==0) switch(*p)
            {
               case '\'' : j=p;break;
               case '\' : z=1-z;
                           l[i][y].Len=p-l[i][y].Start;
                           y++;
                           if(z==1)
                           {
                              CopyMem(p+1,&x,4);
                              l[i][y].Adr=adr+x;
                              p+=4;
                           } else l[i][y].Adr=0;
                           l[i][y].Start=p+1;
                           break;
            }
      p++;
   }
   if(j) {l[i][y].Len=j-l[i][y].Start;p=j+1;}
   else {l[i][y].Len=p-l[i][y].Start;p++;}
   l[i][y+1].Start=0;
   return(p);
}

Local void ScrollUp() // is called only if cursor is on bottom of the window

{
   if(*(last-1) != '\'')
   {
      PrCr(line,col);
      SetDrMd(rp,1);
__ent2:
      while(*first!='\n') first++;
      {
         unsigned char *pom=(unsigned char *)(first-3);
         for(;pom<first;pom++)
            if(*pom==0xAD && pom[1]==0)
            {
               first++;
               goto __ent2;
            }
      }
      first++;
      last=MakeLine(ofs,last);
      ScrollRaster(rp,0,8,3,15,2+(NC<<3),6+(NUMLINES+1<<3));
   //   RectFill(rp,3,2+((NUMLINES+1)<<3),4+8*NC,10+((NUMLINES+1)<<3));
      Move(rp,3,13+(NUMLINES<<3));
      PrintLine(ofs);
      ofs++;
      if(ofs>=NUMLINES) ofs-=NUMLINES;
      SetDrMd(rp,3);
      PrCr(line,col);
   }
   else
      if(NewCol!=col&&NewCol>=0&&NewCol<NC)
      {
         PrCr(line,col);
         PrCr(line,col=NewCol);
         while(((*cia&0x40)==0)&&(w->MouseY-14>>3>MaxLine)&&(NewCol==w->MouseX-3>>3));
      }
}

Local void ScrollDown()
{
   void MakePage();
   char aa=0;
   if(*first!='\'')
   {
      if(MaxLine<NUMLINES)
      {
         MaxLine++;
         if(MaxLine==NUMLINES) aa=1;
      }
      PrCr(line,col);
      SetDrMd(rp,1);
      ofs--;if(ofs<0) ofs=NUMLINES-1;
__ent:first-=2;
      while(*first!='\n')
         first--;
      {
         unsigned char *pom=(unsigned char *)(first-3);
         for(;pom<first;pom++) if(*pom==0xAD && pom[1]==0) goto __ent;
      }
      first++;
__ent1:
      last-=2;
      while(*last!='\n') last--;
      {
         unsigned char *pom=(void *)(last-3);
         for(;pom<last;pom++) if(*pom==0xAD && pom[1]==0) goto __ent1;
      }
      last++;
      if(*first=='\'') MakeLine(ofs,first+1);
      else MakeLine(ofs,first);
      ScrollRaster(rp,0,-8,3,15,2+(NC<<3),6+(NUMLINES+1<<3));
      Move(rp,3,21);
      PrintLine(ofs);
      SetDrMd(rp,3);
      PrCr(line,col);
      if(aa) MakePage(first);
   }
   else
      if(NewCol!=col&&NewCol>=0&&NewCol<NC)
      {
         PrCr(line,col);
         PrCr(line,col=NewCol);
         while(((*cia&0x40)==0)&&(w->MouseY<13)&&(NewCol==w->MouseX-3>>3));
      }
}

Local void MakePage(char *p)
{
   first=p;MaxLine=1;ofs=0;
   if(*p=='\'') last=MakeLine(0,last=p+1);
   else last=MakeLine(0,last=p);
   while(MaxLine<NUMLINES && *(last-1)!='\'')
   {
      last=MakeLine(MaxLine,last);
      MaxLine++;
   }
}

#ifdef SLOVAKIA
Prototype void TryPBX()
{
   struct TextAttr ta=
   {
      "pbx.font",
      8,
      FS_NORMAL,
      FPF_DISKFONT
   };
   if(cla&NOFONTS)
   {
      pbx=0;
      InitConv();
   }
   else
   {
      if(pbx=OpenFont(&ta))
      {
         CloseFont(pbx);
         RemFont(pbx);
      }
      if(DiskfontBase=OpenLibrary("diskfont.library",0))
         {
            struct TextFont *tf;
            if(tf=(struct TextFont *)OpenDiskFont(&ta))
               pbx=(int)tf;
            CloseLibrary(DiskfontBase);
         }
      if(!pbx) InitConv();
   }
}
#endif


#ifdef SLOVAKIA
Prototype DisposePBX()
{
   if(pbx>1)
      CloseFont(pbx);
}
#endif

Prototype void LoadHelpFile()
{
   struct FileHandle *f,*Open();
   HelpPossible=1;
   if(!(f=Open("NTP.Hlp",MODE_OLDFILE)))
      if(!(f=Open("NT:NTP.Hlp",MODE_OLDFILE)))
      {
#ifdef GERMAN
         ErrorLine("Hilfedatei nicht gefunden");
#else
         ErrorLine("Help file not found");
#endif
         HelpPossible=0;
         return;
      }
   Seek(f,0,OFFSET_END);
   adr=(char *)malloc(Len=Seek(f,0,OFFSET_BEGINNING)+1);
   if(adr)
   {
      *adr='\n';adr++;
      if(Len!=Read(f,adr,Len)+1)
      {
#ifdef GERMAN
         ErrorLine("Lesefehler");
#else
         ErrorLine("Read error");
#endif
         HelpPossible=0;
      }
      Close(f);
   }
   else
   {
      ErrorLine(memory);
      HelpPossible=0;
   }
}

Local void PrintPage()
{
   int i,j=ofs;
   SetDrMd(w->RPort,1);
   for(i=0;i<MaxLine;i++)
   {
      Move(rp,3,21+(i<<3));
      PrintLine(j);
      j++;if(j>=NUMLINES) j-=NUMLINES;
   }
}

Local void Enter()
{
   Hyper *act;
   int i,pos;
   char *st,lin=ofs+line;
   if(lin>=NUMLINES) lin-=NUMLINES;
   for(i=0,st=l[lin][0].Start;l[lin][i].Start;i++)
   {
      if(l[lin][i].Adr)
      {
         pos=l[lin][i].Start-st;
         st++;
         if(pos<=col && pos+l[lin][i].Len>col)
            if(act=(Hyper *)AllocMem(sizeof(Hyper),0))
            {
               act->Next=top;
               act->Line=line;
               act->Col=col;
               act->Adr=first;
               MakePage(l[lin][i].Adr);
               SetDrMd(rp,1);
               SetAPen(rp,KMZ);
               RectFill(rp,3,14,2+(NC<<3),9+(NUMLINES+1<<3));
               PrintPage();
               SetDrMd(rp,3);
               line=col=NewLine=NewCol=0;
               PrCr(0,0);
               top=act;
            }
#ifdef GERMAN
            else ErrorLine(memory);
#else
            else ErrorLine("No memory to go in");
#endif
      }
      if(l[lin][i+1].Adr) st+=5;
   }
}

Local void Bck()
{
   Hyper *act;
   PrCr(line,col);
   NewLine=line=top->Line;NewCol=col=top->Col;MakePage(top->Adr);
   SetDrMd(rp,1);
   SetAPen(rp,KMZ);
   RectFill(rp,3,14,2+(NC<<3),9+(NUMLINES+1<<3));
   PrintPage();
   SetDrMd(rp,3);
   act=top->Next;
   FreeMem(top,sizeof(Hyper));
   top=act;
   PrCr(line,col);
}

Local void LCControl()
{
   if(line!=NewLine || col!=NewCol)
      if(NewLine>=0)
         if(NewLine<MaxLine)
            if(NewCol>=0&&NewCol<NC)
            {
               PrCr(line,col);
               PrCr(line=NewLine,col=NewCol);
            }
            else
            {
               PrCr(line,col);
               PrCr(line=NewLine,col);
               while(((*cia&0x40)==0)&&(NewLine==w->MouseY-14>>3)&&(NewCol==w->MouseX-3>>3));
               NewCol=col;
            }
         else
            if(MaxLine<NUMLINES)
            {
               PrCr(line,col);
               PrCr(NewLine=line,col=NewCol);
               while(((*cia&0x40)==0)&&(w->MouseY-14>>3>=MaxLine)&&(NewCol==w->MouseX-3>>3));
            }
            else {ScrollUp();NewLine--;}
      else {ScrollDown();NewLine++;}
}

Local Hlp(char *ptr)
{
   struct NewWindow nw =

   {
      0,0,
      6+8*NC,
      12+((NUMLINES+1)<<3),
      -1,-1,MOUSEBUTTONS|RAWKEY,ACTIVEWINDOW|RMBTRAP|BORDERLESS,
      NULL,
      NULL,NULL,
      NTPBase->Screen,
      NULL,0,0,0,0,
      CUSTOMSCREEN
   };
   struct Window *OpenWindow();
   struct IntuiMessage *msg,*GetMsg();
   char go=1;
   Hyper *act;
   line=col=0;
   top=0;
   CenterWindow(&nw);
   if(!(w=OpenWindow(&nw)))
   {
      ErrorLine(memory);
      return(0);
   }
   SetRast(rp=w->RPort,KMZ);
   ActivateWindow(w);
//   printf("%s\n",rp->Font->tf_Message.mn_Node.ln_Name);
//   printf("%d,%x\n",rp->Font->tf_Accessors,rp->Font);
   if(pbx>1) SetFont(rp,pbx);
//   printf("%s\n",rp->Font->tf_Message.mn_Node.ln_Name);
//   printf("%d,%x\n",rp->Font->tf_Accessors,rp->Font);
   CRectangle(w,LIGHT,BLACK);
#ifdef GERMAN
   CTitle(w,"Hilfe|-=>Ausgang<=-|-=>Zurck<=-|",LIGHT,BLACK,WHITE,KMZ);
#else
   CTitle(w,"Help |-=> EXIT <=-|-=> BACK <=-|",LIGHT,BLACK,WHITE,KMZ);
#endif
   SetAPen(rp,BLACK);
   SetBPen(rp,KMZ);
   MakePage(ptr);
   PrintPage();
   SetDrMd(rp,3);
   PrCr(0,0);
   while(go)
   {
      Wait(1<<w->UserPort->mp_SigBit);
      while(msg=GetMsg(w->UserPort))
      {
         if(msg->Class == MOUSEBUTTONS)
         {
            if(msg->Code == 104)
            {
               if(msg->MouseY<14)
#ifdef GERMAN
                  if(msg->MouseX>51&&msg->MouseX<263)
#else
                  if(msg->MouseX>51&&msg->MouseX<255)
#endif
#ifdef GERMAN
                     if(msg->MouseX<162) {go=0;break;}
#else
                     if(msg->MouseX<154) {go=0;break;}
#endif
                     else
                     {
                        if(top) Bck();
                        else go=0;
                        break;
                     }
               NewLine=w->MouseY-14>>3;
               NewCol=w->MouseX-3>>3;
               if(NewLine==line && NewCol==col) Enter();
               else while(!(*cia & 0x40))
               {
                  LCControl();
                  NewLine=w->MouseY-14>>3;
                  NewCol=w->MouseX-3>>3;
               }
            }
         }
         else
            switch(msg->Code)
            {
               case 0x4c :
               case 0x3e : NewLine--;LCControl();break;
               case 0x4d :
               case 0x1e : NewLine++;LCControl();break;
               case 0x4e :
               case 0x2f : NewCol++;LCControl();break;
               case 0x4f :
               case 0x2d : NewCol--;LCControl();break;
               case 0x59 :
               case 0x45 : go=0;break;
               case 0x43 :
               case 0x44 : line=NewLine;col=NewCol;Enter();break;
               case 0x41 : if(top) Bck();
                           else go=0;
                           break;
//               case 0x50:  Dump("xx",first,1024); break;
            }
         ReplyMsg(msg);
      }
   }
   CloseWindow(w);
   for(;top;top=act)
   {
      act=top->Next;
      FreeMem(top,sizeof(Hyper));
   }
}

Prototype void Help(int ind)
{
   if(HelpPossible) Hlp(adr+ind);
   else if(cla&FIRST)
   {
      LoadHelpFile();
      if(HelpPossible) Hlp(adr+ind);
      else
      {
         cla&=~FIRST;
#ifdef GERMAN
         ErrorLine("Ich habe nicht Hilfedatei gefunden");
#else
         ErrorLine("I didn't find help-file");
#endif
      }
#ifdef GERMAN
   } else ErrorLine("Ich habe nicht Hilfedatei gefunden");
#else
   } else ErrorLine("I didn't find help-file");
#endif
}

#ifdef TEST
main()
{
   LoadHelpFile();
      /* program ... */
   if(HelpPossible) Help();
   free(adr-1,Len);

}
#endif
