#include <ntp.h>
#include <libraries/dosextens.h>
#include <exec/execbase.h>
#include <exec/resident.h>
#include <libraries/filehandler.h>
#include <devices/console.h>
#include <exec/memory.h>
#include <devices/input.h>
#include <devices/inputevent.h>
#include <exec/io.h>
#include <workbench/startup.h>
#include <graphics/view.h>

#include <clib/exec_protos.h>
#include <clib/dos_protos.h>
#include <clib/icon_protos.h>

#define TEST

#define CREATET 10

/*   !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

extern unsigned short Palette;*/
extern struct ExecBase *SysBase;
extern struct DosLibrary *DOSBase;
extern char strcmp();
extern GetSort();
int stricmp();
static struct MsgPort *port;
extern struct MsgPort *CreatePort();
static struct IOStdReq *req;
extern struct IOStdReq *CreateStdIO();
static struct InputEvent ie;



typedef struct Resident Resident;

typedef struct SegNode {
    BPTR    NextEntry;
    LONG    UseCount;
    BPTR    SegPtr;
    unsigned char    SegName[32];
} SegNode;


Prototype void MsgOFF()
{
   struct Process *p=(struct Process *)FindTask(0);
   swinptr=p->pr_WindowPtr;
   p->pr_WindowPtr=(APTR)-1;
}

Prototype void MsgON()
{
   struct Process *p=(struct Process *)FindTask(0);
   p->pr_WindowPtr=swinptr;
}


Prototype Kick(int v)
{
   if(((struct Library *)SysBase)->lib_Version>=v) return(1);
   else return(0);
}

Prototype CreateTree(char *a,int b)
{
   if(b<50)
   {
      int i,cnt=pw[Act].cnt;
      Dir **l=pw[Act].l;
      if(l[cnt]=(Dir *)AllocMem(sizeof(Dir),0))
      {
    ErrorLine(a);
    i=0;
    if(b)
    {
       for(; i < (b<<1)-1; i++)
          if(i&1) l[cnt]->Name[i]=' ';
          else l[cnt]->Name[i]='|';
       l[cnt]->Name[i]='-';
    } else i=-1;
    strcpy(l[cnt]->Name+i+1,a);
    CopyMem(spaces,l[cnt]->Size,SLEN);
    CopyMem("        ",l[cnt]->Protect,8);
    if(l[cnt]->Comment=(char *)AllocMem(80,0))
    {
       char c=spath[strlen(spath)-1];
       strcpy(l[cnt]->Comment,spath);
       if(c!=':' && c!='/') strcat(l[cnt]->Comment,"/");
    }
    l[cnt]->Set=0;
    pw[Act].cnt++;
      }
   }
   return(1);
}

Prototype void ResList()
{
   char t[10],i,l;
   SegNode *node;
   struct DosInfo *di =(struct DosInfo *)
      BADDR(((struct RootNode *)DOSBase->dl_Root)->rn_Info);
   int cnt=0;
   FreeDir(pw[Act].l,&pw[Act].cnt);
   Forbid();
   for (node =(SegNode *)BADDR(di->di_NetHand); node; node = (SegNode *)BADDR(node->NextEntry))
      if(pw[Act].l[cnt]=(Dir *)AllocMem(sizeof(Dir),0))
      {
    char a=(node->SegName[0]>NLEN ? NLEN : node->SegName[0]);
    CopyMem(node->SegName+1,pw[Act].l[cnt]->Name,a);
    pw[Act].l[cnt]->Name[a]=0;
 //   strncpy(pw[Act].l[cnt]->Size,spaces,SLEN);
   sprintf(t,"%d",node->UseCount);
   l=strlen(t);
   for(i=0;i<SLEN-l;i++) pw[Act].l[cnt]->Size[i]=' ';
   CopyMem(t,pw[Act].l[cnt]->Size+i,SLEN-i);
    CopyMem("        ",pw[Act].l[cnt]->Protect,8);
    pw[Act].l[cnt]->Set=0;pw[Act].l[cnt]->Comment=0;
    cnt++;
      } else ErrorLine(memory);
   Permit();
   pw[Act].cnt=cnt;
}

Prototype void IPrint(char *p)
{
   static y,x;
   if(!p)
   {
      x=(Act==LEFT ? lstart : rstart);
      y=10;
   }
   else if(p==(char *)1)
   {
      int beg,end;
      if(Act==LEFT)
      {
         beg=lstart-2; end=lstart+width;
      }
      else
      {
         beg=rstart-3; end=beg+width+3;
      }
      Move(rp,beg,y-3);
      Draw(rp,end,y-3);
      y+=8;
   }
   else
   {
      int l=strlen(p);
      if(l>width/8) l=width/8;
      Move(rp,x,y);
      y+=8;
      Text(rp,p,l);
   }
}

Prototype void NTPInfo(struct InfoData *i,char act)
{
   void FullPath();
   char pom[60],ppom[60],pom1=Act;
   int cc,cpu;
   Act=act;
   ClearWindow();
   SetBPen(rp,DARK);
   SetAPen(rp,LIGHT);
   IPrint(0);
   IPrint("The NTP. Version 1.1");
   IPrint("Copyright (C) 1993 by Amium");
   IPrint((char *)1);
   strcpy(ppom,"Disk Name:");
   {
      BPTR lock;
      char *ptr;
      if((lock=Lock(wp[1-Act].Path,ACCESS_READ)))
      {
         ptr=(char *)BADDR(((struct DeviceList *)BADDR(((struct FileLock *)BADDR(lock))->fl_Volume))->dl_Name);
         CopyMem(ptr+1,pom+1,*ptr);
         pom[*ptr+1]=0;
         pom[0]=' ';
         strcat(ppom,pom);
         IPrint(ppom);
         UnLock(lock);
      }
   }
#ifdef GERMAN
   strcpy(pom,"Type des Disks: ");
#else
   strcpy(pom,"Disk type : ");
#endif
   switch(i->id_DiskType)
   {
#ifdef GERMAN
      case ID_NO_DISK_PRESENT : strcat(pom,"Kein Disk");break;
#else
      case ID_NO_DISK_PRESENT : strcat(pom,"No disk present");break;
#endif
#ifdef GERMAN
      case ID_UNREADABLE_DISK : strcat(pom,"Disk nicht lesebar");break;
#else
      case ID_UNREADABLE_DISK : strcat(pom,"Unreadable disk");break;
#endif
#ifdef GERMAN
      case ID_DOS_DISK        : strcat(pom,"DOS Disk");break;
#else
      case ID_DOS_DISK        : strcat(pom,"DOS disk");break;
#endif
#ifdef GERMAN
      case ID_NOT_REALLY_DOS  : strcat(pom,"Nicht wirklich DOS Disk");break;
#else
      case ID_NOT_REALLY_DOS  : strcat(pom,"Not really dos disk");break;
#endif
#ifdef GERMAN
      case ID_KICKSTART_DISK  : strcat(pom,"Kiskstart Disk");break;
#else
      case ID_KICKSTART_DISK  : strcat(pom,"Kiskstart disk");break;
#endif
#ifdef GERMAN
      case ID_FFS_DISK  : strcat(pom,"FFS Disk");break;
#else
      case ID_FFS_DISK  : strcat(pom,"FFS disk");break;
#endif
#ifdef GERMAN
      case ID_INTER_DOS_DISK  : strcat(pom,"International DOS Disk");break;
#else
      case ID_INTER_DOS_DISK  : strcat(pom,"International DOS disk");break;
#endif
#ifdef GERMAN
      case ID_INTER_FFS_DISK  : strcat(pom,"International FFS Disk");break;
#else
      case ID_INTER_FFS_DISK  : strcat(pom,"International FFS disk");break;
#endif
#ifdef GERMAN
      case ID_FASTDIR_DOS_DISK  : strcat(pom,"Directory Cache DOS Disk");break;
#else
      case ID_FASTDIR_DOS_DISK  : strcat(pom,"Directory Cache DOS disk");break;
#endif
#ifdef GERMAN
      case ID_FASTDIR_FFS_DISK  : strcat(pom,"Directory Cache FFS Disk");break;
#else
      case ID_FASTDIR_FFS_DISK  : strcat(pom,"Directory Cache FFS disk");break;
#endif
#ifdef GERMAN
      case ID_MSDOS_DISK  : strcat(pom,"MS-DOS Disk");break;
#else
      case ID_MSDOS_DISK  : strcat(pom,"MS-DOS disk");break;
#endif
   }
   IPrint(pom);
#ifdef GERMAN
   if(i->id_UnitNumber>=0) sprintf(pom,"Einheit: %d",i->id_UnitNumber);
#else
   if(i->id_UnitNumber>=0) sprintf(pom,"Unit : %d",i->id_UnitNumber);
#endif
#ifdef GERMAN
      else if(i->id_UnitNumber==-1) strcpy(pom,"Einheit: -1 (RAM)");
#else
      else if(i->id_UnitNumber==-1) strcpy(pom,"Unit : -1 (RAM)");
#endif
   IPrint(pom);
#ifdef GERMAN
   if(i->id_DiskState == ID_WRITE_PROTECTED) strcpy(pom,"Schreibenschutz");
#else
   if(i->id_DiskState == ID_WRITE_PROTECTED) strcpy(pom,"Write protected");
#endif
#ifdef GERMAN
      else if(i->id_DiskState == ID_VALIDATING) strcpy(pom,"Zustand: Validiert");
#else
      else if(i->id_DiskState == ID_VALIDATING) strcpy(pom,"State: Validating");
#endif
#ifdef GERMAN
    else  strcpy(pom,"Schreiben mglich");
#else
    else  strcpy(pom,"Write Enabled");
#endif
#ifdef GERMAN
   sprintf(ppom,"Zustand: %s",pom);
#else
   sprintf(ppom,"State: %s",pom);
#endif
   IPrint(ppom);

   sprintf(pom,"Blocks : %d = %d Bytes",i->id_NumBlocks,
       i->id_NumBlocks*i->id_BytesPerBlock);
   IPrint(pom);
#ifdef GERMAN
   sprintf(pom,"Verw. Blocks : %d = %d Bytes",i->id_NumBlocksUsed,
#else
   sprintf(pom,"Used Blocks : %d = %d Bytes",i->id_NumBlocksUsed,
#endif
       i->id_NumBlocksUsed*i->id_BytesPerBlock);
   IPrint(pom);
#ifdef GERMAN
   sprintf(pom,"Ein Block = %d Bytes",i->id_BytesPerBlock);
#else
   sprintf(pom,"One block = %d Bytes",i->id_BytesPerBlock);
#endif
   IPrint(pom);

#ifdef GERMAN
   sprintf(pom,"Zahl des Softwarefehlers : %d",i->id_NumSoftErrors);
#else
   sprintf(pom,"Number of software errors : %d",i->id_NumSoftErrors);
#endif
   IPrint(pom);
   IPrint((char *)1);
#ifdef GERMAN
   sprintf(pom,"Graph. Speich. frei : %d",AvailMem(2));
#else
   sprintf(pom,"Graph. mem.  free : %d",AvailMem(2));
#endif
   IPrint(pom);
#ifdef GERMAN
   sprintf(pom,"Andere Speich. frei : %d",AvailMem(4));
#else
   sprintf(pom,"Other memory free : %d",AvailMem(4));
#endif
   IPrint(pom);
#ifdef GERMAN
   sprintf(pom,"Total Speicher frei : %d",AvailMem(1));
#else
   sprintf(pom,"Total memory free : %d",AvailMem(1));
#endif
   IPrint(pom);
#ifdef GERMAN
   sprintf(pom,"Der lngstes Block  : %d",AvailMem(1<<17));
#else
   sprintf(pom,"The largest block : %d",AvailMem(1<<17));
#endif
   IPrint(pom);
   IPrint((char *)1);
   strcpy(pom,"CPU : ");
   if(SysBase->AttnFlags&AFF_68040) {cpu=40;strcat(pom,"68040");}
      else if(SysBase->AttnFlags&AFF_68030) {cpu=30;strcat(pom,"68030");}
         else if(SysBase->AttnFlags&AFF_68020) {cpu=20;strcat(pom,"68020");}
            else if(SysBase->AttnFlags&AFF_68010) {cpu=10;strcat(pom,"68010");}
               else {cpu=0;strcat(pom,"68000");}
   IPrint(pom);
   strcpy(pom,"FPU :");
   if(SysBase->AttnFlags&AFF_FPU40)
      if(SysBase->AttnFlags&AFF_68040) strcat(pom," FPU 040");
         else strcat(pom," 68882");
      else if(SysBase->AttnFlags&AFF_68882) strcat(pom," 68882");
         else if(SysBase->AttnFlags&AFF_68881) strcat(pom," 68881");
#ifdef GERMAN
            else strcat(pom," Keine");
#else
            else strcat(pom," None");
#endif
   IPrint(pom);
   if(((struct Library *)SysBase)->lib_Version>=36)
   {
      int i;
      cc=CacheControl(0,0);
      strcpy(pom,"Instr. cache: ");
      i=0;
      if(cc & CACRF_EnableI) {i=1;strcat(pom,"ON ");}
         else if(cpu>10) {i=1;strcat(pom,"OFF ");}
      if(cc & CACRF_IBE) {
         if(i) strcat(pom,", ");
         strcat(pom,"BURST ");
         i=1;
      }
#ifdef GERMAN
      if(!i) strcat(pom,"Keine");
#else
      if(!i) strcat(pom,"None");
#endif
      IPrint(pom);
      strcpy(pom,"Data  cache : ");
      i=0;
      if(cc & CACRF_EnableD) {i=1;strcat(pom,"ON ");}
         else if(cpu>20) {i=1;strcat(pom,"OFF ");}
      if(cc & CACRF_DBE) {
         if(i) strcat(pom,", ");
         strcat(pom,"BURST ");
         i=1;
      }
      if(cc & CACRF_WriteAllocate)
      {
         if(i) strcat(pom,", ");
         strcat(pom,"WriteAlloc ");
         i=1;
      }
      if(cc & CACRF_CopyBack)
       {
         if(i) strcat(pom,", ");
         strcat(pom,"CopyBack ");
         i=1;
      }
#ifdef GERMAN
      if(!i) strcat(pom,"Keine");
#else
      if(!i) strcat(pom,"None");
#endif
      IPrint(pom);
   }
   Act=pom1;
}

Prototype RFree(char a)
{
   BPTR lock;
   struct InfoData inf;
   if(lock=Lock(wp[a].Path,ACCESS_READ))
   {
      Info(lock,&inf);
      fre[a]=(inf.id_NumBlocks-inf.id_NumBlocksUsed)*inf.id_BytesPerBlock;
      UnLock(lock);
   }
}

Prototype void ResModList()
{
   Resident *res;
   char *lnt[17] =
   {
      "UNKNOWN ","TASK    ","INTERRPT","DEVICE  ","MSGPORT ","MESSAGE ","FREEMSG ",
      "REPLMSG ","RESOURCE","LIBRARY ","MEMORY  ","SOFTINTR","FONT    ","PROCESS ",
      "SEMPHORE","SIGNLSEM","BOOTNODE"
   };
   int i=0,cnt=0;
   Dir **l;
   FreeDir(l=pw[Act].l,&pw[Act].cnt);
   do
   {
      res=(Resident *)(((int *)SysBase->ResModules)[i]);
      i++;
      if(res && (!((int)res & 1<<31)))
      {
    if(l[cnt]=(Dir *)AllocMem(sizeof(Dir),0))
    {
       l[cnt]->Comment=0;l[cnt]->Set=0;
       strncpy(l[cnt]->Name,res->rt_Name,NLEN);
       strncpy(l[cnt]->Protect,lnt[res->rt_Type],8);
       sprintf(l[cnt]->Size,"%06x ",res);
       l[cnt]->Size[SLEN-1]=' ';
       cnt++;
    }
    else
    {
       ErrorLine(memory);
       i=0;
    }
      } else i=0;
   } while(i);
   pw[Act].cnt=cnt;
}

Prototype void ExecList(struct List *list)
{
   struct Node *node;
   Dir **l=pw[Act].l;
   int cnt=0;
   FreeDir(l,&pw[Act].cnt);
   for(node=list->lh_Head;node->ln_Succ;node=node->ln_Succ)
      if(l[cnt]=(Dir *)AllocMem(sizeof(Dir),0))
      {
    l[cnt]->Comment=0;l[cnt]->Set=0;
    strncpy(l[cnt]->Name,node->ln_Name,NLEN);
    sprintf(l[cnt]->Size,"%06d ",node->ln_Pri);
    l[cnt]->Size[SLEN-1]=' ';
    strncpy(l[cnt]->Protect,"        ",8);
    cnt++;
      }
      else
      {
    ErrorLine(memory);
    break;
      }
   pw[Act].cnt=cnt;
}


Prototype void ExecList1(struct List *list)
{
   struct Node *node;
   Dir **l=pw[Act].l;
   int cnt=pw[Act].cnt;
   for(node=list->lh_Head;node->ln_Succ;node=node->ln_Succ)
      if(l[cnt]=(Dir *)AllocMem(sizeof(Dir),0))
      {
    l[cnt]->Comment=0;l[cnt]->Set=0;
    strncpy(l[cnt]->Name,node->ln_Name,NLEN);
    sprintf(l[cnt]->Size,"%06d ",node->ln_Pri);
    l[cnt]->Size[SLEN-1]=' ';
    strncpy(l[cnt]->Protect," READY  ",8);
    cnt++;
      }
      else
      {
    ErrorLine(memory);
    break;
      }
   pw[Act].cnt=cnt;
}

Prototype void MemList()
{
   struct List *list=&(SysBase->MemList);
   struct Node *node;
   Dir **l=pw[Act].l;
   int cnt=0,a,b;
   FreeDir(l,&pw[Act].cnt);
   for(node=list->lh_Head;node->ln_Succ;node=node->ln_Succ)
      if(l[cnt]=(Dir *)AllocMem(sizeof(Dir),0))
      {
    a=((struct MemHeader *)node)->mh_Lower;
    b=((struct MemHeader *)node)->mh_Upper;
    l[cnt]->Comment=0;l[cnt]->Set=0;
    strncpy(l[cnt]->Name,node->ln_Name,NLEN);
    sprintf(buf,"%08d",((struct MemHeader *)node)->mh_Free);
    CopyMem(buf,l[cnt]->Size,SLEN);
    sprintf(buf," %07d",b-a);
    CopyMem(buf,l[cnt]->Protect,8);
    cnt++;
      }
      else
      {
    ErrorLine(memory);
    break;
      }
   pw[Act].cnt=cnt;
}

Prototype void TaskList()
{
   Disable();
   ExecList(&(SysBase->TaskWait));
   ExecList1(&(SysBase->TaskReady));
   Enable();
}

Prototype void DosList(char w,char type)
{
/*   if(Kick(36))
   {
      int flags=LDF_READ;
      Dir **l=pw[Act].l;
      int cnt=0;
      char pom[40],*ptr;
      struct FileSysStartupMsg *fs;
      struct DosList *d;
      if(w&(1<<DLT_VOLUME)) flags|=LDF_VOLUMES;
      if(w&(1<<DLT_DEVICE)) flags|=LDF_DEVICES;
      if(w&(1<<DLT_DIRECTORY)) flags|=LDF_ASSIGNS;
      FreeDir(l,&pw[Act].cnt);
      d=(struct DosList *)LockDosList(flags);
      for(;d;d=(struct DosList *)NextDosEntry(d,flags))
         if(l[cnt]=(Dir *)AllocMem(sizeof(Dir),0))
         {
            char a=1;
            ptr=BADDR(d->dol_Name);
            CopyMem(ptr+1,l[cnt]->Name,ptr[0]);
            l[cnt]->Name[ptr[0]]=0;
            if(type==1)
               if((!IsFileSystem(l[cnt]->Name)) || (!(d->dol_Task)))
               {
                  FreeMem(l[cnt],sizeof(Dir));
                  continue;
               }
            switch(d->dol_Type)
            {
               case DLT_VOLUME:strncpy(l[cnt]->Size,"VOLUME  ",SLEN);a=0;break;
               case DLT_DEVICE:strncpy(l[cnt]->Size,"DEVICE  ",SLEN);break;
               case DLT_DIRECTORY:strncpy(l[cnt]->Size,"SUBDIR  ",SLEN);break;
               case DLT_LATE:strncpy(l[cnt]->Size,"LATEBIND",SLEN);break;
               case DLT_NONBINDING:strncpy(l[cnt]->Size,"NON-BIND",SLEN);break;
               case DLT_PRIVATE:strncpy(l[cnt]->Size,"PRIVATE ",SLEN);break;
               default: a=2;
            }
            if(a==2)
            {
               FreeMem(l[cnt],sizeof(Dir));
               continue;
            }
            if(a && d->dol_Task)
               if(!(strcmp("File System",((struct Task *)d->dol_Task->mp_SigTask)->tc_Node.ln_Name)))
                  strncpy(l[cnt]->Protect,"FileSys.",8);
               else
                 if(!(strcmp("RAM",((struct Task *)d->dol_Task->mp_SigTask)->tc_Node.ln_Name)))
                     strncpy(l[cnt]->Protect,"RAM-Han.",8);
                  else
                  {
                     int i;
                     strncpy(l[cnt]->Protect,((struct Task *)d->dol_Task->mp_SigTask)->tc_Node.ln_Name,8);
                     for(i=0;i<8;i++) if(l[cnt]->Protect[i]==0) break;
                     for(;i<8;i++) l[cnt]->Protect[i]=' ';
                  }
            else strncpy(l[cnt]->Protect,"--------",8);
            l[cnt]->Comment=0;l[cnt]->Set=0;
            cnt++;
         } else { ErrorLine(memory);break;}
      pw[Act].cnt=cnt;
      UnLockDosList(flags);
   } else  */
   {
      Dir **l=pw[Act].l;
      int cnt=0;
      char pom[40],*ptr;
      struct DosInfo *i;
      struct FileSysStartupMsg *fs;
      struct DeviceNode *d;
      struct DeviceList *dl;
      FreeDir(l,&pw[Act].cnt);
      Forbid();
      i=(struct DosInfo *)BADDR(((struct RootNode *)DOSBase->dl_Root)->rn_Info);
      d=(struct DeviceNode *)BADDR(i->di_DevInfo);
      for(;d;d=(struct DeviceNode *)BADDR(d->dn_Next))
         if((1<<d->dn_Type & w)) if(type==0 || (type==1 && d->dn_Task))
      if(l[cnt]=(Dir *)AllocMem(sizeof(Dir),0))
      {
         char a=1;
         ptr=BADDR(d->dn_Name);
#ifdef PATRIK
         if(!strncmp(ptr+1,"CC0",3))
         {
            FreeMem(l[cnt],sizeof(Dir));
            continue;
         }
#endif
         CopyMem(ptr+1,l[cnt]->Name,ptr[0]);
         l[cnt]->Name[ptr[0]]=0;
         switch(d->dn_Type)
         {
            case DLT_VOLUME:strncpy(l[cnt]->Size,"VOLUME  ",SLEN);a=0;break;
            case DLT_DEVICE:strncpy(l[cnt]->Size,"DEVICE  ",SLEN);break;
            case DLT_DIRECTORY:strncpy(l[cnt]->Size,"SUBDIR  ",SLEN);break;
         }
         if(a && d->dn_Task)
            if(!(strcmp("File System",((struct Task *)d->dn_Task->mp_SigTask)->tc_Node.ln_Name)))
         strncpy(l[cnt]->Protect,"FileSys.",8);
            else
         if(!(strcmp("RAM",((struct Task *)d->dn_Task->mp_SigTask)->tc_Node.ln_Name)))
            strncpy(l[cnt]->Protect,"RAM-Han.",8);
         else
         {
            int i;
            strncpy(l[cnt]->Protect,((struct Task *)d->dn_Task->mp_SigTask)->tc_Node.ln_Name,8);
            for(i=0;i<8;i++) if(l[cnt]->Protect[i]==0) break;
            for(;i<8;i++) l[cnt]->Protect[i]=' ';
         }
         else strncpy(l[cnt]->Protect,"--------",8);
         l[cnt]->Comment=0;l[cnt]->Set=0;
         cnt++;
      } else { ErrorLine(memory);break;}
      Permit();
      pw[Act].cnt=cnt;
   }
}

Prototype RefreshSet(char w)
{
   if(wp[w].Type==DIR)
   {
      int x,y;
      Move(rp ,x=(w==LEFT ? lstart : rstart) , y=BotBor-3);
      SetBPen(rp,DARK);
      SetDrMd(rp,1);
      Text(rp,spaces,37);
      Move(rp,x,y);
      if(pw[w].Sel) SetAPen(rp,YELLOW);
      else SetAPen(rp,LIGHT);
#ifdef GERMAN
      sprintf(buf,"%d frei; %d Dateien = %d",fre[w],pw[w].Sel,pw[w].SetSize);
#else
      sprintf(buf,"%d free; %d files = %d",fre[w],pw[w].Sel,pw[w].SetSize);
#endif
      Text(rp,buf,strlen(buf));
   }
}

Prototype void RefreshDir(w)
{
   int i,f=pw[w].First,ml;
   if(wp[w].Type==TREE)
      if(pbx) SetFont(NTPBase->w->RPort,pbx);
   ml=(pw[w].cnt-f > NTPBase->Lines  ?  NTPBase->Lines  :  pw[w].cnt-f);
   RefreshSet(w);
   SetDrMd(rp,1);
   for(i=0;i<ml;i++,f++)
      PrintNode(pw[w].l[f],i);
}

Prototype void ReCalcFC(int n)
{
   int i, first=pw[Act].First, row;

   i=n-first;
   if(pw[Act].cnt<=NTPBase->Lines)
   {
      first=0; row=n;
   } else
   if(n>pw[Act].cnt-NTPBase->Lines)
   {
      first=pw[Act].cnt-NTPBase->Lines;
      row=n-first;
   }
   else if(i>=0 && i<NTPBase->Lines)
      row=i;
   else
   {
      row=NTPBase->Lines/2;
      first=n-row;
      if(first<0)
      {
         first=0;
         row=n;
      }
   }
   pw[Act].First=first;
   pw[Act].CurAct=row;
}

Prototype void PrintNumber(int n)
{

   ClearWindow();
   SetCount();
   ReCalcFC(n);
   RefreshDir(Act);
}

Prototype void PrintDir()
{
   if(wp[Act].Type==DIR && pw[Act].s==2) PrintNumber(1);
   else PrintNumber(0);
}

Prototype cmpna(Dir *i,Dir *j) // cmp[0]
{
   return(NTPBase->SCmp[wp[Act].Case](i->Name,j->Name));
}

Prototype cmpsi(Dir *i,Dir *j)  // cmp[1]
{
   return(-strncmp(i->Size,j->Size,SLEN));
}

Prototype cmpnas(Dir *i,Dir *j)   /* cmp[2] */
{
   if(isdigit(i->Size[7]))
      if(isdigit(j->Size[7])) return(NTPBase->SCmp[wp[Act].Case](i->Name,j->Name));
    else return(1);
   if(isdigit(j->Size[7])) return(-1);
   return(NTPBase->SCmp[wp[Act].Case](i->Name,j->Name));
}

Prototype cmpzero(Dir *i,Dir *j)  
{
   return(0);
}

Prototype void RepairDir()
{
   Dir **l=pw[Act].l;   
   int i, j, cnt=pw[Act].cnt;
   for(i=j=0; i<cnt; i++)
      if(l[i]->Set==4)
      {
         FreeNode(i);
         pw[Act].cnt--;
      }
      else l[j++]=l[i];
}

Prototype quicksort(l,r)
int l,r;
{
   int i,j;
   Dir *d,*pom;
   d=pw[Act].l[l+r>>1];
   i=l;j=r;
   while(i<j)
   {
     while(NTPBase->Cmp[wp[Act].Sort](pw[Act].l[i],d) == -1) i++; //  <1
     while(NTPBase->Cmp[wp[Act].Sort](pw[Act].l[j],d) == 1) j--;  // >-1
     if(i<=j)
     {
       pom=pw[Act].l[i];pw[Act].l[i]=pw[Act].l[j];pw[Act].l[j]=pom;
       i++;j--;
     }
   }
   if( l<j ) quicksort(l,j);
   if( i<r ) quicksort(i,r);
}

Prototype ResQuickSort(le,ri)
int le,ri;
{
   int i,j;
   Dir *d,*pom;
   d=l[le+ri>>1];
   i=le;j=ri;
   while(i<j)
   {
     while(NTPBase->Cmp[wp[Act].Sort](l[i],d) == -1) i++;
     while(NTPBase->Cmp[wp[Act].Sort](l[j],d) == 1) j--;
     if(i<=j)
     {
       pom=l[i];l[i]=l[j];l[j]=pom;
       i++;j--;
     }
   }
   if( le<j ) ResQuickSort(le,j);
   if( i<ri ) ResQuickSort(i,ri);
}

Prototype void GetTree(char w)
{
   FreeDir(pw[w].l,&pw[w].cnt);
   strcpy(spath,wp[w].Path);
   CreateTree(wp[w].Path,0);
   ResDir(CREATET,CreateTree);
   {
      int i,j,cnt=pw[w].cnt,e;
      int a[32];
      Dir **l=pw[w].l;
      for(i=0;i<cnt;i++)
        for(j=0;l[i]->Name[j];j++)
           if(l[i]->Name[j]=='|')
           {
              if(l[i]->Name[j+1]!='-')
                 l[i]->Name[j]=165;
              else
              {
                 if(i+1==cnt || l[i+1]->Name[j]!='|') l[i]->Name[j]=186;
                 else l[i]->Name[j]=191;
                 l[i]->Name[j+1]=173;
              }
           }
      cnt--;
      for(i=0;i<32;i++)
      {
         if((UBYTE)l[cnt]->Name[i]==165)
         {
            a[i]=1;
            l[cnt]->Name[i]=' ';
            if((UBYTE)l[cnt-1]->Name[i]==191) l[cnt-1]->Name[i]=186;
         }
         else a[i]=0;
      }
      for(i=cnt-1;i>=0;i--)
      {
         e=0;
         for(j=0;j<32;j++)
         {
            if(e) l[i]->Name[j]=0;
               else if(!l[i]->Name[j]) e=1;
            if(a[j]==1)
               if((UBYTE)l[i]->Name[j]==165)
               {
                  l[i]->Name[j]=' ';
                  if(i>0 && (UBYTE)l[i-1]->Name[j]==191) l[i-1]->Name[j]=186;
               }
               else a[j]=0;
            if(a[j]==0)
               if((UBYTE)l[i-1]->Name[j]==165)
               {
                  unsigned char c=l[i]->Name[j];
                  if(c!=191 && c!=186 && c!=165) a[j]=1;
               }
         }
      }
      if(!pbx)
      {
         cnt++;
         for(i=0;i<cnt;i++)
            for(j=0;l[i]->Name[j];j++)
               switch((UBYTE)l[i]->Name[j])
               {
                  case 173: l[i]->Name[j]='-';break;
                  case 165:
                  case 186:
                  case 191: l[i]->Name[j]='|';
               }
      }

   }
   ErrorLine(0);
}


Prototype void Process(char w)
{
   char a=0,as=Act;
   Act=w;pw[w].s=0;
   switch(wp[w].Type)
   {
      case NO    :  ClearWindow();break;
      case DIR   :  Act=as;
           if(!GetSort(w))
           {
         wp[w].Type=DEVS;
         DosList(1<<DLT_DEVICE,0);a=1;break;
           }
           Act=w;
           a=2;break;
      case TREE   :  GetTree(w);
           a=2;break;
      case DEVS   :
             DosList(1<<DLT_DEVICE,0);a=1;break;
      case ASSIGN :  DosList(1<<DLT_VOLUME | 1<<DLT_DIRECTORY,0);a=1;break;
      case LIST   :  a=1;
           switch(wp[w].List)
           {
         case RESLIST   : ResList();break;
         case RESMODLIST : ResModList();break;
         case TASK   : TaskList();break;
      //      case INTLIST   : ExecList(&(SysBase->IntrList));break;
         case INTLIST   : MemList();break;
         case PORTLIST  : ExecList(&(SysBase->PortList));break;
         // to budu dalsie
           }
           break;
   }
   if(a==1)
      if(wp[Act].Sort!=UNSORTED && pw[Act].s+1<pw[Act].cnt)
    quicksort(pw[Act].s,pw[Act].cnt-1);
   if(a) PrintDir();
   Act=as;
}

Prototype void MoveMouse(int dx,int dy)
{
   ie.ie_X=dx;
   ie.ie_Y=dy;
   DoIO(req);
}

Prototype brk()
{
   return(0);
}

Prototype main(int argc,char **argv)
{
   BPTR lock;
   int r;
   struct IOStdReq cio;
   onbreak(brk);
   SystemVer=((struct Library *)SysBase)->lib_Version;
   for(r=1;r<argc;r++)
      if(argv[r][0]=='-')
    switch(argv[r][1])
    {
       case 'c': cla|=NOFONTS;break;
       case 'f': cla|=NOHELP;break;
       case 'p': cla|=FIRST|NOHELP;break;
    }
   NTPBase=&NTPBASE;
   NTPBase->Prefs=&NTPPREFS;
   Act=LEFT;
   TryPBX();
   if(!(ReadCfg("NTP.Cfg")))
      ReadCfg("NT:NTP.Cfg");
//   OpenIO();
   OpenDevice("console.device",-1,&cio,0);
   ConsoleDevice=(struct Library *)cio.io_Device;
   lock=Lock("",ACCESS_READ);
   lfib=(struct FileInfoBlock *)AllocMem(sizeof(struct FileInfoBlock),0);
   NTPBase->Cmp[SNAME]=cmpna;NTPBase->Cmp[SSIZE]=cmpsi;
   NTPBase->Cmp[SEPAR]=cmpnas;NTPBase->Cmp[UNSORTED]=cmpzero;
   NTPBase->SCmp[UCASE]=stricmp;NTPBase->SCmp[NCASE]=strcmp;
 //  pw[0].cnt=pw[1].cnt=0;  // ked sa nenuluje BSS
   sprintf(NTPBase->SPat,"*");
   sprintf(NTPBase->UPat,"*");
   if(!LoadPrefs()) DefaultPrefs();  /* Musi by tu, kuoli tej LayersBase */
   if(!(LayersBase=OpenLibrary("layers.library",0))) goto nolay;
   if(!OpenEnviroment())
   {
#ifdef DEBUG
      printf("No memory to Enviroment(OpenEnviroment())\n");
#endif
      FreeMem(lfib,sizeof(struct FileInfoBlock));
      exit(201);
   }
   CountLines();
   InitRP();
   RefPrefs();
   if(!(NTPPREFS.Flags&REQON)) MsgOFF();
   if(port=CreatePort(0,0))
   {
      if(req=CreateStdIO(port))
      {
   if(!OpenDevice("input.device",0,(struct IORequest *)req,0))
   {
       req->io_Command=IND_WRITEEVENT;
       req->io_Flags=0;
       req->io_Length=sizeof(struct InputEvent);
       req->io_Data=(void *)&ie;
       ie.ie_NextEvent=0;
       ie.ie_Class=IECLASS_POINTERPOS;
       ie.ie_TimeStamp.tv_secs=0;
       ie.ie_TimeStamp.tv_micro=0;
       ie.ie_Code=0;
       ie.ie_Qualifier=IEQUALIFIER_RELATIVEMOUSE;
       {
          int n;
          for(n=0;n<2;n++)
          {
        RefType(n);
        RefList(n);
        RefCase(n);
        RefSort(n);
          }
       }
       if(InitLineAnalyse()) CalcEn=1;
       if(!(cla&NOHELP)) LoadHelpFile();
       Act=LEFT;Process(LEFT);Act=RIGHT;Process(RIGHT); // if DIR tak DIR ak INFO tak info ...
       SetCursor();
#ifdef GERMAN
       if(HelpPossible) ErrorLine("Drcke F1 oder HELP fr Hilfe!");
#else
       if(HelpPossible) ErrorLine("Press F1 or HELP to help!");
#endif
       IOBox();
       CloseDevice(req);
    }
    DeleteStdIO(req);
      }
      DeletePort(port);
   }
   CloseEnviroment();
   CloseLibrary(LayersBase);
nolay:
   FreeCfg();
   UnLock(CurrentDir(lock));
   FreeMem(lfib,sizeof(struct FileInfoBlock));
   FreeDir(pw[0].l,&pw[0].cnt);
   FreeDir(pw[1].l,&pw[1].cnt);
//   CloseIO();
   CloseDevice(&cio);
#ifdef SLOVAKIA
   DisposePBX();
#endif
}

Prototype wbmain(struct WBStartup *wbs)
{
   int ret;
   struct DiskObject *o;
   BPTR ol=0;
   if(IconBase=OpenLibrary("icon.library",0))
   {
      ol=CurrentDir(wbs->sm_ArgList[0].wa_Lock);
      if(o=GetDiskObject(wbs->sm_ArgList[0].wa_Name))
      {
         char *ptr;

         if(ptr=FindToolType(o->do_ToolTypes,"HELP"))
            if(!strcmp(ptr,"NO")) cla|=NOHELP;
               else if(!strcmp(ptr,"FIRST"))
                  cla|=FIRST|NOHELP;
         if(ptr=FindToolType(o->do_ToolTypes,"PBX"))
            if(!strcmp(ptr,"NO")) cla|=NOFONTS;
         FreeDiskObject(o);
      }
      CloseLibrary(IconBase);
      IconBase=0;
   }
   ret=main(0,0);
   if(ol) CurrentDir(ol);
   return(ret);
}

Prototype void FullPath(pat)
char *pat;
{
   char *ptr;
   getcwd(pat,256);
   ptr=pat+strlen(pat)-1;
   if(*ptr!=':' && *ptr!='/')
   {
      ptr[1]='/';
      ptr[2]=0;
   }
    /*struct FileLock *Lock(),*nnew,*new,*lock,*ParentDir();
  struct FileInfoBlock *fi;
  char pom[32];
  int i=0;
  fi=(struct FileInfoBlock *)AllocMem(sizeof(struct FileInfoBlock),0);
  lock=Lock(pat,ACCESS_READ);
  Examine(lock,fi);
  if (fi -> fib_FileName[0] == '\0') sprintf(pat,"RAM");
            else
              sprintf(pat,"%s",fi -> fib_FileName);
  new=lock;nnew=lock;
  while (nnew=ParentDir(new))
  {
    Examine(nnew,fi);
    if (fi -> fib_FileName[0] == '\0') sprintf(pom,"RAM/%s",pat);
              else
                sprintf(pom,"%s/%s",fi -> fib_FileName,pat);
    sprintf(pat,"%s/",pom);
    i=1;
    new=nnew;
   }

if (i == 1) {
       i=0;
       while(*(pat+i) != '/')
        i++;
       *(pat+i)=':';
        }
      else
        {
      i=0;
      while(*(pat+i) != '\0')
        i++;
      pat[i]=':';
      pat[i+1]='\0';
        }
  FreeMem(fi,sizeof(struct FileInfoBlock));
  UnLock(lock);*/
}  // mozno tato fn. nie je cela

Prototype void RefStrictNC()
{
   char s[2][16]=
   {
      " DEVICESLIST    ",
      " <ROOT>         "
   };
   int i,j;
   if(NTPPREFS.Flags&STRICTNC)
      i=0; else i=1;
   for(j=0;j<2;j++)
   {
      if(wp[j].Type==DIR)
         if(!strncmp(pw[j].l[0]->Size,s[i],8))
         {
            CopyMem(s[1-i],pw[j].l[0]->Size,8);
            CopyMem(s[1-i]+8,pw[j].l[0]->Protect,8);
            if(pw[j].First==0)
               if(j==Act)
               {
                  PCurs();
                  RefreshDir(j);
                  PCurs();
               }
               else
               {
                  Act=j;
                  RefreshDir(j);
                  Act=1-Act;
               }
         }
   }
}

Prototype DefaultPrefs()
{
   int i;
   struct NTPPrefs *p;
   p=NTPBase->Prefs;
   for(i=0;i<2;i++)
   {
      wp[i].Sort=SEPAR;
      wp[i].Case=UCASE;
   // wp[i].Enable[0]=0;  // pre istotu, ked sa nenuluje BSS
   // wp[i].Disable[0]=0; // --------------||--------------
   }
   wp[0].Type=ASSIGN;
   wp[1].Type=DIR;
   wp[0].List=RESLIST;
   wp[1].List=RESMODLIST;
   wp[1].Type=DIR;
   wp[0].Path[0]=0;
   FullPath(wp[0].Path);
   sprintf(wp[1].Path,wp[0].Path);
   NTPPREFS.TabLen=3;
//   p->Run=2|4|8|16;
   if(!(p->Flags&REQON)) MsgON();
   p->Flags=REQON|COLOR;
   p->NChan=4;
//   p->Auto=2|4; // ak sa nen. BSS tak treba este nieco pridat
   // ak vsetko bude spolu, treba este pridat standardne autoinit,
   // alebo load gadgetov
   DefaultGadgets();
   DefaultPrintInfo();
   mode_id=HIRES;
   if(NTPBase->w)
   {
      RefPrefs();
   }
}

Prototype LoadPrefs()
{
   BPTR f;
   int n=1;
#ifdef ENVIROMENT
   APTR ahoj;
   struct Process *p=(struct Process *)FindTask(0);
   
   ahoj=p->pr_WindowPtr;
   p->pr_WindowPtr=(APTR)-1;
   
   if(!(f=Open("Env:NTPPrefs",MODE_OLDFILE)))
   {
#endif
      if(!(f=Open("NTPPrefs",MODE_OLDFILE)))
         if(!(f=Open("NT:NTPPrefs",MODE_OLDFILE)))
         {
#ifdef ENVIROMENT
            p->pr_WindowPtr=ahoj;
#endif
            return(0);
         }
#ifdef ENVIROMENT
   } else if(!LayersBase) LoadHistory();
   p->pr_WindowPtr=ahoj;
#endif

   if(NTPBase->w)
      if(!(NTPPREFS.Flags&REQON))
         MsgON();
   ReadGadgets(f);
   Read(f,NTPBase->Prefs,sizeof(struct NTPPrefs));
   Read(f,wp,sizeof(WinPrefs));
   n=Read(f,wp+1,sizeof(WinPrefs));
   Read(f,&NTPBase->Prot,1);
   ReadPrintInfo(f);
   mode_id=HIRES;
   Read(f, &mode_id, 4);
   Close(f);
   if(NTPBase->w)
   {
      if(!(NTPPREFS.Flags&REQON)) MsgOFF();
      RefPrefs();
   }
   if(NTPPREFS.Flags&NOTIFYWB) InitIconBase();
   return(1);
}


Prototype SavePrefs(char *path)
{
   BPTR f;
   if(!(f=Open(path,MODE_NEWFILE)))
   {
#ifdef GERMAN
      ErrorLine("Speichern nicht mglich");
#else
      ErrorLine("Can't save");
#endif
      return(0);
   }
   FillFlags();
   WriteGadgets(f);
   Write(f,NTPBase->Prefs,sizeof(struct NTPPrefs));
   Write(f,wp,sizeof(WinPrefs));
   Write(f,wp+1,sizeof(WinPrefs));
   Write(f,&NTPBase->Prot,1);
   WritePrintInfo(f);
   Write(f, &mode_id, 4);
   Close(f);
#ifdef GERMAN
   ErrorLine("Einstellungen sichern");
#else
   ErrorLine("Prefs saved");
#endif
   return(1);
}

