#include <NTP.h>
#include <intuition/intuitionbase.h>
#include <devices/console.h>
#include <exec/memory.h>

#define FASTSCROLL

extern struct IntuitionBase *IntuitionBase;

static struct RastPort *rp;
static struct Window *w;
struct Window *OpenWindow();
static short maxline,lines,first,ofs,col,row,ALen;
static short lpw,cpw,lpwp1;
static char cur;
static mod;
static char **list;
static struct RastPort *Frp;

#define nomem() Error(memory);

#define MOV   20
#define py(n) (13+((n)<<3))
#define pyt(n) (19+((n)<<3))
#define px(n) (4+((n)<<3))

// #define TEST

static void Error(char *s)
{
/*   SetWindowTitles(w,s,-1); */
   SetAPen(rp,WHITE);
   SetBPen(rp,KMZ);
   Move(rp,8,8);
   Text(rp,spaces,40);
   Move(rp,8,8);
   Text(rp,s,strlen(s));
}

static void CountMax()
{
   lpw=(w->Height-21>>3);
   lpwp1=lpw+1;
   cpw=w->Width-12>>3;
}

static void PrintLine(int i)
{
   short j;
#ifdef DEBUG
   sprintf(buf,"printline %d",i);
   Error(buf);
   printf("PrintLine(%d)\n",i);
#endif
   Move(Frp,px(0),pyt(i));
   j=strlen(list[i+first]);
   if(ofs)
      if(j>ofs)
      {
         j-=ofs;
         Text(Frp,list[i+first]+ofs,j<cpw ? j : cpw);
         if(cpw-j > 0) Text(Frp,spaces,cpw-j);
      }
      else Text(Frp,spaces,cpw-1);
   else
   {
      Text(Frp,list[i+first],j < cpw ? j : cpw);
      if(cpw-j > 0) Text(Frp,spaces,cpw-j);
   }
}

static void Cursor(char s)
{
   short c = col < ALen ? col : ALen;
   SetDrMd(rp,3);
   RectFill(rp,px(c),py(row),px(c+1)-1,py(row+1)-1);
   SetDrMd(rp,1);
   if(s)
   {
      unsigned char cc=list[first+row][ofs+c];
      if(!cc) cc=13;
      SetAPen(rp,YELLOW);
      SetBPen(rp,KMZ);
      sprintf(buf," %c (%d/%d) %02X   ",mod?'*':'.',first+row+1,ofs+c+1,cc);
      Move(rp,px(41),8);
      Text(rp,buf,strlen(buf));
      SetAPen(rp,LIGHT);
      SetBPen(rp,DARK);
#ifdef DEBUG
      sprintf(buf," %d .%s. ",strlen(list[first+row]),list[first+row]);
      Error(buf);
#endif
   }
}

static void ClearWind()
{
   SetAPen(Frp,DARK);
   RectFill(Frp,px(0),py(0),px(cpw+1)-1,py(lpw)-1);
   SetAPen(Frp,LIGHT);
   cur=0;
}

static PrintText()
{
   void ARef();
   short i,j,k,n=lines-first > lpw ? lpw : lines-first;
   ClearWind();
   SetAPen(Frp,LIGHT);
   for(i=0,k=first;i<n;i++,k++)
   {
      Move(Frp,px(0),pyt(i));
      j=strlen(list[k]);
      if(ofs)
      {
         if(j>ofs)
         {
            j-=ofs;
            Text(Frp,list[k]+ofs,j<cpw ? j : cpw);
         }
      }
      else Text(Frp,list[k],j < cpw ? j : cpw);
   }
   ARef();
}

static char **AllocL(cnt)
{
#ifdef DEBUG
   printf("AllocL(%d)\n",cnt);
#endif
   return((char **)AllocMem(cnt<<2,0));
}

static void MoveL(char *s,char *d,int cnt)
{
#ifdef DEBUG
   printf("MoveL(%x,%x,%d)\n",s,d,cnt);
#endif
   movmem(s,d,cnt<<2);
}

static AddLine(n)
{
   char **ptr;
#ifdef DEBUG
   printf("AddLine(%d)\n",n);
#endif
   lines=lines+n;
   if(maxline >= lines) return(1);
   if(ptr=AllocL(lines))
   {
      CopyMem(list,ptr,lines-n<<2);
      FreeMem(list,maxline<<2);
      list=ptr;
      maxline=lines;
      return(1);
   }
   else nomem();
   return(0);
}

static void DelLineDel(int j)
{
   void ARef();
   int i,a,b;
   i=j+1;
   if(i<lines)
   {
      a=strlen(list[i]);b=strlen(list[j]);
      CopyMem(list[j],buf,b);
      CopyMem(list[i],buf+b,a+1);
      FreeMem(list[i],a+1);
      FreeMem(list[j],b+1);
      lines--;
      a+=b+1;
      MoveL((char *)(list+i+1),(char *)(list+i),lines-i);
      list[j]=(char *)AllocMem(a,0);
         CopyMem(buf,list[j],a);
      mod=1;
      if(row < lpw)
      {
         ScrollRaster(Frp,0,8,px(0),py(row),px(cpw+1)-1,py(lpw)-1);
         if(first+lpw-1 < lines) PrintLine(lpw-1);
      }
      PrintLine(row);
      ARef();
   }
}

static void DelAllLine(int j)
{
   void ARef();
   
   if(j<lines)
   {
      FreeMem(list[j],strlen(list[j]));
      if(j==--lines)
      {
         lines++;
         list[j]=(char *)AllocMem(1,0);
         *list[j]=0;
         PrintLine(row);
         ARef();
         return;
      }
      MoveL((char *)(list+j+1),(char *)(list+j),lines-j);
      mod=1;
      
      if(row < lpw)
      {
         ScrollRaster(Frp,0,8,px(0),py(row),px(cpw+1)-1,py(lpw)-1);
         if(first+lpw-1 < lines) PrintLine(lpw-1);
      }
      PrintLine(row);
      ARef();
   }
}

static DelLine(int i)
{
   if(i)
   {
      void Right();
      int j=i-1,a,b;
      if(i<lines)
      {
         a=strlen(list[i]);b=strlen(list[j]);
         CopyMem(list[j],buf,b);
         CopyMem(list[i],buf+b,a+1);
         FreeMem(list[i],a+1);
         FreeMem(list[j],b+1);
         lines--;
         a+=b+1;
         MoveL((char *)(list+i+1),(char *)(list+i),lines-i);
         list[j]=(char *)AllocMem(a,0);
         CopyMem(buf,list[j],a);
         mod=1;
         if(row+1 < lpw)
            if(row)
               ScrollRaster(Frp,0,8,px(0),py(row-1),px(cpw+1)-1,py(lpw)-1);
            else
            {
               if(first) first--;
               PrintLine(0);
               Right(b);
               return(-1);
            }
         if(row) PrintLine(row-1);
         if(first+lpw-1 < lines) PrintLine(lpw-1);
         else
         {
            SetAPen(rp,DARK);
            RectFill(rp,px(0),py(lpw-1),px(cpw),py(lpw));
            SetAPen(rp,LIGHT);
         }
         return(b);
      }
   }
   return(-1);
}

static InsLine(i,t)
{
   void ARef();
   int med,ii=i-1,ab=0;
#ifdef DEBUG
   printf("InsLine(%d,%d)\n",i,t);
#endif
   if(AddLine(1))
   {
      mod=1;
      if(lines-1-i > 0) MoveL((char *)(list+i),(char *)(list+i+1),lines-1-i);
      {
         int x,y;
         for(x=0;list[ii][x]==' ';x++);
         med=y=x;
         if(y>t)
         {
            med=y=t;
            x=t;
         }
         x=x+(strlen(list[ii]+t)+1);
#ifdef DEBUG
         printf("x=%d,y=%d\n",x,y);
#endif
         if(list[i]=(char *)AllocMem(x,0))
         {
#ifdef DEBUG
            printf("ptr=%x\n",list[i]);
#endif
            if(y) CopyMem(list[ii],list[i],y);
            CopyMem(list[ii]+t,list[i]+y,x-y);
            if(list[ii][t])
            {
#ifdef DEBUG
               printf("if ...\n");
#endif
               CopyMem(list[ii],buf,t);
               FreeMem(list[ii],strlen(list[ii])+1);
               list[ii]=(char *)AllocMem(t+1,0);
               CopyMem(buf,list[ii],t);
               list[ii][t]=0;
            }
         }
         else
         {
            nomem();
            return(0);
         }
      }
      row++;
      if(row >= lpw)
      {
         row--;
         first++;
         ab=1;
      }
      col=0;
      if(ofs)
      {
         ofs=0;
         PrintText();
      }
      else
      {
         if(!ab)
            ScrollRaster(Frp,0,-8,px(0),py(row),px(cpw+1)-1,py(lpw)-1);
         else
            ScrollRaster(Frp,0,8,px(0),py(0),px(cpw+1)-1,py(lpw)-1);
         PrintLine(ii-first);
         PrintLine(i-first);
         Right(med);
      }
      ARef();
   }
#ifdef DEBUG
   printf("%s\n,%s\n",list[ii],list[i]);
#endif
}

static void FreeList()
{
   register i=lines;
   char **sl=list;
   if(maxline)
   {
      while(i)
      {
         FreeMem(*list,strlen(*list)+1);
         ++list;
         --i;
      }
      FreeMem(sl,maxline<<2);
   }
   maxline=lines=0;
}

static void New()
{
   FreeList();
   list=(char **)AllocMem(4,0);
   list[0]=(char *)AllocMem(1,0);
   list[0][0]=0;
   lines=maxline=1;
}

static void Init()
{
   list=0;maxline=lines=first=0;
}

static LoadFile(char *Name)
{
   int f;
   char *ptr;
#ifdef GERMAN
   Error("Lese Datei");
#else
   Error("Loading file");
#endif
   FreeList();
   if(f=fopen(Name,"r"))
   {
      int lin=0;
      while(fgets(buf,4000,f))
      {
         int i,j;
         short ol,len=strlen(buf),tlen=0;
         char jt=0;
         for(i=0,j=0;i<len;i++,j++)
            if(buf[i] == '\t')
            {
               ol=NTPPREFS.TabLen-(j%NTPPREFS.TabLen)-1;
               tlen+=ol;
               j=j+ol;
               jt=1;
            }
         ol=len;
         if(buf[len-1]!='\n') len++;
         if(ol<3999)
         {
            if(!(ptr=(char *)AllocMem(len+tlen,0)))
            {
               nomem();
               lines=lin;
               ErrorLine(memory);
               return(-1);
            }
            if(jt)
               for(i=0,j=0;i<len;i++)
                  if(buf[i]=='\t')
                  {
                     CopyMem(spaces,ptr+j,NTPPREFS.TabLen-j%NTPPREFS.TabLen);
                     j+=NTPPREFS.TabLen-j%NTPPREFS.TabLen;
                  }
                  else
                  {
                     ptr[j]=buf[i];
                     j++;
                  }
            else CopyMem(buf,ptr,len);
            ptr[len+tlen-1]=0;
         }
         else
         {
       //     nomem();
       //     return(-1);
            if(!(ptr=(char *)AllocMem(4000,0)))
            {
               nomem();
               lines=lin;
               ErrorLine(memory);
               return(-1);
            }
            CopyMem(buf,ptr,4000);
         }
         if(lin==maxline)
            if(!AddLine(255))
            {
               nomem();
               lines=lin;
               return(-1);
            }
         list[lin++]=ptr;
      }
      fclose(f);
      lines=lin;
      Error(Name);
      if(lin) return(1);
   }
   Error(Name);
   New();
   return(0);
}

static SaveFile(char *Name)
{
   int f,l;
   char **li=list,ret=1;
#ifdef GERMAN
   Error("Schreibe Datei");
#else
   Error("Saving file");
#endif
   if(f=Open(Name,1006))
   {
      int i;
      for(i=0;i<lines;++i,++li)
      {
         l=strlen(*li);
         CopyMem(*li,buf,l);
         buf[l]='\n';
         if((l+1)!=Write(f,buf,l+1)) ret=0;;
      }
      Close(f);
   } else ret=0;
   Error(Name);
   return(ret);
}

static void Home()
{
   if(first || ofs)
   {
      first=ofs=row=col=0;
      PrintText();
   }
   else row=col=0;
   ALen=strlen(list[first+row]);
}

static void End()
{
   if(first+row+1 < lines)
   {
      first=lines-lpw;
      if(first < 0) first=0;
      else
      {
         ofs=col=0;
         row=lpw > lines ? lines-1 : lpw-1;
         PrintText();
         ALen=strlen(list[first+row]);
      }
   }
}

static void PgDn()
{
   if(first+row+1 < lines)
   {
      first+=lpw;
      if(first+lpw > lines)
      {
         first-=lpw;
         End();
      }
      else
      {
         ofs=col=0;
         PrintText();
      }
   }
}

static Line()
{
   *buf=0;
#ifdef GERMAN
   if(StringReq(buf,"Gehe zu Zeile:"))
#else
   if(StringReq(buf,"Go to line:"))
#endif
   {
      int i;
      i=atoi(buf)-1;
      if(i<0 || i>=lines) return;
      if(i<lpw)
      {
         first=0;
         row=i;
      }
      else
      {
         first=i-lpw+1;
         row=lpw-1;
      }
      ofs=col=0;
      PrintText();
   }
}



static void PgUp()
{
   if(first==0)
   {
      if(ofs)
      {
         ofs=0;
         PrintText();
      }
      col=row=0;
   }
   else
   {
      first-=lpw;
      if(first < 0)
      {
         first=0;ofs=1;
         PgUp();
      }
      else
      {
         ofs=col=0;
         PrintText();
      }
   }
}

static void ARef()
{
   ALen=strlen(list[first+row])-ofs;
   if(ALen < 0) ALen=0;
}

static Up(int a)
{
   void EoL(),BoL();
/*   int l=-1,p=0;
   char k=*key;
   if(a) for(p=0;p<15000;p++) if(*key!=0x67 && *key!=0x83) p=100000;
   do
   {
      l++;*/
      Cursor(0);
      if(row>0)
      {
         row--;
         ARef();
      }
      else if(first>0)
      {
         first--;
         ScrollRaster(Frp,0,-8,px(0),py(0),px(cpw+1)-1,py(lpw)-1);
         PrintLine(0);
         ARef();
      }
      if(!ALen && ofs)
      {
         BoL();
         EoL();
      }
      Cursor(1);
/*      if(!a) return(0);
      if(p==100000) return(1);
   } while(*key&1 && *key==k);*/
   return(1); //l
}

static Down(int a)
{
   void Bol(),EoL();
/*   int l=-1,p=0;
   char k=*key;
   if(a) for(p=0;p<15000;p++) if(*key!=0x65 && *key!=0xc3) p=100000;
   do
   {
      l++;*/
      Cursor(0);
      if(row+1 < lpw)
      {
         if(first+row+1 < lines)
         {
            row++;
            ARef();
         }
      }
      else if(first+row+1 < lines)
      {
         first++;
         ScrollRaster(Frp,0,8,px(0),py(0),px(cpw+1)-1,py(lpw)-1);
         PrintLine(row);
         ARef();
      }
      if(ALen==0 && ofs)
      {
         BoL();
         EoL();
      }
      Cursor(1);
/*      if(!a) return(0);
      if(p==100000) return(1);
   } while(*key & 1 && *key==k);*/
   return(1);  //l
}

static void GoRight(int h)
{
   int i,j,c=lines < lpw ? lines : lpw,l;
   ALen-=h;
   if(ALen<0) ALen=0;
   ofs+=h;
   ScrollRaster(Frp,h<<3,0,px(0),py(0),px(cpw+1)-1,py(lpw));
   for(i=0,j=first;i<c;i++,j++)
      if((l=strlen(list[j])) >= cpw+ofs-h)
      {
         Move(rp,px(0),pyt(i));
         Text(rp,list[j]+ofs,l-ofs < cpw ? l-ofs : cpw);
      }
}

static void GoLeft(int h)
{
   int i,j,c= lines < lpw ? lines : lpw,l;
   ALen+=h;
   ofs-=h;
   ScrollRaster(Frp,-8*h,0,px(0),py(0),px(cpw)-1,py(lpw));
   for(i=0,j=first;i<c;i++,j++)
      if((l=strlen(list[j])) > ofs)
      {
         Move(rp,px(0),pyt(i));
         Text(rp,list[j]+ofs,l-ofs < cpw ? l-ofs : cpw);
      }
}

static void BoL()
{
   void Left();
   ARef();
   if(col >= ALen) col=ALen-1;
   if(ofs)
   {
      GoLeft(ofs);
      col=0;
   }
   else Left(col);
   ARef();
   if(col == -1) col=0;
}

static void Right(int h)
{
   if(col+h<=ALen)
      if(col+h >= cpw)
      {
         int y;
         y=h/MOV;if(MOV*y!=h) y++;
         col=cpw-(MOV*y-h)-1;
         h=MOV*y;
         GoRight(h);
      } else col+=h;
   else if(row+first+1 < lines)
   {
      Cursor(1);
      Down(0);
      Cursor(0);
      BoL();
   }
}

static void EoL()
{
   ARef();
   if(ALen-col < cpw) Right(ALen-col);
   else
   {
      ofs=strlen(list[first+row])-cpw+1;
      col=cpw-1;
      PrintText();
   }
   ARef();
}

static void Left(int h)
{
   if(col-h > -1) col-=h;
   else if(ofs)
   {
      int y;
      y=h/MOV;if(MOV*y!=h) y++;
      col=MOV*y-h;
      h=MOV*y;
      if(ofs-h<0)
      {
         col-=h-ofs;
         h=ofs;
      }
      GoLeft(h);
   }
   else if(row|first)
   {
      Cursor(1);
      Up(0);
      Cursor(0);
      EoL();
   }
}

static DelChar(int l,int p)
{
   int a=strlen(list[l])+1;
   CopyMem(list[l],buf,a);
   FreeMem(list[l],a);
   if(list[l]=(char *)AllocMem(a-1,0))
   {
      mod=1;
      CopyMem(buf,list[l],p);
      CopyMem(buf+p+1,list[l]+p,a-p-1);
      PrintLine(row);
      ALen--;
      return(1);
   }
   return(0);
}

static BackSpace()
{
   if(col || ofs)
      if(!(DelChar(first+row,col+ofs-1))) return(0);
      else
      {
         Left(1);
         //ALen--;
         ARef();
      }
   else
   {
      int a=DelLine(row+first);
      if(a!=-1)
      {
         row--;
         ARef();
         if(a>cpw)
         {
            int x=a/cpw;
            x*=cpw;
            GoRight(x);
            Right(a-x);
         } else
         Right(a);
      }

   }
}

static Del()
{
   if(col<ALen) DelChar(first+row,col+ofs);
   else DelLineDel(row+first);
}

Prototype KeyConvert(int Code,int Qualifier,int IAddress,char *str)
{
   static struct InputEvent ie = { 0,IECLASS_RAWKEY };
   ie.ie_Code=Code;
   ie.ie_Qualifier=Qualifier;
   ie.ie_position.ie_addr=*((APTR *)IAddress);
   return(RawKeyConvert(&ie,str,100,0));
}

static InsChar(char c)
{
   int l=row+first,p=col+ofs;
   int a=strlen(list[l])+1;
   CopyMem(list[l],buf,a);
   FreeMem(list[l],a);
   if(list[l]=(char *)AllocMem(a+1,0))
   {
      mod=1;
      CopyMem(buf,list[l],p);
      list[l][p]=c;
      CopyMem(buf+p,list[l]+p+1,a-p);
      PrintLine(row);
      ALen++;
      Right(1);
      ARef();
      return(1);
   }
   return(0);
}

static void PutChar(char c)
{
   int l=row+first,p=col+ofs;
   int a=strlen(list[l]);
   mod=1;
   if(a==p)
   {
      CopyMem(list[l],buf,a);
      FreeMem(list[l],a+1);
      if(list[l]=(char *)AllocMem(a+2,0))
      {
         CopyMem(buf,list[l],a);
         list[l][p]=c;
         list[l][p+1]=0;
      }
      ALen++;
   }
   else list[l][p]=c;
   PrintLine(row);
   Right(1);
   ARef();
}

static void PrintNum()
{
   Move(rp,px(cpw-5),8);
   SetAPen(rp,WHITE);
   SetBPen(rp,KMZ);
   if(nlo) Text(rp,"NUM",3);
   else Text(rp,spaces,3);
   SetAPen(rp,LIGHT);
   SetBPen(rp,DARK);
}

static void PrintIns()
{
   if(men)
   {
      SetAPen(rp,WHITE);
      SetBPen(rp,KMZ);
      Move(rp,px(cpw-9),8);
      if(ins==0) Text(rp,"INS",3);
      else Text(rp,spaces,3);
      SetAPen(rp,LIGHT);
      SetBPen(rp,DARK);
   }
}

static void FindNext(char *iss)
{
   char *ptr=0,*strstr();
   int ind=col+ofs,l=first+row;
   if(list[l][ind]) ind++;
   if(col > ALen) col=ALen;
   if(!(ptr=strstr(list[l]+ind,iss)))
   {
      l++;
      while(!ptr && l<lines)
      {
         ptr=strstr(list[l],iss);
         l++;
      }
      l--;
   }
   if(ptr)
   {
      if(l<lpw)
      {
         first=0;
         row=l;
      }
      else
      {
         first=l-lpw+1;
         row=lpw-1;
      }
      ind=ptr-list[l];
      if(ind>cpw)
      {
         ofs=ind-cpw+1;
         col=cpw-1;
      }
      else
      {
         ofs=0;
         col=ind;
      }
      PrintText();
   }
}

Local void InitEdLine(int i)
{
   char n[3];
   int a,b;
   switch(i)
   {
#ifdef GERMAN
      case 2:  CopyMem("Siche.",inl[21],6);
#else
      case 2:  CopyMem("Save  ",inl[21],6);
#endif
               break;
      case 3:  CopyMem(spaces,inl[21],6);
               break;
   }
   a=20;b=29;
   SetDrMd(rp,1);
   Move(rp,0,w->Height-2);
   for(i=a;i<=b;i++)
   {
      sprintf(n,"%d",i-a+1);
      SetAPen(rp,GRAY);
      SetBPen(rp,BLACK);
      Text(rp,n,strlen(n));
      SetAPen(rp,BLACK);
      SetBPen(rp,KMZ);
      Text(rp,inl[i],6);
      if(i<b)
      {
         SetBPen(rp,BLACK);
         Text(rp,spaces,1);
      }
   }
}

Local PushEdLine(int mx,int mc)
{
   static mxs=-2;
   char n[3];
   int a,b,x=0,p,i;
   mx>>=3;
   if(mc==104) mxs=mx;
      else mx=mxs;
   if(mx==-2) return(-2);
   a=20;b=29;
   SetDrMd(rp,1);
   for(i=a;i<=b;i++)
   {
      sprintf(n,"%d",i-a+1);
      if(i==b) p=2;
         else p=1;
      if(mx<x+p+7)
      {
         Move(rp,x<<3,w->Height-2);
         SetAPen(rp,GRAY);
         SetBPen(rp,BLACK);
         Text(rp,n,strlen(n));
         if(mc!=104)
         {
            SetAPen(rp,BLACK);
            SetBPen(rp,KMZ);
            Text(rp,inl[i],6);
            SetBPen(rp,DARK);
         } else
         {
            SetAPen(rp,YELLOW);
            SetBPen(rp,DARK);
            Text(rp,inl[i],6);
            i=-1;
         }
         SetAPen(rp,LIGHT);
         return(i);
      }
      x+=p+7;
   }
}

Prototype ED(char *Name,int sea)
{
   struct NewWindow NW =
   {
      0,0,0,0,-1,-1,
#ifdef TEST
      NEWSIZE|
#endif
      RAWKEY|MOUSEBUTTONS,
#ifdef TEST
      WINDOWSIZING|
#endif
      ACTIVATE|RMBTRAP|BORDERLESS|BACKDROP,
      0,0,0,NTPBase->Screen,0,20,20,0,0,CUSTOMSCREEN
   };
   struct IntuiMessage *msg,*GetMsg();
   int i,ocr;
   struct BitMap Fbm,*bm;
   char go=1,EmptyQ=0,iss[60],lact=0;
   if(!Name)
   {
      if(!lines)
      {
#ifdef GERMAN
         ErrorLine("Keine Datei korrespondiert ihre Muster");
#else
         ErrorLine("No file matching your pattern found");
#endif
         return(0);
      }
   }
   NW.Width=IntuitionBase->ActiveScreen->Width;
   NW.Height=IntuitionBase->ActiveScreen->Height;
   if(sea==1) strncpy(iss,buf,19);
   else iss[0]=0;
   if(!(w=OpenWindow(&NW))) return(0);
   WindowToFront(w);
   rp=w->RPort;
#ifdef SLOVAKIA
   if(pbx) SetFont(rp,pbx);
#endif
   SetRast(rp,DARK);
   SetAPen(rp,KMZ);
   RectFill(rp,0,0,NW.Width,10);
   SetAPen(rp,LIGHT);
   SetBPen(rp,DARK);
#ifdef FASTSCROLL
   ocr=InstallClipRegion(w->WLayer,NULL);
   if(!(Frp=(void *)AllocMem(sizeof(struct RastPort),MEMF_PUBLIC)))
     goto ended;
   CopyMem(w->RPort,Frp,sizeof(struct RastPort));
   InitBitMap(&Fbm,2,w->Width,w->Height);
   bm=w->RPort->BitMap;
   Fbm.Planes[0]=bm->Planes[0];
   Fbm.Planes[1]=bm->Planes[1];
   Frp->BitMap=&Fbm;
#else
   Frp=rp;
#endif

   CountMax();
   if(men) InitEdLine(2);
   else InitEdLine(3);
   if(Name)
   {
      Init();
      if(LoadFile(Name)==-1) goto _my_exit;
   }
   mod=0;
   ofs=1;
   SetBPen(rp,DARK);
   Home();
   Move(rp,px(15),pyt(lpw)+1);
   if(!(men || Name))
#ifdef GERMAN
      Error("Drucke Enter an gewhlten Verzeichnis.");
#else
      Error("Press Enter on the choosen directory.");
#endif
   SetAPen(rp,LIGHT);
   PrintNum();
   PrintIns();

   if(sea)
   {
      FindNext(iss);
   }
   Cursor(1);

   while(go==1)
   {
#ifdef DEBUG
      puts("Wait");
#endif
      Wait(1<<w->UserPort->mp_SigBit);
#ifdef DEBUG
      puts("Getfirst");
#endif
      if(msg=GetMsg(w->UserPort))
      do
      {
#ifdef DEBUG
         puts("do");
#endif
         switch(msg->Class)
         {
            case RAWKEY       :
            {
               if(!(NTPPREFS.Flags&MBLANK)) FreeSprite(0);
               if(msg->Code & 0x80) break;
               if(msg->Code==0x4c||msg->Code==0x3e)
                  if(msg->Qualifier&(IEQUALIFIER_LSHIFT|IEQUALIFIER_RSHIFT))
                  {
                     Cursor(0);
                     if(msg->Qualifier&(IEQUALIFIER_LALT|IEQUALIFIER_RALT))
                        Home();
                     else PgUp();
                     Cursor(1);
                  }
                  else EmptyQ=Up(1);
               else
                  if(msg->Code==0x4d||msg->Code==0x1e)
                     if(msg->Qualifier&(IEQUALIFIER_LSHIFT|IEQUALIFIER_RSHIFT))
                     {
                        Cursor(0);
                        if(msg->Qualifier&(IEQUALIFIER_LALT|IEQUALIFIER_RALT))
                           End();
                        else PgDn();
                        Cursor(1);
                     }
                     else EmptyQ=Down(1);
               else
               {
                  Cursor(0);
                  switch(msg->Code)
                  {
                     case 0x4e :
                     case 0x2f : if(col > ALen) col=ALen;
                                 if(msg->Qualifier&(IEQUALIFIER_LSHIFT|IEQUALIFIER_RSHIFT))
                                    EoL();
                                 else Right(1);
                                 break;
                     case 0x4f :
                     case 0x2d : if(col > ALen) col=ALen;
                                 if(msg->Qualifier&(IEQUALIFIER_LSHIFT|IEQUALIFIER_RSHIFT))
                                    BoL();
                                 else Left(1);
                                 break;
                     case 0x3d : if(nlo) goto aa;
                                 if(msg->Qualifier & 8) //ctrl
                                    Home();
                                 BoL();
                                 break;
                     case 0x1d : if(nlo) goto aa;
                                 if(msg->Qualifier & 8)
                                    End();
                                 else EoL();
                                 break;
                     case 0x41 : if(!men) break;
                                 if(col > ALen) col=ALen;
                                 BackSpace();
                                 break;
                     case 0x44 :
                     case 0x43 : if(men)
                                 {
                                    if(col > ALen) col=ALen;
                                    InsLine(row+first+1,col+ofs);
                                 }
                                 else if(!Name)
                                 {
                                    int j=row+first;
                                    for(i=strlen(list[j]);i>=0;i--)
                                       if(list[j][i]=='/'||list[j][i]==':')
                                          break;
                                    if(i>-1)
                                    {
                                       i++;
                                       CopyMem(list[j],wp[Act].Path,i);
                                       wp[Act].Path[i]=0;
                                       GetSort(Act);
                                       pw[Act].First=-10000;
                                       FirstOcc(list[j]+i);
                                    } else ErrorLine("Err in ED");
                                    go=0;
                                 }
                                 break;
                     case 0x46 :
                     case 0x3c : if(!men) break;
                                 if(col > ALen) col=ALen;
                                 Del();
                                 break;
                    case 0x51 : if(!men) break;
__Save:                            SaveFile(Name);
                                 mod=0;
                                 break;
                     case 0x56 :
#ifdef GERMAN
__Find:                    if(!StringReq(iss,"Kette:")) break;
#else
__Find:                    if(!StringReq(iss,"String:")) break;
#endif
                     case 0x55 :
__Again:                      FindNext(iss);
                           break;
                     case 0x59 :
                     case 0x45 :
__Exit:                          if(mod)
                                 {
#ifdef GERMAN
                                    Error("Modifiziertedatei. Noch einmal zum Ausg.");
#else
                                    Error("File was modified. Repeat if really exit");
#endif
                                    mod=0;
                                 } else go=msg->Code;
                                 break;
                    case 0x3f : if(nlo) goto aa;
                                PgUp();
                                break;
                    case 0x53 : ModifyIDCMP(w,VANILLAKEY);
#ifdef GERMAN
                                Error("Lese Datei ...");
#else
                                Error("Reading file ...");
#endif
                                Dump1(Name);
                                ModifyIDCMP(w,RAWKEY|MOUSEBUTTONS);
                                Error(Name);
                                break;
                    case 0x1f : if(nlo) goto aa;
                                PgDn();
                                break;
                    case 0x42 : if(men)
                                 {
                                    int i;
                                    if(col > ALen) col=ALen;
                                    i=col%NTPPREFS.TabLen;
                                    for(;i<NTPPREFS.TabLen;i++)
                                       if(ins) PutChar(' ');
                                          else InsChar(' ');
                                    break;
                                 }
                    case 0x0f : if(nlo) goto aa;
                                ins=1-ins;
                                PrintIns();
                                break;
                    case 0x50 :
__NumLo:                        nlo=1-nlo;
                                PrintNum();
                                break;
                    default   :
aa:                              if(msg->Qualifier&IEQUALIFIER_RCOMMAND)
                                    switch(msg->Code)
                                    {
                                       case 0x21:if(!men) break;
                                                 if(SaveFile(Name))
                                                   go=0;
                                                 break;
                                       case 0x28:Line();
                                                 break;
#ifdef PATRIK
                                       case 0x20:men=1; break;
#endif
                                    }
                                 else if(msg->Qualifier&IEQUALIFIER_CONTROL)
                                    switch(msg->Code)
                                    {
                                       case 0x32:
                                       case 0x15:
                                          if(men) DelAllLine(first+row);
                                          break;
                                    }
                                 else
                                 {
                                    if(!men) break;
                                    if(col > ALen) col=ALen;
                                    {
                                       char str[100];
                                       short n;
                                       n=KeyConvert(msg->Code,msg->Qualifier,(int)msg->IAddress,str);
                                       if(n==1)
                                          if(ins) PutChar(str[0]);
                                          else InsChar(str[0]);
                                    }
                                 }
                  }
                  Cursor(1);
               }
               break;
            }
            case MOUSEBUTTONS :  if((msg->MouseY>w->Height-9 && msg->Code==104) || \
                                    (lact==-1 && msg->Code==232))
                                 {
                                    switch(lact=PushEdLine(msg->MouseX,msg->Code))
                                    {
                                       case 20: Cursor(1); goto __NumLo;
                                       case 21: if(men)

                                                {
                                                   Cursor(1);
                                                   goto __Save;
                                                }
                                                break;
                                       case 23: /* Cursor(1);*/ Dump1(Name); break;
                                       case 25: Cursor(1); goto __Again;
                                       case 26: Cursor(1); goto __Find;
                                       case 29: Cursor(1); goto __Exit;
                                    }
                                    break;
                                 }
                                 while(!(*cia & 0x40))
                                    if(w->MouseY>(lpw<<2)) Down(0);
                                    else Up(0);
                                 break;
#ifdef TEST
            case NEWSIZE      :  CountMax();
                                 ofs=col=row=0;
                                 PrintText();
                                 Cursor(1);
                                 break;
#endif
         }
         if(EmptyQ)
         {
            int code=msg->Code,class=msg->Class;
            EmptyQ=0;
#ifdef DEBUG
            puts("EmptyQ");
#endif
            do
            {
#ifdef DEBUG
               puts("Reply");
#endif
               ReplyMsg(msg);
#ifdef DEBUG
               puts("msg=");
#endif
               if(!(msg=GetMsg(w->UserPort))) break;
#ifdef DEBUG
               puts("ok");
#endif
            } while(msg->Code==code && msg->Class==class);
         }
         else
         {
            ReplyMsg(msg);
            msg=0;
         }
#ifdef DEBUG
         puts("if(!msg)");
#endif
         if(!msg) msg=GetMsg(w->UserPort);
#ifdef DEBUG
         printf("msg = %d\n",msg);
#endif
      } while(msg);
   }
_my_exit:
#ifdef FASTSCROLL
   FreeMem(Frp,sizeof(struct RastPort));
ended:
   InstallClipRegion(w->WLayer,ocr);
#endif
   CloseWindow(w);
   InitInLine(0);
   FreeList();
   if(go==0x45) return(0);
   return(1);
}

Prototype Find1(char *sou)
{
   if(Match(sou,lp1))
   {
      char *ptr;
      int len=strlen(spath)+1;
      if(ptr=(char *)AllocMem(len,0))
      {
         CopyMem(spath,ptr,len);
         AddLine(1);
         list[lines-1]=ptr;
      }
      else
      {
         ErrorLine(memory);
         return(0);
      }
   }
   return(1);
}

Prototype void Find()
{
#ifdef GERMAN
   if(StringReq(lp1,"Muster:"))
#else
   if(StringReq(lp1,"Pattern:"))
#endif
   {
      int i;
      Init();
      ToUpper(lp1);
      ResDir(OTHER,Find1);
      men=0;
      ED(0,0);
      for(i=pw[Act].cnt-1;i>=0;i--) pw[Act].l[i]->Set=0;
   }
}


#ifdef TEST
main(int ac,char **av)
{
   if(ac==1) ED(0);
   else
   {
      int i=1;
      while(i<ac) ED(av[i++]);
   }
}
#endif

