//#define TEST

#ifndef TEST
#include "ntp.h"
#include <libraries/dos.h>
#endif

#include <intuition/intuitionbase.h>
#include <exec/memory.h>
#include <clib/dos_protos.h>

#ifdef TEST
UBYTE *key=0xbfec01;
UBYTE *cia=0xbfe001;
#endif

#define BPL 16
#define py 14
#define pyt(n) (20+((n)<<3))
#define pyn(n) (14+((n)<<3))
#define px  4

extern struct Window *OpenWindow();
extern struct IntuitionBase *IntuitionBase;
extern struct FileInfoBlock *lfib;
extern char spath[50],buf[BLEN];
Local struct Window *w;
Local struct RastPort *rp;
Local unsigned char lpw;
Local unsigned char *first,*end,*start;
Local unsigned char hex[16]="0123456789ABCDEF";
Local unsigned char *orig, state, side;
Local ofs, pos;
Local int ap, tp, flen, plen, len;
Local BPTR f;
Local char *file;

Local void DumpLine(adr,len)
long len;
unsigned char *adr;
{
   unsigned char pom[9], t[100],*p=t;
   register a;
   sprintf(p,"%06x: ",adr-start+ofs);
   p+=8;
   for(a=0;a<len;a++,adr++)
   {
      *p++=*(hex+(*adr>>4));
      *p++=*(hex+(*adr&0xf));
      *p++=' ';
   }
   Text(rp,t,p-t);
   rp->cp_x=492;
   p=t;
   adr-=len; 
   for(a=0;a<len;a++,adr++)
      if((*adr & 0x7f) < 32) *p++='.';
      else *p++=*adr;
   Text(rp,t,p-t);
}

Local void DumpLineEd(adr1, adr2, len)
long len;
unsigned char *adr1, *adr2;
{
   unsigned char pom[9], t[100];
   register a;
   sprintf(t,"%06x: ",adr1-start+ofs);
   Text(rp, t, 8);
   t[2]=' ';
   for(a=0;a<len;a++,adr1++, adr2++)
   {
      if(*adr1==*adr2) SetAPen(rp, LIGHT);
      else SetAPen(rp, YELLOW);
      *t=*(hex+(*adr1>>4));
      t[1]=*(hex+(*adr1&0xf));
      Text(rp, t, 3);
   }
   rp->cp_x=492;
   adr1-=len; adr2-=len;
   for(a=0; a<len; a++, adr1++, adr2++)
   {
      if(*adr1==*adr2) SetAPen(rp, LIGHT);
      else SetAPen(rp, YELLOW);
      if((*adr1 & 0x7f) < 32) *t='.';
      else *t=*adr1;
      Text(rp,t,1);
   }
   SetAPen(rp, LIGHT);
}

Local void PrintLine(int i)
{
   unsigned char *ptr=first+i*BPL;
   int len=end-ptr;
   if(len>0)
   {
      Move(rp,px,pyt(i));
      DumpLine(ptr,len<BPL?len:BPL);
   }
}

Local void PrintLineEd(int i)
{
   unsigned char *ptr=start+i*BPL;
   int len=end-ptr;

   if(len>0)
   {
      Move(rp,px,pyt(i));
      DumpLineEd(ptr, i*16+orig,len<BPL?len:BPL);
   }
}

Local void PrintDump()
{
   int i;
   SetAPen(rp,DARK);
   RectFill(rp,px,w->Height-19,w->Width-8,w->Height-11);
   SetAPen(rp,LIGHT);
   SetBPen(rp,DARK);
   for(i=0;i<lpw;i++)
   {
      if(end-start-i*16<16)
      {
         SetAPen(rp, DARK);
         RectFill(rp, px, pyn(i), w->Width-1, w->Height-11);
         SetAPen(rp, LIGHT);
         PrintLine(i);
         break;
      }
      PrintLine(i);
   }
}

Local void Rectangle(x1, y1, x2, y2)
int x1, x2, y1, y2;
{
   Move(rp, x1, y1);
   Draw(rp, x1, y2);
   Draw(rp, x2, y2);
   Draw(rp, x2, y1);
   Draw(rp, x1, y1);
}

Local void PrCr()
{
   SetDrMd(rp, 3);
   if(side)
   {
      short a=492+8*(pos&15), b=pyn(pos>>4);
      RectFill(rp, a, b, a+8, b+8);
      a=px+64+24*(pos&15);
      Rectangle(a, b, a+16, b+8);
   } else
   {
      short a=492+8*(pos & 15), b=pyn(pos/16);
      Rectangle(a, b, a+8, b+8);
      a=px+64+24*(pos & 15);
      RectFill(rp, a, b, a+16, b+8);
   }
   SetDrMd(rp, 1);
}

Local void Down()
{
   if(first+BPL*lpw < end)
   {
      first+=BPL;
      ScrollRaster(rp,0,8,px,py,w->Width-8,w->Height-11);
      PrintLine(lpw-1);
   }
}

Local void Up()
{
   if(first>start)
   {
      first-=BPL;
      ScrollRaster(rp,0,-8,px,py,w->Width-(px<<1),w->Height-11);
      PrintLine(0);
   }
}

Local End()
{
   int ofs;
   first=end-lpw*BPL;
   ofs=((int)first%BPL-(int)start%BPL);
   if(ofs<0) ofs+=BPL;
   first+=BPL-ofs;
   if(first>start) PrintDump();
   else first=start;
}

Prototype Dump(char *title,unsigned char *adr,int len)
{
   void WRectangle(),WTitle();
   struct NewWindow NW =
   {
      0,0,0,0,-1,-1,
      RAWKEY|MOUSEBUTTONS,
      ACTIVATE|BORDERLESS|RMBTRAP,
      0,0,0,
#ifdef TEST
      0,
#else
      NTPBase->Screen,
#endif

      0,20,20,0,0,

#ifdef TEST
      WBENCHSCREEN
#else
      CUSTOMSCREEN
#endif
   };
   struct IntuiMessage *msg,*GetMsg();
   char go=1;
   ofs=0;
   NW.Width=IntuitionBase->ActiveScreen->Width;
   NW.Height=IntuitionBase->ActiveScreen->Height;
   if(!(w=OpenWindow(&NW))) return(0);
   SetRast(rp=w->RPort,DARK);
   SetAPen(rp,KMZ);
   SetBPen(rp,KMZ);
   SetFont(rp,pbx);
   RectFill(rp,0,0,NW.Width-1,10);
   SetAPen(rp,YELLOW);
   Move(rp,5,8);
   Text(rp,title,strlen(title));
   SetBPen(rp,GRAY);
   SetAPen(rp,WHITE);
   lpw=(w->Height-32>>3)+1;
   start=first=adr;
   end=adr+len;
   PrintDump();
   while(go==1)
   {
      Wait(1<<w->UserPort->mp_SigBit);
      while(msg=GetMsg(w->UserPort))
      {
         switch(msg->Class)
         {
            case RAWKEY :
               switch(msg->Code)
               {
                  case 0x45:
                     go=2;
                     break;
                  case 0x59:
                     go=0;
                     break;
                  case 0x4d:
                  case 0x1e:
                     if(msg->Qualifier&(IEQUALIFIER_LSHIFT|IEQUALIFIER_RSHIFT)) goto _pgdn;
                     if(*key==0x65 || *key==0xc3) Down();
                     break;
                  case 0x4c:
                  case 0x3e:
                     if(msg->Qualifier&(IEQUALIFIER_LSHIFT|IEQUALIFIER_RSHIFT)) goto _pgup;
                     if(*key==0x67 || *key==0x83) Up();
                     break;
                  case 0x1f:
_pgdn:               if(first+BPL*lpw*2<end)
                     {
                        first+=BPL*lpw;
                        PrintDump();
                     }
                     else End();
                     break;
                  case 0x35:
                  case 0x1d:
                     End();
                     break;
                  case 0x3f:
_pgup:               if(first!=start)
                     {
                        first-=BPL*lpw;
                        if(first < start)
                        {
                           first=start;
                        }
                        PrintDump();
                     }
                     break;
                  case 0x3d:
                  case 0x14:
                     if(first!=start)
                     {
                        first=start;
                        PrintDump();
                     }
                     break;
               }
               break;
            case MOUSEBUTTONS:
               if(msg->Code == 104)
               {
                  if(msg->MouseY < 15)
                  {
                     go=0;
                     break;
                  }
                  else
                  if(msg->MouseY < 50)
                     while((!(*cia & 0x40)) && w->MouseY < 50) Up();
                  else
                  if(msg->MouseY > 200)
                     while((!(*cia & 0x40)) && w->MouseY > 200) Down();
               }
               break;
         }
         ReplyMsg(msg);
      }
   }
   CloseWindow(w);
   if(go) return(0);
   return(1);
}

Local Warn()
{
   if(memcmp(start, orig, end-start))
      return(Req(E("Modified. Really?") G(uiuou)));
   return 1;
}

Local void PrintTitle(short ap, short tp)
{
   char title[80];
   SetAPen(rp,KMZ);
   SetBPen(rp,KMZ);
   RectFill(rp,0,0, NTPBase->Screen->Width-1,10);
   SetAPen(rp,YELLOW);
   Move(rp,5,8);
   sprintf(title, "( %d / %d ) of %s", ap+1, tp+1, file);
   Text(rp,title,strlen(title));
}


Local void InitEdLine()
{
   char n[3];
   int a,b, i;

   a=30;b=39;
   SetDrMd(rp,1);
   Move(rp,0,w->Height-2);
   for(i=a;i<=b;i++)
   {
      sprintf(n,"%d",i-a+1);
      SetAPen(rp,GRAY);
      SetBPen(rp,BLACK);
      Text(rp,n,strlen(n));
      SetAPen(rp,BLACK);
      SetBPen(rp,KMZ);
      Text(rp,inl[i],6);
      if(i<b)
      {
         SetBPen(rp,BLACK);
         Text(rp,spaces,1);
      }
   }
   SetAPen(rp, LIGHT);
   SetBPen(rp, DARK);
}

Local PushEdLine(int mx,int mc)
{
   static mxs=-2;
   char n[3];
   int a,b,x=0,p,i;
   mx>>=3;
   if(mc==104) mxs=mx;
      else mx=mxs;
   if(mx==-2) return(-2);
   a=30;b=39;
   SetDrMd(rp,1);
   for(i=a;i<=b;i++)
   {
      sprintf(n,"%d",i-a+1);
      if(i==b) p=2;
         else p=1;
      if(mx<x+p+7)
      {
         Move(rp,x<<3,w->Height-2);
         SetAPen(rp,GRAY);
         SetBPen(rp,BLACK);
         Text(rp,n,strlen(n));
         if(mc!=104)
         {
            SetAPen(rp,BLACK);
            SetBPen(rp,KMZ);
            Text(rp,inl[i],6);
            SetBPen(rp,DARK);
         } else
         {
            SetAPen(rp,YELLOW);
            SetBPen(rp,DARK);
            Text(rp,inl[i],6);
            i=-1;
         }
         SetAPen(rp,LIGHT);
         return(i);
      }
      x+=p+7;
   }
}

Local void GoTo(int newofs)
{
   int npage=newofs/plen, npos=newofs%plen;
   
   state=0;
   if(newofs<0 || newofs>=flen) return;
   if(npage==ap)
   {
      if((pos=npos)>len) pos=len-1;
   } else if(Warn())
   {
      Seek(f, newofs-npos-ofs-len, OFFSET_CURRENT);
      len=Read(f, start, plen);
      CopyMem(start, orig, len);
      ap=npage;
      ofs=ap*plen;
      end=start+len;
      if((pos=npos)>len) pos=len-1;
      PrintTitle(ap, tp);
      PrintDump();
   }
}

Local void do_Goto()
{
   char buf[8];
   int i;
   
   if(StringReqLen(buf,E("Dec or $Hex offset"),8))
   {
      if(!buf[0]) return;
      if(buf[0]=='$')
         sscanf(buf+1,"%x",&i);
      else i=atoi(buf);
      GoTo(i);
   }
}


Prototype void ParseLse()
{
   int x,l;
   l=strlen(lse);
   sep[0]=0;
   for(x=1; x<l; x++)
      if(lse[x]==lse[sep[x-1]]) sep[x]=sep[x-1]+1;
      else sep[x]=0;
}

Local do_Find()
{
#define SEARCHLEN 1024
   int mo, i, j, ml;
   char *mem, fnd=0;
   
   if(*lse==0) return;
   if(mem=(void *)AllocMem(SEARCHLEN, MEMF_PUBLIC))
   {
      Seek(f, pos-len, OFFSET_CURRENT);
      mo=ofs; ml=0;
      i=0;
      do
      {
         mo+=ml;
         ml=Read(f, mem, SEARCHLEN);
         
         for(j=0; j<ml; j++)
         {
            if(mem[j]!=lse[i]) i=sep[i];
            if(mem[j]==lse[i])
               if(lse[i+1]==0)
               {
                  fnd=1; ml=0; break;
               }
               else i++;
         }
      } while(ml==SEARCHLEN);
      Seek(f, ofs+len, OFFSET_BEGINNING);
      FreeMem(mem, SEARCHLEN);
      if(fnd)
      {
         GoTo(pos+mo+j-strlen(lse)+1);
         return 1;
      }
   }
   return 0;
#undef SEARCHLEN
}

Prototype DumpEd(char *fi)
{
   void WRectangle(),WTitle();
   struct NewWindow NW =
   {
      0,0,0,0,-1,-1,
      RAWKEY|MOUSEBUTTONS,
      ACTIVATE|BORDERLESS|RMBTRAP,
      0,0,0,
#ifdef TEST
      0,
#else
      NTPBase->Screen,
#endif

      0,20,20,0,0,

#ifdef TEST
      WBENCHSCREEN
#else
      CUSTOMSCREEN
#endif
   };
   struct IntuiMessage *msg,*GetMsg();
   char go=1, lact=0, str[80];
   file=fi; *lse=0;
   
   if(!(f=Open(file, MODE_READWRITE))) return(0);
   Seek(f, 0, OFFSET_END);
   flen=Seek(f, 0, OFFSET_BEGINNING);
   if(!flen) { Close(f); return(0); }
   NW.Width=NTPBase->Screen->Width;
   NW.Height=NTPBase->Screen->Height;
   lpw=(NW.Height-32>>3)+1; //(NW.Height-32>>3)+1;
   plen=lpw*16;
   tp=flen/plen;
   ap=0;
   orig=(void *)AllocMem(plen*2, MEMF_PUBLIC);
   first=start=orig+plen;
   if(!orig)
   {
      Close(f);
      return(0);
   }
   if(!(w=OpenWindow(&NW)))
   {
      Free(orig, plen*2);
      Close(f);
      return(0);
   }
   SetRast(rp=w->RPort,DARK);
   SetFont(rp,pbx);
   PrintTitle(ap, tp);
   SetBPen(rp,GRAY);
   SetAPen(rp,WHITE);
   len=Read(f, start, plen);
   CopyMem(start, orig, len);
   end=start+len;
   pos=state=side=0;
   ofs=ap*plen;
   PrintDump();
   InitEdLine();
   PrCr();
   while(go==1)
   {
      Wait(1<<w->UserPort->mp_SigBit);
      while(msg=GetMsg(w->UserPort))
      {
         PrCr();
         switch(msg->Class)
         {
            case RAWKEY :
               if(msg->Code&0x80) break;
               switch(msg->Code)
               {
                  case 0x42: side=1-side; state=0; break;
                  case 0x45:
                     if(Warn()) go=2;
                     break;
                  case 0x59:
__exit:              if(Warn()) go=0;
                     break;
                  case 0x4d:
                  case 0x1e:
                     if(msg->Qualifier&(IEQUALIFIER_LSHIFT|IEQUALIFIER_RSHIFT)) goto _pgdned;
                     GoTo(ofs+pos+16);
                     break;
                  case 0x4c:
                  case 0x3e:
                     if(msg->Qualifier&(IEQUALIFIER_LSHIFT|IEQUALIFIER_RSHIFT)) goto _pguped;
                     GoTo(ofs+pos-16);
                     break;
                  case 0x4e:
                  case 0x2f:
__righted:           GoTo(ofs+pos+1);
                     break;
                  case 0x4f:
                  case 0x2d:
                     GoTo(ofs+pos-1); 
                     break;
                  case 0x51: 
__save:              state=0;
                     Seek(f, -len, OFFSET_CURRENT);
                     Write(f, start, len);
                     CopyMem(start, orig, len);
                     PrintDump();
                     break;
                  case 0x54:
                     do_Goto(); break;
                  case 0x56:
__fnd:               state=0;
                     if(!StringReq(lse, E("String to search"))) break;
                     ParseLse();
                     do_Find();
                     break;
                  case 0x55:
__fndagn:            state=0;
                     pos++;
                     if(!do_Find()) pos--; break;
                  case 0x1f:
_pgdned:             if(ofs+pos+plen<flen)
                     {
                        GoTo(ofs+pos+plen);
                        break;
                     }
                  case 0x1d:
                     GoTo(flen-1); break;
                  case 0x3f:
_pguped:             GoTo(ofs+pos-plen); break;
                  case 0x3d:
                     GoTo(0); break; break;
                  default:
                     if(KeyConvert(msg->Code, msg->Qualifier, msg->IAddress, buf))
                     {
                        if(side)
                        {
                           start[pos]=*buf;
                           PrintLineEd(pos/16);
                           goto __righted;
                        } else
                        {
                           short c;
                           if(isdigit(*buf)) c=*buf-'0';
                           else c=10+tolower(*buf)-'a';
                           if(c>=0 && c<16)
                           {
                              if(state)
                              {
                                 start[pos]=start[pos]*16+c;
                                 PrintLineEd(pos/16);
                                 goto __righted;
                              } else
                              {
                                 state=1;
                                 start[pos]=c;
                                 PrintLineEd(pos/16);
                              }
                           }
                        }
                     }
               }
               break;
            case MOUSEBUTTONS:
               if((msg->MouseY>w->Height-9 && msg->Code==104) || (lact==-1 && msg->Code==232))
                  switch(lact=PushEdLine(msg->MouseX, msg->Code))
                  {
                     case 31: goto __save;
                     case 34: do_Goto(); break;
                     case 36: goto __fnd;
                     case 35: goto __fndagn;
                     case 39: goto __exit;
                  }
               break;
         }
         ReplyMsg(msg);
         PrCr();
      }
   }
   CloseWindow(w);
   FreeMem(orig, plen*2);
   Close(f);
   if(go) return(0);
   return(1);
}

#ifndef TEST

Prototype Dump1(char *sou)
{
   char *ptr,ret;
   int len,n;
   BPTR f;
   BPTR lock;
   if(!(lock=Lock(sou,ACCESS_READ)))
   {
      DosError(IoErr());
      return(2);
   }
   Examine(lock,lfib);
   len=lfib->fib_Size;
   UnLock(lock);
   if(ptr=(char *)AllocMem(len,0))
   {
      if(f=Open(sou,MODE_OLDFILE))
      {
         n=Read(f,ptr,len);
         if(n)
         {
#ifdef GERMAN
            sprintf(buf,"Hex-dump der Datei %s       Klicken hier zum Ausgang",sou);
#else
            sprintf(buf,"Hex-dump of file %s       Click here to Exit",sou);
#endif
            ret=Dump(buf,ptr,len);
         }
         else
         {
            DosError(IoErr());
            ret=2;
         }
         Close(f);
      }
      else
      {
         DosError(IoErr());
         ret=2;
      }
      FreeMem(ptr,len);
   }
   else
   {
      ErrorLine(memory);
      ret=2;
   }
   return(ret);
}

#endif

#ifdef TEST

#define White 2
#define Black 3
#define Pen 1
#define Back 0

void WRectangle(struct Window *w)
{
   SetAPen(w->RPort,White);
   Move(w->RPort,0,w->Height-1);
   Draw(w->RPort,0,0);
   Draw(w->RPort,w->Width-1,0);
   Move(w->RPort,1,w->Height-2);
   Draw(w->RPort,1,1);
   Draw(w->RPort,w->Width-2,1);
   SetAPen(w->RPort,Black);
   Move(w->RPort,1,w->Height-1);
   Draw(w->RPort,w->Width-1,w->Height-1);
   Draw(w->RPort,w->Width-1,1);
   Move(w->RPort,2,w->Height-2);
   Draw(w->RPort,w->Width-2,w->Height-2);
   Draw(w->RPort,w->Width-2,2);
}

void WTitle(struct Window *w,char *str)
{
   SetAPen(w->RPort,White);
   Move(w->RPort,2,12);
   Draw(w->RPort,2,2);
   Draw(w->RPort,w->Width-3,2);
   SetAPen(w->RPort,Black);
   Move(w->RPort,3,12);
   Draw(w->RPort,w->Width-3,12);
   Draw(w->RPort,w->Width-3,2);
   SetAPen(w->RPort,Pen);
   Move(w->RPort,5,10);
   Text(w->RPort,str,strlen(str));
}


main()
{
   Dump("anca",(char *)100,2000);
}
#endif
