#include <NTP.h>
#include <exec/types.h>
#include <stdio.h>
#include <exec/memory.h>
#include <intuition/intuition.h>
#include <devices/console.h>
#include <libraries/dosextens.h>
#include <libraries/filehandler.h>

extern struct DosLibrary *DOSBase;
extern struct NewScreen NewScreenStructure;

// #define DEBUG
#define MaxM 27
#define min(a,b) (a<b?a:b)

typedef struct IOStdReq IOStdReq;

typedef struct mnu
{
   char Name[60];
   unsigned char sl;
   char Exe[80];
   char Dir[80];
   char Key;
} mnu;

Prototype void CenterWindow(struct NewWindow *a)
{
   short k=(NewScreenStructure.ViewModes&LACE)?1:2;
   a->LeftEdge = a->Screen->Width - a->Width >> 1;
   a->TopEdge  = a->Screen->Height - a->Height >> 1;
   if(FindPort("DMouse"))
      MoveMouse(a->Screen->Width/2-a->Screen->MouseX,k*(a->Screen->Height/2-a->Screen->MouseY));
}


Prototype void CenterDrives(struct NewWindow *a)
{
   short k=(NewScreenStructure.ViewModes&LACE)?1:2;
   a->LeftEdge = (Act==LEFT?lstart:rstart)+(width - a->Width >> 1);
   a->TopEdge  = a->Screen->Height - a->Height >> 1;
   if(FindPort("DMouse"))
      MoveMouse(a->LeftEdge+5-a->Screen->MouseX,k*(a->Screen->Height/2-a->Screen->MouseY));
}

Prototype void ErrorLine(char *Str)
{
   static char nul;
   if(Str)
   {
      SetWindowTitles(NTPBase->w,-1,Str);
      nul=1;
   }
   else
      if(nul==1)
      {
         nul=0;
         SetWindowTitles(NTPBase->w,-1,wp[Act].Path);
      }
}

Prototype CRectangle(struct Window *w,f1,f2)
{
   SetAPen(w->RPort,f1);
   Move(w->RPort,0,w->Height-1);
   Draw(w->RPort,0,0);
   Draw(w->RPort,w->Width-1,0);
   Move(w->RPort,1,w->Height-2);
   Draw(w->RPort,1,1);
   Draw(w->RPort,w->Width-2,1);
   SetAPen(w->RPort,f2);
   Move(w->RPort,1,w->Height-1);
   Draw(w->RPort,w->Width-1,w->Height-1);
   Draw(w->RPort,w->Width-1,1);
   Move(w->RPort,2,w->Height-2);
   Draw(w->RPort,w->Width-2,w->Height-2);
   Draw(w->RPort,w->Width-2,2);
}

Prototype void WRectangle(struct Window *w)
{
   CRectangle(w,WHITE,DGRAY);
}

Prototype void Rect(struct Window *w,x0,y0,x1,y1)
{
   SetAPen(w->RPort,LIGHT);
   Move(w->RPort,x0,y1);
   Draw(w->RPort,x0,y0);
   Draw(w->RPort,x1,y0);
   Move(w->RPort,x0+1,y1-1);
   Draw(w->RPort,x0+1,y0+1);
   Draw(w->RPort,x1-1,y0+1);
   SetAPen(w->RPort,LIGHT);
   Move(w->RPort,x0+1,y1);
   Draw(w->RPort,x1,y1);
   Draw(w->RPort,x1,y0);
   Move(w->RPort,x0+1,y1-1);
   Draw(w->RPort,x1-1,y1-1);
   Draw(w->RPort,x1-1,y0+1);
}

Prototype void CTitle(struct Window *w,char *str,f1,f2,f3,f4)
{
   SetAPen(w->RPort,f1);
   Move(w->RPort,2,12);
   Draw(w->RPort,2,2);
   Draw(w->RPort,w->Width-3,2);
   SetAPen(w->RPort,f2);
   Move(w->RPort,3,12);
   Draw(w->RPort,w->Width-3,12);
   Draw(w->RPort,w->Width-3,2);
   SetAPen(w->RPort,f3);
   Move(w->RPort,5,10);
   SetBPen(w->RPort,f4);
   Text(w->RPort,str,min(strlen(str),w->Width-6>>3));
}

Prototype void WTitle(struct Window *w,char *str)
{
   CTitle(w,str,WHITE,DGRAY,DARK,GRAY);
}

Prototype int ExeMenu()
{
   char b[255];
   if(isdigit(l[cl]->Size[SLEN-1]))
   {
      if(!Evaluate(lse,b)) return(0);
      Exec(b);
      return(1);
   }
   if(sep[0])
   {
      if(!Evaluate(sep,b)) return(0);
      Exec(b);
      return(1);
   }
}

Prototype ReadMenu(char *Path,struct mnu **m)
{
   struct FileLock *lock;
   char Name[255],pom;
   FILE *f;
   int c,i=0,a=0,pi;

   /* if Path is not terminated with ':' or '/' then add '/' */
   if((pom = Path[ strlen(Path)-1 ]) == ':' || pom == '/')
         sprintf(Name,"%sNTP.MNU",Path);
     else sprintf(Name,"%s/NTP.MNU",Path);
   if(lock=(struct FileLock *)Lock(Name,ACCESS_READ))
   {
      UnLock(lock);
   }
   else strcpy(Name,omp);
   if(f=fopen(Name,"r"))
   {
      strcpy(omp,Name);
      while(1)
      {
         while((c=fgetc(f)) == ' ' || c == '\n' || c == '\t');
         if(c == EOF) break;
         m[i]=(mnu *)AllocMem(sizeof(mnu),MEMF_CLEAR);
         pom=(char) c;
         if((c=fgetc(f)) == ' ' || c == '\t')
         {
            m[i]->Key = pom;pi=1;
            while((c=fgetc(f)) == ' ' || c == '\n' || c == '\t');
            m[i]->Name[0]=c;
         }
          else
         {
            m[i]->Name[0] = pom;
            m[i]->Name[1] = (char)c;pi=2;
         }
         for(; (c=fgetc(f)) != '\n' && c != EOF; pi++)
            m[i]->Name[pi] = (char) c;
         m[i]->Name[pi] = 0;
         m[i]->sl = pi;
         while((c=fgetc(f)) == ' ' || c == '\n' || c == '\t');
         if(c == EOF) m[i]->Exe[0]=0;
            else m[i]->Exe[0] = c;
         for(pi=1; (c=fgetc(f)) != '\n' && c != EOF; pi++)
            m[i]->Exe[pi] = (char) c;
         m[i]->Exe[pi] = 0;
         if((c=fgetc(f))=='\\')
         {
            if(!fgets(m[i]->Dir,80,f)) c=EOF;
            m[i]->Dir[strlen(m[i]->Dir)-1]=0;
         }
         else
         {
            m[i]->Dir[0]=0;
            if(c!=EOF) ungetc(c,f);
         }
         if(m[i]->Exe[0]) i++;
         if(c == EOF || i == MaxM-1) break;
      }
      fclose(f);
      if(i == 0)
      {
#ifdef GERMAN
         ErrorLine("NTP.Mnu Datei schlecht formattiert");return(0);
#else
         ErrorLine("Bad formatted NTP.Mnu file, Refer in help");return(0);
#endif
      }
      pi=i;
#ifdef DEBUG
      printf("read-ok nodes=%d\n",i);
#endif
      m[i]=0;
      return(1);
   }
   return(0);
}

Prototype Menu(char *Path)
{
   int i;
   struct mnu *m[MaxM];
   if(ReadMenu(Path,m))
   {
      i=ViewMenu(m,"Menu");
      if(i != -1)
      {
         strcpy(lse,m[i]->Exe);
         strcpy(sep,m[i]->Dir);
         if(pw[Act].cnt)
         {
            SetTest();
            ResDir(PROCESS,ExeMenu);
            RFree(Act);
            Ref();
         }
      }
      for(i=0;m[i];i++)
      {
#ifdef DEBUG
         printf("%d:\n  Key = %c\n  Name= %s\n  Exec= %s\n",i,m[i]->Key,
         m[i]->Name,m[i]->Exe);
#endif
         FreeMem(m[i],sizeof(mnu));
      }
   }
   return(0);
}

Prototype ViewMenu(struct mnu **m,char *title)
{
   struct NewWindow nw =
   {
      0,0,0,0,-1,-1,MOUSEBUTTONS|RAWKEY,ACTIVEWINDOW|RMBTRAP|BORDERLESS,
      NULL,
      NULL,NULL,
      NTPBase->Screen,
      NULL,0,0,0,0,
      CUSTOMSCREEN
   };
   struct Window *w,*OpenWindow();
   struct IntuiMessage *msg=0,*GetMsg(),*WaitPort();
#ifdef GERMAN
   int run=1,pi,mpi=8,i,a=0;
#else
   int run=1,pi,mpi=5,i,a=0;
#endif
#ifdef DEBUG
   puts("ViewMenu");
#endif
   for(i=0;m[i];i++)
      if(m[i]->sl>mpi)
      {
         mpi=m[i]->sl;
      }
   nw.Width = (mpi << 3) + 34;
   nw.Height = i*8 + 28;
   pi=i;
#ifdef GERMAN
   if(*title=='G') CenterDrives(&nw);
#else
   if(*title=='D') CenterDrives(&nw);
#endif
   else CenterWindow(&nw);

#ifdef DEBUG
   printf("%d %d\n",nw.Width,nw.Height);
#endif
   if(w=OpenWindow(&nw))
   {
      struct RastPort *rp=w->RPort;
      int po = nw.Width - 4,na;
      char *cia = (char *) 0xbfe001,buf[1];
#ifdef DEBUG
      puts("OpenWindow");
#endif
      SetRast(rp,GRAY);
      WRectangle(w);
      WTitle(w,title);
      ActivateWindow(w);
      SetAPen(rp,BLACK);
      SetBPen(rp,GRAY);
      SetDrMd(rp,1);
      for(i=0;i<pi;i++)
      {
         if(m[i]->Key)
         {
            Move(rp,10,22+(i<<3));
            Text(rp,&(m[i]->Key),1);
         }
         Move(rp,26,22+(i<<3));
         Text(rp,m[i]->Name,m[i]->sl);
      }
      Move(rp,26,22+(i<<3));
#ifdef GERMAN
      Text(rp,"Ausgang",7);
#else
      Text(rp,"Exit",4);
#endif
      SetDrMd(rp,3);
      RectFill(rp,10,16,po,23);
      while(run == 1)
      {
         long Sig;
#ifdef DEBUG
         puts("SigWait");
#endif
         WaitPort(w->UserPort);
         msg=GetMsg(w->UserPort);
         if(msg->Class==RAWKEY)
         {
#ifdef DEBUG
            printf("RawKey\n");
#endif
            switch(msg->Code)
            {
               case 0x4d:
               case 0x1e:
               case 0x4e:
               case 0x2f:
                         if(a < pi)
                         {
                           RectFill(rp,10,16+(a<<3),
                                   po,23+(a<<3));
                           a++;
                           RectFill(rp,10,16+(a<<3),
                                    po,23+(a<<3));
                         }
                         break;
               case 0x4c:
               case 0x3e:
               case 0x4f:
               case 0x2d:
                         if(a > 0)
                         {
                           RectFill(rp,10,16+(a<<3),
                                    po,23+(a<<3));
                           a--;
                           RectFill(rp,10,16+(a<<3),
                                    po,23+(a<<3));
                         }
                         break;
               case 0x44:
               case 0x43:
                         if(a == pi) run=2;
                         else run=0;
                         break;
               case 0x45:
               case 0x59:
                          run=2;
                          break;
               default:
#ifdef DEBUG
                        puts("Checking");
#endif
                        {
                           char str[100],l;
                           if(1==KeyConvert(msg->Code,msg->Qualifier,msg->IAddress,str))
                              for(i=0;i<pi;i++)
                                 if(m[i]->Key == *str)
                                 {
                                    a=i;
                                    run=0;
                                 }
                        }
            }
         }
         else
         {
#ifdef DEBUG
            puts("MouseButtons");
#endif
            if(msg -> Code == 104)
            {
               na=msg->MouseY - 14 >> 3;
               if(na == a) {run=0;break;}
#ifdef DEBUG
               puts("Code == 104");
#endif
               while(!(*cia & 0x40))
                  if((na=w->MouseY - 14 >> 3) >= 0)
                  {
#ifdef DEBUG
                     puts("Mouse Check");
#endif
                     if(na >= pi)
                     {
                        run = 2;
                        break;
                     }
                     if(na != a)
                     {
                        RectFill(rp,10,16+(a<<3),po,23+(a<<3));
                        RectFill(rp,10,16+(na<<3),po,23+(na<<3));
                        a=na;
                     }
                  }
            }
         }
         ReplyMsg(msg);
      }
   } else ErrorLine(memory);
   if(w) CloseWindow(w);
   if(run) return(-1);
      else return(a);
}

Prototype GetDrives(struct mnu **m)
{
   int a=0,x,y;
   struct DosInfo *i;
   struct DeviceNode *d;
   char *ptr;
   mnu *pom;

   i=(struct DosInfo *)BADDR(((struct RootNode *)DOSBase->dl_Root)->rn_Info);
   d=(struct DeviceNode *)BADDR(i->di_DevInfo);
   for(;d;d=(struct DeviceNode *)BADDR(d->dn_Next))
      if((d->dn_Type==DLT_DEVICE) && d->dn_Task)
         if(m[a]=(mnu *)AllocMem(sizeof(mnu),MEMF_CLEAR|MEMF_PUBLIC))
         {
            ptr=(char *)BADDR(d->dn_Name);
            CopyMem(ptr+1,m[a]->Name,*ptr);
            m[a]->Name[*ptr]=0;
            m[a]->sl=*ptr;
            a++;
         }
   m[a]=0;
   for(y=a;y>1;y--)
      for(x=1;x<a;x++)
         if(stricmp(m[x-1],m[x])==1)
         {
            pom=m[x];
            m[x]=m[x-1];
            m[x-1]=pom;
         }
   for(x=0;x<a;x++)
      m[x]->Key='a'+x;
   return(a);
}

Prototype SelectPath(char *path)
{
   int a;
   struct mnu *m[MaxM];
   if(GetDrives(m))
   {
#ifdef GERMAN
      a=ViewMenu(m,"Gerte:");
#else
      a=ViewMenu(m,"Drives:");
#endif
      if(a!=-1)
      {
         strcpy(path,m[a]->Name);
         strcat(path,":");
         for(a=0;m[a];a++) FreeMem(m[a],sizeof(mnu));
         return(1);
      }
   }
   for(a=0;m[a];a++) FreeMem(m[a],sizeof(mnu));
   return(0);
}


#ifdef TEST
main()
{
   Menu("ram:");
}
#endif
