/*

Directory Opus 5
Original APL release version 5.82
Copyright 1993-2012 Jonathan Potter & GP Software

This program is free software; you can redistribute it and/or
modify it under the terms of the AROS Public License version 1.1.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
AROS Public License for more details.

The release of Directory Opus 5 under the GPL in NO WAY affects
the existing commercial status of Directory Opus for Windows.

For more information on Directory Opus for Windows please see:

                 http://www.gpsoft.com.au

*/

#include "about.h"

ModuleInfo
	module_info={
		1,
		"about.module",
		0,
		0,
		0};

ConfigWindow
	about_window={
		{POS_CENTER,POS_CENTER,50,8},
		{0,0,22+logo_width,26+logo_height}};

struct TagItem
	copyright_tags[]={
		{GTCustom_LayoutRel,GAD_ABOUT_COPYRIGHT},
		{TAG_END}},

	registration_tags[]={
		{GTCustom_LayoutRel,GAD_ABOUT_REGISTRATION},
		{TAG_END}};


ObjectDef
	about_objects[]={

		// Logo area
		{OD_AREA,
			0,
			{0,0,0,0},
			{2,2,73,69},
			0,
			AREAFLAG_RECESSED|AREAFLAG_ERASE|AREAFLAG_THIN|AREAFLAG_FILL_COLOUR,
			GAD_ABOUT_LOGO,
			0},

		// Copyright area
		{OD_AREA,
			TEXTPEN,
			{0,0,SIZE_MAXIMUM,0},
			{14+logo_width,2,-2,10+logo_height},
			0,
			AREAFLAG_RECESSED|AREAFLAG_ERASE|AREAFLAG_THIN|AREAFLAG_FILL_COLOUR,
			GAD_ABOUT_COPYRIGHT,
			0},

		// Copyright text
		{OD_AREA,
			TEXTPEN,
			{0,0,SIZE_MAXIMUM,1},
			{0,3,0,0},
			0,
			TEXTFLAG_CENTER|AREAFLAG_FILL_COLOUR,
			GAD_COPYRIGHT_1,
			copyright_tags},

		{OD_AREA,
			TEXTPEN,
			{0,POS_CENTER,SIZE_MAXIMUM,1},
			{0,0,0,0},
			0,
			TEXTFLAG_CENTER|AREAFLAG_FILL_COLOUR,
			GAD_COPYRIGHT_2,
			copyright_tags},

		{OD_AREA,
			TEXTPEN,
			{0,POS_RIGHT_JUSTIFY,SIZE_MAXIMUM,1},
			{0,-3,0,0},
			0,
			TEXTFLAG_CENTER|AREAFLAG_FILL_COLOUR,
			GAD_COPYRIGHT_3,
			copyright_tags},

		// Registration information
		{OD_AREA,
			0,
			{0,0,SIZE_MAXIMUM,SIZE_MAXIMUM},
			{2,14+logo_height,-2,-2},
			0,
			AREAFLAG_RECESSED|AREAFLAG_ERASE|AREAFLAG_THIN|AREAFLAG_FILL_COLOUR,
			GAD_ABOUT_REGISTRATION,
			0},

		// Registration text
		{OD_AREA,
			TEXTPEN,
			{0,0,SIZE_MAXIMUM,1},
			{0,3,0,0},
			0,
			TEXTFLAG_CENTER|AREAFLAG_FILL_COLOUR,
			GAD_REGISTRATION_1,
			registration_tags},

		{OD_AREA,
			TEXTPEN,
			{0,1,SIZE_MAXIMUM,1},
			{0,3,0,0},
			0,
			TEXTFLAG_CENTER|AREAFLAG_FILL_COLOUR,
			GAD_REGISTRATION_2,
			registration_tags},

		{OD_AREA,
			TEXTPEN,
			{0,2,SIZE_MAXIMUM,1},
			{0,3,0,0},
			0,
			TEXTFLAG_CENTER|AREAFLAG_FILL_COLOUR,
			GAD_REGISTRATION_3,
			registration_tags},

		{OD_AREA,
			TEXTPEN,
			{0,3,SIZE_MAXIMUM,1},
			{0,3,0,0},
			0,
			TEXTFLAG_CENTER|AREAFLAG_FILL_COLOUR,
			GAD_REGISTRATION_4,
			registration_tags},

		{OD_AREA,
			TEXTPEN,
			{0,4,SIZE_MAXIMUM,1},
			{0,3,0,0},
			0,
			TEXTFLAG_CENTER|AREAFLAG_FILL_COLOUR,
			GAD_REGISTRATION_5,
			registration_tags},

		{OD_AREA,
			TEXTPEN,
			{0,5,SIZE_MAXIMUM,1},
			{0,3,0,0},
			0,
			TEXTFLAG_CENTER|AREAFLAG_FILL_COLOUR,
			GAD_REGISTRATION_6,
			registration_tags},

		{OD_AREA,
			TEXTPEN,
			{0,6,SIZE_MAXIMUM,1},
			{0,3,0,0},
			0,
			TEXTFLAG_CENTER|AREAFLAG_FILL_COLOUR,
			GAD_REGISTRATION_7,
			registration_tags},

		{OD_AREA,
			TEXTPEN,
			{0,7,SIZE_MAXIMUM,1},
			{0,3,0,0},
			0,
			TEXTFLAG_CENTER|AREAFLAG_FILL_COLOUR,
			GAD_REGISTRATION_8,
			registration_tags},

		{OD_AREA,
			TEXTPEN,
			{0,8,SIZE_MAXIMUM,1},
			{0,3,0,0},
			0,
			TEXTFLAG_CENTER|AREAFLAG_FILL_COLOUR,
			GAD_REGISTRATION_9,
			registration_tags},

		{OD_END}};

struct Library *DataTypesBase;
APTR logo_obj[logo_frames];
ImageRemap remap;

USHORT
	logo_image[logo_frames][472]={
		{0x0000,0x0000,0x8000,0x0000,0x0000,0x0030,0x8800,0x0000,
		0x0000,0x0230,0x8c20,0x0000,0x0000,0x0331,0xdc62,0x0000,
		0x0000,0x43b9,0xdce6,0x0000,0x0000,0x63b9,0xfcee,0x0000,
		0x0000,0x33ff,0xfdee,0x0000,0x0002,0x3b7f,0x7ffc,0x3000,
		0x0003,0x3f7f,0x7f7c,0xe000,0x0003,0xff3f,0x3e7d,0xe200,
		0x0061,0xff9e,0x3c7f,0xce00,0x0071,0xbf9e,0x3c7e,0xfc00,
		0x003d,0x9f8e,0x387c,0xfc00,0x021f,0xc784,0x1079,0xf820,
		0x03df,0xc784,0x1071,0xf9e0,0x01ff,0xe180,0x00c3,0xffc0,
		0x00ff,0xe01f,0xf803,0xff80,0x0067,0xe07f,0xff83,0xf300,
		0x1830,0xf1ff,0xffc7,0x8600,0x0ff8,0x13ff,0xffe4,0x0e00,
		0x07fc,0x07ff,0xfff8,0x1c00,0x03fe,0x0fff,0xfffc,0x3800,
		0x7fff,0x1fff,0xfffc,0x7000,0x3fff,0x3fff,0xfffe,0x6000,
		0x0e03,0x7fff,0xffff,0xc000,0x0780,0x7fff,0xffff,0x8000,
		0x01c0,0x7fff,0xffff,0x8000,0x2ff0,0xffff,0xffff,0x8000,
		0xfff8,0xffff,0xffff,0x8000,0x3ffc,0xffff,0xffff,0x8000,
		0x0ff0,0xffff,0xffff,0x8000,0x1f81,0xffff,0xffff,0xc000,
		0x7801,0xffff,0xffff,0xc000,0x3f81,0xfff3,0xffc7,0xc000,
		0x03fc,0xff93,0xff83,0xc000,0x07fc,0xf990,0xff01,0xc000,
		0x1ff8,0xf888,0x1e00,0xe000,0x7fe0,0xf846,0x1c00,0x7000,
		0x7fc0,0x7c43,0xf800,0x3800,0x0300,0x7c30,0x7000,0x1c00,
		0x0e7f,0x7e18,0x6600,0x3800,0x3fff,0x3f0f,0xcf00,0x7000,
		0x7ffe,0x1f81,0x9f80,0xe000,0x00fc,0x0fe1,0x8fc1,0xc000,
		0x01f8,0x07f9,0x87e3,0x8000,0x03f0,0x33ff,0xc3c7,0x0000,
		0x07f1,0xe0ff,0xe18e,0x0000,0x1f6f,0xe0ff,0xf01c,0x0000,
		0x00ff,0x81ff,0xf838,0x0000,0x01fe,0x4100,0x1c70,0x0000,
		0x03c2,0xc200,0x0ee0,0x0000,0x0205,0x0600,0x07c0,0x0000,
		0x001a,0x8c00,0x0380,0x0000,0x0017,0x5000,0x0100,0x0000,
		0x002a,0xa000,0x0000,0x0000,0x0051,0x4000,0x0000,0x0000,
		0x0006,0x0000,0x0000,0x0000,0x0005,0x0000,0x0000,0x0000,
		0x0004,0x0000,0x0000,0x0000,
		0x0000,0x0000,0x8000,0x0000,0x0000,0x0030,0x8800,0x0000,
		0x0000,0x0020,0x0420,0x0000,0x0000,0x0021,0x5422,0x0000,
		0x0000,0x0289,0x00a6,0x0000,0x0000,0x2220,0x202a,0x0000,
		0x0000,0x02c6,0x8022,0x0000,0x0000,0x0a08,0x9aa0,0x1000,
		0x0000,0x06d8,0xd980,0x8000,0x0002,0x42cd,0x9995,0x2000,
		0x0060,0x8ccd,0xd934,0x8a00,0x0050,0x4ef5,0xc331,0x2000,
		0x0025,0x36f3,0xe723,0x0000,0x0201,0x72f3,0xe72f,0x2020,
		0x0254,0x3cff,0xff1e,0x6920,0x0103,0x3e7c,0x1f3e,0xc840,
		0x0003,0x9ff0,0x037c,0xc000,0x001c,0x0f00,0x00f8,0x1c00,
		0x180e,0x8e07,0xf038,0xb800,0x0067,0xc83f,0xfe09,0xf200,
		0x0007,0xf0ff,0xff8f,0xf400,0x0073,0xe1ff,0xffc7,0xe800,
		0x4e3d,0xe3ff,0xffe3,0x9000,0x2300,0x47ff,0xfff1,0x0000,
		0x00fb,0x4fff,0xfff9,0x0000,0x047f,0x8fff,0xfff8,0x0000,
		0x011f,0x1fff,0xfffc,0x8000,0x2c07,0x9fff,0xfffc,0x8000,
		0x8063,0x3fff,0xfffc,0x0000,0x21c1,0x3fff,0xfffe,0x0000,
		0x0836,0x3fff,0xfffe,0x0000,0x11ff,0x3fff,0xffc6,0x4000,
		0x03ff,0x3fff,0xff80,0x4000,0x20bf,0x3ff3,0xff10,0x4000,
		0x020e,0x3f9f,0xfe7c,0x4000,0x0660,0x39f6,0xfc7e,0x0000,
		0x19e7,0x3fef,0xd9ff,0x2000,0x410f,0x9b76,0xd1ff,0x1000,
		0x407f,0x1f5b,0xe7ff,0xc800,0x00ff,0x8dbf,0x49ff,0xe400,
		0x0378,0xcfd9,0x10ff,0xe000,0x2001,0xc7ff,0x207f,0xc000,
		0x5f99,0xe3bc,0x703f,0x0000,0x003b,0xe1fc,0xf81f,0x0000,
		0x0063,0xf0f8,0x7c1c,0x0000,0x0007,0x943e,0x7e1c,0x0000,
		0x001f,0x000f,0x1f30,0x0000,0x1318,0x7580,0x1fe0,0x0000,
		0x00a0,0x81f0,0x0fc0,0x0000,0x001e,0x5500,0x0380,0x0000,
		0x0242,0xc200,0x0300,0x0000,0x0205,0x1600,0x0000,0x0000,
		0x001a,0xcc00,0x0000,0x0000,0x0017,0x5000,0x0000,0x0000,
		0x002a,0xa000,0x0000,0x0000,0x0051,0x4000,0x0000,0x0000,
		0x0006,0x0000,0x0000,0x0000,0x0005,0x0000,0x0000,0x0000,
		0x0004,0x0000,0x0000,0x0000},

		{0x0000,0x0000,0x4400,0x0000,0x0000,0x0110,0x4400,0x0000,
		0x0000,0x0118,0xcc10,0x0000,0x0000,0x2198,0xee30,0x0000,
		0x0000,0x21dc,0xee73,0x0000,0x0000,0x31dc,0xfe73,0x0000,
		0x0003,0x39ff,0xbef7,0x0000,0x0003,0x9dbf,0xbffe,0x1800,
		0x0001,0xdfbf,0xbfbe,0x3000,0x0021,0xff9f,0x3f3e,0x7000,
		0x0030,0xff8f,0x1e3f,0xe100,0x001c,0xdf8f,0x1e7f,0x6f00,
		0x001e,0xcf86,0x187e,0xfe00,0x01cf,0xc786,0x1878,0xfc00,
		0x00ff,0xe182,0x0070,0xf820,0x007f,0xe080,0x0061,0xf9e0,
		0x006f,0xe01f,0xf841,0xffc0,0x0831,0xf07f,0xff83,0xff80,
		0x0fd8,0x79ff,0xffc3,0xe380,0x07fc,0x03ff,0xffe7,0x0600,
		0x03fc,0x07ff,0xfff8,0x0e00,0x38fe,0x0fff,0xfffc,0x1c00,
		0x1fff,0x1fff,0xfffc,0x3800,0x0f0f,0xbfff,0xfffe,0x7000,
		0x0380,0x7fff,0xfffe,0x6000,0x01c0,0x7fff,0xffff,0xc000,
		0x2fe0,0x7fff,0xffff,0x8000,0xfff8,0xffff,0xffff,0x8000,
		0x7ffc,0xfbff,0xffff,0x8000,0x0ffc,0xf0ff,0xffff,0x8000,
		0x1f80,0xf11f,0xffff,0x8000,0x7801,0xf103,0xffff,0xc000,
		0x3f81,0xf123,0xffff,0xc000,0x07f1,0xf103,0xffc7,0xc000,
		0x03fc,0xf113,0xff83,0xc000,0x1ffc,0xf191,0xff01,0xc000,
		0x3ff0,0xf999,0xfe00,0xe000,0x7fc0,0xf888,0xfc00,0x7000,
		0x0300,0x78c7,0x7800,0x3800,0x0c00,0x7c63,0xf000,0x1c00,
		0x3fff,0x7e30,0xe600,0x3800,0x7ffe,0x3f3f,0xcf00,0x7000,
		0x00fc,0x1f8f,0x9f80,0xe000,0x01f8,0x0fc7,0x8fc1,0xc000,
		0x07f8,0x27f3,0x87e3,0x8000,0x0ff0,0xe3ff,0xc3c7,0x0000,
		0x1ee3,0xe0ff,0xe18e,0x0000,0x18ff,0xc0ff,0xf01c,0x0000,
		0x01fe,0xc3ff,0xf838,0x0000,0x0385,0x8700,0x1c70,0x0000,
		0x060e,0x8e00,0x0ee0,0x0000,0x001f,0x9c00,0x07c0,0x0000,
		0x001f,0x3800,0x0380,0x0000,0x007f,0xe000,0x0100,0x0000,
		0x0067,0xc000,0x0000,0x0000,0x0007,0x0000,0x0000,0x0000,
		0x000e,0x0000,0x0000,0x0000,0x000c,0x0000,0x0000,0x0000,
		0x0000,0x0000,0x0000,0x0000,
		0x0000,0x0000,0x4400,0x0000,0x0000,0x0110,0x0000,0x0000,
		0x0000,0x0018,0x8810,0x0000,0x0000,0x2110,0xa210,0x0000,
		0x0000,0x0104,0xa253,0x0000,0x0000,0x0100,0x5211,0x0000,
		0x0003,0x2123,0x0291,0x0000,0x0002,0x8104,0x4f58,0x1800,
		0x0000,0x436c,0xcc44,0x0000,0x0021,0x046c,0x68c8,0x0000,
		0x0020,0x6624,0xe89b,0x0000,0x0004,0x2770,0xebd8,0x4900,
		0x0002,0x3a71,0xe391,0x8000,0x0040,0x3c7b,0xf793,0x0400,
		0x0013,0x1c7f,0xef86,0x2020,0x0001,0xcf7c,0x1f9e,0xe920,
		0x0048,0xcff0,0x033c,0xc000,0x082f,0x0f00,0x00fc,0x8600,
		0x09c7,0xce07,0xf038,0x3e80,0x0407,0xe83f,0xfe0d,0x7800,
		0x0271,0xf0ff,0xff8f,0xf000,0x383c,0xe1ff,0xffc7,0xe400,
		0x0002,0x63ff,0xffe3,0xc800,0x090c,0x47ff,0xfff1,0xd000,
		0x003f,0xcfff,0xfff8,0x0000,0x011f,0x8fff,0xfff8,0x0000,
		0x2e0f,0x1fff,0xfffc,0x0000,0x006f,0x9fff,0xfffc,0x8000,
		0x61e1,0x3bff,0xfffc,0x0000,0x0807,0x36ff,0xfffe,0x0000,
		0x11be,0x375f,0xfffe,0x0000,0x07ff,0x37cb,0xffc6,0x4000,
		0x20bf,0x3ffb,0xff80,0x4000,0x041f,0x3fcb,0xff10,0x4000,
		0x0260,0x3f5f,0xfe7c,0x4000,0x19f2,0x37fd,0xfc7e,0x0000,
		0x23c7,0x3fff,0xf9ff,0x2000,0x407f,0x9fbb,0xf1ff,0x1000,
		0x007f,0x1bf7,0x67ff,0xc800,0x0119,0x8feb,0xc9ff,0xe400,
		0x2001,0x8ff2,0x90ff,0xe000,0x1f89,0xc7ff,0x207f,0xc000,
		0x003b,0xe3ee,0x703f,0x0000,0x0173,0xe1de,0xf81f,0x0000,
		0x040f,0xe0f6,0x7c1c,0x0000,0x081e,0x943e,0x7e1c,0x0000,
		0x12b8,0x2a0f,0x1f30,0x0000,0x1820,0xd480,0x1fe0,0x0000,
		0x0000,0xebf0,0x0fc0,0x0000,0x0085,0x9700,0x0380,0x0000,
		0x060e,0xae00,0x0300,0x0000,0x001f,0xdc00,0x0000,0x0000,
		0x001f,0x3800,0x0000,0x0000,0x007f,0xe000,0x0000,0x0000,
		0x0067,0xc000,0x0000,0x0000,0x0007,0x0000,0x0000,0x0000,
		0x000e,0x0000,0x0000,0x0000,0x000c,0x0000,0x0000,0x0000,
		0x0000,0x0000,0x0000,0x0000},

		{0x0000,0x0000,0x0000,0x0000,0x0000,0x0084,0x2200,0x0000,
		0x0000,0x008c,0x6200,0x0000,0x0000,0x10cc,0x6618,0x0000,
		0x0000,0x30ee,0x7738,0x8000,0x0001,0x1cee,0xff39,0x8000,
		0x0001,0x9cfe,0xff7b,0x8000,0x0000,0xcedf,0xdfff,0x0000,
		0x0000,0xef9f,0x9fdf,0x0c00,0x0030,0xffcf,0x9fbf,0x3000,
		0x001c,0xdfcf,0x1f3e,0xf180,0x000f,0x6fc7,0x0e3f,0xf380,
		0x00cf,0xe3c3,0x0e3f,0x3700,0x00f7,0xe1c3,0x0c3e,0x7e00,
		0x007f,0xf1c1,0x083c,0x7e00,0x0077,0xf0c0,0x0078,0xfc10,
		0x0031,0xf01f,0xf841,0xfbf0,0x0798,0x787f,0xff81,0xffc0,
		0x07fc,0x19ff,0xffc3,0xf980,0x03fe,0x03ff,0xffe3,0x8300,
		0x3cfe,0x07ff,0xfffa,0x0700,0x3fff,0x0fff,0xfffc,0x0600,
		0x0eff,0x9fff,0xfffc,0x1c00,0x0701,0x3f1f,0xfffe,0x3800,
		0x01c0,0x7e1f,0xfffe,0x7000,0x07e0,0x7c3f,0xffff,0xe000,
		0x7ff8,0x7c27,0xffff,0xc000,0x3ffe,0xf8c7,0xffff,0x8000,
		0x0ffe,0xf88f,0xffff,0x8000,0x1fc0,0xf191,0xffff,0x8000,
		0x7801,0xf111,0xffff,0x8000,0x7f01,0xf103,0xffff,0xc000,
		0x07c1,0xf127,0xffff,0xc000,0x01fd,0xf327,0xffc7,0xc000,
		0x07fc,0xf327,0xff83,0xc000,0x7ff0,0xf327,0xff01,0xc000,
		0x7fc0,0xf337,0xfe00,0xe000,0x1f80,0xf99b,0xfc00,0x7000,
		0x0e00,0xf9df,0xf800,0x3800,0x3fff,0x7ddf,0xf000,0x1c00,
		0x7ffe,0x3cff,0xe600,0x3800,0x00fc,0x3f7f,0xcf00,0x7000,
		0x03f8,0x1fff,0x9f80,0xe000,0x07f0,0x0fff,0x8fc1,0xc000,
		0x0fe0,0x67ff,0x87e3,0x8000,0x1fe3,0xc3ff,0xc3c7,0x0000,
		0x30df,0xc1ff,0xe18e,0x0000,0x03ff,0xc1ff,0xf01c,0x0000,
		0x07ef,0x839f,0xf838,0x0000,0x061f,0x0f00,0x1c70,0x0000,
		0x003f,0x1c00,0x0ee0,0x0000,0x003f,0x3000,0x07c0,0x0000,
		0x007e,0xe000,0x0380,0x0000,0x00e7,0xc000,0x0100,0x0000,
		0x00cf,0x8000,0x0000,0x0000,0x000e,0x0000,0x0000,0x0000,
		0x001c,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
		0x0000,0x0000,0x0000,0x0000,
		0x0000,0x0000,0x0000,0x0000,0x0000,0x0084,0x2000,0x0000,
		0x0000,0x0008,0x4000,0x0000,0x0000,0x1000,0x4008,0x0000,
		0x0000,0x20a0,0x1128,0x8000,0x0001,0x1480,0x8108,0x8000,
		0x0001,0x1084,0xa108,0x8000,0x0000,0x00a4,0x25ac,0x0000,
		0x0000,0x2524,0x2460,0x0400,0x0020,0x0666,0x6ce5,0x0000,
		0x0004,0xb23a,0x74c8,0x8180,0x0001,0x3b3e,0xe5d8,0x5380,
		0x004a,0x9938,0xe3d8,0x9100,0x0091,0x0c3d,0xf3da,0x8000,
		0x0000,0x8f3d,0xf3c3,0x0200,0x0040,0xdffc,0x1f8f,0x3000,
		0x000c,0x6ff0,0x039f,0x6310,0x0093,0x0f00,0x00fe,0xc000,
		0x0433,0xfe07,0xf03e,0x0200,0x0201,0xf83f,0xfe0c,0x1c00,
		0x3c3c,0xf0ff,0xff8e,0xf900,0x2006,0xe1ff,0xffc7,0xf200,
		0x0800,0xe3ff,0xffe3,0xf400,0x047d,0x475f,0xfff1,0x8800,
		0x017f,0xceff,0xfff8,0x9000,0x060f,0x8dff,0xfff8,0x0000,
		0x0007,0x1fb7,0xfffc,0x4000,0x21f3,0x9bf7,0xfffc,0x0000,
		0x0803,0x3eff,0xfffc,0x0000,0x180f,0x37f5,0xfffe,0x0000,
		0x017f,0x375d,0xfffe,0x0000,0x61ff,0x3dcb,0xffc6,0x4000,
		0x040f,0x3dff,0xff80,0x4000,0x0003,0x3fbf,0xff10,0x4000,
		0x00f2,0x3fbf,0xfe7c,0x4000,0x63c6,0x3fef,0xfc7e,0x0000,
		0x001f,0x377f,0xf9ff,0x2000,0x1cff,0x1ddb,0xf1ff,0x1000,
		0x03ff,0x9fdf,0xe7ff,0xc800,0x2101,0x8fdf,0xc9ff,0xe400,
		0x1e08,0x8dff,0x90ff,0xe000,0x00b9,0xe77f,0x207f,0xc000,
		0x0367,0xe3fe,0x703f,0x0000,0x00c7,0xe1fe,0xf81f,0x0000,
		0x081f,0x98fe,0x7c1c,0x0000,0x133a,0x103e,0x7e1c,0x0000,
		0x3040,0x3e0f,0x1f30,0x0000,0x0203,0xd500,0x1fe0,0x0000,
		0x042f,0x3d90,0x0fc0,0x0000,0x061e,0x5b00,0x0380,0x0000,
		0x0035,0xd400,0x0300,0x0000,0x002a,0x2000,0x0000,0x0000,
		0x005c,0xc000,0x0000,0x0000,0x00a2,0xc000,0x0000,0x0000,
		0x00cd,0x8000,0x0000,0x0000,0x000a,0x0000,0x0000,0x0000,
		0x001c,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
		0x0000,0x0000,0x0000,0x0000},

		{0x0000,0x0000,0x1000,0x0000,0x0000,0x0046,0x1100,0x0000,
		0x0000,0x0066,0x1180,0x0000,0x0000,0x1866,0x3308,0x0000,
		0x0000,0x0c77,0x3b98,0x0000,0x0000,0xce77,0x7f98,0x8000,
		0x0000,0xce7f,0x6fb9,0x8000,0x0000,0xef5f,0xdffb,0x8000,
		0x0018,0x7fcf,0xcfff,0x8400,0x000c,0x6fe7,0xcfdf,0x8c00,
		0x000f,0x67e7,0x8f9f,0x3800,0x00c7,0xe7e3,0x8f1f,0xf880,
		0x0077,0xe3c3,0x0e1f,0xf380,0x007f,0xf1c1,0x0c3f,0x3f00,
		0x003f,0xf861,0x043e,0x7f00,0x001b,0xf800,0x003c,0x7e00,
		0x0718,0x781f,0xf830,0xfc30,0x03ec,0x387f,0xff80,0xfff0,
		0x01fe,0x09ff,0xffc1,0xffc0,0x18ff,0x03ff,0xffe1,0xf1c0,
		0x1fff,0x07fe,0x7ffb,0x0380,0x0fff,0x8fe0,0x7ffc,0x0700,
		0x0383,0x9f80,0x7ffc,0x0e00,0x01c0,0x3f00,0xfffe,0x1800,
		0x20e0,0x7e1c,0x7ffe,0x3800,0x7ff0,0x7c30,0x7fff,0x7000,
		0x3ff8,0x7c60,0xffff,0xe000,0x0ffe,0xf887,0xffff,0x8000,
		0x5ffc,0xf198,0x7fff,0x8000,0x7c00,0xf330,0x7fff,0x8000,
		0x3e01,0xf323,0xffff,0x8000,0x0fc1,0xe267,0xffff,0xc000,
		0x03f9,0xe647,0xffff,0xc000,0x07fd,0xe64f,0xffc7,0xc000,
		0x7ff8,0xf64f,0xff83,0xc000,0x7ff0,0xf7ff,0xff01,0xc000,
		0x1f80,0xffff,0xfe00,0xe000,0x0e00,0xffff,0xfc00,0x7000,
		0x3cee,0x7fff,0xf800,0x3800,0xfffe,0x7fff,0xf000,0x1c00,
		0x01fc,0x3fff,0xe600,0x3800,0x01f8,0x3fff,0xcf00,0x7000,
		0x07f8,0x1fff,0x9f80,0xe000,0x0ff0,0x0fff,0x8fc1,0xc000,
		0x3fc3,0xc7ff,0x87e3,0x8000,0x318f,0xc3ff,0xc3c7,0x0000,
		0x01ff,0x81ff,0xe18e,0x0000,0x07ff,0x83ff,0xf01c,0x0000,
		0x0e1f,0x073f,0xf838,0x0000,0x003f,0x1c00,0x1c70,0x0000,
		0x007e,0x3800,0x0ee0,0x0000,0x007e,0x6000,0x07c0,0x0000,
		0x00ff,0xc000,0x0380,0x0000,0x018f,0x0000,0x0100,0x0000,
		0x001e,0x0000,0x0000,0x0000,0x001c,0x0000,0x0000,0x0000,
		0x0010,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
		0x0000,0x0000,0x0000,0x0000,
		0x0000,0x0000,0x1000,0x0000,0x0000,0x0046,0x0100,0x0000,
		0x0000,0x0024,0x0080,0x0000,0x0000,0x1800,0x0008,0x0000,
		0x0000,0x0451,0x0890,0x0000,0x0000,0x4800,0x5c80,0x0000,
		0x0000,0x0802,0x00a1,0x0000,0x0000,0xa902,0x32d2,0x0000,
		0x0018,0x0292,0x26a4,0x8400,0x0004,0x4313,0x2660,0x8400,
		0x0009,0x519b,0x3664,0x2000,0x00c0,0x8dbd,0x76cd,0x8880,
		0x0011,0x0c9c,0x71cc,0x6080,0x0044,0x8e1c,0xf9e8,0x8800,
		0x0000,0xef3f,0xf3eb,0xc100,0x000e,0x67dc,0x1fe7,0x9a00,
		0x0117,0x07d0,0x03cf,0xb030,0x0003,0xe300,0x00be,0x6310,
		0x0003,0xfe07,0xf03e,0x6000,0x1839,0xf83f,0xfe0c,0x0740,
		0x000e,0x70fe,0x7f8c,0x3e80,0x0900,0x61ef,0xffc7,0xf800,
		0x00f2,0x63bf,0xffe3,0xf200,0x003f,0xc778,0xfff1,0xe000,
		0x208f,0xcefc,0x7ff8,0xc800,0x0007,0x8fbf,0xfff8,0x1000,
		0x23e3,0x1f7f,0xfffc,0x0000,0x0881,0x9ebf,0xfffc,0x0000,
		0x5c1f,0x37fb,0x7ffc,0x0000,0x047e,0x3ff7,0x7ffe,0x0000,
		0x23ff,0x3bef,0xfffe,0x0000,0x087f,0x2aff,0xffc6,0x4000,
		0x020b,0x2ed7,0xff80,0x4000,0x0061,0x2edf,0xff10,0x4000,
		0x47ce,0x364f,0xfe7c,0x4000,0x003e,0x37ff,0xfc7e,0x0000,
		0x1c7f,0x3fff,0xf9ff,0x2000,0x00ff,0x1fff,0xf1ff,0x1000,
		0x22fe,0x1fff,0xe7ff,0xc800,0x8001,0x8fff,0xc9ff,0xe400,
		0x013b,0x8fff,0x90ff,0xe000,0x0173,0xe7ff,0x207f,0xc000,
		0x00cf,0xe3fe,0x703f,0x0000,0x081f,0xb1fe,0xf81f,0x0000,
		0x251f,0x10fe,0x7c1c,0x0000,0x3108,0x383e,0x7e1c,0x0000,
		0x0003,0x3e0f,0x1f30,0x0000,0x0476,0x7c00,0x1fe0,0x0000,
		0x0206,0x7030,0x0fc0,0x0000,0x0008,0xc000,0x0380,0x0000,
		0x0040,0xc000,0x0300,0x0000,0x0001,0x2000,0x0000,0x0000,
		0x003b,0x0000,0x0000,0x0000,0x0180,0x0000,0x0000,0x0000,
		0x0012,0x0000,0x0000,0x0000,0x0004,0x0000,0x0000,0x0000,
		0x0010,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
		0x0000,0x0000,0x0000,0x0000},

		{0x0000,0x0000,0x0000,0x0000,0x0000,0x0022,0x0880,0x0000,
		0x0000,0x0433,0x0880,0x0000,0x0000,0x0c33,0x19c2,0x0000,
		0x0000,0x463b,0x9984,0x0000,0x0000,0x673b,0xbfcc,0x4000,
		0x0000,0x672f,0xbfdc,0x4000,0x0000,0x3fe7,0xefbc,0xc000,
		0x000c,0x3fe7,0xefff,0xc000,0x0006,0x37e7,0xe7ef,0x8600,
		0x0047,0xb7e3,0xc7cf,0x8c00,0x0073,0xf3e3,0xc79f,0xfc00,
		0x003f,0xf9e1,0x871f,0xf8c0,0x003f,0xf8e1,0x861f,0x9b80,
		0x001b,0xf860,0x041f,0x3f80,0x030c,0xf800,0x001c,0x3f00,
		0x03ec,0x381f,0xf838,0x7e00,0x01fe,0x0c7f,0xff80,0xfe38,
		0x1cff,0x01ff,0xffc0,0xfff0,0x1fff,0x03ff,0xffe1,0xfee0,
		0x0fff,0x87fc,0x1ff9,0xe1c0,0x039f,0x8fe0,0x07fd,0x0380,
		0x01c0,0x1f80,0x00fc,0x0600,0x10e0,0x3f0f,0xc0fe,0x0c00,
		0x7ff0,0x7c78,0x19fe,0x1c00,0x1ffc,0x7ce0,0x07ff,0x3000,
		0x0ffc,0x79c3,0x07ff,0xe000,0x07fe,0xfb9f,0x7fff,0xc000,
		0x7f80,0xffb8,0x1fff,0x8000,0x3c00,0xff60,0x1fff,0x8000,
		0x0f81,0xffe7,0xffff,0x8000,0x03f1,0xffdf,0xffff,0xc000,
		0x07fd,0xffff,0xffff,0xc000,0x7ffd,0xffff,0xffc7,0xc000,
		0x7ff0,0xffff,0xff83,0xc000,0x1fc0,0xffff,0xff01,0xc000,
		0x0e00,0xffff,0xfe00,0xe000,0x3c80,0xffff,0xfc00,0x7000,
		0xffff,0xffff,0xf800,0x3800,0x03fe,0x7fff,0xf000,0x1c00,
		0x01fc,0x3fff,0xe600,0x3800,0x07f8,0x3fff,0xcf00,0x7000,
		0x0fe0,0x1fff,0x9f80,0xe000,0x3fc0,0x4fff,0x8fc1,0xc000,
		0x3187,0xc7ff,0x87e3,0x8000,0x03bf,0x83ff,0xc3c7,0x0000,
		0x07ff,0x81ff,0xe18e,0x0000,0x0e1f,0x07ff,0xf01c,0x0000,
		0x003f,0x0e3f,0xf838,0x0000,0x007e,0x3800,0x1c70,0x0000,
		0x007e,0x7000,0x0ee0,0x0000,0x01ef,0xc000,0x07c0,0x0000,
		0x019f,0x8000,0x0380,0x0000,0x001e,0x0000,0x0100,0x0000,
		0x003c,0x0000,0x0000,0x0000,0x0030,0x0000,0x0000,0x0000,
		0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
		0x0000,0x0000,0x0000,0x0000,
		0x0000,0x0000,0x0000,0x0000,0x0000,0x0002,0x0880,0x0000,
		0x0000,0x0412,0x0000,0x0000,0x0000,0x0800,0x0142,0x0000,
		0x0000,0x4008,0x8000,0x0000,0x0000,0x2510,0x2440,0x4000,
		0x0000,0x0405,0x0050,0x0000,0x0000,0x0c51,0x1100,0x0000,
		0x0008,0x011b,0x1b56,0x4000,0x0000,0x1189,0xb330,0x0600,
		0x0040,0x8d99,0x3332,0x0000,0x0050,0x0ede,0x7266,0xc400,
		0x0004,0x8f5e,0x3866,0x8080,0x0020,0xc7bf,0xf8e4,0x2a00,
		0x0004,0x679e,0x79cd,0x6000,0x0003,0x93dc,0x1fc1,0x8900,
		0x0003,0x83f0,0x03ef,0x9800,0x0101,0xe300,0x00cf,0xb220,
		0x1c31,0xfa07,0xf03e,0x7000,0x119e,0x783f,0xfe0e,0x4220,
		0x0983,0x70fc,0x1f8e,0x2700,0x00dc,0x21ff,0xffc7,0xfe80,
		0x003e,0x23fe,0xfee3,0xf800,0x10bf,0xc7ef,0xcef1,0xe000,
		0x0007,0xcdf8,0x1df8,0xe400,0x11e7,0x8fff,0xfff8,0x8000,
		0x00f1,0x19fb,0x7ffc,0x8000,0x0403,0x9bff,0x7ffc,0x0000,
		0x419f,0x3fbb,0xfffc,0x0000,0x21ff,0x3fee,0x7ffe,0x0000,
		0x083f,0x3fe7,0xfffe,0x0000,0x0237,0x3fdf,0xffc6,0x4000,
		0x0041,0x3fff,0xff80,0x4000,0x47e3,0x3fff,0xff10,0x4000,
		0x001e,0x3fff,0xfe7c,0x4000,0x1c7e,0x3fff,0xfc7e,0x0000,
		0x08ff,0x3fff,0xf9ff,0x2000,0x22f7,0x1fff,0xf1ff,0x1000,
		0x8001,0x9fff,0xe7ff,0xc800,0x031b,0x8fff,0xc9ff,0xe400,
		0x0077,0x8fff,0x90ff,0xe000,0x04ef,0xc7ff,0x207f,0xc000,
		0x080f,0xe3fe,0x703f,0x0000,0x201e,0x01fe,0xf81f,0x0000,
		0x3020,0x70fe,0x7c1c,0x0000,0x0280,0x7c3e,0x7e1c,0x0000,
		0x0402,0xfc0f,0x1f30,0x0000,0x0206,0xf480,0x1fe0,0x0000,
		0x000d,0xf030,0x0fc0,0x0000,0x0001,0xc000,0x0380,0x0000,
		0x0003,0x8000,0x0300,0x0000,0x0122,0x0000,0x0000,0x0000,
		0x0014,0x8000,0x0000,0x0000,0x0002,0x0000,0x0000,0x0000,
		0x0024,0x0000,0x0000,0x0000,0x0010,0x0000,0x0000,0x0000,
		0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
		0x0000,0x0000,0x0000,0x0000},

		{0x0000,0x0000,0x8000,0x0000,0x0000,0x0011,0x0440,0x0000,
		0x0000,0x0219,0x8440,0x0000,0x0000,0x0619,0x8cc0,0x0000,
		0x0000,0x231d,0xccc2,0x0000,0x0000,0x339f,0xddc6,0x0000,
		0x0000,0x33b7,0xf7c6,0x2000,0x0006,0x3ff7,0xf7de,0x6000,
		0x0007,0x3ff3,0xf7df,0xc000,0x0003,0x93f3,0xe7f7,0xc000,
		0x0033,0xfbf3,0xe7e7,0xc700,0x003f,0xf9f1,0xc7cf,0x9e00,
		0x001f,0xf8f0,0xc78f,0xbc00,0x001f,0xf870,0x830f,0xf860,
		0x030c,0xf830,0x020f,0x9bc0,0x01e6,0x3c00,0x001f,0x1f80,
		0x01fe,0x1c1f,0xf81c,0x3f80,0x00ff,0x047f,0xff90,0x7e00,
		0x0fff,0x01ff,0xffc0,0x7ff8,0x07ff,0x83ff,0xffe0,0xfff0,
		0x03ff,0xc7f0,0x1ff9,0xfce0,0x01c1,0xcfe0,0x03fd,0xc0c0,
		0x00e0,0x1f9f,0xc0fc,0x0300,0x7ff0,0x3fff,0xf07e,0x0700,
		0x3ff8,0x7ff8,0x1c3e,0x0e00,0x0ffe,0x7fe2,0x063f,0x3800,
		0x07fe,0x7fff,0xe31f,0x3000,0x7fc0,0xfff8,0x310f,0xe000,
		0x3c00,0xfff0,0x008f,0xc000,0x0f80,0xffff,0x888f,0x8000,
		0x03e1,0xffff,0xc4ff,0x8000,0x07fd,0xffff,0xe7ff,0xc000,
		0x7ffd,0xffff,0xffff,0xc000,0x7ff1,0xffff,0xffc7,0xc000,
		0x1fc0,0xffff,0xff83,0xc000,0x0f00,0xffff,0xff01,0xc000,
		0x3c00,0xffff,0xfe00,0xe000,0xfffe,0xffff,0xfc00,0x7000,
		0x07fe,0xffff,0xf800,0x3800,0x01fc,0x7fff,0xf000,0x1c00,
		0x0ff0,0x3fff,0xe600,0x3800,0x0ff0,0x3fff,0xcf00,0x7000,
		0x3fc0,0x1fff,0x9f80,0xe000,0x7383,0xcfff,0x8fc1,0xc000,
		0x037f,0x87ff,0x87e3,0x8000,0x0fff,0x83ff,0xc3c7,0x0000,
		0x1fbf,0x03ff,0xe18e,0x0000,0x007e,0x0fff,0xf01c,0x0000,
		0x007e,0x3c3f,0xf838,0x0000,0x00fc,0x7000,0x1c70,0x0000,
		0x01fc,0xe000,0x0ee0,0x0000,0x039b,0x8000,0x07c0,0x0000,
		0x003e,0x0000,0x0380,0x0000,0x0038,0x0000,0x0100,0x0000,
		0x0070,0x0000,0x0000,0x0000,0x0040,0x0000,0x0000,0x0000,
		0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
		0x0000,0x0000,0x0000,0x0000,
		0x0000,0x0000,0x8000,0x0000,0x0000,0x0001,0x0440,0x0000,
		0x0000,0x0209,0x0000,0x0000,0x0000,0x0400,0x0080,0x0000,
		0x0000,0x0004,0x4002,0x0000,0x0000,0x108a,0x1000,0x0000,
		0x0000,0x0020,0xa200,0x0000,0x0002,0x206c,0x88d2,0x0000,
		0x0005,0x298d,0x99c3,0x0000,0x0000,0x808d,0x9992,0x0000,
		0x0010,0x2ece,0xbd30,0x0500,0x0026,0x874e,0x1d1b,0x1200,
		0x0000,0x679e,0x3cf7,0x0000,0x0016,0x73df,0x38e6,0x3060,
		0x0102,0x13df,0xfce4,0x2240,0x0023,0x83fc,0x1ff1,0xc000,
		0x0109,0xc3f0,0x03e3,0xc480,0x0091,0xf100,0x00c7,0xd800,
		0x01ce,0x7e07,0xf03f,0x39e0,0x0006,0x783f,0xfe0f,0x6010,
		0x00f0,0x70f5,0xff8f,0x0480,0x007e,0x21ff,0xfbc4,0xde00,
		0x009f,0xe39f,0xfee3,0xfc00,0x410f,0xc7ff,0xf771,0xf900,
		0x3007,0xcffb,0xdfb8,0xe200,0x08f3,0x8fe2,0x7ff8,0xe000,
		0x0600,0x1fff,0xfbfc,0x0000,0x40c7,0x9ffb,0xbf6c,0x2000,
		0x21ff,0x3ff3,0xe6fc,0x4000,0x087f,0x3fff,0xbbae,0x0000,
		0x022f,0x3fff,0xd4fe,0x0000,0x0607,0x3fff,0xf7c6,0x4000,
		0x45e3,0x3fff,0xff80,0x4000,0x03c7,0x3fff,0xff10,0x4000,
		0x183e,0x3fff,0xfe7c,0x4000,0x09fe,0x3fff,0xfc7e,0x0000,
		0x23ff,0x3fff,0xf9ff,0x2000,0x0012,0x1fff,0xf1ff,0x1000,
		0x0701,0x9fff,0xe7ff,0xc800,0x0077,0x8fff,0xc9ff,0xe400,
		0x0ec7,0x8fff,0x90ff,0xe000,0x001f,0xc7ff,0x207f,0xc000,
		0x201f,0xa3fe,0x703f,0x0000,0x523a,0x21fe,0xf81f,0x0000,
		0x0020,0x70fe,0x7c1c,0x0000,0x0802,0xf83e,0x7e1c,0x0000,
		0x13ac,0xf80f,0x1f30,0x0000,0x004d,0xf180,0x1fe0,0x0000,
		0x0001,0xe030,0x0fc0,0x0000,0x0083,0x0000,0x0380,0x0000,
		0x0116,0x2000,0x0300,0x0000,0x0200,0x8000,0x0000,0x0000,
		0x0022,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
		0x0050,0x0000,0x0000,0x0000,0x0040,0x0000,0x0000,0x0000,
		0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
		0x0000,0x0000,0x0000,0x0000},

		{0x0000,0x0008,0x0000,0x0000,0x0000,0x0008,0x8200,0x0000,
		0x0000,0x030c,0xc220,0x0000,0x0000,0x138c,0xc660,0x0000,
		0x0000,0x11ce,0xee61,0x8000,0x0000,0x199f,0xeee3,0x0000,
		0x0002,0x1ddf,0xffe3,0x0000,0x0003,0x1ffb,0xfbef,0x3000,
		0x0001,0xdbfb,0xf3ef,0x7000,0x0031,0xd9f9,0xf3ff,0xe000,
		0x001d,0xf8f9,0xe3f7,0xe100,0x001f,0xfcf8,0xe3e7,0xc700,
		0x000f,0xfc70,0xe3cf,0xde00,0x030c,0xfc30,0xc38f,0xfe20,
		0x01c6,0x7c30,0x030f,0xece0,0x00fb,0x1e00,0x000f,0x9fc0,
		0x00ff,0x0e1f,0xf80f,0x1fc0,0x0e3f,0x807f,0xff98,0x3f80,
		0x07ff,0x81ff,0xffc0,0x7f08,0x03bf,0xc3ff,0xffe0,0x7ffc,
		0x01c3,0xc7ff,0x87f8,0xfff0,0x00e0,0xcfff,0xe3fd,0xfc60,
		0x3ff0,0x1fff,0xf8fc,0x01c0,0x1ff8,0x3fff,0x7c7e,0x0380,
		0x0ffc,0x7fff,0x8e3e,0x0700,0x03fe,0x7fff,0xe31f,0x1c00,
		0x7ffe,0x7fff,0xf31f,0x3800,0x3c00,0xffff,0x118f,0xf000,
		0x0f00,0xffff,0x8c8f,0xe000,0x03c0,0xffff,0xc48f,0x8000,
		0x07f1,0xffff,0xe447,0x8000,0x7ffd,0xffff,0xe47f,0xc000,
		0x7ff9,0xffff,0xe07f,0xc000,0x1fe1,0xffff,0xe4c7,0xc000,
		0x0f00,0xffff,0xfd83,0xc000,0x7c00,0xffff,0xff01,0xc000,
		0xffd0,0xffff,0xfe00,0xe000,0xdffe,0xffff,0xfc00,0x7000,
		0x01fc,0x7fff,0xf800,0x3800,0x07f8,0x7fff,0xf000,0x1c00,
		0x0ff0,0x3fff,0xe600,0x3800,0x3fc0,0x3fff,0xcf00,0x7000,
		0x77c1,0x9fff,0x9f80,0xe000,0x033f,0x8fff,0x8fc1,0xc000,
		0x07ff,0x07ff,0x87e3,0x8000,0x1fff,0x03ff,0xc3c7,0x0000,
		0x003e,0x07ff,0xe18e,0x0000,0x007e,0x1eff,0xf01c,0x0000,
		0x00fc,0x781f,0xf838,0x0000,0x01f8,0xe000,0x1c70,0x0000,
		0x07fb,0x8000,0x0ee0,0x0000,0x023e,0x0000,0x07c0,0x0000,
		0x007c,0x0000,0x0380,0x0000,0x0070,0x0000,0x0100,0x0000,
		0x0040,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
		0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
		0x0000,0x0000,0x0000,0x0000,
		0x0000,0x0008,0x0000,0x0000,0x0000,0x0000,0x8200,0x0000,
		0x0000,0x0200,0x8000,0x0000,0x0000,0x1280,0x0440,0x0000,
		0x0000,0x0042,0x2801,0x8000,0x0000,0x0811,0x2002,0x0000,
		0x0002,0x1414,0x3500,0x0000,0x0001,0x1206,0xc429,0x2000,
		0x0000,0xd0ce,0xc4a1,0x1000,0x0030,0x1066,0xcda5,0x0000,
		0x0005,0x126e,0xcd8c,0x2100,0x0011,0x232e,0x5dbd,0x8500,
		0x0000,0x330f,0x3dbb,0x5000,0x0300,0x1bcf,0xbcfb,0x4220,
		0x0103,0x1be7,0xbef2,0x30e0,0x0009,0xe3fc,0x1df2,0xe000,
		0x0091,0xf9f0,0x03e1,0xe040,0x080e,0xf900,0x00e3,0xc480,
		0x000f,0x7e07,0xf02f,0xd908,0x0200,0x383f,0xfe0f,0x39c0,
		0x0072,0x10ff,0x978f,0x0000,0x009f,0xe1ff,0xffc6,0x0d00,
		0x059f,0xe3ff,0xffe3,0x7e40,0x1007,0xc7ff,0x7ff1,0xfc80,
		0x08f3,0xcfff,0xaff8,0xf100,0x0200,0x8fff,0xfbf8,0xf000,
		0x4003,0x1fff,0xff7c,0xe800,0x27ff,0x1fff,0x57ec,0x0000,
		0x097f,0x3fff,0xbfbc,0x2000,0x003f,0x3fff,0xf7be,0x0000,
		0x0607,0x3fff,0xff76,0x0000,0x68e1,0x3fff,0xfd46,0x4000,
		0x03c3,0x3fff,0xf900,0x4000,0x100f,0x3fff,0xff10,0x4000,
		0x087e,0x3fff,0xfc7c,0x4000,0x61fe,0x3fff,0xfc7e,0x0000,
		0x0053,0x3fff,0xf9ff,0x2000,0xde01,0x1fff,0xf1ff,0x1000,
		0x0171,0x1fff,0xe7ff,0xc800,0x04e7,0x8fff,0xc9ff,0xe400,
		0x018f,0x8fff,0x90ff,0xe000,0x201f,0xe7ff,0x207f,0xc000,
		0x767d,0x03fe,0x703f,0x0000,0x0078,0x71fe,0xf81f,0x0000,
		0x0000,0x70fe,0x7c1c,0x0000,0x01ec,0xf83e,0x7e1c,0x0000,
		0x0009,0xf00f,0x1f30,0x0000,0x0013,0xe280,0x1fe0,0x0000,
		0x0001,0x0010,0x0fc0,0x0000,0x0022,0x2000,0x0380,0x0000,
		0x04e8,0x8000,0x0300,0x0000,0x0202,0x0000,0x0000,0x0000,
		0x0044,0x0000,0x0000,0x0000,0x0010,0x0000,0x0000,0x0000,
		0x0040,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
		0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
		0x0000,0x0000,0x0000,0x0000},

		{0x0000,0x0004,0x0000,0x0000,0x0000,0x0004,0x6100,0x0000,
		0x0000,0x0186,0x6300,0x0000,0x0000,0x08c6,0x6330,0x0000,
		0x0000,0x18c6,0xe730,0x0000,0x0000,0x0cef,0xe771,0x8000,
		0x0001,0x0eed,0xeff1,0x8000,0x0001,0x8ff9,0xfdf7,0x8800,
		0x0011,0xedfd,0xf9f7,0xb800,0x001c,0xecf8,0xf9ff,0x7000,
		0x000e,0xfcf8,0xf1fb,0xf000,0x000f,0xfc78,0xf1f3,0xe180,
		0x0106,0xfe38,0x61e7,0xe700,0x01c6,0x7e18,0x41c7,0xff00,
		0x00fb,0x3e18,0x0187,0xfe10,0x007f,0x0e00,0x010f,0xece0,
		0x063f,0x861f,0xf80f,0x8fe0,0x07ff,0x807f,0xff8c,0x1fc0,
		0x03ff,0xc1ff,0xffc8,0x3f80,0x01c7,0xe3ff,0xffe0,0x7f04,
		0x00e0,0xe7ff,0xfff8,0x7ffc,0x3af0,0x0fff,0xfffc,0xfff0,
		0x1ff8,0x1fff,0xfffc,0xc0e0,0x0ffc,0x3fff,0xff7e,0x01c0,
		0x03fe,0x7fff,0xff3e,0x0380,0x3fff,0x7fff,0xfb9f,0x0600,
		0x3c00,0x7fff,0xfd8f,0x1c00,0x0e00,0xffff,0xeccf,0xb800,
		0x03c0,0xffff,0xeccf,0xf000,0x01f0,0xffff,0xe647,0xe000,
		0x7ffd,0xffff,0xe247,0xc000,0x7ffd,0xffff,0xf27f,0xc000,
		0x1ff1,0xffff,0xe27f,0xc000,0x0781,0xffff,0xe4c7,0xc000,
		0x3c00,0xffff,0xc583,0xc000,0xfd00,0xffff,0xc701,0xc000,
		0x5ffe,0xffff,0xfe00,0xe000,0x03fe,0xffff,0xfc00,0x7000,
		0x03f8,0x7fff,0xf800,0x3800,0x0ff0,0x7fff,0xf000,0x1c00,
		0x7fe0,0x3fff,0xe600,0x3800,0xf780,0x3fff,0xcf00,0x7000,
		0x0307,0x9fff,0x9f80,0xe000,0x0fff,0x8fff,0x8fc1,0xc000,
		0x3fff,0x07ff,0x87e3,0x8000,0x307e,0x07ff,0xc3c7,0x0000,
		0x00fc,0x1fff,0xe18e,0x0000,0x01fc,0x7cff,0xf01c,0x0000,
		0x01f8,0xf01f,0xf838,0x0000,0x07f3,0xc000,0x1c70,0x0000,
		0x063f,0x0000,0x0ee0,0x0000,0x007c,0x0000,0x07c0,0x0000,
		0x00f0,0x0000,0x0380,0x0000,0x00c0,0x0000,0x0100,0x0000,
		0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
		0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
		0x0000,0x0000,0x0000,0x0000,
		0x0000,0x0004,0x0000,0x0000,0x0000,0x0000,0x6100,0x0000,
		0x0000,0x0100,0x2300,0x0000,0x0000,0x0840,0x2220,0x0000,
		0x0000,0x1000,0x8400,0x0000,0x0000,0x0029,0x0001,0x8000,
		0x0000,0x0208,0x0a80,0x8000,0x0001,0x0852,0x4014,0x8000,
		0x0011,0x2266,0xc450,0xa800,0x0014,0x0a63,0x66d2,0x4000,
		0x0002,0x2333,0x64c6,0x1000,0x0008,0x31e7,0x9e9c,0x0180,
		0x0100,0x3b87,0x1c9d,0xa400,0x0105,0x19cf,0x9e79,0xb100,
		0x0008,0xe1f7,0xbefb,0x0a10,0x0000,0x71f8,0x1ffb,0x38a0,
		0x000c,0xfcf0,0x03f8,0xe560,0x0447,0x7f00,0x00e1,0xeac0,
		0x0243,0xfc07,0xf03b,0xc780,0x0120,0x383f,0xfe0f,0xde04,
		0x009e,0x90ff,0xff8f,0x7d54,0x02cf,0xe1ff,0xffc6,0xaaa0,
		0x000f,0xe3ff,0xffe1,0x4fc0,0x08f3,0xc7ff,0xff71,0x5580,
		0x027b,0xcfff,0xff78,0xfd80,0x0000,0x8fff,0xfbb8,0x5200,
		0x0017,0x1fff,0xfdac,0xf400,0x08ff,0x9fff,0xeefc,0xa800,
		0x007f,0x3fff,0xeddc,0x5000,0x001f,0x3fff,0xef56,0x6000,
		0x6867,0x3fff,0xebd6,0x4000,0x07e1,0x3fff,0xfb46,0x4000,
		0x100f,0x3fff,0xeb80,0x4000,0x04bf,0x3fff,0xfd10,0x4000,
		0x25fe,0x3fff,0xdc7c,0x4000,0x853e,0x3fff,0xf47e,0x0000,
		0x5801,0x3fff,0xf9ff,0x2000,0x0233,0x9fff,0xf1ff,0x1000,
		0x00e3,0x1fff,0xe7ff,0xc800,0x03df,0x8fff,0xc9ff,0xe400,
		0x601f,0x8fff,0x90ff,0xe000,0x963f,0xc7ff,0x207f,0xc000,
		0x0020,0x63fe,0x703f,0x0000,0x0800,0xf1fe,0xf81f,0x0000,
		0x200d,0xf0fe,0x7c1c,0x0000,0x3059,0xfc3e,0x7e1c,0x0000,
		0x0099,0xf00f,0x1f30,0x0000,0x0107,0xc480,0x1fe0,0x0000,
		0x0007,0x1010,0x0fc0,0x0000,0x05e2,0x4000,0x0380,0x0000,
		0x0600,0x0000,0x0300,0x0000,0x0004,0x0000,0x0000,0x0000,
		0x0090,0x0000,0x0000,0x0000,0x00c0,0x0000,0x0000,0x0000,
		0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
		0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
		0x0000,0x0000,0x0000,0x0000},

		{0x0000,0x0002,0x1000,0x0000,0x0000,0x00c2,0x2080,0x0000,
		0x0000,0x00c3,0x3088,0x0000,0x0000,0x0463,0x3198,0x0000,
		0x0000,0x0c77,0x7398,0x0000,0x0001,0x8677,0xf3b8,0x4000,
		0x0000,0xc777,0xf7b8,0xc000,0x0000,0xc7fc,0xfef9,0xc000,
		0x000c,0xf6fc,0xfdf3,0x8c00,0x000e,0x7efc,0xf9f7,0xb800,
		0x0007,0xfe7c,0x79fd,0xf800,0x0007,0xfe3c,0x71f9,0xf000,
		0x00c2,0x7e18,0x31f3,0xf080,0x007f,0x3e18,0x21e3,0xe780,
		0x007f,0x8f08,0x21c7,0xff00,0x073f,0x8700,0x0107,0xf610,
		0x03ff,0x831f,0xf807,0xe6e0,0x01ff,0xc07f,0xff8f,0x0fe0,
		0x01df,0xe1ff,0xffcc,0x1fc0,0x00e1,0xe3ff,0xffe0,0x3580,
		0x3e30,0x27ff,0xfff8,0x6b06,0x1ff8,0x0fff,0xfffc,0x5ffe,
		0x07f8,0x1fff,0xfffc,0x7e38,0x03fe,0x3fff,0xfffe,0x0070,
		0x3fff,0x7fff,0xfffe,0x01c0,0x3d00,0x7fff,0xffff,0x0380,
		0x0e00,0x7fff,0xffff,0x0e00,0x0380,0xffff,0xffff,0xbc00,
		0x01e0,0xffff,0xffff,0xf000,0x5ff8,0xffff,0xfff7,0xe000,
		0x7ffd,0xffff,0xff77,0xc000,0x1ff9,0xffff,0xfb7f,0xc000,
		0x0781,0xffff,0xf37f,0xc000,0x3e01,0xffff,0xf3c7,0xc000,
		0xfd00,0xffff,0xe383,0xc000,0x5ff8,0xffff,0x0701,0xc000,
		0x01fe,0xffff,0x0e00,0xe000,0x03fc,0xffff,0x3c00,0x7000,
		0x0ff0,0x7fff,0x9800,0x3800,0x3fe0,0x7fff,0x3000,0x1c00,
		0x7fc0,0x3fff,0x6600,0x3800,0x0301,0xbfff,0xcf00,0x7000,
		0x0eff,0x1fff,0x9f80,0xe000,0x1fff,0x0fff,0x8fc1,0xc000,
		0x107e,0x07ff,0x87e3,0x8000,0x00fc,0x07ff,0xc3c7,0x0000,
		0x01fc,0x3fff,0xe18e,0x0000,0x03f8,0xf8ff,0xf01c,0x0000,
		0x07f1,0xc01f,0xf838,0x0000,0x066f,0x8000,0x1c70,0x0000,
		0x007c,0x0000,0x0ee0,0x0000,0x00f0,0x0000,0x07c0,0x0000,
		0x01c0,0x0000,0x0380,0x0000,0x0000,0x0000,0x0100,0x0000,
		0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
		0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
		0x0000,0x0000,0x0000,0x0000,
		0x0000,0x0002,0x1000,0x0000,0x0000,0x00c0,0x2080,0x0000,
		0x0000,0x0081,0x0088,0x0000,0x0000,0x0020,0x1110,0x0000,
		0x0000,0x0814,0x4280,0x0000,0x0001,0x8010,0x8020,0x4000,
		0x0000,0x4121,0x0580,0x4000,0x0000,0x0228,0x2008,0x4000,
		0x0004,0x9231,0x6300,0x0c00,0x0008,0x29b1,0x3360,0x2000,
		0x0000,0x91d3,0x2660,0x4800,0x0004,0x19d7,0xa744,0x0000,
		0x0000,0x1cc3,0x8e4c,0x4000,0x000e,0x64f3,0xde3d,0xc080,
		0x0042,0xe1fb,0xdf7d,0x9000,0x0508,0x79fc,0x1e7d,0x0810,
		0x0066,0x3ef0,0x03fb,0x30e0,0x0063,0xbf00,0x00f8,0x73e0,
		0x0110,0xbe07,0xf037,0xe7c0,0x009d,0x183f,0xfe0f,0xc580,
		0x260f,0x30ff,0xff8f,0xcb06,0x1007,0xe1ff,0xffc7,0x1ffe,
		0x00d3,0xe3ff,0xffe3,0x7e38,0x0279,0xc7ff,0xfff0,0x5570,
		0x1400,0xcfff,0xfff8,0xabc0,0x0100,0x8fff,0xfff8,0x5780,
		0x00ff,0x1fff,0xfffc,0xae00,0x003f,0x9fff,0xfffc,0xfc00,
		0x000f,0x3fff,0xfffc,0x7000,0x480b,0x3fff,0xfff6,0x6000,
		0x03e1,0x3fff,0xff76,0x4000,0x108f,0x3fff,0xfbc6,0x4000,
		0x041f,0x3fff,0xff80,0x4000,0x20ff,0x3fff,0xff10,0x4000,
		0x057e,0x3fff,0xfa7c,0x4000,0x5038,0x3fff,0x747e,0x0000,
		0x0101,0x3fff,0xe9ff,0x2000,0x0077,0x9fff,0x31ff,0x1000,
		0x01cf,0x1fff,0x87ff,0xc800,0x002f,0x8fff,0x89ff,0xe400,
		0x7c7f,0x8fff,0x10ff,0xe000,0x00f1,0xc7ff,0x207f,0xc000,
		0x0000,0x63fe,0x703f,0x0000,0x0000,0xe1fe,0xf81f,0x0000,
		0x1059,0xf0fe,0x7c1c,0x0000,0x0031,0xf03e,0x7e1c,0x0000,
		0x0107,0xe20f,0x1f30,0x0000,0x0207,0x0880,0x1fe0,0x0000,
		0x00e4,0x0010,0x0fc0,0x0000,0x0640,0x8000,0x0380,0x0000,
		0x0004,0x0000,0x0300,0x0000,0x0010,0x0000,0x0000,0x0000,
		0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
		0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
		0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
		0x0000,0x0000,0x0000,0x0000},

		{0x0000,0x0001,0x0800,0x0000,0x0000,0x0061,0x1800,0x0000,
		0x0000,0x0461,0x9840,0x0000,0x0000,0x0671,0xb8c4,0x0000,
		0x0000,0x0373,0xb9cc,0x0000,0x0000,0xc77b,0xb9dc,0x0000,
		0x0000,0x63fa,0xfbdc,0x6000,0x0004,0x76fe,0x7ffc,0xe000,
		0x0006,0x7b7e,0x7ef9,0xc000,0x0007,0xbf7e,0x7cfb,0xcc00,
		0x0003,0xff3e,0x7cff,0xdc00,0x0043,0xff1c,0x38fc,0xfc00,
		0x007b,0x3f1c,0x30f9,0xf800,0x003d,0x8f0c,0x30f3,0xf1c0,
		0x073f,0x8700,0x00c3,0xff80,0x03df,0xc300,0x0083,0xff00,
		0x01ff,0xc11f,0xf803,0xf208,0x00df,0xe07f,0xff87,0x8750,
		0x00e3,0xe1ff,0xffcf,0x0eb0,0x1c30,0x63ff,0xffe0,0x1c40,
		0x1ff8,0x07ff,0xfff8,0x3a80,0x07fc,0x0fff,0xfffc,0x2516,
		0x03fe,0x1fff,0xfffc,0x6aa8,0x3ffe,0x3fff,0xfffe,0xf018,
		0x3fff,0xffff,0xfffe,0x00b0,0x0e00,0x7fff,0xffff,0x0140,
		0x0780,0x7fff,0xffff,0x0280,0x01e0,0xffff,0xffff,0x8600,
		0x3ff0,0xffff,0xffff,0xac00,0x7ffc,0xffff,0xffff,0xf000,
		0x1ffc,0xffff,0xffff,0xc000,0x07e1,0xffff,0xffff,0xc000,
		0x3e01,0xffff,0xffff,0xc000,0xf801,0xffff,0xffc7,0xc000,
		0x1fc1,0xffff,0xf383,0xc000,0x03fc,0xfffc,0x0701,0xc000,
		0x03fc,0xfffc,0x0e00,0xe000,0x1ff8,0xfffe,0x3c00,0x7000,
		0x3fe0,0x7fe0,0xf800,0x3800,0xff80,0x7ff0,0x3000,0x1c00,
		0x0700,0x7fc8,0xe600,0x3800,0x0eff,0xbf83,0xcf00,0x7000,
		0x3ffe,0x1f81,0x9f80,0xe000,0x3cfe,0x0fe1,0x8fc1,0xc000,
		0x00be,0x0fff,0x87e3,0x8000,0x01f8,0x1fff,0xc3c7,0x0000,
		0x03f8,0x7dff,0xe18e,0x0000,0x0ff1,0xf0ff,0xf01c,0x0000,
		0x0e67,0x801f,0xf838,0x0000,0x00fc,0x0000,0x1c70,0x0000,
		0x01f8,0x0000,0x0ee0,0x0000,0x03c0,0x0000,0x07c0,0x0000,
		0x0200,0x0000,0x0380,0x0000,0x0000,0x0000,0x0100,0x0000,
		0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
		0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
		0x0000,0x0000,0x0000,0x0000,
		0x0000,0x0001,0x0800,0x0000,0x0000,0x0060,0x1800,0x0000,
		0x0000,0x0440,0x8040,0x0000,0x0000,0x0450,0x2840,0x0000,
		0x0000,0x0142,0x2940,0x0000,0x0000,0x8449,0x0054,0x0000,
		0x0000,0x0000,0x9244,0x6000,0x0004,0x1411,0x1104,0xa000,
		0x0000,0x0919,0x3101,0x0000,0x0004,0x9599,0xb130,0x0800,
		0x0000,0x09db,0xd761,0x4000,0x0000,0x8ce1,0xd362,0x0400,
		0x004a,0xcee3,0xc766,0x0800,0x0000,0x6ef3,0xef5e,0xc140,
		0x0720,0x3073,0xcf1c,0xdc00,0x0247,0x3e78,0x1f3d,0x8000,
		0x0003,0xbe70,0x03fd,0x8800,0x0010,0xbf00,0x00fc,0x3350,
		0x008a,0x5e07,0xf039,0x72b0,0x000f,0x083f,0xfe0f,0xe040,
		0x1007,0xc0ff,0xff8f,0xea80,0x0407,0xe1ff,0xffc7,0x8516,
		0x0279,0xe3ff,0xffe3,0x2aa8,0x2400,0xc7ff,0xfff1,0xf098,
		0x2100,0xcfff,0xfff8,0x00b0,0x00ff,0x8fff,0xfff8,0x5540,
		0x047f,0x1fff,0xfffc,0x0280,0x003f,0x9fff,0xfffc,0xc600,
		0x3807,0x3fff,0xfffc,0x2c00,0x03e0,0x3fff,0xfffe,0x7000,
		0x1046,0x3fff,0xfffe,0x0000,0x042f,0x3fff,0xffc6,0x4000,
		0x20ff,0x3fff,0xff80,0x4000,0x82ff,0x3fff,0xff10,0x4000,
		0x104f,0x3fff,0xf27c,0x4000,0x0200,0x3fff,0x1c7e,0x0000,
		0x0073,0x3fff,0xe9ff,0x2000,0x11ef,0x9ffe,0x31ff,0x1000,
		0x201f,0x1fec,0xe7ff,0xc800,0x9c3f,0x8fff,0x89ff,0xe400,
		0x047e,0xcfe8,0x90ff,0xe000,0x08f0,0x47b3,0x207f,0xc000,
		0x2000,0xe3be,0x703f,0x0000,0x3cf9,0xe1ec,0xf81f,0x0000,
		0x00b3,0xf8fe,0x7c1c,0x0000,0x0063,0xd43e,0x7e1c,0x0000,
		0x0207,0x450f,0x1f30,0x0000,0x081c,0x3080,0x1fe0,0x0000,
		0x0610,0x0010,0x0fc0,0x0000,0x0024,0x0000,0x0380,0x0000,
		0x0008,0x0000,0x0300,0x0000,0x0240,0x0000,0x0000,0x0000,
		0x0200,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
		0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
		0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
		0x0000,0x0000,0x0000,0x0000}};

image_data images[image_count]={
	{71,67,4,335,jon_data,jon_palette},
	{70,67,4,335,greg_data,greg_palette},
	{70,67,4,330,andrew_data,andrew_palette},
	{50,67,3,268,ben_data,ben_palette},
	{70,67,4,335,dave_data,dave_palette},
	{70,67,3,335,leo_data,leo_palette},
	{70,67,4,335,thomas_data,thomas_palette},
	{70,67,4,335,trevor_data,trevor_palette},
	{70,67,4,335,john_data,john_palette},
	{70,67,4,335,bill_data,bill_palette},
	{70,67,4,335,harv_data,harv_palette},
	{70,67,4,335,ash_data,ash_palette},
	{70,67,4,335,frederic_data,frederic_palette},
	{70,67,4,335,martin_data,martin_palette},
	{70,67,4,335,coopers_data,coopers_palette},
	{70,67,4,335,juggler_data,juggler_palette},
	{70,67,4,335,tick_data,tick_palette}};

unsigned char about_message[]=
	{0xBC,0x97,0x8E,0x9B,0x9D,0x8C,0x91,0x8E,0x87,0xE0,0xB1,0x90,0x8B,0x8D,0xE0,0xCB,
	0xE0,0x89,0x9F,0x8D,0xE0,0x89,0x8E,0x97,0x8C,0x8C,0x9B,0x92,0xE0,0x9E,0x87,0xE0,
	0xB6,0x91,0x92,0x9F,0x8C,0x98,0x9F,0x92,0xE0,0xB0,0x91,0x8C,0x8C,0x9B,0x8E,0xD4,
	0xE0,0x9F,0x92,0x9C,0xE0,0x9C,0x9B,0x8D,0x97,0x99,0x92,0x9B,0x9C,0xE0,0x9E,0x87,
	0xE0,0xB6,0x91,0x92,0x9F,0x8C,0x98,0x9F,0x92,0xE0,0xB0,0x91,0x8C,0x8C,0x9B,0x8E,
	0xE0,0x9F,0x92,0x9C,0xE0,0xB9,0x8E,0x9B,0x99,0xE0,0xB0,0x9B,0x8E,0x8E,0x87,0xD2,
	0xE0,0xAC,0x98,0x9B,0xE0,0xB1,0x90,0x8B,0x8D,0xBA,0xAC,0xB0,0xE0,0x9F,0x92,0x9C,
	0xE0,0xBF,0xBA,0xBD,0xE0,0x93,0x91,0x9C,0x8B,0x94,0x9B,0x8D,0xE0,0x89,0x9B,0x8E,
	0x9B,0xE0,0x89,0x8E,0x97,0x8C,0x8C,0x9B,0x92,0xE0,0x9E,0x87,0xE0,0xBF,0x92,0x9C,
	0x8E,0x9B,0x89,0xE0,0xBC,0x8B,0x92,0x9E,0x9F,0x8E,0xD2,0xE0,0xDB,0x8D,0xAC,0x98,
	0x97,0x8D,0xE0,0x90,0x8E,0x91,0x9C,0x8B,0x9D,0x8C,0xE0,0x97,0x8D,0xE0,0x8C,0x98,
	0x9B,0xE0,0x9D,0x8B,0x94,0x93,0x97,0x92,0x9F,0x8C,0x97,0x91,0x92,0xE0,0x91,0x9A,
	0xE0,0x9B,0x97,0x99,0x98,0x8C,0xE0,0x87,0x9B,0x9F,0x8E,0x8D,0xE0,0x91,0x9A,0xE0,
	0x9C,0x9B,0x8A,0x9B,0x94,0x91,0x90,0x93,0x9B,0x92,0x8C,0xD4,0xE0,0x9F,0x92,0x9C,
	0xE0,0x89,0x91,0x8B,0x94,0x9C,0xE0,0x98,0x9F,0x8A,0x9B,0xE0,0x9E,0x9B,0x9B,0x92,
	0xE0,0x97,0x93,0x90,0x91,0x8D,0x8D,0x97,0x9E,0x94,0x9B,0xE0,0x89,0x97,0x8C,0x98,
	0x91,0x8B,0x8C,0xE0,0x8C,0x98,0x9B,0xE0,0x9F,0x8D,0x8D,0x97,0x8D,0x8C,0x9F,0x92,
	0x9D,0x9B,0xD4,0xE0,0x9E,0x91,0x8C,0x98,0xE0,0x9D,0x8B,0x8E,0x8E,0x9B,0x92,0x8C,
	0x94,0x87,0xE0,0x9F,0x92,0x9C,0xE0,0x90,0x8E,0x9B,0x8A,0x97,0x91,0x8B,0x8D,0x94,
	0x87,0xD4,0xE0,0x91,0x9A,0xE0,0x8C,0x98,0x9B,0xE0,0x9A,0x91,0x94,0x94,0x91,0x89,
	0x97,0x92,0x99,0xE0,0x90,0x9B,0x91,0x90,0x94,0x9B,0xC6,0xF6,0xF6,0xB3,0x9F,0x8E,
	0x95,0xE0,0xBF,0x94,0x94,0x9B,0x92,0xF6,0xB0,0x97,0x92,0x91,0xE0,0xBF,0x94,0x9E,
	0x9B,0x8E,0x8C,0x97,0xF6,0xB3,0x97,0x95,0x9B,0xE0,0xBE,0x9F,0x97,0x94,0x9B,0x87,
	0xF6,0xB3,0x9F,0x8C,0xE0,0xBE,0x9B,0x8C,0x8C,0x97,0x92,0x8D,0x91,0x92,0xF6,0xB2,
	0x9B,0x97,0x94,0xE0,0xBE,0x91,0x8C,0x98,0x89,0x97,0x9D,0x95,0xF6,0xBF,0x92,0x9C,
	0x8E,0x9B,0x89,0xE0,0xBE,0x8E,0x91,0x89,0x92,0xF6,0xAC,0x91,0x92,0x87,0xE0,0xBD,
	0x9F,0x8E,0x93,0x91,0x9C,0x87,0xF6,0xBB,0x9C,0x9C,0x97,0x9B,0xE0,0xBD,0x98,0x8B,
	0x8E,0x9D,0x98,0x97,0x94,0x94,0xF6,0xBC,0x9F,0x8A,0x9B,0xE0,0xBD,0x94,0x9F,0x8E,
	0x95,0x9B,0xF6,0xAD,0x98,0x9F,0x8B,0x92,0xE0,0xBD,0x91,0x8D,0x99,0x8E,0x91,0x8A,
	0x9B,0xF6,0xB6,0x91,0x98,0x92,0xE0,0xBD,0x91,0x8B,0x8D,0x97,0x92,0x8D,0xF6,0xB4,
	0x9B,0x91,0xE0,0xBC,0x9F,0x8A,0x97,0x9C,0x8D,0x91,0x92,0xF6,0xAE,0x91,0x8D,0x8D,
	0xE0,0xBC,0x9B,0x94,0x9F,0x9A,0x91,0x8E,0x9D,0x9B,0xF6,0xAC,0x9F,0x92,0x97,0x9F,
	0xE0,0xBC,0x9B,0x92,0x92,0x97,0x8D,0xF6,0xBF,0x92,0x9C,0x8E,0x9B,0x89,0xE0,0xBC,
	0x8B,0x92,0x9E,0x9F,0x8E,0xF6,0xB3,0x9F,0x8B,0x8E,0x97,0x86,0x97,0x91,0xE0,0xBA,
	0x9F,0x9E,0x97,0x9F,0x92,0x97,0xF6,0xB6,0x91,0x8D,0x98,0xE0,0xBA,0x9F,0x97,0x8E,
	0x94,0x97,0x9B,0xF6,0xBD,0x9F,0x8D,0x98,0xE0,0xBA,0x91,0x94,0x9B,0x87,0xF6,0xBC,
	0x9F,0x8A,0x9B,0xE0,0xBA,0x8E,0x9B,0x9B,0x93,0x9F,0x92,0xF6,0xB9,0x9B,0x91,0x8E,
	0x99,0x9B,0xE0,0xB9,0x8E,0x9F,0x98,0x9F,0x93,0xF6,0xAC,0x8E,0x91,0x9B,0x94,0x8D,
	0xE0,0xA9,0x9F,0x94,0x8D,0x8C,0x9B,0x9C,0xE0,0xB8,0x9F,0x92,0x8D,0x9B,0x92,0xF6,
	0xAD,0x9B,0x8C,0x98,0xE0,0xB8,0x9F,0x8E,0x93,0x91,0x92,0xF6,0xB6,0x91,0x98,0x92,
	0xE0,0xB8,0x9B,0x92,0x9C,0x8E,0x97,0x95,0x88,0xF6,0xB5,0x9B,0x9B,0x8D,0xE0,0xB8,
	0x8B,0x97,0x86,0x9B,0x8E,0xF6,0xB6,0x97,0x93,0xE0,0xB8,0x8B,0x94,0x8D,0xF6,0xB8,
	0x9B,0x94,0x93,0x8B,0x8C,0xE0,0xB8,0x8B,0x93,0x93,0x9B,0x94,0xF6,0xB0,0x9B,0x8C,
	0x9B,0x8E,0xE0,0xB6,0x9F,0x9D,0x95,0x8D,0x91,0x92,0xF6,0xBF,0x9C,0x8E,0x97,0x9F,
	0x92,0xE0,0xB6,0x91,0x92,0x9B,0x8D,0xF6,0xB8,0x9F,0x8E,0x8A,0x9B,0x87,0xE0,0xB4,
	0x9F,0x8D,0x9B,0x8E,0xF6,0xB3,0x97,0x95,0x9B,0xE0,0xB4,0x9F,0x8C,0x97,0x92,0x91,
	0x8A,0x97,0x9D,0x98,0xF6,0xBF,0x92,0x9C,0x87,0xE0,0xB4,0x9B,0x9F,0x92,0x97,0x92,
	0x99,0xF6,0xB6,0x91,0x98,0x92,0xE0,0xB4,0x91,0x89,0x9B,0x8E,0x87,0xF6,0xB4,0x9B,
	0x97,0x99,0x98,0xE0,0xB3,0x9F,0x94,0x90,0x9F,0x8D,0xF6,0xAC,0x97,0x93,0xE0,0xB3,
	0x9F,0x8E,0x8C,0x97,0x92,0xF6,0xAE,0x91,0x8D,0x8D,0xE0,0xB3,0x91,0x94,0x9C,0x9B,
	0x92,0xF6,0xAC,0x8E,0x9B,0x8A,0x91,0x8E,0xE0,0xB3,0x91,0x8E,0x8E,0x97,0x8D,0xF6,
	0xBC,0x97,0x9B,0x8C,0x9B,0x8E,0xE0,0xB3,0x8B,0x94,0x94,0x9B,0x8E,0xF6,0xB3,0x9F,
	0x8E,0x8C,0x97,0x92,0xE0,0xB3,0x8B,0x8E,0x8E,0x9F,0x87,0xF6,0xBE,0x9F,0x8E,0x9E,
	0x9F,0x8E,0x9F,0xE0,0xB2,0x9F,0x9E,0x97,0x94,0x9B,0x95,0xF6,0xBE,0x97,0x94,0x94,
	0xE0,0xB2,0x9B,0x9F,0x8E,0xF6,0xB6,0x97,0x93,0xE0,0xB1,0xD9,0xBA,0x94,0x9F,0x98,
	0x9B,0x8E,0x8C,0x87,0xD4,0xE0,0xB6,0x8E,0xD2,0xF6,0xAD,0x8C,0x9B,0x9A,0x9F,0x92,
	0xE0,0xB1,0x8D,0x8D,0x91,0x89,0x8D,0x95,0x97,0xF6,0xBE,0x8E,0x91,0x92,0x89,0x87,
	0x92,0xE0,0xB0,0x9B,0x8E,0x8E,0x87,0xF6,0xB3,0x97,0x9D,0x98,0x9F,0x9B,0x94,0xE0,
	0xB0,0x91,0x8E,0x8C,0x93,0x9F,0x92,0x92,0xF6,0xBD,0x9F,0x8E,0x91,0x94,0xE0,0xB0,
	0x91,0x8C,0x8C,0x9B,0x8E,0xF6,0xBB,0x93,0x97,0x94,0x87,0xE0,0xB0,0x91,0x8C,0x8C,
	0x9B,0x8E,0xF6,0xB6,0x9F,0x93,0x9B,0x8D,0xE0,0xB0,0x91,0x8C,0x8C,0x9B,0x8E,0xF6,
	0xB7,0x9F,0x92,0xE0,0xAE,0x91,0x9C,0x9E,0x91,0x8B,0x8E,0x92,0xF6,0xBA,0x8E,0x9B,
	0x9C,0xE0,0xAD,0x9D,0x98,0x8B,0x9D,0x98,0x93,0x9F,0x92,0xF6,0xB0,0x9B,0x8C,0x9B,
	0x8E,0xE0,0xAD,0x9D,0x98,0x8B,0x94,0x86,0xF6,0xB2,0x9B,0x97,0x94,0xE0,0xAD,0x9B,
	0x9C,0x99,0x9B,0x8E,0xF6,0xB3,0x9F,0x8E,0x8C,0x97,0x92,0xE0,0xAD,0x8C,0x9B,0x97,
	0x99,0x9B,0x8E,0x89,0x9F,0x94,0x9C,0xF6,0xBA,0x8E,0x9B,0x9C,0x9B,0x8E,0x97,0x9D,
	0xE0,0xAD,0x8C,0x9B,0x97,0x92,0x9A,0x9B,0x94,0x8D,0xF6,0xB7,0x9F,0x92,0xE0,0xAD,
	0x8C,0x9B,0x8B,0x9F,0x8E,0x8C,0xF6,0xAC,0x97,0x93,0xE0,0xAD,0x8C,0x8E,0x9F,0x9D,
	0x98,0x9F,0x92,0xF6,0xAC,0x98,0x91,0x93,0x9F,0x8D,0xE0,0xAD,0x8A,0x9B,0x92,0x8D,
	0x91,0x92,0xF6,0xBF,0x8D,0x98,0xE0,0xAC,0x98,0x91,0x93,0x9F,0x8D,0xF6,0xB5,0x9B,
	0x97,0x8C,0x98,0xE0,0xAC,0x8B,0x9D,0x95,0x9B,0x8E,0xF6,0xB6,0x91,0x98,0x92,0xE0,
	0xAA,0x9B,0x94,0x9C,0x8C,0x98,0x8B,0x97,0x8D,0xF6,0xBB,0x9C,0x93,0x8B,0x92,0x9C,
	0xE0,0xAA,0x9B,0x8E,0x93,0x9B,0x8B,0x94,0x9B,0x92,0xF6,0xBE,0x9B,0x92,0xE0,0xAA,
	0x91,0x8D,0x8C,0xF6,0xAE,0x97,0x9D,0x98,0x9F,0x8E,0x9C,0xE0,0xA9,0x9F,0x8D,0x90,
	0x9B,0xF6,0xAE,0x91,0x99,0x9B,0x8E,0xE0,0xA9,0x9F,0x8C,0x9B,0x8E,0x8D,0xF6,0xAD,
	0x8C,0x9B,0x8A,0x9B,0xE0,0xA9,0x9B,0x93,0x87,0x8D,0x8D,0xF6,0xBF,0x92,0x9C,0x8E,
	0x9B,0x89,0xE0,0xA9,0x97,0x94,0x8D,0x91,0x92,0xF6,0xF6,0xAC,0x91,0xE0,0x8C,0x98,
	0x9B,0x8D,0x9B,0xE0,0x90,0x9B,0x91,0x90,0x94,0x9B,0xD4,0xE0,0x9F,0x92,0x9C,0xE0,
	0x9F,0x92,0x87,0xE0,0x91,0x8C,0x98,0x9B,0x8E,0x8D,0xE0,0x89,0x98,0x91,0xE0,0xB7,
	0xE0,0x98,0x9F,0x8A,0x9B,0xE0,0x9A,0x91,0x8E,0x99,0x91,0x8C,0x8C,0x9B,0x92,0xE0,
	0xD8,0xB7,0xD9,0x93,0xE0,0x8D,0x8B,0x8E,0x9B,0xE0,0x8C,0x98,0x9B,0x8E,0x9B,0xE0,
	0x9F,0x8E,0x9B,0xE0,0x93,0x9F,0x92,0x87,0xD7,0xD4,0xE0,0x93,0x87,0xE0,0x8D,0x97,
	0x92,0x9D,0x9B,0x8E,0x9B,0xE0,0x8C,0x98,0x9F,0x92,0x95,0x8D,0xD2,0xE0,0xAC,0x91,
	0xE0,0x9F,0x94,0x94,0xE0,0x8C,0x98,0x9B,0xE0,0x9E,0x9B,0x8C,0x9F,0xE0,0x8C,0x9B,
	0x8D,0x8C,0x9B,0x8E,0x8D,0xE0,0xD8,0x8D,0x91,0x93,0x9B,0xE0,0x9F,0x8E,0x9B,0xE0,
	0x92,0x9F,0x93,0x9B,0x9C,0xE0,0x9F,0x9E,0x91,0x8A,0x9B,0xD7,0xD4,0xE0,0xB9,0x8E,
	0x9B,0x99,0xE0,0x9F,0x92,0x9C,0xE0,0xB7,0xE0,0x9F,0x90,0x90,0x8E,0x9B,0x9D,0x97,
	0x9F,0x8C,0x9B,0xE0,0x9F,0x94,0x94,0xE0,0x8C,0x98,0x9B,0xE0,0x98,0x9F,0x8E,0x9C,
	0xE0,0x89,0x91,0x8E,0x95,0xE0,0x87,0x91,0x8B,0xD9,0x8A,0x9B,0xE0,0x9C,0x91,0x92,
	0x9B,0xD4,0xE0,0x9F,0x92,0x9C,0xE0,0x9A,0x91,0x8E,0xE0,0x90,0x8B,0x8C,0x8C,0x97,
	0x92,0x99,0xE0,0x8B,0x90,0xE0,0x89,0x97,0x8C,0x98,0xE0,0x8C,0x98,0x9B,0xE0,0x9F,
	0x9E,0x8B,0x8D,0x9B,0xE0,0xC6,0xD3,0xD7,0xF6,0xF6,0xAC,0x98,0x9F,0x92,0x95,0x8D,
	0xE0,0x8C,0x91,0xE0,0xB9,0x8E,0x9B,0x99,0xE0,0xDA,0xE0,0xBE,0x8E,0x91,0x92,0xE0,
	0x9A,0x91,0x8E,0xE0,0x90,0x8B,0x8C,0x8C,0x97,0x92,0x99,0xE0,0x8B,0x90,0xE0,0x89,
	0x97,0x8C,0x98,0xE0,0x93,0x9B,0xE0,0x97,0x92,0xE0,0xBE,0x8E,0x97,0x8D,0x9E,0x9F,
	0x92,0x9B,0xD2,0xE0,0xAC,0x98,0x9F,0x92,0x95,0x8D,0xE0,0x8C,0x91,0xE0,0x93,0x87,
	0xE0,0x9A,0x9F,0x93,0x97,0x94,0x87,0xE0,0x9A,0x91,0x8E,0xE0,0x90,0x8B,0x8C,0x8C,
	0x97,0x92,0x99,0xE0,0x8B,0x90,0xE0,0x89,0x97,0x8C,0x98,0xE0,0x93,0x9B,0xE0,0x99,
	0x9B,0x92,0x9B,0x8E,0x9F,0x94,0x94,0x87,0xD2,0xF6,0xF6,0xBF,0x94,0x94,0xE0,0x93,
	0x87,0xE0,0x94,0x91,0x8A,0x9B,0xE0,0x8C,0x91,0xE0,0xBE,0x9F,0x8E,0x9E,0x9F,0x8E,
	0x9F,0xF6,0xF6,0xAC,0x98,0x9F,0x92,0x95,0x8D,0xE0,0x8C,0x91,0xE0,0x9B,0x8A,0x9B,
	0x8E,0x87,0x91,0x92,0x9B,0xE0,0x89,0x98,0x91,0xE0,0x98,0x9F,0x8D,0xE0,0x9E,0x91,
	0x8B,0x99,0x98,0x8C,0xE0,0x9F,0x92,0x9C,0xE0,0x8D,0x8B,0x90,0x90,0x91,0x8E,0x8C,
	0x9B,0x9C,0xE0,0xB1,0x90,0x8B,0x8D,0xD2,0xF6,0xF6,0xF6,0xBC,0x97,0x8E,0x9B,0x9D,
	0x8C,0x91,0x8E,0x87,0xE0,0xB1,0x90,0x8B,0x8D,0xE0,0xCB,0xE0,0x97,0x8D,0xE0,0x9C,
	0x9B,0x9C,0x97,0x9D,0x9F,0x8C,0x9B,0x9C,0xE0,0x8C,0x91,0xF6,0xF6,0xF6,0xF6,0xB6,
	0x9F,0x87,0xE0,0xB3,0x97,0x92,0x9B,0x8E,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,
	0xF6,0xF6,0xF6,0xF6,0xBF,0x92,0x9C,0xE0,0x8C,0x91,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,
	0xF6,0xF6,0xF6,0xF6,0xF6,0xAC,0x98,0x9B,0xE0,0xAD,0x90,0x97,0x8E,0x97,0x8C,0xE0,
	0x91,0x9A,0xE0,0xAC,0x98,0x9B,0xE0,0xBF,0x93,0x97,0x99,0x9F,0xF6,0xF6,0xF6,0xF6,
	0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0x00};

/*
"Directory Opus 5 was written by Jonathan Potter, and designed by Jonathan Potter "
"and Greg Perry. The OpusFTP and AFC modules were written by Andrew Dunbar. %s"
"This product is the culmination of eight years of development, and would have been "
"impossible without the assistance, both currently and previously, of the following people:\n\n"

"Mark Allen\n"
"Pino Alberti\n"
"Mike Bailey\n"
"Mat Bettinson\n"
"Neil Bothwick\n"
"Andrew Brown\n"
"Tony Carmody\n"
"Eddie Churchill\n"
"Dave Clarke\n"
"Shaun Cosgrove\n"
"John Cousins\n"
"Leo Davidson\n"
"Ross Delaforce\n"
"Tania Dennis\n"
"Andrew Dunbar\n"
"Maurizio Fabiani\n"
"Josh Fairlie\n"
"Cash Foley\n"
"Dave Freeman\n"
"George Graham\n"
"Troels Walsted Hansen\n"
"Seth Harmon\n"
"John Hendrikx\n"
"Kees Huizer\n"
"Jim Huls\n"
"Helmut Hummel\n"
"Peter Jackson\n"
"Adrian Jones\n"
"Harvey Laser\n"
"Mike Latinovich\n"
"Andy Leaning\n"
"John Lowery\n"
"Leigh Malpas\n"
"Tim Martin\n"
"Ross Molden\n"
"Trevor Morris\n"
"Dieter Muller\n"
"Martin Murray\n"
"Barbara Nabilek\n"
"Bill Near\n"
"Jim O'Flaherty, Jr.\n"
"Stefan Ossowski\n"
"Bronwyn Perry\n"
"Michael Portmann\n"
"Carol Potter\n"
"Emily Potter\n"
"James Potter\n"
"Ian Rodbourn\n"
"Fred Schuchman\n"
"Peter Schulz\n"
"Neil Sedger\n"
"Martin Steigerwald\n"
"Frederic Steinfels\n"
"Ian Steuart\n"
"Tim Strachan\n"
"Thomas Svenson\n"
"Ash Thomas\n"
"Keith Tucker\n"
"John Veldthuis\n"
"Edmund Vermeulen\n"
"Ben Vost\n"
"Richard Waspe\n"
"Roger Waters\n"
"Steve Wemyss\n"
"Andrew Wilson\n\n"

"To these people, and any others who I have forgotten (I'm sure there are many), "
"my sincere thanks. To all the beta testers (some are named above), Greg and I "
"appreciate all the hard work you've done, and for putting up with the abuse :-)\n\n"

"Thanks to Greg & Bron for putting up with me in Brisbane. "
"Thanks to my family for putting up with me generally.\n\n"

"All my love to Barbara\n\n"

"Thanks to everyone who has bought and supported Opus.\n"
"Remember - Spread the Word and not the Disk!\n\n\n"

"Directory Opus 5 is dedicated to\n\n\n\n"

"Jay Miner\n\n\n\n\n\n\n\n\n\n\n\n"
"And to\n\n\n\n\n\n\n\n\n\n\n"
"The Spirit of The Amiga\n\n\n\n\n\n\n\n\n\n";
*/
