#!/bin/sh
# PI.sh

# #!/usr/local/bin/dash
# #!/bin/sh
# #!/bin/bash
# #!/bin/ksh
# #!/bin/zsh

# PI to the default 8 decimal places.
# 3.14159265

clear
echo 'Start, please wait...'
echo ''
echo 'Using integer maths only and fully POSIX compliant!'

# Nilakantha's series...
echo 'Nilakantha Series: PI=3+(4/(2x3x4))-(4/(4x5x6))+(4/(6x7x8))-(4/(8x9x10))+...'
echo ''
PI_APPROX=300000000
SWITCH_SIGN=1
POLARITY=0
K=2
LOOP=0
while [ ${LOOP} -le 250 ]
do
	if [ ${PI_APPROX} -eq 314159265 ]
	then
		break
	fi
	if [ $(( POLARITY%2 )) -eq 0 ]
	then
		SWITCH_SIGN="1"
	else
		SWITCH_SIGN="-1"
	fi
	PI_APPROX=$(( PI_APPROX+(1*(SWITCH_SIGN))*(400000000/(K*(K+1)*(K+2))) ))
	POLARITY=$(( POLARITY+1 ))
	K=$(( K+2 ))
	LOOP=$(( LOOP+1 ))
done
printf "32 bit; PI to 8 decimal places = %.8f...\n" "${PI_APPROX}e-8"
echo "Number of loops = ${LOOP}."
echo ''
echo 'Stop...'

