/*
	main.c, `main()' for `read'
	Copyright (c) 2004 Kalle Risnen.


	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <sys/time.h>

#include "read.h"


char *program_name;

int main(int argc, char *argv[])
{
	FILE *inp;
	int  i;
	int  read_res  = 0;
	int  silent    = 0,
	     few_ok    = 0,
	     max_read  = DEF_MAXREAD,
        timeout   = 0, 
	     escape    = 1,
	     ask_mode  = 0,
	     num_vars  = 0;
	char *wdelim   = NULL,
	     *delim    = NULL;
	char *buff     = NULL,
	     **vars    = NULL,
	     *prompt   = NULL,
	     *filename = NULL;
	int  ret       = RETURN_OK;

	if(argc == 2)
		{
		if(strcmp(argv[1], "--help") == 0)
			{
			printf(VERSTAG "\n\n"
		       "   read [ [OPTION ...] [NAME ...] | [ --help | --copyright | --version ] ]\n\n"
		       "\t-a ANAME\n"
		       "\t    Should assign each input word into sequential indices of the array\n"
		       "\t    ANAME, as bash read does. Since we're working with environmentals,\n"
		       "\t    not variables, it just adds ANAME to NAMEs.\n"
		       "\t-d DELIM\n"
		       "\t    Use any character in DELIM to end input, rather than newline.\n"
		       "\t-e  Does nothing, kept for bash read compatibility (and, to some extent,\n"
		       "\t    for ash read compatibility).\n"
		       "\t-f  Return OK if fewer words were entered than there are NAMEs.\n"
		       "\t-n NCHARS\n"
		       "\t    Return after reading NCHARS instead of upon reaching end of line.\n"
		       "\t-p PROMPT\n"
		       "\t    Display PROMPT before reading. Not displayed if reading from file.\n"
		       "\t-q  `Ask' mode, reads only one char and, if it is 'y' or 'Y', sets NAME to\n"
		       "\t    'y' and returns WARN, otherwise sets NAME to 'n' and returns OK.\n"
		       "\t-r  Don't allow backslash escapes (eg. typeing '\\' + <ENTER> to enter\n"
		       "\t    newline, or using '\\n' in prompt to echo newline).\n"
		       "\t-s  Silent, don't echo input.\n"
		       "\t-t TIMEOUT\n"
		       "\t    If input isn't done in TIMEOUT seconds, return failure.\n"
		       "\t-u FILENAME\n"
		       "\t    Take input from FILENAME, rather than standard input.\n"
		       "\t-w WDELIM\n"
		       "\t    Use WDELIM is delimiter between words. By default, read looks for the\n"
		       "\t    looks for the environmental variable IFS, and if it's found uses it\n"
		       "\t    Otherwise, we use \" \\t\" (space/tab). NB: WDELIM can be any number\n"
			    "\t    of chars, any of which'll be recognized as IFSs.\n"
		       "\tNAME\n"
		       "\t    Save input into the environmental variable NAME. If more than one NAME\n"
		       "\t    is specified, split input by WDELIM, and save each `word' into each\n"
		       "\t    NAME.\n"
		       "\t--copyright\n"
		       "\t    Outputs copyright information.\n"
		       "\t--help\n"
		       "\t    Outputs this message.\n"
		       "\t--version\n"
		       "\t    Outputs read version.\n\n"
		       "Read returns WARN if it recieved any input, and OK if no input was given (or, if\n"
		       "the `-f' flag is given, if fewer words were input than there are NAMEs). Returns FAIL\n"
		       "if it failed setting NAME(s).\n\n"
		       "Report any bugs to <bugs@aros-stuff.tk>.\n"
		       );
			return RETURN_OK;
			}
		else if(strcmp(argv[1], "--version") == 0)
			{
			printf(VERSTAG "\n");
			return RETURN_OK;
			}
		else if(strcmp(argv[1], "--copyright") == 0)
			{
			printf(VERSTAG "\n\n"
			       "This program is free software; you can redistribute it and/or modify\n"
			       "it under the terms of the GNU General Public License as published by\n"
			       "the Free Software Foundation; either version 2 of the License, or\n"
			       "(at your option) any later version.\n\n"
			       "This program is distributed in the hope that it will be useful,\n"
			       "but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
			       "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
			       "GNU General Public License for more details.\n\n"
			       "You should have received a copy of the GNU General Public License\n"
			       "along with this program; if not, write to the Free Software\n"
			       "Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA\n");
			return RETURN_OK;
			}
		} 
	/* argc != 2 */

	program_name = argv[0];

	vars = xmalloc(argc * sizeof(char **));

	if(get_env("IFS"))
		{
		char *p = get_env("IFS");
		wdelim = xmalloc(strlen(p));
		strcpy(wdelim, p);  
		}
	else
		wdelim = strdup(DEF_IFS);

	delim = strdup("\n\r");


	if(!wdelim || !delim)
		error("Out of memory!");

	for(i = 1; i < argc; i++)
		{
		if(argv[i][0] == '-')
			{
			int j, noarg = 0, skip = 0;
			for(j = 1; j < strlen(argv[i]); j++)
				{
				switch(argv[i][j])
					{
					case 'a':
						if(argc <= i + 1) { noarg++; break; }
						vars[num_vars++] =  argv[i + 1];
						skip++;
						break;
					case 'd':
						if(argc <= i + 1) { noarg++; break; }
						free(delim);
						delim = malloc(strlen(argv[i+1]) + 1);
						strcpy(delim, argv[i + 1]);
						if(strchr(delim, '\n') && !strchr(delim, '\r'))
							strcat(delim, "\n");
						skip++;
						break;
					case 'e': break; /* Not implemented */
					case 'f': few_ok = 1; break;
					case 'n':
						if(argc <= i + 1) { noarg++; break; }
						max_read = (atoi(argv[i + 1])) ? atoi(argv[i + 1]) : DEF_MAXREAD;
						skip++; 
						break;
					case 'p':
						if(argc <= i + 1) { noarg++; break; }
						if(prompt) free(prompt);
						prompt = xmalloc(strlen(argv[i + 1]));
						strcpy(prompt, argv[i + 1]);
						skip++; 
						break;
					case 'q': max_read = ask_mode  = 1; break;
					case 'r': escape    = 0; break;
					case 's': silent    = 1; break;
					case 't':
						if(argc <= i + 1) { noarg++; break; }
						timeout = atoi(argv[i + 1]);
						skip++;
						break;
					case 'u':
						if(argc <= i + 1) { noarg++; break; }
						if(filename) free(filename);
						filename = xmalloc(strlen(argv[i + 1]));
						strcpy(filename, argv[i + 1]);
						skip++;
						silent = 1;
						break;
					case 'w':
						if(argc <= i + 1) { noarg++; break; }
						free(wdelim);
						wdelim = xmalloc(strlen(argv[i + 1]));
						strcpy(wdelim, argv[i + 1]);
						skip++;
						break;
					default:
						error("unrecognized option `%c'.\n"
						      "Try `%s --help' for more information.",
						       argv[i][j], argv[0]); 
					}
				if(noarg)
					error("%s requires an argument.\n"
					      "Try `%s --help' for more information.\n",
					       argv[i], argv[0]);
				if(skip) { i++; break;}
				}
			}
		else
			vars[num_vars++] = argv[i];
		}

	if(!num_vars) vars[num_vars++] = "REPLY";

	if(filename)
		{
		if(!(inp = fopen(filename, "r")))
			error("Error opening `%s'.", filename);
		free(filename);
		}
	else
		inp = stdin;

	if(prompt != NULL && inp == stdin)
		{
		put_str(stderr, prompt, escape);
		free(prompt);
		}

	buff = xmalloc(max_read + 1);

	read_res = get_str(inp, buff, max_read, escape, timeout, silent, delim);

	if(read_res == 0 && !ask_mode)
		ret = RETURN_OK;
	else if(read_res == -1)
		ret = RETURN_FAIL;
	else
		{
		if(!ask_mode)
			ret = RETURN_WARN;
		else if(buff[0] == 'y' || buff[0] == 'Y')
			{
			strcpy(buff, "y");
			ret = RETURN_WARN;
			}
		else
			{
			strcpy(buff, "n");
			ret = RETURN_OK;
			}
		read_res = str_to_vars(buff, vars, num_vars, wdelim, escape);
		if(read_res == -1)
			ret = RETURN_FAIL;
		else if(read_res < num_vars && few_ok)
			ret = RETURN_OK;
		else if(!ask_mode)
			ret = RETURN_WARN;
		}

	if(inp != stdin) fclose(inp);

	return ret;
}
