/***************************************************************************

 MagicMenu - Intuition PopupMenu enhancement

 Copyright (C) 1993-1997 by Martin Korndrfer
 Copyright (C) 1997-2001 by Olaf `Olsen' Barthel
 Copyright (C) 2001 by Stephan Rupprecht, Jens Langner

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 MagicMenu Official Support Site :  http://www.magicmenu.de/

 $Id$

***************************************************************************/

/*#define DEBUG*/

#ifndef _GLOBAL_H
#include "Global.h"
#endif /* _GLOBAL_H */

BOOL
DoIntuiMenu (UWORD NewMenuMode, BOOL PopUp, BOOL SendMenuDown)
{
  struct Window *ZwWin;
  UWORD Code, Err;
  struct InputEvent *NewEvent;
  BOOL lending = FALSE;
  ENTER();
  /* Zum Zeichnen des Hintergrundes mssen wir das vormerken.
   * Diese Flag entscheidet, ob der Transparenzmodus wirklich
   * aktiv werden darf.
   */
  GlobalPopUp = PopUp;

  /* Zugriff auf MenWin, MenScr und MenStrip sperren. */
  ObtainSemaphore (GetPointerSemaphore);

  /* Intuition anhalten. */
  IBaseLock = LockIBase (NULL);

  /* Ist gerade ein Fenster aktiv? */
  if (!(MenWin = IntuitionBase->ActiveWindow))
  {
    /* Falls nicht, die ganze Prozedur rckgngig machen. */
    UnlockIBase (IBaseLock);
    ReleaseSemaphore (GetPointerSemaphore);
    return (TRUE);
  }

  MenStrip = MenWin->MenuStrip;
  MenScr = MenWin->WScreen;

  /* Leiht dem Fenster ein anderes seine Mens? */
  if(V39)
  {
    struct Window *OtherGuy;

    if(OtherGuy = FindLending(MenWin))
    {
      SHOWMSG("menu lending active");

      D(("this window 0x%08lx |%s|",MenWin,MenWin->Title));

      MenWin = OtherGuy;
      MenStrip = OtherGuy->MenuStrip;
      MenScr = OtherGuy->WScreen;

      D(("Other window 0x%08lx |%s|",MenWin,MenWin->Title));

      lending = TRUE;
    }
  }

  /* Ist mit diesem Fenster etwas zu machen? */
  if ((!MenStrip) || (MenWin->Flags & WFLG_RMBTRAP) || (MenWin->ReqCount != 0))
  {
    /* Intuition wieder starten. */
    UnlockIBase (IBaseLock);
    ReleaseSemaphore (GetPointerSemaphore);
	LEAVE();
    return (FALSE);
  }

  /* Ab jetzt kann wieder lesend auf MenWin, MenScr, MenStrip
   * zugegriffen werden.
   */
  ReleaseSemaphore (GetPointerSemaphore);

  MenuMode = NewMenuMode;

  DoGlobalQuit = FALSE;
  FirstSelectedMenu = NULL;
  LastSelectedMenu = NULL;
  FirstMenuNum = MENUNULL;
  MenuNum = NOMENU;
  ItemNum = NOITEM;
  SubItemNum = NOSUB;

  if (MenWin->IDCMPFlags & IDCMP_MENUVERIFY)
  {
    D(("has menuverify"));
    /* Nachricht verschicken (beinhaltet UnlockIBase()) */
    Code = MENUHOT;
    Err = SendIntuiMessage (IDCMP_MENUVERIFY, &Code, PeekQualifier (), NULL, MenWin, IBaseLock, TRUE);

    if (Code == MENUCANCEL || Err != SENDINTUI_OK)
    {
      D(("code=%ld err=%ld", Code, Err));
      EndIntuiMenu (FALSE);
	  LEAVE();
      return (TRUE);
    }

    D(("get going again"));

    /* Intuition wieder starten. */
    IBaseLock = LockIBase (NULL);
  }

  /* Jetzt werden alle inaktiven Fenster des Bildschirms
   * benachrichtigt, die IDCMP_MENUVERIFY gesetzt haben.
   */

  for (ZwWin = MenScr->FirstWindow; ZwWin != NULL; ZwWin = ZwWin->NextWindow)
  {
    if (ZwWin != MenWin && (ZwWin->IDCMPFlags & IDCMP_MENUVERIFY))
    {
      /* Nachricht verschicken; fire and forget. */
      Code = MENUWAITING;
      SendIntuiMessage (IDCMP_MENUVERIFY, &Code, PeekQualifier (), NULL, ZwWin, NULL, FALSE);
    }
  }

  /* Das war die letzte Handlung, zu der Intuition
   * gesperrt werden mute.
   */
  UnlockIBase (IBaseLock);

  /* Das Men wird jetzt endlich aktiv; Operationen in diesem
   * Bildschirm, in diesem Fenster, in diesem Men werden
   * warten mssen.
   */
  ObtainSemaphore (MenuActSemaphore);

  MenWin->Flags |= WFLG_MENUSTATE;

  GlobalLastWinDMREnable = (MenWin->DMRequest != NULL);

  HelpPressed = FALSE;

  if (!AktPrefs.mmp_NonBlocking)
  {
    LockLayerInfo (&MenScr->LayerInfo);
    LockLayers (&MenScr->LayerInfo);
    LayersLocked = TRUE;
  }

  ResetMenu (MenStrip, TRUE);

  ChangeBrokerSetup ();

  if (DrawMenuStrip (PopUp, ((PopUp) ? AktPrefs.mmp_PULook : AktPrefs.mmp_PDLook), TRUE))
  {
    SelectSpecial = (MenuMode == MODE_SELECT);
    ProcessIntuiMenu ();
  }

  CleanUpMenu ();

  ResetMenu (MenStrip, FALSE);

  if(lending)
  {
    Code = FirstMenuNum;

    IBaseLock = LockIBase (NULL);
    SendIntuiMessage ((HelpPressed) ? IDCMP_MENUHELP : IDCMP_MENUPICK, &Code, PeekQualifier (), MenWin, MenWin, NULL, FALSE);
    UnlockIBase (IBaseLock);
  }
  /* Das hier ist der Knackpunkt. Das Fenster kann verschwinden (!) bevor
   * die IntuiMessage erzeugt und ausgeliefert ist. Vielleicht wre es
   * besser, die IntuiMessage selbst zu erzeugen und auszuliefern.
   *
   * Eigentlich nicht. Intuition ist schlau genug, damit klarzukommen.
   */
  else if (NewEvent = AllocVecPooled (sizeof (struct InputEvent), MEMF_PUBLIC | MEMF_CLEAR))
  {
    NewEvent->ie_Class = (HelpPressed) ? IECLASS_MENUHELP : IECLASS_MENULIST;

    D(("sending with window 0x%08lx |%s|",MenWin,MenWin->Title));

    NewEvent->ie_Code = FirstMenuNum;
    NewEvent->ie_EventAddress = MenWin;
    NewEvent->ie_Qualifier = PeekQualifier ();

    InputIO->io_Data = (APTR) NewEvent;
    InputIO->io_Length = sizeof (struct InputEvent);

    InputIO->io_Command = IND_WRITEEVENT;
    DoIO ((struct IORequest *) InputIO);

    FreeVecPooled (NewEvent);
  }
  else
  {
    SHOWMSG("not enough memory for notification message");
  }

  /* Jetzt kommt die letzte Manahme. Die Fenster, die vorher die
   * MENUVERIFY/MENUWAITING-Nachricht bekommen hatten, erhalten jetzt
   * noch MOUSEBUTTONS/MENUUP.
   */

  IBaseLock = LockIBase (NULL);

  for (ZwWin = MenScr->FirstWindow; ZwWin != NULL; ZwWin = ZwWin->NextWindow)
  {
    if (ZwWin != MenWin && (ZwWin->IDCMPFlags & (IDCMP_MENUVERIFY | IDCMP_MOUSEBUTTONS)) == (IDCMP_MENUVERIFY | IDCMP_MOUSEBUTTONS))
    {
      /* Nachricht verschicken; fire and forget. */
      Code = MENUUP;
      SendIntuiMessage (IDCMP_MOUSEBUTTONS, &Code, PeekQualifier (), NULL, ZwWin, NULL, FALSE);
    }
  }

  UnlockIBase (IBaseLock);

  EndIntuiMenu (TRUE);
  LEAVE();
  return (TRUE);
}
