/* $VER: 19.05.03 */

#ifndef _GLOBALSTUFF_H
#define _GLOBALSTUFF_H

#include <stdio.h>

#include <exec/types.h>
#include <exec/lists.h>
#include <exec/nodes.h>
#include <exec/memory.h>
#include <intuition/intuition.h>
#include <intuition/gadgetclass.h>
#include <libraries/gadtools.h>
#include <dos/dos.h>
#include <utility/tagitem.h>
#include <utility/date.h>
#include <devices/timer.h>
#include <workbench/workbench.h>
#include <workbench/startup.h>

#ifndef __NOLIBBASE__
#define __NOLIBBASE__
#endif

#include <proto/exec.h>
#include <proto/intuition.h>
#include <proto/gadtools.h>
#include <proto/graphics.h>
#include <proto/utility.h>
#include <proto/timer.h>
#include <proto/dos.h>
#include <proto/icon.h>
#include <proto/alib.h>

#define ZIPWIDTH  16
#define ZIPHEIGHT 16
#define DELAY     1


/* handle GLOBAL variables */
#ifdef PRIMARY
#define _GLOBAL
#else
#define _GLOBAL extern
#endif

#ifdef DEBUG
#define DPUTS(x) puts( x );
#define DPRINTF(x,y) printf( x, y );
#else
#define DPUTS(x)
#define DPRINTF(x,y)
#endif

/* Color structure */
struct Color32 {
    ULONG red;
    ULONG green;
    ULONG blue;
};

/* Memo structure */
struct Memo {

    struct Node   node; /* For the linked list */

    struct Window *window; /* pointer to the Memo window*/

    struct Color32 tColor; /* RGB for text */
    struct Color32 mColor; /* RGB for background */

    BOOL  zipped; /* minimized or normal */

    WORD  textColor; /* foreground colour */
    WORD  memoColor; /* background colour */
    UBYTE text[10][21]; /* memo text buffers */
    BOOL  alarm; /* alarm on/off */
    UWORD hours; /* alarm hours */
    UWORD minutes; /* alarm minutes */

    WORD origWidth; /* Memo window's normal width */
    WORD origHeight; /* ... height */
    WORD x; /* x location */
    WORD y; /* y location */

};

/* Node for obtained pens */
struct PenNode {
    struct Node node;
    ULONG pen;
};

/* Gadget IDs */
enum {
    TEXT0=0,
    TEXT1,
    TEXT2,
    TEXT3,
    TEXT4,
    TEXT5,
    TEXT6,
    TEXT7,
    TEXT8,
    TEXT9,
    TEXTCOLOR,
    MEMOCOLOR,
    HOURSLIDER,
    MINUTESLIDER,
    TOGGLEALARM,
    OKBUTTON,
    SHOWCONTENT
};

/* Menu Item IDs */
enum {
    NEWMEMO=0,
    EDIT,
    ABOUT,
    CLOSETHIS,
    SAVE,
    SAVEQUIT,
    QUIT
};

#ifdef __GNUC__
_GLOBAL struct ExecBase         *SysBase;
#endif

_GLOBAL struct DOSBase          *DOSBase;
_GLOBAL struct GfxBase          *GfxBase;
_GLOBAL struct IntuitionBase    *IntuitionBase;
_GLOBAL struct Library          *GadToolsBase;
_GLOBAL struct Library          *UtilityBase;
_GLOBAL struct Library          *IconBase;

_GLOBAL struct Device           *TimerBase;

_GLOBAL struct timeval          tvSystem;
_GLOBAL struct ClockData        cdSystem;
_GLOBAL struct timerequest      *timeRequest;
_GLOBAL struct MsgPort          *timerPort;

_GLOBAL struct MsgPort          *winPort;

_GLOBAL struct List             memoList;

_GLOBAL struct List             penList;

_GLOBAL struct Screen           *screen;

_GLOBAL struct ViewPort         *vp;

_GLOBAL struct ColorMap         *cm;

_GLOBAL struct Gadget           *gadgetList;

_GLOBAL struct Window           *prefsWin;
_GLOBAL struct DrawInfo         *drawInfo;
_GLOBAL APTR                    visualInfo;

_GLOBAL struct Menu             *menu;

_GLOBAL struct Color32          tColor;

_GLOBAL struct Color32          mColor;

_GLOBAL WORD                    origHeight, origWidth, mx, my;

_GLOBAL WORD                    textWidth;

_GLOBAL UWORD                   hours, minutes;
_GLOBAL WORD                    textColor;
_GLOBAL WORD                    memoColor;
_GLOBAL ULONG                   count; /* Memo count */

_GLOBAL UBYTE                   text[10][21];

_GLOBAL BOOL                    alarm, zipped, timer, waiting;
_GLOBAL BOOL                    quit, killPrefsWindow, killMemo;

_GLOBAL BOOL                    doubleBorders, killAllMemos, showContent;

_GLOBAL STRPTR                  fileName;

_GLOBAL BOOL                    editMode;

_GLOBAL struct Memo             *memoToEdit;

_GLOBAL STRPTR                  versionString;

_GLOBAL STRPTR                  version; /* For prefs file */

#endif
