/* $VER: 14.05.03 */

/*

TODO:

    - Reaction / MUI GUI
    - size gadget
    - header text?
    - commodity?

*/

#define PRIMARY

#include "globalstuff.h"
#include "protos.h"


/* the MAIN program */
int main( int argc, char **argv )
{

    /* Menu */
    struct NewMenu newMenu[] = {
        { NM_TITLE, "AmiMemos",       0, 0, 0, 0, },
        {  NM_ITEM, "New Memo",     "N", 0, 0, (APTR)NEWMEMO, },
        {  NM_ITEM, "Edit Current", "E", 0, 0, (APTR)EDIT, },
        {  NM_ITEM, "About",        "A", 0, 0, (APTR)ABOUT, },
        {  NM_ITEM, "Close This",   "C", 0, 0, (APTR)CLOSETHIS, },
        {  NM_ITEM, "Save",         "S", 0, 0, (APTR)SAVE, },
        {  NM_ITEM, "Save & Quit",  "X", 0, 0, (APTR)SAVEQUIT, },
        {  NM_ITEM, "QUIT",         "Q", 0, 0, (APTR)QUIT, },
        {   NM_END,   0,              0, 0, 0, 0, },
    };

    struct DiskObject *dObj = NULL;
    struct WBStartup  *argm;
    struct WBArg      *wbArg;

    struct Node       *node;
    struct PenNode    *penNode;

    STRPTR screenName = NULL; // = "Workbench";
    STRPTR active = NULL;

    BPTR oldDir = (BPTR)-1;

    count = 0;

    versionString = (STRPTR)"$VER: AmiMemos 0.80 for AmigaOS (14.5.03)  by Juha Niemimki";
    version = (STRPTR)"0.80";

    fileName = NULL; // = "test.memo";

    showContent = FALSE;

    if (!argc) {

        /* Try to open a global message port for memo windows */
        if ( (winPort = CreateMsgPort()) ) {

            /* Open the needed libraries */
            if (IntuitionBase = (struct IntuitionBase *)OpenLibrary("intuition.library", 39))
            {
                GfxBase       = (struct GfxBase *)OpenLibrary("graphics.library", 39);
                GadToolsBase  = OpenLibrary("gadtools.library", 39);
                UtilityBase   = OpenLibrary("utility.library", 39);
                IconBase      = OpenLibrary("icon.library", 39);
                DOSBase       = (struct DOSBase*)OpenLibrary("dos.library", 39);
            }

            /* Check that we got everything we need */
            if (IntuitionBase && GfxBase && GadToolsBase && UtilityBase && IconBase)
            {

                argm = (struct WBStartup *) argv;
                wbArg = argm->sm_ArgList;

                if ( wbArg->wa_Lock )
                    oldDir = CurrentDir( wbArg->wa_Lock );

                if ( ( *wbArg->wa_Name ) && ( dObj = (struct DiskObject *)GetDiskObject( wbArg->wa_Name ) ) ) {

                    if ( screenName = (STRPTR) FindToolType( dObj->do_ToolTypes, "Screen" ) )
                    {
                        //printf("Screen ok\n");

                    } else {
                        screenName = "Workbench";
                    }

                    if ( fileName = (STRPTR) FindToolType( dObj->do_ToolTypes, "File" ) )
                    {
                        //printf("File ok\n");
                    } else {
                        fileName = "memo.test";
                    }

                    if ( active = (STRPTR) FindToolType( dObj->do_ToolTypes, "Active" ) )
                    {
                        //printf("Active ok\n");
                    } else {
                        active = "FALSE";
                    }

                }

                if ( oldDir != (BPTR)-1)
                    CurrentDir( oldDir );

                if ( MatchToolValue( active, "TRUE" ) ) {

                    NEWLIST( &memoList );
                    NEWLIST( &penList );

                    /* Try to lock a public screen */
                    if ( ! ( screen = LockPubScreen( screenName ) ) )
                    {
                        screen = LockPubScreen( NULL );
                    }

                    if ( screen )
                    {

                        if (drawInfo = GetScreenDrawInfo(screen))
                        {
                            if (visualInfo = GetVisualInfoA(screen,NULL))
                            {
                                gadgetList = NULL;

                                vp= &(screen->ViewPort);
                                cm = vp->ColorMap;

                                menu = CreateMenus( newMenu, TAG_DONE );
                                LayoutMenus( menu, visualInfo, GTMN_NewLookMenus, TRUE, TAG_DONE );

                                if ( create_gadgets() )
                                {
                                    load_memos( fileName );

                                    if ( count == 0 )
                                    {
                                        open_prefsWindow();
                                    }

                                    /* Open a message port for Timer device: */
                                    if ( !( timerPort = (struct MsgPort*)CreatePort( "AmiMemos Timer", 0 ) ) ){
                                        //printf("Error while opening message port.\n");
                                        timer = FALSE;
                                    } else {

                                        /* Allocate and initialize timerequest: */
                                        if (! (timeRequest = (struct timerequest*)CreateExtIO( timerPort, sizeof( struct timerequest ) ) ) ) {
                                            //printf("Couldn't initialize timerequest.\n");
                                            timer = FALSE;
                                        } else {

                                            /* Try opening timer.device */
                                            if ( OpenDevice(TIMERNAME, UNIT_VBLANK, (struct IORequest *)timeRequest, 0) ) {
                                                //printf("Error while opening timer.device.\n");
                                                timer = FALSE;
                                            } else {
                                                TimerBase = (timeRequest)->tr_node.io_Device;/**/
                                                timer = TRUE;
                                            }

                                        } /* else */
                                    } /* else */

                                    handle_IDCMP();

                                    if (prefsWin) {
                                        //printf("ClosePrefsWin..");
                                        CloseWindowSafely(prefsWin);
                                    }

                                    //printf("..:AbortIO:..");
                                    AbortIO( (struct IORequest *)timeRequest );

                                    //printf("CloseDev..");
                                    if (timer)
                                        CloseDevice((struct IORequest *)timeRequest);

                                    //printf("DeleteExtIO..");
                                    if (timeRequest)
                                        DeleteExtIO( (struct IORequest *)timeRequest );

                                    //printf("DeletePort..");
                                    if (timerPort)
                                        DeletePort( timerPort );

                                }

                                FreeMenus(menu);
                                FreeGadgets(gadgetList);
                                FreeVisualInfo(visualInfo);
                            }
                            FreeScreenDrawInfo(screen,drawInfo);
                        }
                        UnlockPubScreen(NULL,screen);
                    }

                    /* Release obtained pens */
                    node = penList.lh_Head;
                    while ( node->ln_Succ ) {
                        penNode = (struct PenNode *) node;
                        node = node->ln_Succ;
                        ReleasePen( cm, penNode->pen );
                        Remove( (struct Node *)penNode );
                        FreeVec( penNode );
                    }


                } // if (active)..

                if ( dObj )
                    FreeDiskObject( dObj );
            }

            if (IntuitionBase)
            {
                CloseLibrary((struct Library*)DOSBase);
                CloseLibrary((struct Library *)UtilityBase);
                CloseLibrary(GadToolsBase);
                CloseLibrary((struct Library *)GfxBase);
                CloseLibrary((struct Library *)IntuitionBase);
                CloseLibrary(IconBase);
            }

            DeleteMsgPort( winPort );

        } else
            puts("Could not create message port!");

    } else
        puts("Run this program from Workbench!");

    return(0);
}
