#ifndef SDI_DEFINES_H
#define SDI_DEFINES_H

/* Includeheader

	Name:		SDI_defines
	Versionstring:	$VER: SDI_defines.h 1.32 (30.04.2000)
	Author:		SDI
	Distribution:	PD
	Description:	standard defines and macros and version string

 1.17  12.06.96 : RETURN_WARN instead of RETURN_ERROR in SDI_ENDCODE
 1.18  06.07.96 : End: PrintFault behind end --> allows selecting output
 1.19  21.08.96 : added __SASC __AMIGADATE__ support
 1.20  24.08.96 : better SAS-C support
 1.21  04.09.96 : changed error with SAS date having the brackets already
 1.22  18.11.96 : converted to english, C++ comments to C ones
 1.23  02.01.97 : corrected some stuff
 1.24  17.03.97 : removed GetChar and other obsolete defines
 1.25  08.10.97 : renamed defines, removed some defines
 1.26  10.02.98 : made version string const
 1.27  20.02.98 : added compiler independence stuff
 1.28  25.06.98 : compiler independent stuff moved to SDI_compiler.h
 1.29  01.09.98 : fixes for StormC Demo
 1.30  06.05.99 : changed AUTHOR string
 1.31  17.11.99 : date stuff now defaults to __DATE__ for unknown compiler
 1.32  30.04.00 : excluded SDI_version.h
*/

#include <exec/types.h>

/* ========================= useable defines ============================ */

/*
  SDI_ENDCODE		turn on generation of End function
  SDI_ENDCODE_NOCTRLC	use End generation without CTRL_C check
*/

/* ======================= no need for <stdlib.h> ======================= */

#ifdef __cplusplus
  extern "C"
#endif
extern void exit(int);

/* ============================ other macros ============================ */

/* <proto/exec.h>, <dos/dos.h> */

#define CTRL_C		(SetSignal(0L,0L) & SIGBREAKF_CTRL_C)

/* ================================= SAS C ============================== */

#define TestOS if(DOSBase->dl_lib.lib_Version < DosVersion)	\
  		   exit(RETURN_FAIL)

/* A word about variable DosVersion: In my startup code for MaxonC++ I
include use OpenLibrary("dos.library", DosVersion) instead of standard
OpenLibrary("dos.library",0) call. If no DosVersion is given, this
variable defaults to 33, else you can give the value by creating a global
variable ULONG DosVersion = 37;. The program does not start, when the
required DOS is not available. (Better then others, which crash) */

/* ===================== version string and EndCode ===================== */


#ifdef NAME
  #include "SDI_version.h"
#endif /* NAME */

#if defined(SDI_ENDCODE) || defined(SDI_ENDCODE_NOCTRLC)
  #include "SDI_compiler.h"

  INLINE void end(void);

  void End(UBYTE err)
  {
    #ifndef SDI_ENDCODE_NOCTRLC
    if(CTRL_C)
    {
      err = RETURN_WARN;
      SetIoErr(ERROR_BREAK);
    }
    #endif

    end();

    if(err)		PrintFault(IoErr(), 0);
    exit(err);
  }
#endif /* SDI_ENDCODE && SDI_ENDCODE_NOCTRLC */

#endif /* SDI_DEFINES_H */

