#include <stdio.h>
#include <termios.h>

int setup=0;

/*
 * Put the terminal in character by character mode.
 */
void init_screen() {
    struct termios t;

    tcgetattr(0, &t);
    t.c_iflag |= BRKINT;
    t.c_lflag &= ~(ICANON | ECHO);
    t.c_cc[VMIN] = 0;
    t.c_cc[VTIME] = 0;
    tcsetattr(0, TCSANOW, &t);

    setup=1;
}

void write_char(char c) {
    fputc(c, stdout);
    fflush(stdout);
}

int read_char() {
}

/*
    int c;

    while (-1 == (c = fgetc(stdin)));
    return c;
}
*/

int scan_key() {
    int c;

    if (setup && (-1 != (c = fgetc(stdin)))) {
	return c;
    } else 
	return 0;
}
