/****************************************************************************/
/*              Beebem - (c) David Alan Gilbert 1994                        */
/*              ------------------------------------                        */
/* This program may be distributed freely within the following restrictions:*/
/*                                                                          */
/* 1) You may not charge for this program or for any part of it.            */
/* 2) This copyright message must be distributed with all copies.           */
/* 3) This program must be distributed complete with source code.  Binary   */
/*    only distribution is not permitted.                                   */
/* 4) The author offers no warrenties, or guarentees etc. - you use it at   */
/*    your own risk.  If it messes something up or destroys your computer   */
/*    thats YOUR problem.                                                   */
/* 5) You may use small sections of code from this program in your own      */
/*    applications - but you must acknowledge its use.  If you plan to use  */
/*    large sections then please ask the author.                            */
/*                                                                          */
/* If you do not agree with any of the above then please do not use this    */
/* program.                                                                 */
/* Please report any problems to the author at beebem@treblig.org           */
/****************************************************************************/
/* The window which the beeb emulator displays stuff in */
#ifndef BEEBWIN_HEADER
#define BEEBWIN_HEADER

#include <string.h>
#include <stdio.h>
#include <stdlib.h>

//
// BeOS includes
//
#include <Application.h>
//#include <GraphicsDefs.h>
#include <WindowScreen.h>
#include <Screen.h>
#include <Window.h>
#include "my_view.h"


#include "port.h"

typedef union {
	unsigned char data[8];
  EightByteType eightbyte;
} EightUChars;

typedef union {
	unsigned char data[16];
  EightByteType eightbytes[2];
} SixteenUChars;


#undef DOUBLE_HEIGHT


typedef long (*blit_hook) (long, long, long, long, long, long);
typedef long (*sync_hook) ();


class BeebWin : public BWindowScreen {

	private:
		my_view *view;

		int OldAutoRepeat; /* -1 means we don't know, 0 and 1 are as returned from XGetKeyboardControl */
		int DataSize;

		BRect window_rect;

		bool fullsize;		// true to enable double height

		// Rendering buffer
		unsigned char	*image_data;
		int				bytes_per_row;

		bool QuitRequested(void) {
			puts("QuitRequested");
			be_app->PostMessage(B_QUIT_REQUESTED);
			return true;
		}

		void ScreenConnected(bool);

		void pixel_doubling_blit_8(
				const void * source_bitmap,
				int          source_rowbytes,
				int          source_width,
				int          source_height,
				void *       dest_bitmap,
				int          dest_rowbytes);

		// WindowScreen stuff
		uint8	*save_buffer;
		uint8	*frame_buffer;
		ulong	line_length;
		bool	thread_is_locked;
		thread_id tid;
		sem_id	sem;
		area_id	area;
		blit_hook blit;
		sync_hook sync;

	static long thread_func(void *obj);
	thread_id the_thread;			// id of our spawned thread


	public:
		BeebWin(status_t *ret, bool size = false);
		~BeebWin();

		unsigned char cols[8]; /* Beeb colour lookup */

		EightUChars *GetLinePtr(int y);
		SixteenUChars *GetLinePtr16(int y);

		char *imageData();
		int bytesPerLine();
		void updateLines(int starty, int nlines);

		// DirectWindow stuff
		rgb_color		palette[256];
		int				requested_depth;
		BRect			requested_size;

#if 0
		color_space		fFormat;	// Pixel format
		clipping_rect	fBounds;	// Window bounds rectangle
		uint32			fNumClipRects;	// # rectangles in clip rectangle list
		clipping_rect	*fClipList;	// List of clip rectangles
#endif
		bool		fConnected;		// Connected to frame buffer?
		thread_id	fDrawThreadID;	// id of drawing thread

		void doHorizLine(unsigned long Col, int y, int sx, int width);
		void doHorizLine(unsigned long Col, int offset, int width);
};



#endif
