//bbcim.cc (bbc diskbeeld manipulatie): SINGLE DENSITY, DD extensions and more.

// Copyright (c) W.H. Scholten 1996
 
// Permission to use, copy, modify, distribute, but NOT to sell this software
// and its documentation for any purpose is hereby granted without fee,
// provided that the above copyright notice appear in all copies and
// that both that copyright notice and this permission notice appear in
// supporting documentation, and that the name of the copyright holder
// not be used in advertising or publicity pertaining to distribution
// of the software without specific, written prior permission. The
// copyright holder makes no representations about the suitability of
// this software for any purpose. It is provided "as is" without express
// or implied warranty.
//
// THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
// SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
// FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY
// SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
// RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
// CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
// CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
//
//
// Send comments and bug-reports to 
//
//    wouters@cistron.nl
//
// Send anything else to /dev/null.
//
// It works under linux (1.2.13/GCC 2.7.0+)

/* Changes from v. 0.70 to 0.80:
   xcrc implemented
   -ed works on a mac (I think): uncomment #define MAC
     NOTE: I refer the files in the created dir not by going to the directory,
           but by taking the file 'dir/file'. Don't know if this works on a mac.
           LET ME KNOW.
   adjustments for differences from GCC 2.5.8 to GCC 2.7.x:
       1. after for loop for(int i ...) i doesn't exist any more (also on MAC compilers)
       2. fclose on a file with NULL result when opened not allowed
          (Segmentation fault)
   -e options now in any order

   -e and -y: if a file exists, you can choose whether to overwrite or rename.

  Changes from 0.80 to 0.83:
  -x completed (file overwrite/renames)
  seeks immediately before read/write in add-loop, otherwise segmentation faults sometimes (bug in GCC).
  fixed small mistake in xcrc.

  More xbeeb support coming later.

  Bugs and 'features' still present:
   -several files in a diskimage can have the same name.
   -'Locked' is not kept everywhere

  If in doubt: it's not a bug, it is a feature!
 */

//26-6-1996

#define VERSION "0.83"

//Comment out for english messages:
//#define NL

//#define MAC
//#define NO_COMMAND_LINE


#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef MAC
#include <unix.h>
#endif


#include "overschrijf.cc"

#include "nieuw_diskb.cc"
#include "diskb_add.cc"
#include "diskb_del.cc"
#include "expand_im.cc"
#include "minimaliseer.cc"

#include "intersplits.cc"
#include "ddos2dfs.cc"

#include "splits_cat.cc"
#include "bbc_crc.cc"
#include "xbeeb.cc"
#include "archief.cc"



int main(int argc, char *argv[])
{char  catalogus[50],  extract[50], disk[50], basisnaam[50], optstring[20];
 char  actie[60], naam[50], disknaam[15], backupnaam[50], infofile[50];
 char  addfile[50];
 unsigned char byte,H;
 FILE *fpcat, *fpextract, *fpdisk, *fpinfo;

 long filesizesum=0;

 int extr=0, extr_dir=0, cat=0, expand=0, min=0, bcrc=0, bare=0;
 int add=0, info=0, no_bbc_dir=0, remove_file=0, remove_disk_im=0;

 int bad_option=1;
 int options=1;



#if DEBUG
printf("debug versie.\n");
#endif

#ifdef NO_COMMAND_LINE
argc=1;
#endif

 if (argc < 2)
   {
    #ifdef NL
    printf("Welke optie?");
    #else
    printf("Which option?");
    #endif
    scanf("%20s", optstring); options=0;
    }
  else strcpy(optstring, argv[1]);



//1e SELECTIE
 if (!strcmp(optstring,"-V"))
    {printf(" bbcim %s (by whs)\n\n",VERSION); exit(0);
     }

 if (!strcmp(optstring,"-H"))
   {printf("Commando overzicht\n");
    printf(" -c diskbeeld            : toon bestanden in diskbeeld\n");

    printf(" -e[b/d,#,i,r] diskbeeld : bestanden uit diskbeeld halen\n");
    printf(" -a[r] diskbeeld {lijst} : bestanden in diskbeeld plaatsen\n");
    printf(" -d diskbeeld {lijst}    : verwijder bestanden uit diskbeeld\n");
    printf(" -40/-80/-max diskbeeld  : grootte van diskbeeld wijzigen\n");
    printf(" -min diskbeeld          : diskbeeld minimaliseren\n");
    printf(" -crc diskbeeld : bereken CRC's van bestanden in diskbeeld\n");

    printf(" -y {lijst} : archief bestanden bijwerken\n");
    printf(" -s[#] bestand : splits tekst bestand in .inf bestanden\n\n");
    printf(" -x {lijst} : archief bestanden omzetten naar xbeeb formaat\n");

    printf(" -icrc {lijst} : controleer CRC's van archief bestanden\n");
    printf(" -xcrc : controleer CRC's in xbeeb dir\n");

    printf(" -interss (sd,dd) B1 B2 B3 : enkelzijdig naar dubbelzijdig diskbeeld\n");
    printf(" -splitds (sd,dd) B : dubbelzijdig naar enkelzijdig diskbeeld\n");

    printf(" -ddos2dfs ddosbeeld : splits DDOS diskbeeld in DFS diskbeelden\n");

    printf(" -V : versie\n\n");

    exit(0);
    }

 if (!strcmp(optstring,"-interss")) {interss(argc, argv, options); exit(0);}
 if (!strcmp(optstring,"-splitds")) {splitds(argc, argv, options); exit(0);}
 if (!strcmp(optstring,"-ddos2dfs")) {ddos2dfs(argc, argv, options); exit(0);}
 if (!strcmp(optstring,"-d")) {del_from_im(argc, argv, options); exit(0);}
 if (!strcmp(optstring,"-s"))  {split_cat(argc, argv, options, optstring); exit(0);}
 if (!strcmp(optstring,"-x")) {xbeeb(argc, argv, options); exit(0);}
 if (!strcmp(optstring,"-y")) {cleanup(argc, argv, options); exit(0);}
 if (!strcmp(optstring,"-icrc")) {icrc(argc, argv, options); exit(0);}
 if (!strcmp(optstring,"-xcrc")) {xcrc(argc, argv, options); exit(0);}




//BEKIJK NU DE RESTERENDE OPTIES
  if (!strcmp(optstring,"-c"))	 {cat=1; bad_option=0;}

  if (!strncmp(optstring,"-e",2))
     {extr=1; bad_option=0;
      for (int i=2; i<strlen(optstring); i++)
        {switch (optstring[i])
          {case 'd' : extr_dir=1; break;
           case 'b' : bare=1; break;
           case 'i' : info=1; break;
           case '#' : no_bbc_dir=1; break;
           case 'r' : remove_disk_im=1; break;
           default : bad_option=1;
           }
         if (bare & extr_dir) {fprintf(stderr, "bd = slechte optie\n"); exit(1);}
         } //for
     }


  if (!strcmp(optstring,"-crc")) {bcrc=1; cat=1; bad_option=0;}
  if (!strcmp(optstring,"-40"))  {expand=40*10; bad_option=0;}
  if (!strcmp(optstring,"-80"))  {expand=80*10; bad_option=0;}
  if (!strcmp(optstring,"-max")) {expand=1023;  bad_option=0;}
  if (!strcmp(optstring,"-min")) {min=1; 	bad_option=0;}

  if (!strncmp(optstring,"-a", 2))
     {add=1; bad_option=0;
      for (int i=2; i<strlen(optstring); i++)
        {switch (optstring[i])
          {case 'r' : remove_file=1; break;
           default  : bad_option=1;
           }
         }
      }


  if (!strcmp(optstring,"-new")) {bad_option=0;}

//EINDE OPTIES

if (bad_option)
  {
   #ifdef NL
     printf("Slechte optie\n");
   #else
     printf("Bad option\n");
   #endif
   exit(1);
   }

 if ((argc-options)<2)
  {
   #ifdef NL
   printf("Naam van het bbc diskbeeld?");
   #else
   printf("Name of the bbc disk image?");
   #endif
   scanf("%50s", naam);
   } else strcpy(naam, argv[1+options]);
 strcpy(disk, naam);


//NU UITVOEREN VAN DE OPTIE:

//MAKE EMPTY DISKIMAGE..................
 if (!strcmp(optstring,"-new"))
    {new_diskim(disk, 800);
     exit(0);
     }


 strcpy(basisnaam, naam);
 basisnaam[strcspn(naam,".")]=0;
 strcpy(catalogus, basisnaam);
 strcat(catalogus,".cat");
 


 fpdisk=fopen(disk,"r");



//ADD FILES TO DISKIMAGE...............
//ALLEEN VOOR ADD HOEFT HET DISKBEELD NOG NIET TE BESTAAN
 if (add)
  {if (fpdisk==NULL)
     {new_diskim(disk, 800); //DEFAULT size=80 track

#ifdef NL
      printf("Nieuw diskbeeld gemaakt\n");
#else
      printf("New diskimage made\n");
#endif

      }
   else fclose(fpdisk);

   add_to_image(disk, options, argc,  argv, remove_file);
   exit(0);
  }
//EINDE ADDFILES..............



//VOOR ANDERE OPTIES MOET HET DISKBEELD BESTAAN
 if (fpdisk==NULL)
   {
    #ifdef NL
     printf("Bestand %s is niet te openen\n\n",disk);
    #else
     printf("File %s cannot be opened\n\n",disk);
    #endif
    exit(1);
    }

if (extr_dir){
#ifdef MAC
  strcpy(actie, ":"); //MIGHT NEED TO BE "volume:" where volume is ?
  strcat(actie, basisnaam);
  mkdir(basisnaam,0);}
#else
  strcpy(actie, "mkdir ");strcat(actie, basisnaam); system(actie);}
#endif


if (no_bbc_dir)
  {
#ifdef NL
 printf("geen bbc dir\n");
#else
 printf("no bbcdir\n");
#endif
   }



//EXPAND diskbeeld .................
if (expand) 
   {fclose(fpdisk);
    expand_im(disk,expand);
    exit(0);
    }

 


//CRC, CAT, EXTRACT, MIN ................

//Doe alleen iets als het diskbeeld meer dan 2 sectoren bevat.
 fseek(fpdisk,0L, SEEK_END);
 if (ftell(fpdisk)<512)
    {
     #ifdef NL
     printf("niets op het diskbeeld\n\n");
     #else
     printf("Nothing on the diskimage\n\n");
     #endif

     exit(1);
    }

//MINIMALISEER apart
 if (min) {fclose(fpdisk); min_diskim(disk); exit(0);}


//DISKNAAM BEPALEN (voor cat, crc, extract)
 fseek(fpdisk,0L,SEEK_SET);
 for (long i=0; i<8; i++)
   {fread (&byte,1,1,fpdisk);
    disknaam[i]=byte;
    if (byte==0) break;
    }
 fseek(fpdisk,256L,SEEK_SET);
 for (long i=0; i<4; i++)
   {fread (&byte,1,1,fpdisk);
    disknaam[i+8]=byte;
    if (byte==0) break;
    }






 fseek(fpdisk,256+5L,SEEK_SET);
 unsigned char files=0;
 fread(&files,1,1,fpdisk);

//SANITY CHECK ON DISKIMAGE:
 if (files % 8){
#ifdef NL
    printf("corrupt diskbeeld (bestand-aantal byte)\n"); exit(1);
#else
    printf("bad diskimage (fileno byte)\n"); exit(1);
#endif
  }

 int rfiles=files/8;
 #ifdef NL
  printf("aantal bestanden: %d\n",rfiles);
 #else
  printf("number of files: %d\n",rfiles);
 #endif

 fread(&byte,1,1,fpdisk);
 int bootoption=byte >> 4;
 H=byte & 3;
 fread(&byte,1,1,fpdisk);
 
unsigned int sectorsondisk=byte+H*256L;



 if (extr) fpcat=fopen(catalogus,"w"); else fpcat=stdout;
 #ifdef NL
 fprintf(fpcat,"\nDiskette :");
 fprintf(fpcat, disknaam);
 if (strlen(disknaam)==0) fprintf(fpcat, "(geen naam)");
 fprintf(fpcat,"\n");
 fprintf(fpcat,"%d sectoren op de diskette\n",sectorsondisk);
 #else
 fprintf(fpcat,"\nDisk :");
 fprintf(fpcat, disknaam);
 if (strlen(disknaam)==0) fprintf(fpcat, "(no name)");
 fprintf(fpcat,"\n");
 fprintf(fpcat,"%d sectors on disk\n",sectorsondisk);
 #endif

 #ifdef NL
  fprintf(fpcat, "bootoptie: ");
 #else
  fprintf(fpcat, "bootoption: ");
 #endif

 switch(bootoption)
   {case 0 :
      #ifdef NL
        fprintf(fpcat, "geen");
      #else
        fprintf(fpcat, "none");
      #endif
      break;
    case 1 : fprintf(fpcat, "*LOAD !BOOT");break;
    case 2 : fprintf(fpcat, "*RUN !BOOT");break;
    case 3 : fprintf(fpcat, "*EXEC !BOOT");
   }
 fprintf(fpcat,"\n");

#ifdef NL
 fprintf(fpcat, "Bestand    Laad   Exec  Lengte Access startsector\n");
#else
 fprintf(fpcat, "File       Load   Exec  Length Access startsector\n");
#endif

 //Hoofdlus: alle bestanden opzoeken.
 if (files>0)
  {
//VOOR MINIMALIZEREN:
//   if (min)
//    {fclose(fpdisk);
//     strcpy(backupnaam, disk);strcat(backupnaam,"%");

//     remove(backupnaam);
//     rename(disk,backupnaam);

//     fpdisk=fopen(backupnaam,"r");
//     fpdisk2=fopen(disk,"w");


//     for(long i=0;i<512;i++)
//      {fread (&byte,1,1,fpdisk);
//       fwrite (&byte,1,1,fpdisk2);
//       }

//     }
//EINDE INITIALISATIE VOOR MIN (COMPACT)

//   long startsector2=2;


   for(long file=0;file<files; file +=8)
    {

    strcpy(extract, basisnaam);
    if (extr_dir) strcat(extract,"/"); else strcat(extract,".");
    if (bare) strcpy(extract, "");

    char bbcfilenaam[20];
    fseek(fpdisk,file+15L,SEEK_SET);
    fread(&byte,1,1,fpdisk);
    int locked=byte >>7;
    bbcfilenaam[0]=(byte & 0x7F);
    bbcfilenaam[1]='.';
    

    fseek(fpdisk,file+8L,SEEK_SET);
    for(int i=0; i<7; i++)
      {fread(&byte,1,1,fpdisk);
       bbcfilenaam[i+2]=byte;
       }
    bbcfilenaam[9]=0;

//printf("bbc bestand :%s\n",bbcfilenaam);

    //load/exec  adressen + lengte bepalen.
    fseek(fpdisk,256+file+14,SEEK_SET);
    unsigned char eellddss;
    fread(&eellddss,1,1,fpdisk);

    //STARTSECTOR
    fread(&byte,1,1,fpdisk);
    long startsector=byte+(eellddss & 3)*256L;

//SANITY CHECK ON DISKIMAGE? (startsec>1 BUT DISALLOWS DDOS DIR OF VOL 0A
//WITH STANDARD DFS ROUTINES.

//printf("\nstartsector %d\n", startsector);

    //LOADADDRESS
    fseek(fpdisk,file+256L+8L,0);
    fread(&byte,1,1,fpdisk);
    fread(&H,1,1,fpdisk);
    long loadaddress=H*256L+byte+(eellddss & 0x0C)*16384L;
    if (loadaddress & 0x30000) loadaddress |=0xFF0000;

    //EXECADDRESS
    fread(&byte,1,1,fpdisk);
    fread(&H,1,1,fpdisk);
    long execaddress=int(H)*256+byte+int(eellddss & 0xC0)*4L*256L;
    if (execaddress & 0x30000) execaddress |=0xFF0000;

    //FILELENGTE
    fread(&byte,1,1,fpdisk);
    fread(&H,1,1,fpdisk);
    long length=H*256L+byte+(eellddss & 0x30)*16L*256L;

    filesizesum +=length;


    //UITVOER VAN DEZE GEGEVENS NAAR CATALOGUS
    fprintf(fpcat,bbcfilenaam);
    fprintf(fpcat," %6X %6X %6X",loadaddress,execaddress,length);
    if (locked) fprintf(fpcat," Locked");
      else fprintf(fpcat,"       "); //VOOR CRC UITLIJNEN

//    fprintf(fpcat,"\n");

    char bbc8filenaam[20];
    strcpy(bbc8filenaam, bbcfilenaam);



//spaties aan het einde van extract weghalen: geeft anders bestands namen met
//spaties (in linux).
    int i=8;
    while (bbcfilenaam[i]==' ') i--;
    bbcfilenaam[i+1]=0;

    if (no_bbc_dir)
      {if (bbcfilenaam[0]=='$') strcat(extract,bbcfilenaam+2);
       else {bbcfilenaam[1]=bbcfilenaam[0];
             strcat(extract,bbcfilenaam+1);}
      }
    else strcat(extract,bbcfilenaam);


    if (extr)
      {

//NAME CHECK:
       char nieuwe_naam[55]; strcpy(nieuwe_naam, extract);
       if ((fpextract=fopen(extract, "r"))!=NULL){
         fclose(fpextract);
         int antwoord=overschrijf_vraag(extract, nieuwe_naam);

         switch(antwoord){
//1. OVERSCHRIJVEN:
           case 1: break;
//2. NIEUWE BESTAND HERNOEMEN:
           case 2: strcpy(extract, nieuwe_naam); break;
//3. BESTAANDE BESTAND HERNOEMEN:
           case 3: rename(extract, nieuwe_naam);
//altijd ook info bestand hernoemen:
                   strcpy(infofile, extract); strcat(infofile, ".inf");
                   strcat(nieuwe_naam, ".inf"); rename(infofile, nieuwe_naam);
                   break;
//4. OVERSLAAN:
           case 4: continue; }//for

       }
//END NAME CHECK


       fpextract=fopen(extract, "w");

       fseek(fpdisk,startsector*256, SEEK_SET);
       for (i=0; i<length; i++)
         {fread(&byte,1,1,fpdisk);
          if (feof(fpdisk)) 
           {
            #ifdef NL
               {printf("onverwacht einde van het diskbeeld" \
               " bij bestand %s\n\n", bbcfilenaam);}
            #else
               {printf("unexpected end of the diskimage" \
               " at file %s\n\n", bbcfilenaam);}
            #endif
            exit(1);
            }
           fwrite(&byte,1,1,fpextract);
          }
         fclose(fpextract);
        }


      if (info)
         {strcpy(infofile, extract);
          strcat(infofile, ".inf");

          fpinfo=fopen(infofile, "w");

//Evt volgende regel weg. (FILENAAM, bv $.ELITE)
          fprintf(fpinfo,bbc8filenaam);

//CHANGED, I no longer automatically include file length in the INFO file.
//          fprintf(fpinfo," %6X %6X %6X",loadaddress,execaddress,length);
          fprintf(fpinfo," %6X %6X",loadaddress,execaddress);

          if (locked) fprintf(fpinfo," Locked");

          } //N.B. info bestand wordt in crc deel gesloten


      unsigned int crc=0;
      if (bcrc || info)
        {fseek(fpdisk,startsector*256, SEEK_SET);
//         unsigned int crc=0;
         for (i=0; i<length; i++)
          {fread(&byte,1,1,fpdisk);
           if (feof(fpdisk)) 
            {
             #ifdef NL
               {printf("onverwacht einde van het diskbeeld" \
               " bij bestand %s\n\n", bbcfilenaam);}
             #else
               {printf("unexpected end of the diskimage" \
               " at file %s\n\n", bbcfilenaam);}
             #endif
             exit(1);
             }

            crc ^=(byte << 8);
            for(int k=0;k<8;k++)
             {if (crc & 32768) crc=(((crc ^ 0x0810) & 32767) << 1)+1;
                else crc =crc <<1;
              }
           }

         if (info) {fprintf(fpinfo, " CRC= %04X", crc); fclose(fpinfo);}

         }

       fprintf(fpcat,"  %4d", startsector);
       if (bcrc) fprintf(fpcat, "       CRC= %04X\n", crc); else fprintf(fpcat, "\n");

//     fprintf(fpcat,"\n");


//      if (min)
//        {
//nieuwe startsector
//         fseek(fpdisk2,256+file+14,SEEK_SET);
//         eellddss =(eellddss & 0xFC)+(startsector2>>8);
//         fwrite(&eellddss,1,1,fpdisk2);
//         byte=startsector2 & 0xFF;
//         fwrite(&byte,1,1,fpdisk2);
//
//
//         fseek(fpdisk,startsector*256, SEEK_SET);
//         fseek(fpdisk2,startsector2*256, SEEK_SET);
//         for (i=0; i<((length+255)>>8)*256; i++)
//         {fread(&byte,1,1,fpdisk);
//          if (feof(fpdisk)) 
//           {
//             #ifdef NL
//               {printf("onverwacht einde van het diskbeeld" \
//               " bij bestand %s\n\n", bbcfilenaam);}
//             #else
//               {printf("unexpected end of the diskimage" \
//               " at file %s\n\n", bbcfilenaam);}
//             #endif
//             exit(1);
//             }
//           fwrite(&byte,1,1,fpdisk2);
//            }
//        startsector2=startsector2+((length+255)>>8);
//       }

   }
 #ifdef NL
  fprintf(fpcat,"\n%d bestand", rfiles);
  if (rfiles !=1) fprintf(fpcat,"en");
 #else
  fprintf(fpcat,"\n%d file", rfiles);
  if (rfiles !=1) fprintf(fpcat,"s");
 #endif
  fprintf(fpcat,"\n");


   fclose(fpdisk);
   if (remove_disk_im) remove(disk);



 }
 #ifdef NL
  fprintf(fpcat,"Totaal %d bytes\n", filesizesum);
 #else
  fprintf(fpcat,"Total %d bytes\n", filesizesum);
 #endif


return 0;
}
