/*******************************************************************************************

      keys.c

      (C) 1992,97 MHG


*******************************************************************************************/
#include <i86.h>
#include <dos.h>
#include "keys.h"
/*******************************************************************************************


      DATA


*******************************************************************************************/
static void interrupt (far *old_int9)(void)=0;
char  keyx[256];
/*******************************************************************************************


      EXTERNALS


*******************************************************************************************/
extern unsigned char  *keytail;
extern unsigned char  *keyhead;
extern   char         *keybuff;
/*******************************************************************************************


      Interrupt


*******************************************************************************************/
void interrupt key_handler(void)
{
   register char key;
   unsigned char p;
   unsigned char scan;

   scan = inp(0x60);

   key=inp(0x61);
   outp(0x61, (key| 0x80));
   outp(0x61, key);

   outp(0x20,0x20);

   if (scan & 0x80)
	{
      keyx[scan&0x7f] = 0;
	}
  	else
   {
      keyx[scan&0x7f] = 1;
   }

   p=*keytail;
   p++;
   p&=255;
   keybuff[p]=scan;
   *keytail=p;
}
/*******************************************************************************************


      Install


*******************************************************************************************/
void install_keyboard_interrupt(void)
{
  int i;

  for (i=0; i<128; i++)
      keyx[i]=0;

  _disable();

  old_int9 = _dos_getvect(9);

  _dos_setvect(9,key_handler);

  _enable();
}
/*******************************************************************************************


      Remove


*******************************************************************************************/
void remove_keyboard_interrupt(void)
{
  _disable();

  if (old_int9)
    _dos_setvect(9,old_int9);

  _enable();
}


