
/*
 *main.c -- Globals and emulation setup for Apple ][ Emulator
 *(C) 1989 Ben Koning [556498717 408/738-1763 ben@apple.com]
 */

#include "apple.h"
#include <curses.h>
#define REF_DELAY 2000

main (argc,argv)

int	argc;
char	*argv [];

{
  short int byte;
  int i, addr;                  /* Loop iterators */
  int refdelay = REF_DELAY;
  FILE *fp;
  char *R80FILE = "basic.bbc",
       *RC0FILE = "os.bbc",
       *RFFFILE = "ff00.bbc" ;
  
  /* Interpret args: 'invokename [-t] [-m] [-i]' */
  for (i = 1;   i <= argc-1;   i++)
  {
    if (!strcmp (argv [i],"-t"))
      DebugSingle = 1;
    else
    {
	(void)fprintf (stderr,"Usage: %s [-t] [-m] [-i]\n",
		argv [0]);
	exit (1);
    }
  }
  
  /* Print banner message: */
  (void)fprintf (stderr,"\nBBC Emulation 32K\n\n");

  /*--------------------------------------------------*\
    Load the 'ROM' with the appropriate 6502 code:
  \*--------------------------------------------------*/ 
  fp = fopen (R80FILE, "r");
  if(fp==NULL)
  	{
	puts("Can't open 8000 File");
	exit(-1);
	}
  for (addr = 0x8000;   addr <= 0xBfff;   addr++)
    Rom [addr - 0x8000] = fgetc (fp);
  (void)fclose (fp);

  fp = fopen (RC0FILE, "r");
    if(fp==NULL)
  	{
	puts("Can't open C000 File");
	exit(-1);
	}
  for (addr = 0xc000;   addr <= 0xfeff;   addr++)
    Rom [addr - 0x8000] = fgetc (fp);
  (void)fclose (fp);

  fp = fopen (RFFFILE, "r");
    if(fp==NULL)
  	{
	puts("Can't open FF00 File");
	exit(-1);
	}
  for (addr = 0xFF00;   addr <= 0xffff;   addr++)
    Rom [addr - 0x8000] = fgetc (fp);
  (void)fclose (fp);


MMemory[0x003b]=0xff;

MMemory[0x0000]=0x02 ;

/* Vectors */
MMemory[0x200]=0x10 ;
MMemory[0x201]=0xe3 ;
MMemory[0x202]=0x54 ;
MMemory[0x203]=0xdc ;
MMemory[0x204]=0x93 ;
MMemory[0x205]=0xdc ;
MMemory[0x206]=0x89 ;
MMemory[0x207]=0xde ;
MMemory[0x208]=0x89 ;
MMemory[0x209]=0xdf ;
MMemory[0x20a]=0x72 ;
MMemory[0x20b]=0xe7 ;
MMemory[0x20c]=0xeb ;
MMemory[0x20d]=0xe7 ;
MMemory[0x20e]=0xa4 ;
MMemory[0x20f]=0xe0 ;
MMemory[0x210]=0xc5 ;
MMemory[0x211]=0xde ;
MMemory[0x212]=0x7d ;
MMemory[0x213]=0xf2 ;
MMemory[0x214]=0x8e ;
MMemory[0x215]=0xf1 ;
MMemory[0x216]=0xc9 ;
MMemory[0x217]=0xf4 ;
MMemory[0x218]=0x29 ;
MMemory[0x219]=0xf5 ;
MMemory[0x21a]=0xa6 ;
MMemory[0x21b]=0xff ;
MMemory[0x21c]=0xca ;
MMemory[0x21d]=0xf3 ;
MMemory[0x21e]=0xb1 ;
MMemory[0x21f]=0xf1 ;
MMemory[0x220]=0xa6 ;
MMemory[0x221]=0xff ;
MMemory[0x222]=0xa6 ;
MMemory[0x223]=0xff ;
MMemory[0x224]=0xa6 ;
MMemory[0x225]=0xff ;
MMemory[0x226]=0xa6 ;
MMemory[0x227]=0xff ;
MMemory[0x228]=0x02 ;
MMemory[0x229]=0xef ;
MMemory[0x22a]=0xb3 ;
MMemory[0x22b]=0xe4 ;
MMemory[0x22c]=0x64 ;
MMemory[0x22d]=0xe4 ;
MMemory[0x22e]=0xd1 ;
MMemory[0x22f]=0xe1 ;
MMemory[0x230]=0xa6 ;
MMemory[0x231]=0xff ;
MMemory[0x232]=0xa6 ;
MMemory[0x233]=0xff ;
MMemory[0x234]=0xa6 ;
MMemory[0x235]=0xff ;

/* initialize for Basic */
MMemory[0x1900]=0xa2 ;
MMemory[0x1901]=0x07 ;
MMemory[0x1902]=0xa0 ;
MMemory[0x1903]=0x19 ;
MMemory[0x1904]=0x20 ;
MMemory[0x1905]=0xf7 ;
MMemory[0x1906]=0xff ;
MMemory[0x1907]=0x42 ;
MMemory[0x1908]=0x41 ;
MMemory[0x1909]=0x53 ;
MMemory[0x190a]=0x49 ;
MMemory[0x190b]=0x43 ;
MMemory[0x190c]=0x0d ;


/* TestRoutine 
MMemory[0x1900]=0xa9 ;
MMemory[0x1901]=66 ;
MMemory[0x1902]=0x20 ;
MMemory[0x1903]=0xe3 ;
MMemory[0x1904]=0xff ;
MMemory[0x1905]=0xa9 ;
MMemory[0x1906]=0xd ;
MMemory[0x1907]=0x20 ;
MMemory[0x1908]=0xe3 ;
MMemory[0x1909]=0xff ;
MMemory[0x190a]=0xff ;
*/

/* OsRdch routine */
Rom[0xdec5-0x8000]=0xd4 ;
Rom[0xdec6-0x8000]=0xe0 ;
Rom[0xdec7-0x8000]=0x60 ;


/* OsWrch routine */
Rom[0xe0a4-0x8000]=0xd4 ;
Rom[0xe0a5-0x8000]=0xee ;
Rom[0xe0a6-0x8000]=0x60 ;

/*OsWord routine */
Rom[0xe7eb-0x8000]=0xd4 ;
Rom[0xe7ec-0x8000]=0xf1 ;
Rom[0xe7ed-0x8000]=0x60 ;

/*OsByte routine */
Rom[0xe772-0x8000]=0xd4 ;
Rom[0xe773-0x8000]=0xf4 ;
Rom[0xe774-0x8000]=0x60 ;

/*OsFsc routine */
Rom[0xf1b1-0x8000]=0xd4 ;
Rom[0xf1b2-0x8000]=0x1e ;
Rom[0xf1b3-0x8000]=0x60 ;

/* OsFile Routine */
Rom[0xf27d-0x8000]=0xd4 ;
Rom[0xf27e-0x8000]=0xdd ;
Rom[0xf27f-0x8000]=0x60 ;

/* IRQ1 Routine */
Rom[0xdc93-0x8000]=0xd4 ;
Rom[0xdc94-0x8000]=0xfe ;
Rom[0xdc95-0x8000]=0x60 ;

/* IRQ2 Routine */
Rom[0xde89-0x8000]=0xd4 ;
Rom[0xde8a-0x8000]=0xff ;
Rom[0xde8b-0x8000]=0x40 ;

/* Start address */
Rom[0xfffc-0x8000]=0x00 ;
Rom[0xfffd-0x8000]=0x19 ;

/* Interupt address */
/*
Rom[0xfffe-0x8000]=0x02 ;
Rom[0xffff-0x8000]=0xb4 ;
  */
  /* Initialize the emulation: */
  MegaStartUp ();
  CPUReset ();
  
  /*--------------------------------------------------*\
    Run it until user wants to quit:
  \*--------------------------------------------------*/
  while (!MegaQuitDetect)
  {
    CPUExecute ();
    if(DebugSingle)
	DebugDisasm (stdout);

    if (MegaQuitDetect  || DebugTrace)
      Debugger();
  }
  
  /* Exit cleanly: */
  MegaShutDown ();
  exit (0);
}



