/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	assert.h,v $
 * Revision 4.2.2.2  92/03/27  15:20:37  Craig_Horman
 * 	Merge with AG
 * 	[92/03/27  13:50:02  Craig_Horman]
 * 
 * 	Merge with BL5
 * 	[92/03/09  14:44:28  Craig_Horman]
 * 
 * 	Added C++ Support
 * 	[92/02/26  14:32:07  Craig_Horman]
 * 
 * Revision 4.2  91/09/20  05:13:38  devbld
 * 	Adding ODE Headers
 * 
 * $EndLog$
 */
/*	
 *	@(#)$RCSfile: assert.h,v $ $Revision: 4.2.2.2 $ (DEC) $Date: 92/03/27 15:20:37 $
 */ 
/*
 */
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/*
 * OSF/1 Release 1.0
 */
/*
 * assert.h
 *
 *	Modification History:
 *
 * 01-Apr-91	Fred Canter
 *	MIPS C 2.20+, changes for -std
 *
 */

/*
 * COMPONENT_NAME: (SYSDB) Kernel Debugger
 *
 * FUNCTIONS:
 *
 *
 * ORIGINS: 27
 *
 * (C) COPYRIGHT International Business Machines Corp. 1988, 1990
 * All Rights Reserved
 * Licensed Materials - Property of IBM
 *
 * US Government Users Restricted Rights - Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 * 
 * assert.h	1.10  com/inc,3.1,9021 5/11/90 10:03:55 
 */

#ifndef _ASSERT_H_
#define _ASSERT_H_
#include <standards.h>

/*
 *
 *      The ANSI standard requires that certain values be in assert.h.
 *      It also requires that if _ANSI_C_SOURCE is defined then ONLY these
 *      values are present.  This header includes all ANSI required entries.  
 *
 */
#ifdef _ANSI_C_SOURCE

#ifdef NDEBUG
#define assert(ignore) ((void)0)
#else
#if defined(__STDC__) || defined(__cplusplus)
#if defined(__cplusplus)
extern "C" {
#endif
extern void __assert(char *assertion, char *filename, int line_num);
#if defined(__cplusplus)
}
#endif
#else  /* __STDC__ */
extern void __assert();
#endif /* _NO_PROTO */

#if defined(__STDC__) || defined(__cplusplus)
#define assert(EX) (void) ((##EX) ? 0 : (__assert(# EX , __FILE__, __LINE__),1))
#else
#define assert(EX) if (EX) ; else __assert("EX", __FILE__, __LINE__)
#endif /* __STDC__*/

#endif /* NDEBUG */
#endif /* _ANSI_C_SOURCE */
#endif /* _ASSERT_H_ */
