/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	fstab.h,v $
 * Revision 4.2  91/09/20  05:14:59  devbld
 * Adding ODE Headers
 * 
 * $EndLog$
 */
/*	
 *	@(#)$RCSfile: fstab.h,v $ $Revision: 4.2 $ (DEC) $Date: 91/09/20 05:14:59 $
 */ 
/*
 */
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/*
 * OSF/1 Release 1.0
 */
/*
 * Copyright (c) 1980 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the University of California, Berkeley.  The name of the
 * University may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 *	@(#)fstab.h	3.1 (Berkeley) 2/26/91
 */

#ifndef _FSTAB_H_
#define _FSTAB_H_
/*
 * File system table, see fstab(5).
 *
 * Used by dump, mount, umount, swapon, fsck, df, ...
 *
 * The fs_spec field is the block special name.  Programs that want to use
 * the character special name must create that name by prepending a 'r'
 * after the right most slash.  Quota files are always named "quotas", so
 * if type is "rq", then use concatenation of fs_file and "quotas" to locate
 * quota file.
 */
#define	_PATH_FSTAB	"/etc/fstab"
#define	FSTAB		"/etc/fstab"	/* deprecated */

#define	FSTAB_RW	"rw"		/* read/write device */
#define	FSTAB_RQ	"rq"		/* read/write with quotas */
#define	FSTAB_RO	"ro"		/* read-only device */
#define	FSTAB_SW	"sw"		/* swap device */
#define	FSTAB_XX	"xx"		/* ignore totally */

struct fstab {
	char	*fs_spec;		/* block special device name */
	char	*fs_file;		/* file system path prefix */
	char	*fs_type;		/* FSTAB_* */
	int	fs_freq;		/* dump frequency, in days */
	int	fs_passno;		/* pass number on parallel dump */
	char	*fs_vfstype;		/* File system type, ufs, nfs */
	char	*fs_mntops;		/* Mount options ala -o */
};

#ifdef _NO_PROTO
struct	fstab *getfsent();
struct	fstab *getfsspec();
struct	fstab *getfsfile();
int	setfsent();
int	endfsent();
#if defined(_REENTRANT) || (_THREAD_SAFE)
int     getfsent_r();
int     getfsspec_r();
int     getfsfile_r();
#endif
#else
extern struct fstab *getfsent(void);
extern struct fstab *getfsspec(const char*);
extern struct fstab *getfsfile(const char*);
extern int setfsent(void);
extern int endfsent(void);
#if defined(_REENTRANT) || (_THREAD_SAFE)
extern int getfsent_r(struct fstab *, char*);
extern int getfsspec_r(const char *, struct fstab *, char*);
extern int getfsfile_r(const char *, struct fstab *, char*);
#endif
#endif	/* _NO_PROTO */
#endif	/* _FSTAB_H_ */
