/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	pwd.h,v $
 * Revision 4.2.2.3  92/04/10  11:16:25  Stephen_Strange
 * 	POSIX compliance changes for ISO 9945-1 (1990)
 * 	[92/03/30  18:16:32  Stephen_Strange]
 * 
 * Revision 4.2.2.2  92/03/27  15:28:47  Craig_Horman
 * 	Merge with AG
 * 	[92/03/27  14:03:57  Craig_Horman]
 * 
 * 	Merge with BL5
 * 	[92/03/10  11:57:53  Craig_Horman]
 * 
 * 	Added C++ Support
 * 	[92/02/26  16:47:23  Craig_Horman]
 * 
 * Revision 4.2  91/09/20  05:18:32  devbld
 * 	Adding ODE Headers
 * 
 * $EndLog$
 */
/*	
 *	@(#)$RCSfile: pwd.h,v $ $Revision: 4.2.2.3 $ (DEC) $Date: 92/04/10 11:16:25 $
 */ 
/*
 */
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */

/*
 * COMPONENT_NAME: pwd.h
 *                                                                    
 * Copyright International Business Machines Corp. 1985, 1988
 * All Rights Reserved
 * Licensed Material - Property of IBM
 *
 * RESTRICTED RIGHTS LEGEND
 * Use, Duplication or Disclosure by the Government is subject to
 * restrictions as set forth in paragraph (b)(3)(B) of the Rights in
 * Technical Data and Computer Software clause in DAR 7-104.9(a).
 */                                                                   
/*
 * OSF/1 Release 1.0
 */

#ifndef _PWD_H_
#define _PWD_H_

#include <standards.h>
#include <sys/types.h>

/* The POSIX standard requires that certain elements be included in pwd.h. 
 * It also requires that when _POSIX_SOURCE is defined, only those standard
 * specific elements are made available.
 * This header includes all the POSIX required entries.
 */

#ifdef _POSIX_SOURCE

#ifdef _NO_PROTO

	extern struct passwd *getpwuid();
	extern struct passwd *getpwnam();

/* _POSIX_REENTRANT_FUNCTIONS */
#if defined(_THREAD_SAFE) || defined(_REENTRANT)
	extern int getpwuid_r();
	extern int getpwnam_r();
#endif

#else /* _NO_PROTO */
#if defined(__STDC__) || defined(__cplusplus)
#if defined(__cplusplus)
extern "C"
{
#endif

	extern struct passwd *getpwuid(uid_t );
	extern struct passwd *getpwnam(const char *);

/* _POSIX_REENTRANT_FUNCTIONS */
#if defined(_THREAD_SAFE) || defined(_REENTRANT)
	extern int getpwuid_r(uid_t, struct passwd *, char *, int);
	extern int getpwnam_r(char *, struct passwd *, char *, int);
#endif

#if defined(__cplusplus)
}
#endif
#endif
#endif /* _NO_PROTO */

struct passwd {
	char	*pw_name;
	char	*__pw_passwd;
	uid_t	pw_uid;
	gid_t	pw_gid;
        int     __pw_quota;
        char    *__pw_comment;
	char    *__pw_gecos;
	char	*pw_dir;
	char	*pw_shell;
};

#ifdef _OSF_SOURCE
#define pw_passwd __pw_passwd
#define pw_quota __pw_quota
#define pw_comment __pw_comment
#define pw_gecos __pw_gecos
#endif /* _OSF_SOURCE */
#endif /* _POSIX_SOURCE */

#ifdef _OSF_SOURCE 

#define pw_etc pw_gecos

#ifdef _NO_PROTO

extern struct passwd *getpwent();
extern void setpwent();
extern void endpwent();
extern void setpwfile();

/* _POSIX_REENTRANT_FUNCTIONS */
#if defined(_THREAD_SAFE) || defined(_REENTRANT)
extern int  getpwent_r();
#endif

#else /* _NO_PROTO */
#if defined(__STDC__) || defined(__cplusplus)
#if defined(__cplusplus)
extern "C"
{
#endif

extern struct passwd *getpwent (void);
extern void setpwent (void);
extern void endpwent (void);
extern void setpwfile (const char*);

/* _POSIX_REENTRANT_FUNCTIONS */
#if defined(_THREAD_SAFE) || defined(_REENTRANT)
extern int  getpwent_r(struct passwd *, char *, int);
#endif

#if defined(__cplusplus)
}
#endif
#endif
#endif  /* _NO_PROTO */

#endif /* _OSF_SOURCE */ 

#endif /* _PWD_H_ */
