/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	utime.h,v $
 * Revision 4.2.2.3  92/04/10  11:16:42  Stephen_Strange
 * 	POSIX compliance changes for ISO 9945-1 (1990)
 * 	[92/03/30  18:16:48  Stephen_Strange]
 * 
 * Revision 4.2.2.2  92/03/27  15:38:33  Craig_Horman
 * 	Merge with AG
 * 	[92/03/27  14:10:02  Craig_Horman]
 * 
 * 	Merge with BL5
 * 	[92/03/10  12:06:06  Craig_Horman]
 * 
 * 	Added C++ Support
 * 	[92/02/26  17:43:44  Craig_Horman]
 * 
 * Revision 4.2  91/09/20  05:19:40  devbld
 * 	Adding ODE Headers
 * 
 * $EndLog$
 */
/*	
 *	@(#)$RCSfile: utime.h,v $ $Revision: 4.2.2.3 $ (DEC) $Date: 92/04/10 11:16:42 $
 */ 
/*
 */
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/*
 * OSF/1 Release 1.0
 */
/*
 * RESTRICTED RIGHTS LEGEND
 * Use, Duplication or Disclosure by the Government is subject to
 * restrictions as set forth in paragraph (b)(3)(B) of the rights in
 * Technical Data and Computer Software clause in DAR 7-104.9(a).
 */ 

/*
 * COMPONENT_NAME: (CMDFS) commands that deal with the file system
 *
 * FUNCTIONS: 
 *
 * ORIGINS: 27
 *
 * (C) COPYRIGHT International Business Machines Corp. 1985, 1989
 * All Rights Reserved
 * Licensed Materials - Property of IBM
 *
 * US Government Users Restricted Rights - Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 */

#ifndef _UTIME_H_
#define _UTIME_H_

#include <standards.h>
#include <sys/types.h>

/*
 * POSIX requires that certain values be included in utime.h.  It also
 * requires that when _POSIX_SOURCE is defined only those standard
 * specific values are present.  This header includes all the POSIX
 * required entries.
 */

#ifdef _POSIX_SOURCE

struct utimbuf {
	time_t	actime;			/* access time */
	time_t	modtime;		/* modification time */
	};

#ifdef _NO_PROTO
extern int utime();
#else
#if defined(__STDC__) || defined(__cplusplus)
#if defined(__cplusplus)
extern "C"
{
#endif
extern int utime(const char *, const struct utimbuf *); 
#if defined(__cplusplus)
}
#endif
#endif
#endif /* _NO_PROTO */

#endif /* _POSIX_SOURCE */
#endif /* _UTIME_H_ */
