/*
	ide.c
	routines to talk to a isa bus ide controller
*/


struct ideparam {
	short ip_conf;
	short ip_fcyl;
	short ip_rcyl;
	short ip_nhd;
	short ip_ubpt;
	short ip_ubps;
	short ip_sec;
	short ip_minsg;
	short ip_minpa;
	short ip_nvendst;
	char  ip_serno[20];
	short ip_type;
	short ip_secbufsz;
	short ip_necc;
	char ip_rev[8];
	char ip_model[40];
	short ip_nsecpint;
	short ip_longw;
};

/* status register defines */
#define	SBSY	0x80
#define	SRDY	0x40
#define SWF	0x20
#define SSC	0x10
#define SDRQ	0x08
#define SDWC	0x04
#define SINDX	0x02
#define SERR	0x01

/* error register defines */
#define EBB	0x80
#define ECRC	0x40
#define EIDNF	0x10
#define EAC	0x04
#define ETK0	0x02
#define EDMNF	0x01


#define TRACE(x)	/* x */
#define DEBUG(x)	/* x */

#define IDE(n)  (0x1f0+n)
#define AIDE(n)	(0x206+n)

#define SWAB(x)	((((x)&0xff00) >> 8) | (((x)&0xff)<<8))

static struct ideparam ip;
static int idestat;

ide_init(u)
int u;
{
int i;
long offset;
long size;

	outp(IDE(4),0xa5);
	if(inp(IDE(4)) != 0xa5)
		return(-1);

	/* restore */
	if(ide_cmd(u,0x10,0,0,0,(long)0,0)<0)
		return(-1);

	/* read parameter page */
	if(ide_cmd(u,0xec,0,0,0,&ip,(int)sizeof(ip))<0)
		return(-1);

	printf("ide_init: cyl %d hd %d sec %d\n",
		SWAB(ip.ip_fcyl) + SWAB(ip.ip_rcyl),
		SWAB(ip.ip_nhd),
		SWAB(ip.ip_sec)
		);

	return(0);
}

ide_rw(un,rw,blk,buf,len)
int un,rw;
unsigned long blk;
char *buf;
int len;
{
unsigned long trk;
int hd,cy,se;

	trk = blk / SWAB(ip.ip_sec);	/* which track */
	cy = trk / SWAB(ip.ip_nhd);	/* cylinder */
	hd = trk % SWAB(ip.ip_nhd);	/* which head */
	se = (blk % SWAB(ip.ip_sec)) + 1;

	len = (len > 512) ? 512: len;

	if(rw)
		return(ide_cmd(un,0x30,hd,cy,se,buf,len));
	else
		return(ide_cmd(un,0x20,hd,cy,se,buf,len));
}

ide_cmd(un,cmd,hd,cy,se,buf,len)
int un,cmd,hd,cy,se;
short *buf;
int len;
{
int i,s,st;
	TRACE(printf("ide_cmd: cmd %x hd %x cy %x se %x buf %X len %x\n",
		cmd,hd,cy,se,buf,len));

	/* busy ? */
	while(((st=inp(IDE(7)) & (SBSY|SRDY))) != SRDY) ;

	outp(IDE(2),len/512);	/* sec count */
	TRACE(printf("cnt %x ",len/512));

	outp(IDE(3),se);	/* sector */
	TRACE(printf("sec %x ",se));

	outp(IDE(4),cy&0xff);	/* cylinder low byte */
	TRACE(printf("cyl lsb %x ",cy&0xff));

	outp(IDE(5),cy>>8);	/* cylinder high byte */
	TRACE(printf("cyl msb %x ",cy>>8));

	outp(IDE(6),0xa0 | (un <<4) | (hd & 0xf) ); /* secsize,unit,head */
	TRACE(printf("sdh %x ",0xa0 | (un <<4) | (hd & 0xf)));

	/* wait for drive to become ready */
	while(!(inp(IDE(7)) & SRDY)) ;

	outp(IDE(7),cmd);	/* command */
	TRACE(printf("cmd %x ",cmd));

	/* do a write */
	if(cmd == 0x30){
		/* wait for drive to accept data */
		while(!(inp(IDE(7)) & SDRQ)) ;
		len = len / 2;
		i = 0;
		while(i < len){
			outpw(IDE(0),*buf++);
			i++;
		}
		i = i*2;
		/* should we wait for the completion of the write here ??? */
		if((st = inp(IDE(7))) & SBSY){
			while((st = inp(IDE(7))) & SBSY) ; 
		}
		if(st & 0x01) {		/* an error occured */
			printf("ide_cmd: Error status %x error %x\n",st,inp(IDE(1)));
			return(-1);
		}
	}else{
		if((st = inp(IDE(7))) & SBSY){
			while((st = inp(IDE(7))) & SBSY) ; 
		}

		if(st & 0x01) {		/* an error occured */
			printf("ide_cmd: Error status %x error %x\n",st,inp(IDE(1)));
			return(-1);
		}
		i = st;
		if(len){
			/* is drive ready to send data ? */
			while(!(inp(IDE(7)) & SDRQ)) ;

			len = len / 2;
			i = 0;
			while(i < len){
				*buf++ = inpw(IDE(0));
				i++;
			}
			i = i*2;
		}
	}
	if(inp(IDE(7)) & SDRQ)
		TRACE(printf("DRQ still active "));

	TRACE(printf("returns %x\n",i));
	return(i);
}
