#include "addr.h"
#define KBD	(unsigned char *)(AD_MFP)

#include "scancodes.h"

static int caps,ctrl,alt,shft;

kbd_getc()
{
unsigned char c;

	while(!(c=kbd_stat()))
		;
	return(c);
}
kbd_stat()
{
unsigned char *port = KBD;
unsigned char x,ox;
extern struct codetab codetab[];
static int brk=0;

	if(!(port[0x15] & 0x80))
		return(0);

	x = port[0x17];

	if(x == SC_BREAK){
		brk = 1;
		return(0);
	}
	if(x > 0x7f){
		brk = 0;
		return(0);
	}
	if(brk){
		brk = 0;
		ox = codetab[x].code;
		switch(ox){
			case CC_LSHFT:
			case CC_RSHFT:
				shft = 0; break;
			case CC_CTRL:
				ctrl = 0; break;
			default:
				/* other release codes */
				break;
		}
		return(0);
	}
	ox = codetab[x].code;
	switch(ox){
		case CC_LSHFT:
		case CC_RSHFT:
			shft = 1; break;
		case CC_CTRL:
			ctrl = 1; break;
		case CC_CAPS:
			caps = caps?0:1; break;
		default:
			if(ctrl)
				return(codetab[x].cchar);
			if(shft || caps)
				return(codetab[x].schar);
			return(codetab[x].uchar);
	}
	return(0);
}
kbd_init()
{
unsigned char *port = KBD;

	port[0x14] = 0x0c; /*0x14;	/* UCR 1 stop */
	port[0x15] = 0x01;	/* RSR RE enabled */

	caps = 0;
	ctrl = 0;
	alt = 0;
	shft = 0;
}
kbd_in()
{
unsigned char *port = KBD;
unsigned char x,ox;

	while(!((x = port[0x15]) & 0x80))
		;
	return(port[0x17]);
}
