/*
 *	$Source: /u1/X/DECToolkit/src/RCS/Geometry.c,v $
 *	$Header: Geometry.c,v 1.1 86/12/17 09:01:46 swick Exp $
 */

#ifndef lint
static char *rcsid_Geometry_c = "$Header: Geometry.c,v 1.1 86/12/17 09:01:46 swick Exp $";
#endif	lint

#ifndef lint
static  char    *sccsid = "@(#)Geometry.c	1.3          12/11/86";
#endif lint
/*
 *			  COPYRIGHT 1986
 *		   DIGITAL EQUIPMENT CORPORATION
 *		       MAYNARD, MASSACHUSETTS
 *			ALL RIGHTS RESERVED.
 *
 * THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND
 * SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL EQUIPMENT CORPORATION.
 * DIGITAL MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THIS SOFTWARE FOR
 * ANY PURPOSE.  IT IS SUPPLIED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
 *
 * IF THE SOFTWARE IS MODIFIED IN A MANNER CREATING DERIVATIVE COPYRIGHT RIGHTS,
 * APPROPRIATE LEGENDS MAY BE PLACED ON THE DERIVATIVE WORK IN ADDITION TO THAT
 * SET FORTH ABOVE.
 *
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting documentation,
 * and that the name of Digital Equipment Corporation not be used in advertising
 * or publicity pertaining to distribution of the software without specific, 
 * written prior permission.
 */


/* File: Geometry.c */

#include <X/Xlib.h>
#include "Toolkit.h"

/* Private  Definitions */

extern char *malloc();
static int geometryContext;
static int initialized = FALSE;

/* Public routines */

/*
 * The "normal" case is for the geometry manager to be associated with a
 * windows parent. This code currently looks for an association on the passed
 * window then it's parent. In the real version of this code the request
 * should propagate up the tree. Note that parent windows may not be in the
 * requesting windows address space and the propagation will require a server
 * dialog.
 */
int TMakeGeometryRequest (window, request, requestBox, replyBox)
Window window;
enum TGeometryRequest request;
WindowBox *requestBox, *replyBox;
{
    int (*proc)();
    Window parent, *children;
    int error, nchildren;

    parent = window;
    error = FindEntry(window, geometryContext, &proc);
    if (error != ERRNONE) {
        XQueryTree(window, &parent, &nchildren, &children);
        error = FindEntry(parent, geometryContext, &proc);
        free(children);
        if (error != ERRNONE)
            return(REQUESTNOENTRY);
    }
    return(proc(parent, window, request, requestBox, replyBox));
}

/*
 * Register a geometry routine with the toolkit dispatcher.
 */
int TSetGeometryRequest(w, proc)
Window w;
int proc;
{
    if (initialized == FALSE) {
        geometryContext = UniqueEntryType ();
        initialized = TRUE;
  }
  return(SaveEntry (w, geometryContext, proc));
}

/*
 * Delete the geometry routine's entry in the toolkit dispatcher.
 */
TClearGeometryRequest(w)
Window w;
{
    return(DeleteEntry(w, geometryContext));
}
