/*
 *	$Source: /u1/Xr/src/Xrlib/Editor/RCS/editorUtil.c,v $
 *	$Header: editorUtil.c,v 1.1 86/12/17 09:06:22 swick Exp $
 */

#ifndef lint
static char *rcsid_editorUtil_c = "$Header: editorUtil.c,v 1.1 86/12/17 09:06:22 swick Exp $";
#endif	lint


#include <Xr/xr-copyright.h>

/* $Header: editorUtil.c,v 1.1 86/12/17 09:06:22 swick Exp $ */
/* Copyright 1986, Hewlett-Packard Company */
/* Copyright 1986, Massachussetts Institute of Technology */

static char rcsid[] = "$Header: editorUtil.c,v 1.1 86/12/17 09:06:22 swick Exp $";
/*************************************<+>*************************************
 *****************************************************************************
 **
 **   File:        editorUtil.c
 **
 **   Project:     X-ray Toolbox
 **
 **   Description: 
 **         This file contains several general purpose utility routines
 **         which may be used by all field editors.  The utility routines
 **         include the following:
 **
 **             _XrInitEditorStruct()
 **             _XrCatchableKey()
 *              _XrMakeInvisible()
 **
 **
 **   ------------------------ MODIFICATION RECORD   ------------------------
 *
 * $Log:	editorUtil.c,v $
 * Revision 1.1  86/12/17  09:06:22  swick
 * Initial revision
 * 
 * Revision 7.0  86/11/13  08:29:51  08:29:51  fred ()
 * Final QA Release
 * 
 * Revision 6.0  86/11/10  15:38:22  15:38:22  fred ()
 * QA #2 release
 * 
 * Revision 5.1  86/11/07  14:25:21  14:25:21  fred ()
 * Added new copyright message.
 * 
 * Revision 5.0  86/10/28  08:39:06  08:39:06  fred ()
 * QA #1.1 release
 * 
 * Revision 4.0  86/10/20  12:15:54  12:15:54  fred ()
 * QA #1 release
 * 
 * Revision 3.1  86/10/16  09:23:18  09:23:18  fred ()
 * Performance enhanced: added use of register variables.
 * 
 * Revision 3.0  86/10/02  16:04:21  16:04:21  fred ()
 * Alpha release set to 3.0
 * 
 * Revision 2.2  86/09/19  07:14:20  07:14:20  fred ()
 * Enlarged graphics context changeList structure.
 * 
 * Revision 2.1  86/09/16  11:18:25  11:18:25  fred ()
 * Filled in the procedure headers.
 * 
 * Revision 2.0  86/09/16  08:14:25  08:14:25  fred ()
 * Updated _XrCatchableKey() to process an XEvent instead of an xrEvent.
 * 
 * Revision 1.1  86/09/03  13:59:10  13:59:10  fred ()
 * Initial revision
 * 
 *
 *****************************************************************************
 *************************************<+>*************************************/



#include <X/Xlib.h>
#include <Xr/defs.h>
#include <Xr/types.h>




/*************************************<->*************************************
 *
 *  _XrInitEditorStruct (editorStructPtr, editorInfoPtr, editorDataPtr,
 *                       editorFunct)
 *
 *     xrEditor         * editorStructPtr;
 *     xrEditorTemplate * editorInfoPtr;
 *     char             * editorDataPtr;
 *     xrEditor         * (*editorFunct)();
 *
 *   Description:
 *   -----------
 *     This routine is invoked by every field editor, as part of its
 *     MSG_NEW handling.  It will fill in the following fields of the
 *     editor instance structure pointed by the 'editorStructPtr' parameter:
 *
 *     editorWindowId, editorFunct, editorState, editorREct, editorData
 *
 *
 *   Inputs:
 *   ------
 *     editorStructPtr = Points to the empty editor instance structure.
 *
 *     editorInfoPtr = Points to an editor's 'info' structure; most of the
 *                     info which will be copied into the editor instance
 *                     structure is obtained from this 'info' structure.
 *
 *     editorDataPtr = Points to the new editor instance's 'data' structure.
 *
 *     editorFunct = This is a pointer to the handler routine associated
 *                   with the editor instance being created.
 * 
 *   Outputs:
 *   -------
 *     The editor structure pointed to by 'editorStructPtr' is filled.
 *
 *   Procedures Called
 *   -----------------
 *
 *************************************<->***********************************/

_XrInitEditorStruct (editorStructPtr, editorInfoPtr, editorDataPtr, editorFunct)

   register xrEditor         * editorStructPtr;
   register xrEditorTemplate * editorInfoPtr;
            char             * editorDataPtr;
            xrEditor         * (*editorFunct)();

{
   editorStructPtr->editorWindowId = editorInfoPtr->editorWindowId;
   editorStructPtr->editorFunct = editorFunct;
   editorStructPtr->editorState = editorInfoPtr->editorState;
   XrCopyRect (&editorInfoPtr->editorRect, &editorStructPtr->editorRect);
   editorStructPtr->editorData = editorDataPtr;
}

/*************************************<->*************************************
 *
 *  _XrCatchableKey (editorStructPtr, eventPtr)
 *
 *     xrEditor       * editorStructPtr;
 *     XButtonEvent   * eventPtr;
 *
 *   Description:
 *   -----------
 *     This routine takes an X button event, and determines whether
 *     the specified field editor instance should process it.  If the
 *     location of the button event was within the editor's rectangle,
 *     and if the editor was SENSITIVE and VISIBLE, then it will be
 *     allowed to process the event; otherwise, it should ignore it.
 *
 *
 *   Inputs:
 *   ------
 *     editorStructPtr = Points to an editor instance structure, indicating 
 *                       which editor instance is checking the input event.
 *
 *     eventPtr = This is a pointer to an X button event.
 * 
 *   Outputs:
 *   -------
 *     If the field editor should process the event, then a value of
 *        TRUE is returned; otherwise, FALSE is returned.
 *
 *   Procedures Called
 *   -----------------
 *   XrSetPt()     [calc.c]
 *   XrPtInRect()  [calc.c]
 *
 *************************************<->***********************************/

_XrCatchableKey (editorStructPtr, eventPtr)

   register xrEditor     * editorStructPtr;
   register XButtonEvent * eventPtr;

{
   POINT selectPt;

   if ((editorStructPtr == NULL) || (eventPtr == NULL) ||
       (editorStructPtr->editorState & (XrSENSITIVE | XrVISIBLE)) !=
       (XrSENSITIVE | XrVISIBLE))
      return (FALSE);

   XrSetPt (&selectPt, eventPtr->x, eventPtr->y);
   if (! XrPtInRect (&selectPt, &editorStructPtr->editorRect))
      return (FALSE);

   return (TRUE);
}

/*************************************<->*************************************
 *
 *  _XrMakeInvisible (windowId, rectPtr, makeGCFlag)
 *
 *     Window      windowId;
 *     RECTANGLE * rectPtr;
 *     INT8        makeGCFlag;
 *
 *   Description:
 *   -----------
 *     If the 'makeGCFlag' parameter is set to TRUE, then this routine will
 *     first create a graphics context which is set to do a tile fill,
 *     using the background tile for the specified window; if 'makeGCFlag'
 *     is set to FALSE, then it will assume that the application has
 *     already set up the graphics context itself (in xrEditorGC8).
 *     Then it will fill the rectangular region defined by the 'rectPtr'
 *     parameter, using this graphics context.  This has the effect of
 *     'erasing' anything in the window which reside in that rectangular
 *     region.
 *     
 *
 *
 *   Inputs:
 *   ------
 *     windowId = This indicates the window in which the tile fill is to
 *                occur.
 *
 *     rectPtr = This defines the region which is to be tile filled.
 *
 *     makeGCFlag = This signals whether this routine needs to construct
 *                  a graphics context.
 * 
 *   Outputs:
 *   -------
 *
 *   Procedures Called
 *   -----------------
 *   XrInput()           [input.c]
 *   _XrCopyGC()         [gcUtil.c]
 *   _XrChangeGC()       [gcUtil.c]
 *   _XrFillRectangle()  [rectUtil.c]
 *
 *************************************<->***********************************/

_XrMakeInvisible (windowId, rectPtr, makeGCFlag)

            Window      windowId;
   register RECTANGLE * rectPtr;
            INT8        makeGCFlag;

{
   if (makeGCFlag)
   {
      xrWindowData windowData;
      INT32        changeList[21];
      INT32        changeMask;

      XrInput (windowId, MSG_GETWINDOWDATA, &windowData);
      _XrCopyGC (xrDefaultGC, xrEditorGC8);
      changeList[XrFILLSTYLEVAL] = Tiled;
      changeList[XrTILEVAL] = windowData.backTile;
      changeMask = (XrFILLSTYLE | XrTILE);
      _XrChangeGC (xrEditorGC8, changeMask, changeList);
   }

   _XrFillRectangle (windowId, xrEditorGC8, rectPtr);
}
