/*
 *	$Source: /u1/Xr/src/Xrlib/Intrinsic/RCS/globals.c,v $
 *	$Header: globals.c,v 1.1 86/12/17 09:08:05 swick Exp $
 */

#ifndef lint
static char *rcsid_globals_c = "$Header: globals.c,v 1.1 86/12/17 09:08:05 swick Exp $";
#endif	lint

#include <Xr/xr-copyright.h>

/* $Header: globals.c,v 1.1 86/12/17 09:08:05 swick Exp $ */
/* Copyright 1986, Hewlett-Packard Company */
/* Copyright 1986, Massachussetts Institute of Technology */

static char rcsid[] = "$Header: globals.c,v 1.1 86/12/17 09:08:05 swick Exp $";
/*************************************<+>*************************************
 *****************************************************************************
 **
 **   File:        globals.c
 **
 **   Project:     X-ray Toolbox
 **
 **   Description: This file contains the declarations and static 
 **                initialization needed to set X-ray's global variables.
 **
 **
 **   ------------------------ MODIFICATION RECORD   ------------------------
 *
 * $Log:	globals.c,v $
 * Revision 1.1  86/12/17  09:08:05  swick
 * Initial revision
 * 
 * Revision 7.0  86/11/13  08:19:43  08:19:43  rick ()
 * Final QA release
 * 
 * Revision 6.0  86/11/10  15:21:32  15:21:32  rick ()
 * QA #2 release
 * 
 * Revision 5.3  86/11/07  14:01:38  14:01:38  rick ()
 * Added the copyright message.
 * 
 * Revision 5.2  86/11/07  11:20:11  11:20:11  rick ()
 * Added the what(1) string "X-ray Version 10  -  06.00"
 * 
 * Revision 5.1  86/11/06  09:17:55  09:17:55  rick ()
 * Added the slant bitmaps.
 * 
 * Revision 5.0  86/10/28  08:22:22  08:22:22  rick ()
 * QA #1.1 release
 * 
 * Revision 4.0  86/10/20  12:08:20  12:08:20  rick ()
 * QA 1 release
 * 
 * Revision 3.8  86/10/17  12:23:04  12:23:04  rick ()
 * Linted
 * 
 * Revision 3.7  86/10/16  11:20:09  11:20:09  rick ()
 * Added register variables.
 * 
 * Revision 3.6  86/10/15  16:11:46  16:11:46  rick ()
 * Removed the Menu Meta global.
 * 
 * Revision 3.5  86/10/10  12:53:10  12:53:10  rick ()
 * Added the declarations for the select and menu button modifiers
 * 
 * Revision 3.4  86/10/09  10:14:31  10:14:31  rick ()
 * Added the window foreground, background and border defaults.
 * 
 * Revision 3.3  86/10/08  15:08:54  15:08:54  rick ()
 * Added the foreground and background color defaults.
 * 
 * Revision 3.2  86/10/08  08:14:15  08:14:15  ed ()
 * Added Meta and Sticky variables.
 * 
 * Revision 3.1  86/10/07  16:00:11  16:00:11  ed ()
 * Temporary change for panel context.
 * 
 * Revision 3.0  86/10/02  15:58:26  15:58:26  rick ()
 *  Alpha release set to 3.0
 * 
 * Revision 2.3  86/09/29  10:17:57  10:17:57  rick ()
 * Added xrMenuCursor
 * 
 * Revision 2.2  86/09/29  09:41:51  09:41:51  rick ()
 * Added the menus cursor image and mask
 * 
 * Revision 2.1  86/09/25  10:55:36  10:55:36  rick ()
 * Added the globals for menu default colors and tile.
 * 
 * Revision 2.0  86/09/16  07:58:36  07:58:36  rick ()
 * Added the globals xrSelect, xrSelectUp, xrMenuPost, and xrMenuItemSelect.
 * 
 * Revision 1.1  86/09/03  13:35:09  13:35:09  rick ()
 * Initial revision
 * 
 *
 *****************************************************************************
 *************************************<+>*************************************/


#include <X/Xlib.h>
#include <Xr/defs.h>
#include <Xr/types.h>


static char ident[] = "@(#)X-ray Version 10  -  07.00";

extern char * malloc();
extern        free();
extern char * realloc();
extern char * calloc();


FontInfo   * xrBaseFontInfo;

POINT     xrZeroPt = {0,0};
RECTANGLE xrZeroRect = {0,0,0,0};


/*
 *  The allocation functions.
 */

char * (*xrMalloc)() = malloc;
int    (*xrFree)() = free;
char * (*xrRealloc)() = realloc;
char * (*xrCalloc)() = calloc;


/*
 *  The variables which contain the select and menu button conditions.
 */

INT8 xrSelect;
INT8 xrSelectUp;
INT8 xrMenuPost;
INT8 xrMenuItemSelect;


/*
 *  The variables used as modifiers for the select and menu buttons.
 */

UINT16 xrLBDMod;
UINT16 xrLBUMod;
UINT16 xrMBDMod;
UINT16 xrMBUMod;
UINT16 xrRBDMod;
UINT16 xrRBUMod;


/*
 *  X-ray general default globals.
 */

Pixmap xrWindowForeground;
Pixmap xrWindowBackground;
INT32  xrBorderWidth;
INT32  xrForegroundColor;
INT32  xrBackgroundColor;
Cursor xrDefaultCursor;
Pixmap xrDefaultTile;


/*
 *  The menu default globals.
 */

INT32  xrMenuSticky;


/*
 *  The panel context defaults structure.
 */

xrPanelContext xrPanelContextDefaults;


/*
 *  The graphics context structures.
 */

INT32 xr_GCList[9][21] =
  {{ GXcopy, -1,        0,     1, 1,
     Solid,  Butt,      Miter, 0, 0,
     0,      0,         Solid, 0, ClipByChildren,
     FALSE,  0,         0,     0, 0, 
     4 },

   { GXcopy, -1,        0,     1, 1,
     Solid,  Butt,      Miter, 0, 0,
     0,      0,         Solid, 0, ClipByChildren,
     FALSE,  0,         0,     0, 0, 
     4 },

   { GXcopy, -1,        0,     1, 1,
     Solid,  Butt,      Miter, 0, 0,
     0,      0,         Solid, 0, ClipByChildren,
     FALSE,  0,         0,     0, 0, 
     4 },

   { GXcopy, -1,        0,     1, 1,
     Solid,  Butt,      Miter, 0, 0,
     0,      0,         Solid, 0, ClipByChildren,
     FALSE,  0,         0,     0, 0, 
     4 },

   { GXcopy, -1,        0,     1, 1,
     Solid,  Butt,      Miter, 0, 0,
     0,      0,         Solid, 0, ClipByChildren,
     FALSE,  0,         0,     0, 0, 
     4 },

   { GXcopy, -1,        0,     1, 1,
     Solid,  Butt,      Miter, 0, 0,
     0,      0,         Solid, 0, ClipByChildren,
     FALSE,  0,         0,     0, 0, 
     4 },

   { GXcopy, -1,        0,     1, 1,
     Solid,  Butt,      Miter, 0, 0,
     0,      0,         Solid, 0, ClipByChildren,
     FALSE,  0,         0,     0, 0, 
     4 },

   { GXcopy, -1,        0,     1, 1,
     Solid,  Butt,      Miter, 0, 0,
     0,      0,         Solid, 0, ClipByChildren,
     FALSE,  0,         0,     0, 0, 
     4 },

   { GXcopy, -1,        0,     1, 1,
     Solid,  Butt,      Miter, 0, 0,
     0,      0,         Solid, 0, ClipByChildren,
     FALSE,  0,         0,     0, 0, 
     4 }};

INT32 xrDefaultGC = 0;
INT32 xrEditorGC1 = 1;
INT32 xrEditorGC2 = 2;
INT32 xrEditorGC3 = 3;
INT32 xrEditorGC4 = 4;
INT32 xrEditorGC5 = 5;
INT32 xrEditorGC6 = 6;
INT32 xrEditorGC7 = 7;
INT32 xrEditorGC8 = 8;


INT16 xrCursorImage [] =
{

   0x0000,	/*  @@@@ @@@@ @@@@ @@@@  */
   0x0002,	/*  @.@@ @@@@ @@@@ @@@@  */
   0x0006,	/*  @..@ @@@@ @@@@ @@@@  */
   0x000e,	/*  @... @@@@ @@@@ @@@@  */
   0x001e,	/*  @... .@@@ @@@@ @@@@  */
   0x003e,	/*  @... ..@@ @@@@ @@@@  */
   0x007e,	/*  @... ...@ @@@@ @@@@  */
   0x00fe,	/*  @... .... @@@@ @@@@  */
   0x01fe,	/*  @... .... .@@@ @@@@  */
   0x0036,	/*  @..@ ..@@ @@@@ @@@@  */
   0x0062,	/*  @.@@ @..@ @@@@ @@@@  */
   0x0060,	/*  @@@@ @..@ @@@@ @@@@  */
   0x00c0,	/*  @@@@ @@.. @@@@ @@@@  */
   0x00c0,	/*  @@@@ @@.. @@@@ @@@@  */
   0x0000,	/*  @@@@ @@@@ @@@@ @@@@  */
   0x0000,	/*  @@@@ @@@@ @@@@ @@@@  */
   0x0000,	/*  @@@@ @@@@ @@@@ @@@@  */
};


INT16 xrCursorMask [] =
{
   0x0003,	/*  ..@@ @@@@ @@@@ @@@@  */
   0x0007,	/*  ...@ @@@@ @@@@ @@@@  */
   0x000f,	/*  .... @@@@ @@@@ @@@@  */
   0x001f,	/*  .... .@@@ @@@@ @@@@  */
   0x003f,	/*  .... ..@@ @@@@ @@@@  */
   0x007f,	/*  .... ...@ @@@@ @@@@  */
   0x00ff,	/*  .... .... @@@@ @@@@  */
   0x01ff,	/*  .... .... .@@@ @@@@  */
   0x03ff,	/*  .... .... ..@@ @@@@  */
   0x01ff,	/*  .... .... .@@@ @@@@  */
   0x00f7,	/*  ...@ .... @@@@ @@@@  */
   0x00f2,	/*  @.@@ .... @@@@ @@@@  */
   0x01e0,	/*  @@@@ @... .@@@ @@@@  */
   0x01e0,	/*  @@@@ @... .@@@ @@@@  */
   0x00c0,	/*  @@@@ @@.. @@@@ @@@@  */
   0x0000,	/*  @@@@ @@@@ @@@@ @@@@  */
   0x0000,	/*  @@@@ @@@@ @@@@ @@@@  */
};


UINT16 xr_bitmaps [9][16] =
{
   {  0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 		/*  White  */
      0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
      0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
      0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF  },

   {  0x0000, 0x0000, 0x0000, 0x0000, 		/*  Black  */
      0x0000, 0x0000, 0x0000, 0x0000, 
      0x0000, 0x0000, 0x0000, 0x0000, 
      0x0000, 0x0000, 0x0000, 0x0000  },

   {  0x5555, 0x0000, 0xAAAA, 0x0000, 		/*  25 percent  */
      0x5555, 0x0000, 0xAAAA, 0x0000, 
      0x5555, 0x0000, 0xAAAA, 0x0000, 
      0x5555, 0x0000, 0xAAAA, 0x0000  },

   {  0x5555, 0xAAAA, 0x5555, 0xAAAA,		/*  50 percent  */
      0x5555, 0xAAAA, 0x5555, 0xAAAA,
      0x5555, 0xAAAA, 0x5555, 0xAAAA,
      0x5555, 0xAAAA, 0x5555, 0xAAAA  },

   {  0x5555, 0xFFFF, 0xAAAA, 0xFFFF,		/*  75 percent  */
      0x5555, 0xFFFF, 0xAAAA, 0xFFFF,
      0x5555, 0xFFFF, 0xAAAA, 0xFFFF,
      0x5555, 0xFFFF, 0xAAAA, 0xFFFF  },

   {  0x5555, 0x5555, 0x5555, 0x5555,		/*  Vertical  */
      0x5555, 0x5555, 0x5555, 0x5555,
      0x5555, 0x5555, 0x5555, 0x5555,
      0x5555, 0x5555, 0x5555, 0x5555  },

   {  0xffff, 0x0000, 0xffff, 0x0000,		/*  Horizontal  */ 
      0xffff, 0x0000, 0xffff, 0x0000, 
      0xffff, 0x0000, 0xffff, 0x0000, 
      0xffff, 0x0000, 0xffff, 0x0000  },

   {  0xeeee, 0xdddd, 0xbbbb, 0x7777,		/*  Slant Left  */
      0xeeee, 0xdddd, 0xbbbb, 0x7777, 
      0xeeee, 0xdddd, 0xbbbb, 0x7777, 
      0xeeee, 0xdddd, 0xbbbb, 0x7777  },

   {  0x7777, 0xbbbb, 0xdddd, 0xeeee, 		/*  Slant Right  */
      0x7777, 0xbbbb, 0xdddd, 0xeeee, 
      0x7777, 0xbbbb, 0xdddd, 0xeeee, 
      0x7777, 0xbbbb, 0xdddd, 0xeeee  }
};


/*
 *  The polygon draw array
 */

Vertex xr_PolyList[100];


/*
 *  Error reporting variable
 */

INT32 xrErrno;
