/*
 *	$Source: /u1/Xr/usr/contrib/RB/RCS/selectRaster.c,v $
 *	$Header: selectRaster.c,v 1.1 86/12/17 08:54:06 swick Exp $
 */

#ifndef lint
static char *rcsid_selectRaster_c = "$Header: selectRaster.c,v 1.1 86/12/17 08:54:06 swick Exp $";
#endif	lint

static char rcsid[] = "$Header: selectRaster.c,v 1.1 86/12/17 08:54:06 swick Exp $";
/*************************************<+>*************************************
 *****************************************************************************
 **
 **   File:        selectRaster.c
 **
 **   Project:     X-ray Toolbox
 **
 **   Description: The file contains the routines that select a portion
 **                of the display.
 **
 **   *******************************************************************
 **   * (c)  Copyright Hewlett-Packard Company, 1986.  All rights are   *
 **   * reserved.  Copying or other reproduction of this program except *
 **   * for archival purposes is prohibited without the prior written   *
 **   * consent of Hewlett-Packard Company.                             *
 **   *******************************************************************
 **
 **
 **   ------------------------ MODIFICATION RECORD   ------------------------
 *
 * $Log:	selectRaster.c,v $
 * Revision 1.1  86/12/17  08:54:06  swick
 * Initial revision
 * 
 *
 *****************************************************************************
 *************************************<+>*************************************/


#include <X/Xlib.h>
#include <Xr/defs.h>
#include <Xr/types.h>


extern xrRasterEditInfo rasterEditInfo;


SelectRaster ()
{
   XButtonEvent buttonEvent;
   Window subWin;
   INT32  x, y;
   INT32  oldX, oldY;
   POINT  point1, point2;
   RECTANGLE grabRect;


   /*
    *  Grab the mouse buttons and initialize the necessary data.
    */

   XGrabButton (RootWindow, xrDefaultCursor, LeftMask,
                ButtonPressed | ButtonReleased);

   point1.x = point2.x = point1.y = point2.y = -1;


   /*
    *  Set up a loop to catch the select point.
    */

   while (1)
   {
      if (XrInput (0, MSG_BLKREAD, &buttonEvent))
      {
         if (XrMapButton (XrSELECT, &buttonEvent))
         {
            XQueryMouse (RootWindow, &x, &y, &subWin);
            point1.x = oldX = x;
            point1.y = oldY = y;
            break;
         }
      }
   }


   /*
    *  Set up a loop to catch the select up point.
    */

   while (1)
   {
      XQueryMouse (RootWindow, &x, &y, &subWin);

      if (x != oldX || y != oldY)
      {
         if (point2.x != -1)
            DrawRect (&point1, &point2);
         point2.x = oldX = x;
         point2.y = oldY = y;
         DrawRect (&point1, &point2);
      }

      if (XrInput (0, MSG_NONBLKREAD, &buttonEvent))
         if (XrMapButton (XrSELECTUP, &buttonEvent))
         {
            DrawRect (&point1, &point2);
            break;
         }
   }

   XUngrabButton (LeftMask);


   /*
    *  Calculate the grabbed rectangle and return is less than the minimum.
    */

   XrPt2Rect (&point1, &point2, &grabRect);
   if (grabRect.width < 16 || grabRect.height < 16)
      return;


   /*
    *  Initialize a raster to hold the image to be read from the display.
    */

   RasterInit (grabRect.width, grabRect.height, DisplayPlanes());

   if (DisplayPlanes() == 1)
      XPixmapGetXY (RootWindow, grabRect.x, grabRect.y,
                                grabRect.width, grabRect.height,
                                rasterEditInfo.rasterData.raster);
   else
      XPixmapGetZ (RootWindow, grabRect.x, grabRect.y,
                               grabRect.width, grabRect.height,
                               rasterEditInfo.rasterData.raster);


   /*
    *  Reinitialize the main and image windows.
    */

   MainWindowInit();
}




/************************************************************************
 *
 *  DrawRect
 *	DrawRect takes two points as input and draws a rectangle with
 *      a line width and height of 3 around the rectangle generated
 *      by the two points.  The rectangle is drawn XOR so that it
 *      can be erased.
 *
 ************************************************************************/

DrawRect (point1, point2)
POINT * point1;
POINT * point2;

{
   RECTANGLE drawRect;

   XrPt2Rect (point1, point2, &drawRect);

   XPixFill (RootWindow, drawRect.x, drawRect.y, 
                         drawRect.width, 3,
                         WhitePixel, 0, GXxor, AllPlanes);
   XPixFill (RootWindow, drawRect.x + drawRect.width - 3, drawRect.y + 3, 
                         3, drawRect.height - 3,
                         WhitePixel, 0, GXxor, AllPlanes);
   XPixFill (RootWindow, drawRect.x, drawRect.y + drawRect.height - 3,
                         drawRect.width - 3, 3,
                         WhitePixel, 0, GXxor, AllPlanes);
   XPixFill (RootWindow, drawRect.x, drawRect.y + 3, 
                         3, drawRect.height - 6, 
                         WhitePixel, 0, GXxor, AllPlanes);
}

