/*
 * Decompiled with CFR 0.152.
 */
package com.symbios.jxdr;

import com.symbios.jxdr.CMDHeader;
import com.symbios.jxdr.DMIErrorException;
import com.symbios.jxdr.JRPCClient;
import com.symbios.jxdr.JxdrInputStream;
import com.symbios.jxdr.JxdrStream;
import com.symbios.jxdr.JxdrType;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;

public class DCEClient
extends JRPCClient {
    InetAddress proxyAddr;
    int proxyPort;
    Socket serverSocket;
    int state;
    public static final byte STATUS_RAW = 0;
    public static final byte STATUS_DMI_READY = 1;
    public static final byte STATUS_DMI_EXECUTING = 2;
    public static final short CMD_REQUEST_NEW_SESSION = 101;
    public static final short CMD_REGISTER = 102;
    public static final short CMD_EXECUTE = 103;
    public static final short CMD_UNREGISTER = 104;
    public static final short CMD_CLOSE_SESSION = 105;
    public static final short CMD_RESPONSE = 201;
    public static final short CMD_RESPONSE_WITH_ERR = 202;

    public DCEClient(InetAddress inetAddress) throws IOException {
        super(inetAddress);
    }

    public void Initialize(InetAddress inetAddress, int n, int n2, int n3, int n4) {
        try {
            this.proxyAddr = inetAddress;
            this.proxyPort = n;
            this.serverSocket = new Socket(inetAddress, n);
            this.serverSocket.setSoTimeout(n2);
            this.out = new BufferedOutputStream(this.serverSocket.getOutputStream());
            this.in = new BufferedInputStream(this.serverSocket.getInputStream());
            this.cmdOut = new JxdrStream();
            this.cmdIn = new JxdrInputStream(this.in);
            this.state = 0;
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void ExecCmd(short s, JxdrType jxdrType, JxdrType jxdrType2) throws IOException, DMIErrorException {
        byte[] byArray = new byte[10];
        byArray = this.dmispAddr.getAddress();
        this.cmdOut.Init();
        CMDHeader cMDHeader = new CMDHeader(byArray, this.proxyPort, 103, s, 25, 26);
        cMDHeader.put(this.cmdOut);
        jxdrType.put(this.cmdOut);
        this.cmdOut.fixHeaderLength();
        this.cmdIn.Init();
        this.cmdIn.skipBytes();
        this.out.write(this.cmdOut.buffer, 0, this.cmdOut.inPos);
        this.out.flush();
        this.cmdIn.receiveData();
        CMDHeader cMDHeader2 = new CMDHeader();
        cMDHeader2.get(this.cmdIn);
        if (cMDHeader2.status >= 256) {
            this.state = 1;
            throw new DMIErrorException(this.cmdIn, cMDHeader2);
        }
        jxdrType2.get(this.cmdIn);
    }

    public int OpenSession() throws IOException, DMIErrorException {
        byte[] byArray = new byte[10];
        byArray = this.dmispAddr.getAddress();
        this.cmdOut.Init();
        CMDHeader cMDHeader = new CMDHeader(byArray, this.proxyPort, 101, 0, 25, 26);
        cMDHeader.put(this.cmdOut);
        this.cmdOut.fixHeaderLength();
        this.cmdIn.Init();
        this.out.write(this.cmdOut.buffer, 0, this.cmdOut.inPos);
        this.out.flush();
        this.cmdIn.receiveData();
        CMDHeader cMDHeader2 = new CMDHeader();
        cMDHeader2.get(this.cmdIn);
        if (cMDHeader2.status >= 256) {
            this.state = 1;
            throw new DMIErrorException(this.cmdIn, cMDHeader2);
        }
        this.cmdIn.getInt32();
        return 0;
    }

    public int CloseSession() throws IOException {
        byte[] byArray = new byte[10];
        byArray = this.dmispAddr.getAddress();
        this.cmdOut.Init();
        CMDHeader cMDHeader = new CMDHeader(byArray, this.proxyPort, 105, 0, 25, 26);
        cMDHeader.put(this.cmdOut);
        this.cmdOut.fixHeaderLength();
        this.cmdIn.Init();
        this.out.write(this.cmdOut.buffer, 0, this.cmdOut.inPos);
        this.out.flush();
        this.cmdIn.receiveData();
        CMDHeader cMDHeader2 = new CMDHeader();
        cMDHeader2.get(this.cmdIn);
        this.cmdIn.getInt32();
        return 0;
    }

    public int RegisterWithSP(JxdrType jxdrType, JxdrType jxdrType2) throws IOException, DMIErrorException {
        byte[] byArray = new byte[10];
        byArray = this.dmispAddr.getAddress();
        this.cmdOut.Init();
        CMDHeader cMDHeader = new CMDHeader(byArray, this.proxyPort, 102, 0, 25, 26);
        cMDHeader.put(this.cmdOut);
        jxdrType.put(this.cmdOut);
        this.cmdOut.fixHeaderLength();
        this.cmdIn.Init();
        this.out.write(this.cmdOut.buffer, 0, this.cmdOut.inPos);
        this.out.flush();
        this.cmdIn.receiveData();
        CMDHeader cMDHeader2 = new CMDHeader();
        cMDHeader2.get(this.cmdIn);
        if (cMDHeader2.status >= 256) {
            this.state = 1;
            throw new DMIErrorException(this.cmdIn, cMDHeader2);
        }
        jxdrType2.get(this.cmdIn);
        this.cmdIn.getInt32();
        this.state = 1;
        return 0;
    }

    public int UnregisterFromSP(JxdrType jxdrType, JxdrType jxdrType2) throws IOException, DMIErrorException {
        byte[] byArray = new byte[10];
        byArray = this.dmispAddr.getAddress();
        this.cmdOut.Init();
        CMDHeader cMDHeader = new CMDHeader(byArray, this.proxyPort, 104, 0, 25, 26);
        cMDHeader.put(this.cmdOut);
        jxdrType.put(this.cmdOut);
        this.cmdOut.fixHeaderLength();
        this.cmdIn.Init();
        this.out.write(this.cmdOut.buffer, 0, this.cmdOut.inPos);
        this.out.flush();
        this.cmdIn.receiveData();
        CMDHeader cMDHeader2 = new CMDHeader();
        cMDHeader2.get(this.cmdIn);
        if (cMDHeader2.status >= 256) {
            this.state = 1;
            throw new DMIErrorException(this.cmdIn, cMDHeader2);
        }
        jxdrType2.get(this.cmdIn);
        this.cmdIn.getInt32();
        this.state = 1;
        return 0;
    }
}

