/*
 * Decompiled with CFR 0.152.
 */
package com.symbios.jxdr;

import com.symbios.jxdr.DMIErrorException;
import com.symbios.jxdr.JRPCClient;
import com.symbios.jxdr.JxdrInputStream;
import com.symbios.jxdr.JxdrStream;
import com.symbios.jxdr.JxdrType;
import com.symbios.jxdr.Mapping4;
import com.symbios.jxdr.ONCCallHdr;
import com.symbios.jxdr.ONCReplyHdr;
import com.symbios.jxdr.Pmapper;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;

public class ONCClient
extends JRPCClient {
    int sPort;
    int prog;
    int vers;
    int state;
    Socket serverSocket;
    public static final int IPPROTO_TCP = 6;
    public static final int IPPROTO_UDP = 17;

    public ONCClient(InetAddress inetAddress) throws IOException {
        super(inetAddress);
    }

    public void Initialize(InetAddress inetAddress, int n, int n2, int n3, int n4) {
        this.prog = n3;
        this.vers = n4;
        Pmapper pmapper = new Pmapper(this.dmispAddr);
        try {
            this.sPort = pmapper.GetPortTCP(n3, 6);
            this.serverSocket = new Socket(this.dmispAddr, this.sPort);
            this.serverSocket.setSoTimeout(n2);
            this.out = new BufferedOutputStream(this.serverSocket.getOutputStream());
            this.in = new BufferedInputStream(this.serverSocket.getInputStream(), 8192);
            this.cmdOut = new JxdrStream();
            this.cmdIn = new JxdrInputStream(this.in);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public int RegisterWithSP(JxdrType jxdrType, JxdrType jxdrType2) throws IOException, DMIErrorException {
        this.ExecCmd((short)512, jxdrType, jxdrType2);
        return 0;
    }

    public int UnregisterFromSP(JxdrType jxdrType, JxdrType jxdrType2) throws IOException, DMIErrorException {
        this.ExecCmd((short)513, jxdrType, jxdrType2);
        return 0;
    }

    public void ExecCmd(short s, JxdrType jxdrType, JxdrType jxdrType2) throws IOException, DMIErrorException {
        boolean bl;
        Mapping4 mapping4 = new Mapping4(2, this.prog, this.vers, s);
        ONCCallHdr oNCCallHdr = new ONCCallHdr(mapping4, 0);
        ONCReplyHdr oNCReplyHdr = new ONCReplyHdr(0);
        this.cmdOut.Init();
        oNCCallHdr.put(this.cmdOut);
        jxdrType.put(this.cmdOut);
        while (this.in.available() > 0) {
            this.in.skip(this.in.available());
        }
        this.cmdIn.Init();
        this.cmdIn.skipBytes();
        int n = this.cmdOut.inPos;
        this.out.write((byte)((n |= Integer.MIN_VALUE) >> 24 & 0xFF));
        this.out.write((byte)(n >> 16 & 0xFF));
        this.out.write((byte)(n >> 8 & 0xFF));
        this.out.write((byte)(n & 0xFF));
        this.out.write(this.cmdOut.buffer, 0, this.cmdOut.inPos);
        this.out.flush();
        while (this.in.available() == 0) {
        }
        do {
            bl = (n = this.readMarker()) > Integer.MIN_VALUE;
            int n2 = n & Integer.MAX_VALUE;
            this.cmdIn.receiveBytes(n2);
        } while (!bl);
        oNCReplyHdr.get(this.cmdIn);
        int n3 = this.cmdIn.getInt32();
        if (n3 != 0) {
            throw new DMIErrorException(n3);
        }
        jxdrType2.get(this.cmdIn);
    }

    public int OpenSession() throws IOException, DMIErrorException {
        return 0;
    }

    public int CloseSession() throws IOException {
        return 0;
    }

    public int readMarker() throws IOException {
        byte[] byArray = new byte[4];
        this.in.read(byArray, 0, 4);
        int n = byArray[0] & 0xFF;
        int n2 = 1;
        while (n2 < 4) {
            n <<= 8;
            n += byArray[n2] & 0xFF;
            ++n2;
        }
        return n;
    }
}

