/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.awt;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.Serializable;
import java.util.ResourceBundle;
import symantec.itools.awt.ButtonBase;
import symantec.itools.awt.util.ColorUtils;
import symantec.itools.beans.PropertyChangeSupport;
import symantec.itools.beans.VetoableChangeSupport;
import symantec.itools.lang.OS;
import symantec.itools.util.GeneralUtils;

public class DirectionButton
extends ButtonBase
implements Serializable {
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int UP = 2;
    public static final int DOWN = 3;
    protected Color arrowColor;
    protected Color disabledArrowColor;
    protected int direction;
    protected int left;
    protected int right;
    protected int top;
    protected int bottom;
    protected int indent;
    protected int tempIndent;
    protected transient ResourceBundle errors;
    private SizeVeto sizeVeto;
    private IndntVeto indentVeto;
    private VetoableChangeSupport vetos = new VetoableChangeSupport(this);
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);

    public DirectionButton() {
        this(0);
    }

    public DirectionButton(int d) {
        this.direction = d;
        this.left = 0;
        this.right = 0;
        this.bottom = 0;
        this.tempIndent = this.indent = 0;
        try {
            this.setArrowColor(Color.black);
        }
        catch (PropertyVetoException propertyVetoException) {}
    }

    public void setDirection(int d) throws PropertyVetoException {
        if (this.direction != d) {
            Integer oldValue = new Integer(this.direction);
            Integer newValue = new Integer(d);
            this.vetos.fireVetoableChange("direction", oldValue, newValue);
            this.direction = d;
            this.repaint();
            this.changes.firePropertyChange("direction", oldValue, newValue);
        }
    }

    public int getDirection() {
        return this.direction;
    }

    public void setArrowIndent(int ai) throws PropertyVetoException {
        if (this.isAdded) {
            if (this.indent != ai) {
                Integer oldValue = new Integer(this.indent);
                Integer newValue = new Integer(ai);
                this.vetos.fireVetoableChange("arrowIndent", oldValue, newValue);
                this.indent = ai;
                this.tempIndent = ai;
                this.shrinkTriangle(this.left, this.right, this.top, this.bottom);
                this.repaint();
                this.changes.firePropertyChange("arrowIndent", oldValue, newValue);
            }
        } else {
            this.tempIndent = ai;
        }
    }

    public void setArrowColor(Color newValue) throws PropertyVetoException {
        if (!GeneralUtils.objectsEqual(this.arrowColor, newValue)) {
            Color oldValue = this.arrowColor;
            this.vetos.fireVetoableChange("arrowColor", oldValue, newValue);
            this.arrowColor = newValue;
            try {
                this.disabledArrowColor = ColorUtils.fade(this.arrowColor, Color.lightGray, 0.5);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            this.repaint();
            this.changes.firePropertyChange("arrowColor", oldValue, newValue);
        }
    }

    public Color getArrowColor() {
        return this.arrowColor;
    }

    public int getArrowIndent() {
        return this.isAdded ? this.indent : this.tempIndent;
    }

    public void shrinkTriangle(int l, int r, int t, int b) {
        if (this.isAdded) {
            Dimension s = this.getSize();
            int maxWidth = s.width - this.bevel - this.bevel - 2;
            int maxHeight = s.height - this.bevel - this.bevel - 2;
            if (maxWidth - (l + r + this.indent + this.indent) >= 3) {
                this.left = l;
                this.right = r;
            } else {
                this.right = this.left = (maxWidth - this.indent - this.indent - 3) / 2;
            }
            if (maxHeight - (t + b + this.indent + this.indent) >= 3) {
                this.top = t;
                this.bottom = b;
            } else {
                this.bottom = this.top = (maxHeight - this.indent - this.indent - 3) / 2;
            }
        }
    }

    public Dimension getPreferredSize() {
        Dimension defaultSize = super.getPreferredSize();
        return new Dimension(defaultSize.width + 7, defaultSize.height + 7);
    }

    public Dimension getMinimumSize() {
        Dimension defaultSize = super.getPreferredSize();
        return new Dimension(defaultSize.width + 3, defaultSize.height + 3);
    }

    public synchronized void addNotify() {
        this.errors = ResourceBundle.getBundle("symantec.itools.resources.ErrorsBundle");
        if (this.sizeVeto == null) {
            this.sizeVeto = new SizeVeto();
            this.addDirectionListener(this.sizeVeto);
        }
        if (this.indentVeto == null) {
            this.indentVeto = new IndntVeto();
            this.addArrowIndentListener(this.indentVeto);
        }
        super.addNotify();
    }

    public synchronized void removeNotify() {
        if (this.sizeVeto != null) {
            this.removeDirectionListener(this.sizeVeto);
            this.sizeVeto = null;
        }
        if (this.indentVeto != null) {
            this.removeArrowIndentListener(this.indentVeto);
            this.indentVeto = null;
        }
        super.removeNotify();
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        super.addPropertyChangeListener(listener);
        this.changes.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        super.removePropertyChangeListener(listener);
        this.changes.removePropertyChangeListener(listener);
    }

    public synchronized void addVetoableChangeListener(VetoableChangeListener listener) {
        super.addVetoableChangeListener(listener);
        this.vetos.addVetoableChangeListener(listener);
    }

    public synchronized void removeVetoableChangeListener(VetoableChangeListener listener) {
        super.removeVetoableChangeListener(listener);
        this.vetos.removeVetoableChangeListener(listener);
    }

    public synchronized void addDirectionListener(PropertyChangeListener listener) {
        this.changes.addPropertyChangeListener("direction", listener);
    }

    public synchronized void removeDirectionListener(PropertyChangeListener listener) {
        this.changes.removePropertyChangeListener("direction", listener);
    }

    public synchronized void addDirectionListener(VetoableChangeListener listener) {
        this.vetos.addVetoableChangeListener("direction", listener);
    }

    public synchronized void removeDirectionListener(VetoableChangeListener listener) {
        this.vetos.removeVetoableChangeListener("direction", listener);
    }

    public synchronized void addArrowIndentListener(PropertyChangeListener listener) {
        this.changes.addPropertyChangeListener("arrowIndent", listener);
    }

    public synchronized void removeArrowIndentListener(PropertyChangeListener listener) {
        this.changes.removePropertyChangeListener("arrowIndent", listener);
    }

    public synchronized void addArrowIndentListener(VetoableChangeListener listener) {
        this.vetos.addVetoableChangeListener("arrowIndent", listener);
    }

    public synchronized void removeArrowIndentListener(VetoableChangeListener listener) {
        this.vetos.removeVetoableChangeListener("arrowIndent", listener);
    }

    protected void updateButtonImage() {
        super.updateButtonImage();
        Graphics g = this.buttonImage.getGraphics();
        Dimension s = this.size();
        int trueBevel = this.bevel + 1;
        if (this.isEnabled()) {
            g.setColor(this.arrowColor);
        } else {
            g.setColor(this.disabledArrowColor);
        }
        int centerHorizontal = (s.width - 1) / 2 + this.pressedAdjustment;
        int centerVertical = (s.height - 1) / 2 + this.pressedAdjustment;
        int topSide = this.top + trueBevel - 1 + this.pressedAdjustment + this.indent;
        int bottomSide = s.height - 1 - this.bottom - trueBevel + this.pressedAdjustment - this.indent;
        int leftSide = this.left + trueBevel - 1 + this.pressedAdjustment + this.indent;
        int rightSide = s.width - 1 - this.right - trueBevel + this.pressedAdjustment - this.indent;
        if (OS.isMacintosh()) {
            ++leftSide;
            ++topSide;
        }
        switch (this.direction) {
            case 2: {
                this.fillTriangle(g, centerHorizontal, topSide, leftSide, bottomSide, rightSide, bottomSide, this.direction);
                break;
            }
            case 3: {
                this.fillTriangle(g, centerHorizontal, bottomSide, leftSide, topSide, rightSide, topSide, this.direction);
                break;
            }
            case 0: {
                this.fillTriangle(g, leftSide, centerVertical, rightSide, bottomSide, rightSide, topSide, this.direction);
                break;
            }
            case 1: {
                this.fillTriangle(g, rightSide, centerVertical, leftSide, bottomSide, leftSide, topSide, this.direction);
                break;
            }
        }
        if (g != null) {
            g.dispose();
        }
    }

    protected void fillTriangle(Graphics g, int tipX, int tipY, int aX, int aY, int bX, int bY, int direction) {
        switch (direction) {
            case 2: 
            case 3: {
                int min;
                int dist = Math.abs(aX - bX);
                int max = Math.max(aX, bX);
                int i = min = Math.min(aX, bX);
                while (i <= max) {
                    g.drawLine(tipX, tipY, i, aY);
                    ++i;
                }
                break;
            }
            case 0: 
            case 1: {
                int min;
                int dist = Math.abs(aY - bY);
                int max = Math.max(aY, bY);
                int i = min = Math.min(aY, bY);
                while (i <= max) {
                    g.drawLine(tipX, tipY, aX, i);
                    ++i;
                }
                break;
            }
        }
    }

    protected boolean isValidBevelSize(int i) {
        Dimension s = this.size();
        int temp = i * 2 + 4;
        return i >= 0 && s.width >= temp && s.height >= temp;
    }

    protected boolean isValidDirection(int i) {
        switch (i) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    protected boolean isValidArrowIndent(int i) {
        Dimension s = this.size();
        int temp = i * 2 + (this.bevel + 1) * 2 + 4;
        return i >= 0 && s.width >= temp && s.height >= temp;
    }

    protected void verifyContstrainedPropertyValues() {
        super.verifyContstrainedPropertyValues();
        try {
            this.setArrowIndent(this.tempIndent);
        }
        catch (PropertyVetoException propertyVetoException) {}
    }

    class SizeVeto
    implements VetoableChangeListener,
    Serializable {
        public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
            int i = (Integer)e.getNewValue();
            if (!DirectionButton.this.isValidDirection(i)) {
                throw new PropertyVetoException(String.valueOf(DirectionButton.this.errors.getString("InvalidDirection")) + i, e);
            }
        }

        SizeVeto() {
            DirectionButton.this = DirectionButton.this;
        }
    }

    class IndntVeto
    implements VetoableChangeListener,
    Serializable {
        public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
            int i = (Integer)e.getNewValue();
            if (!DirectionButton.this.isValidArrowIndent(i)) {
                throw new PropertyVetoException(String.valueOf(DirectionButton.this.errors.getString("InvalidArrowIndent")) + i, e);
            }
        }

        IndntVeto() {
            DirectionButton.this = DirectionButton.this;
        }
    }
}

